/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.corereaders.DumpReader;
import com.ibm.dtfj.corereaders.NewAixDump;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class Aix64Dump
extends NewAixDump {
    private static final long THRDENTRY64_V1_SIZE = 424L;
    private static final long THRDENTRY64_V2_SIZE = 512L;
    private static final long THRDCTX64_V1 = 1000L;
    private static final long THRDCTX64_V2 = 1088L;
    private static final int GPR_COUNT = 32;
    private boolean hasVersionBeenDetermined = false;
    private long sizeofThreadCtx64 = 1000L;
    private long sizeofThreadEntry64 = 424L;

    protected Aix64Dump(DumpReader reader) throws IOException {
        super(reader);
        this.readCore();
    }

    protected int readLoaderInfoFlags() throws IOException {
        return this.coreReadInt();
    }

    protected long userInfoOffset() {
        return 1216L;
    }

    protected int pointerSize() {
        return 64;
    }

    protected Map readRegisters(long threadOffset) throws IOException {
        if (!this.hasVersionBeenDetermined) {
            this.calculateThreadStructureSizes(threadOffset);
        }
        this.coreSeek(threadOffset + this.sizeofThreadEntry64);
        TreeMap<String, Number> registers = new TreeMap<String, Number>();
        for (int i = 0; i < 32; ++i) {
            registers.put("gpr" + i, new Long(this.coreReadLong()));
        }
        registers.put("msr", new Long(this.coreReadLong()));
        registers.put("iar", new Long(this.coreReadLong()));
        registers.put("lr", new Long(this.coreReadLong()));
        registers.put("ctr", new Long(this.coreReadLong()));
        registers.put("cr", new Integer(this.coreReadInt()));
        registers.put("xer", new Integer(this.coreReadInt()));
        registers.put("fpscr", new Integer(this.coreReadInt()));
        return registers;
    }

    public void calculateThreadStructureSizes(long threadOffset) {
        long address;
        try {
            this.coreSeek(threadOffset + 424L + 8L);
            address = this.coreReadLong();
        }
        catch (IOException e) {
            return;
        }
        if (null == this.memoryRangeFor(address)) {
            this.sizeofThreadEntry64 = 512L;
            this.sizeofThreadCtx64 = 1088L;
        } else {
            this.sizeofThreadEntry64 = 424L;
            this.sizeofThreadCtx64 = 1000L;
        }
        this.hasVersionBeenDetermined = true;
    }

    protected long threadSize(long threadOffset) {
        if (!this.hasVersionBeenDetermined) {
            this.calculateThreadStructureSizes(threadOffset);
        }
        return this.sizeofThreadCtx64;
    }

    protected long getStackPointerFrom(Map registers) {
        return (Long)registers.get("gpr1");
    }

    protected long getInstructionPointerFrom(Map registers) {
        return (Long)registers.get("iar");
    }

    protected long getLinkRegisterFrom(Map registers) {
        return (Long)registers.get("lr");
    }

    protected int sizeofTopOfStack() {
        return 304;
    }
}

