/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.logging;

import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.logging.ILogListener;
import com.ibm.cic.common.logging.LogEntry;
import com.ibm.cic.common.logging.LogManager;
import java.io.OutputStream;
import java.io.Writer;
import org.eclipse.core.runtime.OperationCanceledException;

public abstract class StreamLog
implements ILogListener {
    protected Writer writer;

    public abstract String format(LogEntry var1);

    protected Encodings getEncoding() {
        return Encodings.UTF8;
    }

    protected void setOutputStream(OutputStream out) {
        this.writer = this.getEncoding().writer(out);
    }

    @Override
    public synchronized void logEntry(LogEntry entry) {
        String msg;
        if (this.writer == null) {
            return;
        }
        try {
            msg = this.format(entry);
        }
        catch (Exception e) {
            StreamLog.reportError(e);
            return;
        }
        try {
            this.writer.write(msg);
        }
        catch (Exception e) {
            StreamLog.reportError(e);
        }
        this.flush();
    }

    @Override
    public synchronized void close() {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.close();
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (Exception e) {
            StreamLog.reportError(e);
        }
        this.writer = null;
    }

    public void flush() {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.flush();
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (Exception e) {
            StreamLog.reportError(e);
        }
    }

    protected static void reportError(Exception e) {
        LogManager.reportError(e);
    }
}

