/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads.handlerImpl;

import com.ibm.cic.common.core.internal.utils.RefCount;
import com.ibm.cic.common.downloads.AbstractHostInfo;
import com.ibm.cic.common.downloads.CredentialInfo;
import com.ibm.cic.common.downloads.CredentialPrompter;
import com.ibm.cic.common.downloads.CredentialRequested;
import com.ibm.cic.common.downloads.CredentialStore;
import com.ibm.cic.common.downloads.CredentialTarget;
import com.ibm.cic.common.downloads.HostInfo;
import com.ibm.cic.common.downloads.ICredentialPrompter;
import com.ibm.cic.common.downloads.ICredentialValidator;
import com.ibm.cic.common.downloads.ProxyInfo;
import com.ibm.cic.common.downloads.RequestStatus;
import com.ibm.cic.common.downloads.handlerImpl.DownloadHandlerUtil;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.Logger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class AbstractAuthenticator
implements ICredentialValidator,
CredentialStore.ICredentialStoreListener {
    private static final Logger log = DownloadHandlerUtil.traceProxySettings.getLog();
    private final HostsRefCounted hostsRefs = new HostsRefCounted();
    private final Map retrieved = Collections.synchronizedMap(new HashMap());
    private final Map asked = Collections.synchronizedMap(new HashMap());
    private int askedCount = 0;
    private final Object askedCountLock = new Object();
    private final Map usedBefore = Collections.synchronizedMap(new HashMap());
    private final Map useNext = Collections.synchronizedMap(new HashMap());
    private final Map provided = Collections.synchronizedMap(new HashMap());
    private static ThreadLocal perThreadProvided = new ThreadLocal();
    private static ThreadLocal perThreadCanceled = new ThreadLocal();
    private final Object proxyLock = new Object();
    private final Object nonProxyLock = new Object();

    private CredentialRequested getProvidedCredential(CredentialRequested credReq) {
        CredentialRequested cr = (CredentialRequested)this.provided.get(credReq);
        return cr;
    }

    private CredentialRequested removeProvidedCredential(CredentialRequested credReq) {
        return (CredentialRequested)this.provided.remove(credReq);
    }

    private void addThreadProvidedCredential(CredentialRequested creq) {
        LinkedHashMap<CredentialRequested, CredentialRequested> requestedCredentials;
        LinkedHashMap<AbstractAuthenticator, LinkedHashMap<CredentialRequested, CredentialRequested>> map = (LinkedHashMap<AbstractAuthenticator, LinkedHashMap<CredentialRequested, CredentialRequested>>)perThreadProvided.get();
        if (map == null) {
            map = new LinkedHashMap<AbstractAuthenticator, LinkedHashMap<CredentialRequested, CredentialRequested>>();
            perThreadProvided.set(map);
        }
        if ((requestedCredentials = (LinkedHashMap<CredentialRequested, CredentialRequested>)map.get(this)) == null) {
            requestedCredentials = new LinkedHashMap<CredentialRequested, CredentialRequested>();
            map.put(this, requestedCredentials);
        }
        requestedCredentials.put(creq, creq);
    }

    private CredentialRequested removeThreadProvidedCredentials(CredentialRequested creq) {
        Map map = (Map)perThreadProvided.get();
        if (map == null) {
            return null;
        }
        Map requestedCredentials = (Map)map.get(this);
        if (requestedCredentials == null) {
            return null;
        }
        return (CredentialRequested)requestedCredentials.remove(creq);
    }

    private CredentialRequested getThreadProvidedCredentials(CredentialRequested creq) {
        Map map = (Map)perThreadProvided.get();
        if (map == null) {
            return null;
        }
        Map requestedCredentials = (Map)map.get(this);
        if (requestedCredentials == null) {
            return null;
        }
        return (CredentialRequested)requestedCredentials.get(creq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrAskedCount() {
        Object object = this.askedCountLock;
        synchronized (object) {
            ++this.askedCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAskedCount() {
        Object object = this.askedCountLock;
        synchronized (object) {
            return this.askedCount;
        }
    }

    private CredentialInfo getUsedBefore(CredentialRequested requested) {
        CredentialInfo credInfo = (CredentialInfo)this.usedBefore.get(requested);
        credInfo = credInfo != null ? credInfo : CredentialInfo.NONE;
        return credInfo;
    }

    protected AbstractAuthenticator() {
        CredentialStore.INSTANCE.addCredentialStoreListener(this);
    }

    protected abstract String getTraceName();

    public void addHostInfo(AbstractHostInfo hostInfo) {
        this.hostsRefs.add(hostInfo);
        log.debug("{0}: added hostInfoInfo {1}", this.getTraceName(), hostInfo);
    }

    public void removeHostInfo(AbstractHostInfo hostInfo) {
        RefCount refCount = this.hostsRefs.remove(hostInfo);
        log.debug("{0}: hostsRefs.remove{1} returns {2}.", this.getTraceName(), hostInfo, refCount);
    }

    private CredentialInfo retrieveCredentials(AbstractHostInfo hostInfo, CredentialRequested requested, CredentialTarget ct) {
        CredentialInfo credInfo = CredentialStore.INSTANCE.retrieveCredentials(hostInfo, requested, ct);
        this.retrieved.put(requested, credInfo);
        return credInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CredentialResult askCredentials(CredentialRequested requested, CredentialTarget ct) {
        CredentialPrompter prompterHolder = CredentialPrompter.INSTANCE;
        ICredentialPrompter prompter = prompterHolder.getPrompter();
        if (prompter == null) {
            if (!DownloadHandlerUtil.traceProxySettings.enabled) return null;
            DownloadHandlerUtil.traceProxySettings.println("{0}: no credential prompter registered", this.getTraceName());
            return null;
        }
        CredentialInfo[] ret = new CredentialInfo[1];
        CredentialInfo credInfoPrevious = this.getUsedBefore(requested);
        String connectMessage = prompterHolder.createConnectMessage(requested, credInfoPrevious);
        IStatus status = prompter.askUserIdAndPassword(this, connectMessage, requested, credInfoPrevious, ret);
        if (status == null) {
            return null;
        }
        if (status.isOK()) {
            CredentialInfo credInfo = ret[0];
            if (DownloadHandlerUtil.traceProxySettings.enabled) {
                DownloadHandlerUtil.traceProxySettings.println("{0}: prompter to return credentials ''{1}'' for ''{2}''", new String[]{this.getTraceName(), credInfo.toString(), ct.toString()});
                DownloadHandlerUtil.traceProxySettings.println(".. removing or updating stored credentials for same location");
            }
            if (credInfo.isPersist()) {
                if (!CredentialStore.INSTANCE.storeCredentials(requested, ct, credInfo)) return null;
                this.retrieved.put(requested, credInfo);
            } else if (CredentialStore.INSTANCE.removeCredentials(requested, ct)) {
                this.retrieved.remove(requested);
            }
            this.asked.put(requested, credInfo);
            this.incrAskedCount();
            return new CredentialResult(status, credInfo);
        }
        DownloadHandlerUtil.traceProxySettings.println("{0}: prompter returns no credentials for ''{1}'' (cancel)", this.getTraceName(), ct.toString());
        return new CredentialResult(Status.CANCEL_STATUS, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractHostInfo getHostInfo(CredentialRequested requested) {
        AbstractHostInfo hostInfo = null;
        HostsRefCounted hostsRefCounted = this.hostsRefs;
        synchronized (hostsRefCounted) {
            for (AbstractHostInfo hi : this.hostsRefs.getHosts()) {
                if (!hi.getHost().equals(requested.getHost()) || hi.getPort() != requested.getPort()) continue;
                hostInfo = hi;
                break;
            }
            if (hostInfo == null) {
                for (AbstractHostInfo hi : this.hostsRefs.getHosts()) {
                    if (!hi.getHost().equals(requested.getHost())) continue;
                    hostInfo = hi;
                    break;
                }
            }
        }
        return hostInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CredentialResult getCredentials(CredentialRequested requested, boolean allowUserPrompt) {
        AbstractHostInfo hostInfo = null;
        HostsRefCounted hostsRefCounted = this.hostsRefs;
        synchronized (hostsRefCounted) {
            for (AbstractHostInfo hi : this.hostsRefs.getHosts()) {
                if (!hi.getHost().equals(requested.getHost()) || hi.getPort() != requested.getPort()) continue;
                hostInfo = hi;
                requested.setProxy(hi instanceof ProxyInfo);
                break;
            }
            if (hostInfo == null) {
                for (AbstractHostInfo hi : this.hostsRefs.getHosts()) {
                    if (!hi.getHost().equals(requested.getHost())) continue;
                    hostInfo = hi;
                    requested.setProxy(hi instanceof ProxyInfo);
                    break;
                }
            }
        }
        if (hostInfo != null) {
            CredentialTarget target = CredentialTarget.makeFromRequest(requested);
            return this.getCredentials(hostInfo, requested, target, allowUserPrompt);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForAuthenticationResponse(AbstractHostInfo hostInfo, CredentialRequested credReq) {
        CredentialRequested requested = this.getProvidedCredential(credReq);
        if (requested == null) return;
        requested.setRequestDone(false);
        CredentialRequested credentialRequested = requested;
        synchronized (credentialRequested) {
            while (true) {
                if (requested.isRequestDone()) {
                    requested = this.getProvidedCredential(credReq);
                    log.debug("done waiting. provided is now {0}", requested);
                    return;
                }
                try {
                    log.debug("waiting for {0}", requested);
                    requested.wait();
                }
                catch (InterruptedException e) {
                    ExceptionUtil.debugLogInterruptedException(e);
                }
            }
        }
    }

    private Object getTypeLock(boolean proxy) {
        return proxy ? this.proxyLock : this.nonProxyLock;
    }

    private Object getTypeLock(CredentialRequested requested) {
        return this.getTypeLock(requested.isProxy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CredentialResult getCredentials(AbstractHostInfo hostInfo, CredentialRequested requested, CredentialTarget target, boolean allowUserPrompt) {
        Object lock;
        CredentialRequested threadProvided = this.getThreadProvidedCredentials(requested);
        if (threadProvided != null) {
            log.debug("{0}: Clearing credentials as same thread asks again for {1}", this.getTraceName(), requested);
            this.setNotAuthorized(requested);
        }
        Object object = lock = this.getTypeLock(requested);
        synchronized (object) {
            this.waitForAuthenticationResponse(hostInfo, requested);
            CredentialResult askResult = this.getOrAskCredentials(hostInfo, requested, target, allowUserPrompt);
            if (askResult != null) {
                if (askResult.getStatus().isOK()) {
                    CredentialInfo credInfo = askResult.getCredentialInfo();
                    assert (credInfo.isSomething());
                    this.provided.put(requested, requested);
                    this.addThreadProvidedCredential(requested);
                    this.usedBefore.put(requested, credInfo);
                } else {
                    assert (askResult.getStatus().matches(8));
                    this.provided.put(requested, requested);
                    this.addThreadProvidedCredential(requested);
                    perThreadCanceled.set(Boolean.TRUE);
                }
            }
            return askResult;
        }
    }

    private CredentialResult getOrAskCredentials(AbstractHostInfo hostInfo, CredentialRequested requested, CredentialTarget target, boolean allowUserPrompt) {
        CredentialInfo credInfo = (CredentialInfo)this.useNext.get(requested);
        if (credInfo != null) {
            log.debug("{0}: reply confirmed credential {1} for {2}", this.getTraceName(), credInfo, requested);
            return new CredentialResult(Status.OK_STATUS, credInfo);
        }
        credInfo = this.retrieveCredentials(hostInfo, requested, target);
        if (credInfo != CredentialInfo.NONE) {
            log.debug("{0}: reply with persisted credentials {1} for 2", this.getTraceName(), credInfo, requested);
            return new CredentialResult(Status.OK_STATUS, credInfo);
        }
        log.debug("{0}: no persisted credentials stored for {1}", this.getTraceName(), requested);
        if (!allowUserPrompt) {
            return null;
        }
        CredentialResult askResult = this.askCredentials(requested, target);
        return askResult;
    }

    @Override
    public IStatus validate(CredentialInfo credentialInfo) {
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(AbstractHostInfo ahostInfo, RequestStatus state) {
        Map map = this.provided;
        synchronized (map) {
            Set providedRequests = this.provided.entrySet();
            if (providedRequests == null) {
                providedRequests = Collections.EMPTY_SET;
            }
            if (providedRequests.isEmpty()) {
                return;
            }
            Iterator iter = providedRequests.iterator();
            while (iter.hasNext()) {
                ProxyInfo proxyInfo;
                HostInfo hostInfo;
                Map.Entry entry = (Map.Entry)iter.next();
                CredentialRequested requested = (CredentialRequested)entry.getValue();
                if (requested.isProxy() == false ? ahostInfo instanceof ProxyInfo || !(hostInfo = (HostInfo)ahostInfo).getHost().equals(requested.getHost()) || hostInfo.getPort() != requested.getPort() : !(ahostInfo instanceof ProxyInfo) || !(proxyInfo = (ProxyInfo)ahostInfo).getHost().equals(requested.getHost()) || proxyInfo.getPort() != requested.getPort()) continue;
                CredentialRequested threadProvided = this.removeThreadProvidedCredentials(requested);
                if (threadProvided == null) break;
                iter.remove();
                log.debug("{0}: Removing provided credentials {1}", this.getTraceName(), requested);
                this.setResult(ahostInfo, requested, state);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResult(AbstractHostInfo hostInfo, CredentialRequested requested, RequestStatus state) {
        assert (requested != null);
        CredentialRequested credentialRequested = requested;
        synchronized (credentialRequested) {
            if (state.equals(RequestStatus.UNAUTHORIZED)) {
                this.setNotAuthorizedInternal(requested);
            } else if (state.equals(RequestStatus.SUCCEEDED)) {
                log.debug("{0}: Remembering result of credentials for request {1}", this.getTraceName(), requested);
                CredentialInfo credInfoAsked = (CredentialInfo)this.asked.remove(requested);
                log.debug("... asked.remove({0}) returns ''{1}''.", requested, credInfoAsked);
                if (credInfoAsked == null) {
                    credInfoAsked = CredentialInfo.NONE;
                }
                CredentialInfo credInfoRetrieved = (CredentialInfo)this.retrieved.remove(requested);
                log.debug("... retrieved.remove({0}) returns ''{1}''.", requested, credInfoRetrieved);
                if (credInfoRetrieved == null) {
                    credInfoRetrieved = CredentialInfo.NONE;
                }
                CredentialInfo credInfoAskedOrRetrieved = credInfoAsked.isSomething() ? credInfoAsked : credInfoRetrieved;
                this.setCredentialSucceeded(hostInfo, requested, credInfoAskedOrRetrieved);
            } else if (state.equals(RequestStatus.ASK_CREDENTIAL_CANCELED)) {
                this.removeUnconfirmedRequests(requested);
                this.resetCanceled(hostInfo);
            } else if (state.equals(RequestStatus.EXCEPTION)) {
                this.removeUnconfirmedRequests(requested);
                log.debug("{0}: exception after credential request for {1}. Existing stored credentials will be used continue ", this.getTraceName(), hostInfo);
            }
            requested.setRequestDone(true);
            requested.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotAuthorized(CredentialRequested requested) {
        CredentialRequested threadProvided = this.removeThreadProvidedCredentials(requested);
        if (threadProvided == null) {
            return;
        }
        Map map = this.provided;
        synchronized (map) {
            CredentialRequested credReq = this.removeProvidedCredential(requested);
            if (credReq != null) {
                this.setNotAuthorizedInternal(credReq);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNotAuthorizedInternal(CredentialRequested requested) {
        assert (requested != null);
        CredentialRequested credentialRequested = requested;
        synchronized (credentialRequested) {
            log.debug("{0}: Revoking credentials cached/stored for request {1}", this.getTraceName(), requested);
            this.removeUnconfirmedRequests(requested);
            this.revokeCredential(requested);
            requested.setRequestDone(true);
            requested.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUnconfirmedRequests(CredentialRequested requested) {
        CredentialRequested credentialRequested = requested;
        synchronized (credentialRequested) {
            CredentialInfo credInfoAsked = (CredentialInfo)this.asked.remove(requested);
            log.debug("... asked.remove({0}) returns ''{1}''.", requested, credInfoAsked);
            CredentialInfo credInfoRetrieved = (CredentialInfo)this.retrieved.remove(requested);
            log.debug("... retrieved.remove({0}) returns ''{1}''.", requested, credInfoRetrieved);
        }
    }

    private void revokeCredential(CredentialRequested requested) {
        log.debug("{0}: unauthorized indicated for credentials of {1}. removing from confirmed cache and store", this.getTraceName(), requested);
        Object previousCredInfo = this.useNext.remove(requested);
        log.debug("{0}: useNext.remove({1}) returns {2}.", this.getTraceName(), requested, previousCredInfo);
        CredentialTarget credTarget = CredentialTarget.makeFromRequest(requested);
        boolean deleted = CredentialStore.INSTANCE.removeCredentials(requested, credTarget);
        log.debug("{0}: deleted persisted .removeCredentials({1}) returns {2}", this.getTraceName(), credTarget, deleted);
    }

    private void setCredentialSucceeded(AbstractHostInfo hostInfo, CredentialRequested requested, CredentialInfo credInfoAskedOrRetrieved) {
        if (!credInfoAskedOrRetrieved.isSomething()) {
            log.debug("{0}: no unconfirmed credentials known for {1}", this.getTraceName(), hostInfo);
        } else {
            this.useNext.put(requested, credInfoAskedOrRetrieved);
            if (DownloadHandlerUtil.traceProxySettings.enabled) {
                log.debug("{0}: success indicated for credentials of {1}\n   will reuse {2}", this.getTraceName(), requested, credInfoAskedOrRetrieved);
            }
        }
    }

    public boolean checkThreadCanceled(AbstractHostInfo hostInfo, boolean reset) {
        boolean canceled;
        Boolean b = (Boolean)perThreadCanceled.get();
        boolean bl = canceled = b != null ? b : false;
        if (reset) {
            this.resetCanceled(hostInfo);
        }
        return canceled;
    }

    private void resetCanceled(AbstractHostInfo hostInfo) {
        log.debug("{0}: reset cancel flag for {1}", this.getTraceName(), hostInfo);
        perThreadCanceled.set(null);
    }

    @Override
    public void clearCachedCredentials() {
        this.retrieved.clear();
        this.asked.clear();
        this.usedBefore.clear();
        this.useNext.clear();
    }

    @Override
    public boolean isAnyCredentialSaved() {
        return !this.useNext.isEmpty() || !this.asked.isEmpty() || !this.useNext.isEmpty();
    }

    public static class CredentialResult {
        IStatus status;
        CredentialInfo credInfo;

        public CredentialResult(IStatus status, CredentialInfo credInfo) {
            this.status = status;
            this.credInfo = credInfo;
        }

        public IStatus getStatus() {
            return this.status;
        }

        public CredentialInfo getCredentialInfo() {
            return this.credInfo;
        }
    }

    static class HostsRefCounted {
        private final HashMap hosts = new HashMap(10);

        HostsRefCounted() {
        }

        public synchronized void add(AbstractHostInfo host) {
            RefCount ref = (RefCount)this.hosts.get(host);
            if (ref != null) {
                ref.incrRefCount();
            } else {
                this.hosts.put(host, new RefCount(host));
            }
        }

        public synchronized Collection getHosts() {
            return Collections.unmodifiableCollection(this.hosts.keySet());
        }

        public synchronized RefCount remove(AbstractHostInfo host) {
            RefCount ref = (RefCount)this.hosts.get(host);
            if (ref != null) {
                ref.decrRefCount();
                if (ref.isZeroRefCount()) {
                    this.hosts.remove(host);
                }
                return ref;
            }
            return null;
        }

        public synchronized boolean hasHostInfo(AbstractHostInfo host) {
            RefCount ref = (RefCount)this.hosts.get(host);
            return ref != null;
        }
    }
}

