/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.logging.Logger;
import java.net.URI;
import java.net.URISyntaxException;

public class UrlUserInfoUtil {
    private static final Logger log = Logger.getLogger(UrlUserInfoUtil.class);
    public static final String ANONYMOUS_USER = "anonymous";

    private UrlUserInfoUtil() {
    }

    public static String getUserId(String urlString) {
        URI uri;
        try {
            uri = new URI(urlString);
        }
        catch (URISyntaxException e) {
            log.debug(e);
            return null;
        }
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            String[] strings = UrlUserInfoUtil.parseUserInfo(userInfo);
            return strings[0];
        }
        return null;
    }

    public static String[] getUsernameAndPassword(String urlString) {
        URI uri;
        try {
            uri = new URI(urlString);
        }
        catch (URISyntaxException e) {
            log.debug(e);
            return null;
        }
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            String[] strings = UrlUserInfoUtil.parseUserInfo(userInfo);
            return strings;
        }
        return null;
    }

    public static String[] parseUserInfo(String userInfo) {
        String uname;
        String pword = null;
        int split = userInfo.indexOf(58);
        if (split >= 0) {
            uname = userInfo.substring(0, split);
            pword = userInfo.substring(split + 1);
        } else {
            uname = userInfo;
        }
        return new String[]{uname, pword};
    }
}

