/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.internal.downloads.Messages;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.downloads.ByteRange;
import com.ibm.cic.common.downloads.DownloadProtocolException;
import com.ibm.cic.common.downloads.DownloadTrace;
import com.ibm.icu.util.StringTokenizer;

public class HttpRangeUtil {
    private static final String BYTES_LITERAL = "bytes";

    public static String getHttpRangeRequestHeaderValue(ByteRange byteRange) {
        StringBuffer sb = new StringBuffer(50);
        sb.append(BYTES_LITERAL);
        sb.append('=');
        sb.append(byteRange.getStart());
        sb.append('-');
        if (byteRange.hasSpecifiedEnd()) {
            sb.append(byteRange.getEnd() - 1L);
        }
        return sb.toString();
    }

    public static ByteRange convertContentRangeToByteRange(ByteContentRange cr) {
        if (cr.getRangeSize() == cr.getInstanceLength()) {
            return ByteRange.remainingRange(cr.getFirstBytePos(), cr.getLastBytePos() + 1L);
        }
        return ByteRange.range(cr.getFirstBytePos(), cr.getLastBytePos() + 1L);
    }

    public static ByteContentRange parseByteContentRange(String contentRangeSpec) {
        if (contentRangeSpec == null) {
            return null;
        }
        String s = HttpRangeUtil.surroundDelimitersWithSpace("-/", contentRangeSpec);
        String lwsDelim = " \t\r\n";
        StringTokenizer tok = new StringTokenizer(s = HttpRangeUtil.subTokenSpacingToSingleSpace(new StringTokenizer(s, lwsDelim), contentRangeSpec), " ");
        if (!tok.hasMoreTokens()) {
            return null;
        }
        String token = tok.nextToken();
        if (!token.equalsIgnoreCase(BYTES_LITERAL)) {
            return null;
        }
        ByteContentRange bcr = new ByteContentRange();
        token = HttpRangeUtil.nextToken(contentRangeSpec, bcr, tok);
        if (token.length() == 1 && token.charAt(0) == '*') {
            bcr.setFirstBytePos(-1L);
            bcr.setLastBytePos(-1L);
        } else {
            HttpRangeUtil.parseSpecificBytesRangeSpec(contentRangeSpec, bcr, tok, token);
        }
        HttpRangeUtil.eatChar(contentRangeSpec, bcr, tok, '/');
        token = HttpRangeUtil.nextToken(contentRangeSpec, bcr, tok);
        if (token.length() == 1 && token.charAt(0) == '*') {
            bcr.setInstanceLength(-1L);
        } else {
            bcr.setInstanceLength(HttpRangeUtil.parseLong(contentRangeSpec, bcr, token));
        }
        if (tok.hasMoreTokens()) {
            String msg = NLS.bind(Messages.HttpRangeUtil_cantParseExtraCharacters, (Object)contentRangeSpec);
            throw new IllegalArgumentException(msg);
        }
        return bcr;
    }

    public static ByteContentRange getNonRequiredContentRange(String urlString, String contentRangeResponse) {
        ByteContentRange contentRange = null;
        try {
            contentRange = HttpRangeUtil.parseByteContentRange(contentRangeResponse);
        }
        catch (IllegalArgumentException e) {
            String msg = HttpRangeUtil.getContentRangeResponseHeaderBadMessage(urlString, e);
            DownloadTrace.traceHappy.getLog().error(msg);
        }
        return contentRange;
    }

    public static ByteContentRange getRequiredContentRange(String urlString, String contentRangeResponse) throws DownloadProtocolException {
        ByteContentRange contentRange;
        try {
            contentRange = HttpRangeUtil.parseByteContentRange(contentRangeResponse);
        }
        catch (IllegalArgumentException e) {
            String msg = HttpRangeUtil.getContentRangeResponseHeaderBadMessage(urlString, e);
            throw new DownloadProtocolException(msg, e);
        }
        if (contentRange == null) {
            String msg = HttpRangeUtil.getContentRangeResponseHeaderMissingMessage(urlString);
            throw new DownloadProtocolException(msg, null);
        }
        return contentRange;
    }

    public static String getContentRangeNotSatisfiableMsg(String urlString, ByteRange requestedRange, long actualSize) {
        String msg = actualSize != -1L ? NLS.bind(Messages.HttpRangeUtil_contentRangeNotSatisfiable, urlString, requestedRange, actualSize) : NLS.bind(Messages.HttpRangeUtil_contentRangeNotSatisfiableUnknownActualSize, (Object)urlString, (Object)requestedRange);
        return msg;
    }

    private static String getContentRangeResponseHeaderBadMessage(String urlString, IllegalArgumentException e) {
        String msg = NLS.bind(Messages.HttpRangeUtil_badContentRangeResponseHeader, (Object)urlString, (Object)e);
        return msg;
    }

    private static String getContentRangeResponseHeaderMissingMessage(String urlString) {
        String msg = NLS.bind(Messages.HttpRangeUtil_missingContentRangeResponseHeader, (Object)urlString);
        return msg;
    }

    private static void parseSpecificBytesRangeSpec(String contentRangeSpec, ByteContentRange bcr, StringTokenizer tok, String token) {
        bcr.setFirstBytePos(HttpRangeUtil.parseLong(contentRangeSpec, bcr, token));
        HttpRangeUtil.eatChar(contentRangeSpec, bcr, tok, '-');
        token = HttpRangeUtil.nextToken(contentRangeSpec, bcr, tok);
        bcr.setLastBytePos(HttpRangeUtil.parseLong(contentRangeSpec, bcr, token));
    }

    private static String nextToken(String contentRangeSpec, ByteContentRange bcr, StringTokenizer tok) {
        if (!tok.hasMoreTokens()) {
            HttpRangeUtil.cantParse(contentRangeSpec, bcr);
        }
        String token = tok.nextToken();
        return token;
    }

    private static void eatChar(String contentRangeSpec, ByteContentRange bcr, StringTokenizer tok, char c) {
        String token;
        if (!tok.hasMoreTokens()) {
            HttpRangeUtil.cantParse(contentRangeSpec, bcr);
        }
        if ((token = tok.nextToken()).length() != 1 || token.charAt(0) != c) {
            HttpRangeUtil.cantParse(contentRangeSpec, bcr);
        }
    }

    private static void cantParse(String contentRangeSpec, ByteContentRange bcr) {
        String msg = NLS.bind(Messages.HttpRangeUtil_cantParse, (Object)contentRangeSpec, (Object)bcr);
        throw new IllegalArgumentException(msg);
    }

    private static long parseLong(String contentRangeSpec, ByteContentRange bcr, String token) {
        try {
            long l = Long.parseLong(token);
            return l;
        }
        catch (IllegalArgumentException e) {
            String msg = NLS.bind(Messages.HttpRangeUtil_cantParse, (Object)contentRangeSpec, (Object)bcr);
            IllegalArgumentException newException = new IllegalArgumentException(msg);
            newException.initCause(e);
            throw newException;
        }
    }

    private static String subTokenSpacingToSingleSpace(StringTokenizer tok, String s) {
        StringBuffer sb = new StringBuffer(s.length());
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            sb.append(token);
            sb.append(' ');
        }
        return sb.toString();
    }

    private static String surroundDelimitersWithSpace(String delims, String s) {
        StringBuffer sb = new StringBuffer(s.length());
        int i = 0;
        while (i < s.length()) {
            block3: {
                char c = s.charAt(i);
                int j = 0;
                while (j < delims.length()) {
                    char d = delims.charAt(j);
                    if (d == c) {
                        sb.append(' ');
                        sb.append(c);
                        sb.append(' ');
                        break block3;
                    }
                    ++j;
                }
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static class ByteContentRange {
        private long firstBytePos = -2L;
        private long lastBytePos = -2L;
        private long instanceLength = -2L;

        public void setFirstBytePos(long firstBytePos) {
            this.firstBytePos = firstBytePos;
        }

        public void setLastBytePos(long lastBytePos) {
            this.lastBytePos = lastBytePos;
        }

        public void setInstanceLength(long instanceLength) {
            this.instanceLength = instanceLength;
        }

        public long getFirstBytePos() {
            return this.firstBytePos;
        }

        public long getLastBytePos() {
            return this.lastBytePos;
        }

        public long getRangeSize() {
            return this.lastBytePos - this.firstBytePos + 1L;
        }

        public long getInstanceLength() {
            return this.instanceLength;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(50);
            sb.append(HttpRangeUtil.BYTES_LITERAL);
            sb.append(' ');
            if (this.firstBytePos == -1L && this.lastBytePos == -1L) {
                sb.append('*');
            } else {
                ByteContentRange.append(sb, this.firstBytePos);
                sb.append('-');
                ByteContentRange.append(sb, this.lastBytePos);
            }
            sb.append('/');
            ByteContentRange.append(sb, this.instanceLength);
            return sb.toString();
        }

        private static void append(StringBuffer sb, long value) {
            if (value == -1L) {
                sb.append('*');
            } else if (value == -2L) {
                sb.append('?');
            } else {
                sb.append(value);
            }
        }
    }
}

