/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.downloads.Messages;
import com.ibm.icu.text.DecimalFormat;

public class FormatUtil {
    private static final String Zero_Dot_Zero = "0.0";
    private static final String Zero_Dot_ZeroZero = "0.00";
    private static final char[] ZERO_TO_NINE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public static String formatBytes(long bytes) {
        double kiloBytes = (double)bytes / 1024.0;
        return FormatUtil.formatBytes(kiloBytes);
    }

    public static String formatBytes(double kiloBytes) {
        if (kiloBytes * 1024.0 == 9.223372036854776E18) {
            return Messages.FormatUtil_format_NA;
        }
        double diskSpace = kiloBytes;
        String number_format_string = Zero_Dot_Zero;
        String NLS_format_string = Messages.FormatUtil_format_kilobyte;
        if (diskSpace > 1024.0) {
            diskSpace /= 1024.0;
            number_format_string = Zero_Dot_ZeroZero;
            NLS_format_string = Messages.FormatUtil_format_megabyte;
        }
        if (diskSpace > 1024.0) {
            diskSpace /= 1024.0;
            number_format_string = Zero_Dot_ZeroZero;
            NLS_format_string = Messages.FormatUtil_format_gigabyte;
        }
        DecimalFormat decimalFormat = new DecimalFormat(number_format_string);
        return NLS.bind(NLS_format_string, (Object)decimalFormat.format(diskSpace));
    }

    public static String formatBytesHuman(long bytes) {
        long kb = (long)Math.ceil((double)bytes / 1024.0);
        String msg = "";
        if (kb < 1024L) {
            msg = NLS.bind(Messages.FormatUtil_format_human_kiloBytes, (Object)kb);
        } else if (kb < 10240L) {
            DecimalFormat format = new DecimalFormat(Zero_Dot_Zero);
            msg = NLS.bind(Messages.FormatUtil_format_human_megaBytes_with_fraction, (Object)format.format((double)kb / 1024.0));
        } else if (kb < 0x100000L) {
            msg = NLS.bind(Messages.FormatUtil_format_human_megaBytes, (Object)(kb / 1024L));
        } else {
            DecimalFormat format = new DecimalFormat(Zero_Dot_Zero);
            msg = NLS.bind(Messages.FormatUtil_format_human_gigaBytes_with_fraction, (Object)format.format((double)kb / 1048576.0));
        }
        return msg;
    }

    public static String formatBytesPerSecond(long bytesPerSecond) {
        String msg;
        if (bytesPerSecond < 1024L) {
            msg = NLS.bind(Messages.FormatUtil_bytesPerSecond, (Object)bytesPerSecond);
        } else if (bytesPerSecond < 10240L) {
            double kbps = (double)bytesPerSecond / 1024.0;
            DecimalFormat decimalFormat = new DecimalFormat(Zero_Dot_Zero);
            msg = NLS.bind(Messages.FormatUtil_kiloBytesPerSecondWithFraction, (Object)decimalFormat.format(kbps));
        } else if (bytesPerSecond < 0x100000L) {
            msg = NLS.bind(Messages.FormatUtil_kiloBytesPerSecond, (Object)(bytesPerSecond / 1024L));
        } else {
            double mbps = (double)bytesPerSecond / 1048576.0;
            DecimalFormat decimalFormat = new DecimalFormat(Zero_Dot_Zero);
            msg = NLS.bind(Messages.FormatUtil_megaBytesPerSecondWithFraction, (Object)decimalFormat.format(mbps));
        }
        return msg;
    }

    public static String formatTimeSpan(long seconds) {
        if (seconds < 60L) {
            return NLS.bind(Messages.FormatUtil_seconds, (Object)seconds);
        }
        if (seconds < 3600L) {
            long m = seconds / 60L;
            String s = FormatUtil.format2Digits((int)(seconds % 60L));
            return NLS.bind(Messages.FormatUtil_mmss, (Object)m, (Object)s);
        }
        String s = FormatUtil.format2Digits((int)(seconds % 60L));
        String m = FormatUtil.format2Digits((int)(seconds / 60L % 60L));
        long h = seconds / 3600L;
        return NLS.bind(Messages.FormatUtil_hhmmss, h, m, s);
    }

    public static String formatTimeSpanMilliSeconds(long ms) {
        if (ms < 1000L) {
            return NLS.bind(Messages.FormatUtil_milliSeconds, (Object)ms);
        }
        return FormatUtil.formatTimeSpan(ms / 1000L);
    }

    private static String format2Digits(int count) {
        assert (count >= 0);
        assert (count < 100);
        int d1 = count / 10;
        int d0 = count % 10;
        char[] chars = new char[]{ZERO_TO_NINE[d1], ZERO_TO_NINE[d0]};
        return new String(chars);
    }
}

