/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.downloads.DownloadException;

public class DownloadPrematureEOFException
extends DownloadException {
    public static final int REASON_PREMATURE_VS_ACTUAL_SIZE = 1;
    public static final int REASON_PREMATURE_VS_REQUESTED_SIZE = 2;
    public static final int REASON_EOF_MAYBE_BEFORE_REQUESTED_START = 4;
    private final int reasons;

    public DownloadPrematureEOFException(int reasons, Exception cause) {
        super(cause);
        this.reasons = reasons;
        this.validateReasons();
    }

    public DownloadPrematureEOFException(int reasons, String msg, Exception cause) {
        super(msg, cause);
        this.reasons = reasons;
        this.validateReasons();
    }

    private static boolean reasons(int reasons, int reasonFlags) {
        return (reasons & reasonFlags) != 0;
    }

    public static String reasonsAsString(int reasons) {
        StringBuffer sb = new StringBuffer();
        if (DownloadPrematureEOFException.reasons(reasons, 2)) {
            sb.append("PREMATURE_VS_REQUESTED");
        }
        if (DownloadPrematureEOFException.reasons(reasons, 4)) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append("EOF_MAYBE_BEFORE_REQUESTED_START");
        }
        if (DownloadPrematureEOFException.reasons(reasons, 1)) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append("PREMATURE_VS_ACTUAL");
        }
        return sb.toString();
    }

    private void validateReasons() {
        assert (this.reasons(7));
    }

    public boolean reasons(int reasonFlags) {
        return DownloadPrematureEOFException.reasons(this.reasons, reasonFlags);
    }

    public int getReasons() {
        return this.reasons;
    }
}

