/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

public class CredentialRequested {
    private static final String EMPTY_STRING = "";
    private final String scheme;
    private final String host;
    private final int port;
    private Boolean proxy;
    private final String realm;
    private boolean requestDone = false;

    public CredentialRequested(String scheme, String host, int port, String realm, Boolean proxy) {
        this.scheme = scheme == null ? EMPTY_STRING : scheme.toUpperCase();
        this.host = host == null ? EMPTY_STRING : host.toLowerCase();
        this.port = port;
        this.realm = realm == null ? EMPTY_STRING : realm;
        this.proxy = proxy;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getRealm() {
        return this.realm;
    }

    public Boolean isProxy() {
        return this.proxy;
    }

    public void setProxy(boolean proxy) {
        this.proxy = proxy;
    }

    public String getScheme() {
        return this.scheme;
    }

    public int hashCode() {
        int hash = this.scheme.hashCode();
        hash = hash * 17 + this.host.hashCode();
        hash = hash * 17 + this.port;
        hash = hash * 17 + this.realm.hashCode();
        hash = hash * 17 + (this.proxy == null ? 5 : this.proxy.hashCode());
        return hash;
    }

    private static boolean equalsWithNull(Boolean a, Boolean b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CredentialRequested) {
            CredentialRequested rhs = (CredentialRequested)obj;
            return rhs.scheme.equals(this.scheme) && rhs.host.equals(this.host) && rhs.port == this.port && rhs.realm.equals(this.realm) && CredentialRequested.equalsWithNull(rhs.proxy, this.proxy);
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("scheme=");
        sb.append(this.scheme);
        sb.append(" realm=");
        sb.append(CredentialRequested.shorten(this.realm, 20));
        sb.append(" host=");
        sb.append(this.host);
        sb.append(" port=");
        sb.append(Integer.toString(this.port));
        sb.append(" proxy=");
        sb.append(this.proxy == null ? "null" : this.proxy.toString());
        return sb.toString();
    }

    private static String shorten(String realm2, int max) {
        int n = realm2.length() > max ? max : realm2.length();
        return realm2.substring(0, n);
    }

    public String getLocation() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.host);
        sb.append(':');
        sb.append(this.port);
        return sb.toString();
    }

    public void setRequestDone(boolean requestDone) {
        this.requestDone = requestDone;
    }

    public boolean isRequestDone() {
        return this.requestDone;
    }
}

