/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.downloads.ProxyInfo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CredentialInfo {
    public static final CredentialInfo NONE = new CredentialInfo();
    public static final ProxyInfo NO_PROXY = new ProxyInfo();
    public static final String KEY_PERSIST = "persist";
    public static final String KEY_USER_ID = "uid";
    public static final String KEY_DOMAIN = "domain";
    public static final String KEY_PWD = "pwd";
    public static final String KEY_AUTO_GENERATED = "autoGenerated";
    private final Map map;

    public CredentialInfo(Map platformInfo) {
        this.map = platformInfo;
    }

    public CredentialInfo() {
        this.map = new HashMap();
    }

    private String getStringValue(String key) {
        Object obj = this.map.get(key);
        if (obj != null) {
            return (String)obj;
        }
        return "";
    }

    private void setStringValue(String key, String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.map.put(key, value);
    }

    private boolean getBooleanValue(String key) {
        Object obj = this.map.get(key);
        if (obj != null) {
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            if (obj instanceof String) {
                return Boolean.parseBoolean((String)obj);
            }
        }
        return false;
    }

    private void setBooleanValue(String key, boolean value) {
        this.map.put(key, value);
    }

    public boolean isSomething() {
        return this != NONE;
    }

    public boolean isPersist() {
        return this.getBooleanValue(KEY_PERSIST);
    }

    public boolean isAutoGenerated() {
        return this.getBooleanValue(KEY_AUTO_GENERATED);
    }

    public String getUid() {
        return this.getStringValue(KEY_USER_ID);
    }

    public String getDomain() {
        return this.getStringValue(KEY_DOMAIN);
    }

    public String getPwd() {
        return this.getStringValue(KEY_PWD);
    }

    public void setPersist(boolean v) {
        this.setBooleanValue(KEY_PERSIST, v);
    }

    public void setAutoGenerated(boolean v) {
        this.setBooleanValue(KEY_AUTO_GENERATED, v);
    }

    public void setUid(String uid) {
        this.setStringValue(KEY_USER_ID, uid);
    }

    public void setPwd(String pwd) {
        this.setStringValue(KEY_PWD, pwd);
    }

    public void setDomain(String domain) {
        this.setStringValue(KEY_DOMAIN, domain);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CredentialInfo)) {
            return false;
        }
        CredentialInfo rhs = (CredentialInfo)obj;
        return rhs.map.equals(this.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public static String maskPassword(String password) {
        return "******";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this == NONE) {
            sb.append("Credentials-NONE");
        } else {
            sb.append("Credentials {");
            Iterator i = this.map.entrySet().iterator();
            boolean hasNext = i.hasNext();
            while (hasNext) {
                Map.Entry entry = i.next();
                String key = (String)entry.getKey();
                sb.append(key);
                sb.append("=");
                sb.append((Object)(key.equals(KEY_PWD) ? CredentialInfo.maskPassword(entry.getValue().toString()) : entry.getValue()));
                hasNext = i.hasNext();
                if (!hasNext) continue;
                sb.append(", ");
            }
            sb.append("}");
        }
        return sb.toString();
    }

    public Map getInfoMap() {
        return this.map;
    }
}

