/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.utils.XMLWriter;
import com.ibm.cic.common.downloads.DigestValue;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IMessageDigests;
import java.util.Iterator;

public class ContentInfoUtil {
    public static String contentInfoToXML(IContentInfo info) {
        StringBuffer result = new StringBuffer();
        ContentInfoUtil.appendContentInfoXML(result, info, false);
        return result.toString();
    }

    public static void appendContentInfoXML(StringBuffer sb, IContentInfo info, boolean forInconsistentIuCheck) {
        long installSize;
        long downloadSize;
        if (!forInconsistentIuCheck && (downloadSize = info.getSizeInfo().getDownloadSize()) != Long.MIN_VALUE) {
            sb.append(' ').append("downloadSize");
            sb.append("='").append(downloadSize).append('\'');
        }
        if ((installSize = info.getSizeInfo().getInstallSize()) != Long.MIN_VALUE) {
            sb.append(' ').append("installSize");
            sb.append("='").append(installSize).append('\'');
        }
        ContentInfoUtil.appendMessageDigestsXML(sb, (IMessageDigests)info);
    }

    public static void appendMessageDigestsXML(StringBuffer sb, IMessageDigests digests) {
        ContentInfoUtil.appendMessageDigestsXML(sb, digests, "");
    }

    public static void appendMessageDigestsXML(StringBuffer sb, IMessageDigests digests, String postfix) {
        Iterator<DigestValue> iterator = digests.getDigests().iterator();
        while (iterator.hasNext()) {
            DigestValue element;
            DigestValue dv = element = iterator.next();
            sb.append(' ');
            ContentInfoUtil.appendDigestName(sb, dv.getAlgorithm().toUpperCase());
            sb.append(postfix);
            sb.append("='").append(dv.getDigestAsString()).append('\'');
        }
    }

    public static void appendMessageDigestsXML(XMLWriter writer, IMessageDigests digests) {
        Iterator<DigestValue> iterator = digests.getDigests().iterator();
        while (iterator.hasNext()) {
            DigestValue element;
            DigestValue dv = element = iterator.next();
            String name = ContentInfoUtil.getXMLDigestName(dv);
            writer.attribute(name, dv.getDigestAsString());
        }
    }

    private static String getXMLDigestName(DigestValue dv) {
        String algorithm = dv.getAlgorithm();
        return ContentInfoUtil.getXMLDigestName(algorithm);
    }

    private static String getXMLDigestName(String algorithm) {
        StringBuffer sb = new StringBuffer(algorithm.length());
        ContentInfoUtil.appendDigestName(sb, algorithm);
        return sb.toString();
    }

    private static void appendDigestName(StringBuffer sb, String algorithm) {
        int i = 0;
        while (i < algorithm.length()) {
            char c = Character.toLowerCase(algorithm.charAt(i));
            if (c == '.' || c == '_' || c == ':' || c == '-' || Character.isLetterOrDigit(c)) {
                sb.append(c);
            }
            ++i;
        }
    }
}

