/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.downloads.DigestValue;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.SizeInfo;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ContentInfo
implements IContentInfo {
    public static final ContentInfo EMPTY_CONTENT_INFO = new ContentInfo();
    private final SizeInfo sizeInfo = new SizeInfo();

    public long getSize() {
        return this.getSizeInfo().getDownloadSize();
    }

    @Override
    public SizeInfo getSizeInfo() {
        return this.sizeInfo;
    }

    @Override
    public String getMessageDigestAsString(String algorithm) {
        return null;
    }

    @Override
    public DigestValue getDigestValue(String algorithm) {
        return null;
    }

    @Override
    public int getAvailableDigestsCount() {
        return 0;
    }

    public Set getDigestAlgorithmSet() {
        return Collections.EMPTY_SET;
    }

    public List getDigestAlgorithms() {
        return Collections.EMPTY_LIST;
    }

    public Set getDigestSet() {
        return Collections.EMPTY_SET;
    }

    public List getDigests() {
        return Collections.EMPTY_LIST;
    }

    public static String toString(IContentInfo ci) {
        if (ci == EMPTY_CONTENT_INFO) {
            return "empty IContentInfo";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("IContentInfo ").append(ci.getSizeInfo()).append(',');
        if (ci.getAvailableDigestsCount() > 0) {
            Iterator<DigestValue> iterator = ci.getDigests().iterator();
            while (iterator.hasNext()) {
                DigestValue element;
                DigestValue dv = element = iterator.next();
                sb.append(' ');
                sb.append(dv.getAlgorithm());
                sb.append('=');
                sb.append(dv.getDigestAsString());
            }
        } else {
            sb.append(" no digests known.");
        }
        return sb.toString();
    }

    public String toString() {
        return ContentInfo.toString(this);
    }
}

