/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.XMLUtil;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class XMLWriter {
    protected final Stack<String> elements;
    private boolean open;
    private String indent;
    private final PrintWriter pw;

    public XMLWriter(OutputStream output, boolean writeXMLProcessingInstruction) {
        this(output, writeXMLProcessingInstruction, null);
    }

    public XMLWriter(OutputStream output, boolean writeXMLProcessingInstruction, String[] header) {
        this.pw = new PrintWriter(Encodings.UTF8.writer(output), true);
        if (header != null) {
            String[] stringArray = header;
            int n = header.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                this.println(element);
                ++n2;
            }
        }
        if (writeXMLProcessingInstruction) {
            this.println("<?xml version='1.0' encoding='UTF-8'?>");
        }
        this.elements = new Stack();
        this.open = false;
        this.indent = "  ";
    }

    public XMLWriter(OutputStream output, ProcessingInstruction piElement, boolean writeXMLProcessingInstruction) {
        this(output, new ProcessingInstruction[]{piElement}, writeXMLProcessingInstruction);
    }

    public XMLWriter(OutputStream output, ProcessingInstruction piElement) {
        this(output, new ProcessingInstruction[]{piElement}, true);
    }

    public XMLWriter(OutputStream output, ProcessingInstruction[] piElements, boolean writeXMLProcessingInstruction) {
        this(output, writeXMLProcessingInstruction);
        if (piElements != null) {
            ProcessingInstruction[] processingInstructionArray = piElements;
            int n = piElements.length;
            int n2 = 0;
            while (n2 < n) {
                ProcessingInstruction piElement = processingInstructionArray[n2];
                this.println(piElement.toString());
                ++n2;
            }
        }
    }

    public XMLWriter(OutputStream output, ProcessingInstruction[] piElements) {
        this(output, piElements, true);
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public void start(String name) {
        this.closeIfOpen();
        this.indent();
        this.print('<');
        this.print(name);
        this.elements.push(name);
        this.open = true;
    }

    public void end(String name) {
        int index = this.elements.search(name);
        assert (index >= 0) : "end() without start for element: " + name;
        int i = 0;
        while (i < index) {
            this.end();
            ++i;
        }
    }

    public void end() {
        assert (!this.elements.empty()) : "end() without any open elements";
        String name = this.elements.pop();
        if (this.open) {
            this.println("/>");
        } else {
            this.printlnIndented("</" + name + '>', false);
        }
        this.open = false;
    }

    public void attribute(String name, boolean value, boolean defaultValue) {
        if (value != defaultValue) {
            this.attribute(name, value);
        }
    }

    public void attribute(String name, boolean value) {
        this.attribute(name, Boolean.toString(value));
    }

    public void attribute(String name, int value) {
        this.attribute(name, Integer.toString(value));
    }

    public void attribute(String name, Object value) {
        assert (this.open) : "Attribute after nested content";
        if (value == null) {
            return;
        }
        this.print(' ');
        this.print(XMLWriter.attributeImage(name, value.toString()));
    }

    public void comment(List<String> lines) {
        this.comment(lines.toArray(new String[lines.size()]));
    }

    public void comment(String ... lines) {
        if (lines.length == 0) {
            return;
        }
        this.closeIfOpen();
        this.indent();
        this.print("<!--");
        if (lines.length == 1) {
            this.print(' ');
            this.print(lines[0]);
            this.print(' ');
        } else {
            this.println();
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                this.indent();
                this.println(line);
                ++n2;
            }
            this.indent();
        }
        this.println("-->");
    }

    public void cdata(String data) {
        this.cdata(data, true);
    }

    public void cdata(String data, boolean escape) {
        this.closeIfOpen();
        if (data != null) {
            this.printlnIndented(data, escape);
        }
    }

    public void cdataLines(String data, boolean escape) {
        this.closeIfOpen();
        if (data.indexOf(10) == -1) {
            this.printlnIndented(data, escape);
        } else {
            String[] lines;
            String[] stringArray = lines = data.split("\\s*\\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                this.printlnIndented(line, escape);
                ++n2;
            }
        }
    }

    public void oneLineElement(String name, String data, boolean escape) {
        this.start(name);
        this.print('>');
        if (data != null) {
            this.print(escape ? XMLUtil.escape(data) : data);
        }
        this.println("</" + name + '>');
        this.elements.pop();
        this.open = false;
    }

    public void flush() {
        while (!this.elements.empty()) {
            this.end();
        }
        this.pw.flush();
    }

    public void close() {
        this.flush();
        this.pw.close();
    }

    public void write(LinkedProperties x) {
        if (x == null) {
            return;
        }
        String[] stringArray = x.getPropertyKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.writeProperty(name, x.getProperty(name));
            ++n2;
        }
    }

    public void write(LinkedProperties x, Map xKeys) {
        String[] stringArray = x.getPropertyKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key;
            String val = (String)xKeys.get(key = stringArray[n2]);
            this.writeProperty(key, val != null ? val : x.getProperty(key));
            ++n2;
        }
    }

    public void writeProperty(String name, String value) {
        this.start("property");
        this.attribute("name", name);
        this.attribute("value", value);
        this.end();
    }

    private void closeIfOpen() {
        if (this.open) {
            this.println('>');
            this.open = false;
        }
    }

    private static String attributeImage(String name, String value) {
        if (value == null) {
            return "";
        }
        return String.valueOf(name) + "='" + XMLUtil.escape(value) + '\'';
    }

    private void println(char c) {
        this.pw.println(c);
    }

    private void println(String s) {
        this.pw.println(s);
    }

    private void println() {
        this.pw.println();
    }

    private void print(char c) {
        this.pw.print(c);
    }

    private void print(String s) {
        this.pw.print(s);
    }

    private void printlnIndented(String s, boolean escape) {
        if (s.length() == 0) {
            this.println();
        } else {
            this.indent();
            this.println(escape ? XMLUtil.escape(s) : s);
        }
    }

    private void indent() {
        int i = this.elements.size();
        while (i > 0) {
            this.print(this.indent);
            --i;
        }
    }

    public static class ProcessingInstruction {
        private final String target;
        private final String[] data;

        public ProcessingInstruction(String target, String data) {
            this.target = target;
            this.data = new String[]{data};
        }

        public ProcessingInstruction(String target) {
            this.target = target;
            this.data = new String[0];
        }

        public ProcessingInstruction(String target, String[] attrs, String[] values) {
            assert (attrs.length == values.length) : "Mismatched pairs in processing instruction";
            this.target = target;
            this.data = new String[attrs.length];
            int i = 0;
            while (i < attrs.length) {
                this.data[i] = XMLWriter.attributeImage(attrs[i], values[i]);
                ++i;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("<?");
            sb.append(this.target).append(' ');
            int i = 0;
            while (i < this.data.length) {
                sb.append(this.data[i]);
                if (i < this.data.length - 1) {
                    sb.append(' ');
                }
                ++i;
            }
            sb.append("?>");
            return sb.toString();
        }
    }
}

