/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.utils.Messages;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UserOptions {
    private static final Logger log = Logger.getLogger();
    public static final StringOption CIC_REPO_SIMULATED_MOUNT_PATH = new StringOption("cic.repo.mountpath");
    public static final StringOption CIC_MODEL_VALIDATION_FILTER = new StringOption("cic.model.validation.filter", "");
    public static final BooleanOption CIC_REPO_IGNORE_UNEXPECTED_DIGEST = new BooleanOption("cic.repo.download.ignoreUnexpectedDigest");
    public static final BooleanOption CIC_REPO_IGNORE_ARTIFACT_TOC = new BooleanOption("cic.repo.atoc.ignore");
    public static final BooleanOption CIC_REPO_USE_NON_ARTIFACT_MD5 = new BooleanOption("cic.repo.nonArtifactMd5", true);
    public static final BooleanOption CIC_REPO_CACHE_ATOC = new BooleanOption("cic.repo.cache.atoc", true);
    public static final BooleanOption CIC_REPO_DONT_WRITE_ARTIFACT_TOC = new BooleanOption("cic.repo.atoc.dontWrite");
    public static final BooleanOption CIC_REPO_ATOC_COMPATIBILITY = new BooleanOption("cic.repo.atoc.compatibility");
    public static final BooleanOption CIC_REPO_ATOC_IGNORE_DOWNLOADSIZE_FOR_KNOWN_BUILD_ISSUE = new BooleanOption("cic.repo.atoc.ignoreDownloadSizeForKnownBuildIssue", false);
    public static final BooleanOption CIC_REPO_VOLUME_SUPPORT_INITIAL_VERSION = new BooleanOption("cic.repo.volume.supportInitialVersion");
    public static final BooleanOption CIC_ENABLE_LAUNCHER_ERROR_OUTPUT = new BooleanOption("cic.enableErrorOutput", false);
    public static final BooleanOption CIC_DOWNLOAD_ALWAYS_TEMP_FOR_DIP = new BooleanOption("cic.download.alwaysTempForDownloadInProgress");
    public static final BooleanOption CIC_DOWNLOAD_SYNC_ON_CLOSE = new BooleanOption("cic.download.syncOnClose", true);
    public static final BooleanOption CIC_SKIP_FD_SYNC = new BooleanOption("cic.skip.FileDescriptor.sync", true);
    public static final BooleanOption CIC_RETRY_MOVE = new BooleanOption("cic.retry.move", true);
    public static final BooleanOption CIC_DOWNLOAD_WARN_ABOUT_UNEXPECTED_CONCURRENCY = new BooleanOption("cic.download.warnAboutUnexpectedConcurrency", true);
    public static final BooleanOption CIC_HTTP_DISABLE_PREEMPTIVATE_AUTHENTICATION = new BooleanOption("cic.http.disablePreemptiveAuthentication");
    public static final BooleanOption CIC_EXPORT_FORCE_ADD_DIGESTS = new BooleanOption("cic.export.forceAddDigests");
    public static final BooleanOption CIC_EXPORT_UPDATE_DOWNLOAD_SIZE = new BooleanOption("cic.export.updateDownloadSize", true);
    public static final BooleanOption CIC_SKIP_SUPPORTS_GROUP_MODE_CHECK = new BooleanOption("cic.skip.SupportsGroupMode.check", false);
    public static final IntOption CIC_REPO_ADD_THREADS = new IntOption(Runtime.getRuntime().availableProcessors() == 1 ? "cic.repo.singleCPU.addThreads" : "cic.repo.multiCPU.addThreads", 4);
    public static final BooleanOption CIC_EXPANDER_ALLOW_ERRORS = new BooleanOption("cic.expander.allowErrors");
    public static final BooleanOption CIC_TOLERANCE_WORKAROUND = new BooleanOption("cic.tolerance.workaround", true);
    public static final BooleanOption CIC_REPO_LOCKING = new BooleanOption("cic.repo.locking", true);
    public static final BooleanOption CIC_AGENT_ALLOW_LEGACY_ARGUMENTS = new BooleanOption("com.ibm.cic.agent.allow.legacy.arguments");
    public static final BooleanOption CIC_ENABLE_GZIP_HTTP_REQUEST_HEADER = new BooleanOption("cic.http.enable.request.encoding.gzip", true);
    public static final BooleanOption CIC_ENABLE_GZIP_HTTP_REQUEST_HEADER_FOR_XML = new BooleanOption("cic.http.enable.request.encoding.gzip.for.xml", false);
    public static final BooleanOption CIC_FORCE_ZIP_INSTALL_DURING_INSTALL_PHASE = new BooleanOption("com.ibm.cic.force.zip.install.during.install.phase");
    public static final BooleanOption CIC_REPO_DISABLE_REQUIRECONTEXT = new BooleanOption("cic.repo.disable.requireContext");
    public static final BooleanOption CIC_SUPPORTS_CONSOLE_MODE = new BooleanOption("cic.supports.console.mode");
    public static final BooleanOption CIC_SUPPORTS_64_BIT_IM = new BooleanOption("cic.offering.supports.64bit.im");
    public static final BooleanOption CIC_IS_64_BIT_OS = new BooleanOption("cic.is.64bit.os");
    public static final BooleanOption CIC_OFFERING_SUPPORTS_ALL_PLATFORMS = new BooleanOption("cic.offering.supports.all.platforms");
    public static final BooleanOption CIC_USE_NATIVE_CHMOD = new BooleanOption("cic.use.native.chmod");
    public static final IgnoreBadFixesOption CIC_IGNORE_BAD_FIXES = new IgnoreBadFixesOption();
    private static final Set<String> nonDefaultUserOptions = new HashSet<String>();

    public static void initialize() {
        StringOption.reInitialize();
    }

    public static synchronized void logNonDefaultUserOptions(boolean init) {
        if (init) {
            UserOptions.initialize();
        }
        List allOptions = StringOption.getAllOptions();
        StringBuilder sb = new StringBuilder();
        for (StringOption option : allOptions) {
            boolean added;
            if (option.isDefault() || !(added = nonDefaultUserOptions.add(option.toString()))) continue;
            sb.append(LogUtil.NEWLINE).append("  ").append(option);
        }
        if (sb.length() > 0) {
            log.note(Messages.UserOptions_Non_Default_System_Properties, sb);
        }
    }

    public static String set(StringOption option, String value) {
        return option.set(value);
    }

    public static String getSimulatedMountPath() {
        return CIC_REPO_SIMULATED_MOUNT_PATH.value();
    }

    public static String getModelValidationFilter() {
        return CIC_MODEL_VALIDATION_FILTER.value();
    }

    public static boolean getIgnoreUnexpectedDigest() {
        return CIC_REPO_IGNORE_UNEXPECTED_DIGEST.isSet();
    }

    public static boolean useNonArtifactMD5s() {
        return CIC_REPO_USE_NON_ARTIFACT_MD5.isSet();
    }

    public static boolean getIgnoreAtoc() {
        return CIC_REPO_IGNORE_ARTIFACT_TOC.isSet();
    }

    public static boolean getRepoVolumeSupportInitialVersion() {
        return CIC_REPO_VOLUME_SUPPORT_INITIAL_VERSION.isSet();
    }

    public static boolean getDontWriteAtoc() {
        return CIC_REPO_DONT_WRITE_ARTIFACT_TOC.isSet();
    }

    public static boolean maintainAtocCompatibility() {
        return CIC_REPO_ATOC_COMPATIBILITY.isSet();
    }

    public static boolean getDownloadAlwaysUseTempForDip() {
        return CIC_DOWNLOAD_ALWAYS_TEMP_FOR_DIP.isSet();
    }

    public static boolean getExportForceAddDigests() {
        return CIC_EXPORT_FORCE_ADD_DIGESTS.isSet();
    }

    public static boolean getExportUpdateDownloadSize() {
        return CIC_EXPORT_UPDATE_DOWNLOAD_SIZE.isSet();
    }

    public static boolean isChmodNativeEnabled() {
        return CIC_USE_NATIVE_CHMOD.isSet();
    }

    public static boolean isAddThreads() {
        return UserOptions.getAddThreads() > 0;
    }

    public static int getAddThreads() {
        return CIC_REPO_ADD_THREADS.intValue();
    }

    public static boolean getDownloadSyncOnClose() {
        return CIC_DOWNLOAD_SYNC_ON_CLOSE.isSet();
    }

    public static class BooleanOption
    extends StringOption {
        private boolean booleanValue;

        public BooleanOption(String property) {
            this(property, false);
        }

        public BooleanOption(String property, boolean defaultValue) {
            super(property, Boolean.toString(defaultValue));
        }

        public boolean isSet() {
            return this.booleanValue;
        }

        public boolean set(boolean value) {
            boolean prev = this.booleanValue;
            this.set(Boolean.toString(value));
            return prev;
        }

        @Override
        protected void init() {
            super.init();
            this.booleanValue = Boolean.TRUE.equals(Boolean.valueOf(this.value()));
        }
    }

    public static class IgnoreBadFixesOption
    extends StringOption {
        public static final String IGNORE_NONE = "none";

        private IgnoreBadFixesOption() {
            super("cic.ignore.bad.fixes", "entitled");
        }

        public boolean isValueAll() {
            return this.value().equalsIgnoreCase("all");
        }

        public boolean isValueEntitled() {
            return this.value().equalsIgnoreCase("entitled");
        }

        public boolean isValueNone() {
            return this.value().equalsIgnoreCase(IGNORE_NONE);
        }
    }

    public static class IntOption
    extends StringOption {
        private int intValue;

        private IntOption(String property) {
            this(property, 0);
        }

        private IntOption(String property, int defaultValue) {
            super(property, Integer.toString(defaultValue));
        }

        public int intValue() {
            return this.intValue;
        }

        public int set(int value) {
            int prev = this.intValue;
            this.set(Integer.toString(value));
            return prev;
        }

        @Override
        protected void init() {
            super.init();
            try {
                this.intValue = Integer.parseInt(this.value());
            }
            catch (NumberFormatException numberFormatException) {
                this.intValue = Integer.parseInt(this.defaultValue);
            }
        }
    }

    public static class StringOption {
        private static final List<StringOption> allOptions = new ArrayList<StringOption>();
        private final String property;
        protected final String defaultValue;
        private String value = null;

        public StringOption(String property) {
            this(property, null);
        }

        private static List<StringOption> getAllOptions() {
            return Collections.unmodifiableList(allOptions);
        }

        public StringOption(String property, String defaultValue) {
            this.property = property;
            this.defaultValue = defaultValue;
            allOptions.add(this);
            this.init();
        }

        public String toString() {
            return String.valueOf(this.property) + '=' + this.value;
        }

        public static void reInitialize() {
            for (StringOption option : allOptions) {
                option.init();
            }
        }

        public String getName() {
            return this.property;
        }

        public String value() {
            return this.value;
        }

        public String set(String value) {
            String prev = this.value;
            System.setProperty(this.property, value);
            this.init();
            return prev;
        }

        public boolean isDefault() {
            return this.value == null ? this.defaultValue == null : this.value.equals(this.defaultValue);
        }

        protected void init() {
            this.value = this.getProperty();
            log.debug("{0}={1}", this.property, this.value);
        }

        protected String getProperty() {
            return System.getProperty(this.property, this.defaultValue);
        }
    }
}

