/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.utils.CanceledException;
import com.ibm.cic.common.core.utils.NoTaskNameProgressMonitor;
import com.ibm.cic.common.core.utils.Util;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class SplitProgressMonitor {
    private static final int SCALE = 1000;
    private IProgressMonitor monitor;
    private final String msg;
    private int curr = 0;
    private int[] weights;
    private IProgressMonitor prev = null;

    public SplitProgressMonitor(IProgressMonitor monitor, int n) {
        this(monitor, "", n);
    }

    public SplitProgressMonitor(IProgressMonitor monitor, String msg, int n) {
        this(monitor, msg, SplitProgressMonitor.createWeights(n));
    }

    public SplitProgressMonitor(IProgressMonitor monitor, int[] weights) {
        this(monitor, "", weights);
    }

    public SplitProgressMonitor(IProgressMonitor monitor, String msg, int[] weights) {
        this(monitor, msg);
        this.split(weights);
    }

    public SplitProgressMonitor(IProgressMonitor monitor) {
        this(monitor, "");
    }

    public SplitProgressMonitor(IProgressMonitor monitor, String msg) {
        this.monitor = monitor == null ? new NullProgressMonitor() : monitor;
        this.msg = msg;
        this.weights = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(4 * (this.weights != null ? this.weights.length : 6));
        if (this.msg.length() > 0) {
            sb.append(this.msg).append(": ");
        }
        if (this.weights == null) {
            sb.append("split() not yet called");
        } else {
            int i = 0;
            while (i < this.weights.length) {
                if (this.curr == i) {
                    sb.append("| ");
                }
                sb.append(this.weights[i]).append(' ');
                ++i;
            }
            if (this.curr == this.weights.length) {
                sb.append("| ");
            }
        }
        return sb.toString();
    }

    public SplitProgressMonitor split(int n) {
        return this.split(SplitProgressMonitor.createWeights(n));
    }

    public SplitProgressMonitor split(int weight1, int weight2) {
        return this.split(new int[]{weight1, weight2});
    }

    public SplitProgressMonitor split(int weight1, int weight2, int weight3) {
        return this.split(new int[]{weight1, weight2, weight3});
    }

    public SplitProgressMonitor split(int[] theWeights) {
        if (this.weights != null) {
            throw new IllegalStateException("weights can only be set once");
        }
        this.weights = new int[theWeights.length];
        int i = 0;
        while (i < theWeights.length) {
            this.weights[i] = 1000 * theWeights[i];
            ++i;
        }
        this.monitor.beginTask(this.msg, Util.sum(this.weights));
        this.monitor.subTask("");
        return this;
    }

    public SplitProgressMonitor noTaskName() {
        if (!(this.monitor instanceof NullProgressMonitor) && !(this.monitor instanceof NoTaskNameProgressMonitor)) {
            this.monitor = new NoTaskNameProgressMonitor(this.monitor);
        }
        return this;
    }

    public void setTaskName(String name) {
        this.monitor.setTaskName(name);
    }

    public void subTask(String name) {
        this.monitor.subTask(name);
    }

    public boolean isCanceled() {
        return this.monitor.isCanceled();
    }

    public void setCanceled(boolean value) {
        this.monitor.setCanceled(value);
    }

    public SplitProgressMonitor checkCanceled() throws CanceledException {
        if (this.isCanceled()) {
            throw CanceledException.INSTANCE;
        }
        return this;
    }

    public void done() {
        this.monitor.done();
        this.prev = null;
        this.curr = this.weights.length;
    }

    public void checkDone() {
        if (this.curr != this.weights.length) {
            throw new IllegalStateException("monitor is not done");
        }
        this.done();
    }

    public IProgressMonitor next() {
        if (this.weights == null) {
            throw new IllegalStateException("split() must be called before next()");
        }
        if (this.prev != null && this.prev instanceof MySubProgressMonitor) {
            MySubProgressMonitor myPrev = (MySubProgressMonitor)this.prev;
            if (!myPrev.hasBegun()) {
                myPrev.beginTask(null, 1);
            }
            myPrev.done();
        }
        if (this.curr >= this.weights.length) {
            throw new SplitProgressMonitorException();
        }
        this.prev = this.createSubProgressMonitor(this.weights[this.curr++]);
        return this.prev;
    }

    public SplitProgressMonitor splitNext(int n) {
        return this.splitNext(SplitProgressMonitor.createWeights(n));
    }

    public SplitProgressMonitor splitNext(int weight1, int weight2) {
        return this.splitNext(new int[]{weight1, weight2});
    }

    public SplitProgressMonitor splitNext(int[] splitWeights) {
        int i;
        if (splitWeights.length == 0) {
            IProgressMonitor next = this.next();
            next.beginTask(null, 1);
            next.done();
            return this;
        }
        if (splitWeights.length == 1) {
            return this;
        }
        int oldTotal = this.weights[this.curr++];
        int newLength = splitWeights.length + this.weights.length - this.curr;
        if (newLength <= this.weights.length) {
            this.curr -= splitWeights.length;
        } else {
            int[] newWeights = new int[newLength];
            i = this.curr;
            while (i < this.weights.length) {
                newWeights[splitWeights.length + i - this.curr] = this.weights[i];
                ++i;
            }
            this.curr = 0;
            this.weights = newWeights;
        }
        int newTotal = Math.max(1, Util.sum(splitWeights));
        i = 0;
        while (i < splitWeights.length) {
            this.weights[this.curr + i] = (splitWeights[i] * oldTotal + newTotal / 2) / newTotal;
            ++i;
        }
        return this;
    }

    private IProgressMonitor createSubProgressMonitor(int ticks) {
        if (this.monitor instanceof NullProgressMonitor) {
            return this.monitor;
        }
        return new MySubProgressMonitor(this.monitor, ticks);
    }

    private static int[] createWeights(int n) {
        int[] result = new int[n];
        int i = 0;
        while (i < n) {
            result[i] = 1;
            ++i;
        }
        return result;
    }

    private static class MySubProgressMonitor
    extends SubProgressMonitor {
        private boolean begun = false;

        public MySubProgressMonitor(IProgressMonitor monitor, int ticks) {
            super(monitor, ticks, monitor instanceof NoTaskNameProgressMonitor ? 0 : 4);
        }

        public void beginTask(String name, int totalWork) {
            this.begun = true;
            super.beginTask(name, totalWork);
        }

        public boolean hasBegun() {
            return this.begun;
        }
    }

    private static class SplitProgressMonitorException
    extends ArrayIndexOutOfBoundsException {
        public SplitProgressMonitorException() {
            super("next() called too many times");
        }
    }
}

