/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Set;

public class NIOChmodClause {
    private Operation op;
    private Set<PosixFilePermission> perms;

    private NIOChmodClause(Operation op) {
        this.op = op;
        this.perms = new HashSet<PosixFilePermission>();
    }

    public static NIOChmodClause getNewChmodOperation(Operation op) {
        NIOChmodClause clause = new NIOChmodClause(op);
        return clause;
    }

    public void add(PosixFilePermission perm) {
        this.perms.add(perm);
    }

    public Set<PosixFilePermission> apply(Set<PosixFilePermission> permission) {
        if (this.isAdd()) {
            permission.addAll(this.getPerms());
        } else if (this.isRemove()) {
            permission.removeAll(this.getPerms());
        } else if (this.isSet()) {
            permission = this.getPerms();
        }
        return permission;
    }

    private boolean isAdd() {
        return this.op == Operation.ADD;
    }

    private boolean isSet() {
        return this.op == Operation.SET;
    }

    private boolean isRemove() {
        return this.op == Operation.REMOVE;
    }

    public Set<PosixFilePermission> getPerms() {
        return this.perms;
    }

    public static enum Operation {
        ADD,
        REMOVE,
        SET;

    }
}

