/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class LinkedProperties
implements Map {
    private LinkedHashMap linkedMap = null;
    private static final String[] NO_KEYS = new String[0];

    public void putAll(LinkedProperties properties) {
        this.putAll((Map)properties);
    }

    public Collection getPropertyKeysCollection() {
        if (this.linkedMap == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this.linkedMap.keySet());
    }

    public String[] getPropertyKeys() {
        if (this.linkedMap == null) {
            return NO_KEYS;
        }
        Set keySet = this.linkedMap.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    public Object setProperty(String key, String value) {
        assert (key != null);
        assert (value != null);
        this.init();
        return this.linkedMap.put(key, value);
    }

    private void init() {
        if (this.linkedMap == null) {
            this.linkedMap = new LinkedHashMap();
        }
    }

    public String getProperty(String key) {
        return this.linkedMap == null ? null : this.linkedMap.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        String val = this.getProperty(key);
        return val == null ? defaultValue : val;
    }

    @Override
    public int size() {
        return this.linkedMap == null ? 0 : this.linkedMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.linkedMap == null ? true : this.linkedMap.isEmpty();
    }

    @Override
    public synchronized void clear() {
        this.linkedMap = null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.linkedMap != null ? this.linkedMap.containsKey(key) : false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.linkedMap != null ? this.linkedMap.containsValue(value) : false;
    }

    public Set entrySet() {
        return this.linkedMap != null ? this.linkedMap.entrySet() : Collections.EMPTY_SET;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LinkedProperties) {
            LinkedProperties rhs = (LinkedProperties)o;
            if (rhs.linkedMap == this.linkedMap) {
                return true;
            }
            if (rhs.linkedMap == null || this.linkedMap == null) {
                return false;
            }
            return rhs.linkedMap.equals(this.linkedMap);
        }
        if (!(o instanceof Map)) {
            return false;
        }
        if (this.linkedMap == null) {
            Map map = (Map)o;
            return map.size() <= 0;
        }
        return this.linkedMap.equals(o);
    }

    public Object get(Object key) {
        return this.linkedMap != null ? this.linkedMap.get(key) : null;
    }

    @Override
    public int hashCode() {
        return this.linkedMap != null ? this.linkedMap.hashCode() : 0;
    }

    public Set keySet() {
        return this.linkedMap != null ? this.linkedMap.keySet() : Collections.EMPTY_SET;
    }

    public Object put(Object arg0, Object arg1) {
        this.init();
        return this.linkedMap.put(arg0, arg1);
    }

    public void putAll(Map arg0) {
        this.init();
        this.linkedMap.putAll(arg0);
    }

    public Object remove(Object key) {
        return this.linkedMap != null ? this.linkedMap.remove(key) : null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.linkedMap);
        return sb.toString();
    }

    public Collection values() {
        return this.linkedMap != null ? this.linkedMap.values() : Collections.EMPTY_LIST;
    }
}

