/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository.nls;

import com.ibm.cic.common.core.downloads.TransferUtils;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IZipFileHandler;
import com.ibm.cic.common.core.repository.nls.ContentResourceManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;

public class ContentArcResourceManager
extends ContentResourceManager {
    public ContentArcResourceManager(IZipFileHandler a_arcHandler, ICicLocation subLoc) {
        super(subLoc.toString(), new RepositoryArcClassLoader(a_arcHandler));
    }

    private static class RepositoryArcClassLoader
    extends URLClassLoader {
        IZipFileHandler m_arcHandler;

        public RepositoryArcClassLoader(IZipFileHandler a_arcHandler) {
            super(new URL[0], (ClassLoader)null);
            this.m_arcHandler = a_arcHandler;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            try {
                String path = ContentArcResourceManager.resourceNameToLocation(name);
                if (this.m_arcHandler.containsFile(path)) {
                    return this.m_arcHandler.getInputStream(path);
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return null;
        }

        @Override
        public URL getResource(String name) {
            String nlLocation1 = ContentArcResourceManager.resourceNameToLocation(name);
            CicFileLocation l = new CicFileLocation(nlLocation1);
            URL return_value = l.toURL();
            if (return_value != null && !TransferUtils.validURL(return_value, null)) {
                return_value = null;
            }
            return return_value;
        }
    }
}

