/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository.digest;

import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestTocEntry;
import com.ibm.cic.common.core.utils.XMLWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RepositoryDigestToc {
    private final ArrayList<RepositoryDigestTocEntry> entries;
    private ICicLocation m_firstEntryFileName = null;

    ICicLocation getFirstEntryFileName() {
        if (this.m_firstEntryFileName == null) {
            if (!this.entries.isEmpty()) {
                return this.entries.get(0).getFileName();
            }
            this.m_firstEntryFileName = CicConstants.EMPTY_LOCATION;
        }
        return this.m_firstEntryFileName;
    }

    RepositoryDigestToc(int capacity) {
        this.entries = new ArrayList(capacity);
    }

    public RepositoryDigestToc() {
        this.entries = new ArrayList();
    }

    void addEntry(RepositoryDigestTocEntry entry) {
        this.entries.add(entry);
    }

    public List<RepositoryDigestTocEntry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    boolean isEmpty() {
        return this.entries.isEmpty();
    }

    void clear() {
        this.entries.clear();
    }

    void emitXML(XMLWriter writer) {
        if (!this.isEmpty()) {
            writer.start("toc");
            writer.attribute("fileCount", this.entries.size());
            for (RepositoryDigestTocEntry entry : this.entries) {
                entry.emitXML(writer);
            }
            writer.end("toc");
        }
    }
}

