/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.model.proxy.IOfferingReference;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.framework.Version;

public class UpdateOfferingUtils {
    public static List getAllOfferingsAndTheirUpdates(IRepository a_rep, boolean recursive, IProgressMonitor progressMonitor) {
        return UpdateOfferingUtils.getAllOfferingsAndTheirUpdates(false, a_rep, recursive, progressMonitor);
    }

    public static List getAllOfferingsAndTheirUpdates(boolean includeUnavailable, IRepository a_rep, boolean recursive, IProgressMonitor progressMonitor) {
        ArrayList return_value = new ArrayList();
        SplitProgressMonitor spm = new SplitProgressMonitor(progressMonitor, 2);
        List ofs = a_rep.getAllOfferings(includeUnavailable, spm.next());
        return_value.addAll(ofs);
        SplitProgressMonitor spm2 = new SplitProgressMonitor(spm.next(), ofs.size());
        for (IOffering offering : ofs) {
            UpdateOfferingUtils.getAllUpdates(includeUnavailable, a_rep, return_value, offering.getIdentity(), offering.getVersion(), recursive, spm2.next());
        }
        return return_value;
    }

    public static List getAllOfferingsUpdatesAndFixes(IRepository a_rep, IProgressMonitor progressMonitor) {
        return UpdateOfferingUtils.getAllOfferingsUpdatesAndFixes(false, a_rep, progressMonitor);
    }

    public static List getAllOfferingsUpdatesAndFixes(boolean includeUnavailable, IRepository a_rep, IProgressMonitor progressMonitor) {
        ArrayList return_value = new ArrayList();
        SplitProgressMonitor spm = new SplitProgressMonitor(progressMonitor, 3);
        return_value.addAll(a_rep.getAllOfferings(includeUnavailable, spm.next()));
        return_value.addAll(a_rep.getAllUpdates(includeUnavailable, null, null, spm.next()));
        return_value.addAll(a_rep.getAllFixes(includeUnavailable, spm.next()));
        return return_value;
    }

    public static List findAllOfferingsAndTheirUpdates(IRepository a_rep, IIdentity offeringId, Version offeringVersion, boolean recursive, IProgressMonitor progressMonitor) {
        return UpdateOfferingUtils.findAllOfferingsAndTheirUpdates(false, a_rep, offeringId, offeringVersion, recursive, progressMonitor);
    }

    public static List findAllOfferingsAndTheirUpdates(boolean includeUnavailable, IRepository a_rep, IIdentity offeringId, Version offeringVersion, boolean recursive, IProgressMonitor progressMonitor) {
        ArrayList return_value = new ArrayList();
        SplitProgressMonitor spm = new SplitProgressMonitor(progressMonitor, 3);
        UpdateOfferingUtils.getAllUpdates(includeUnavailable, a_rep, return_value, offeringId, offeringVersion, recursive, spm.next());
        Collection ofs = RepositoryUtils.findOfferings(includeUnavailable, a_rep, offeringId, spm.next());
        return_value.addAll(ofs);
        SplitProgressMonitor spm2 = new SplitProgressMonitor(spm.next(), ofs.size());
        for (IOffering offering : ofs) {
            UpdateOfferingUtils.getAllUpdates(includeUnavailable, a_rep, return_value, offering.getIdentity(), offering.getVersion(), recursive, spm2.next());
        }
        return return_value;
    }

    private static void getAllUpdates(boolean includeUnavailable, IRepository a_rep, List return_value, IIdentity offeringId, Version offeringVersion, boolean recursive, IProgressMonitor progressMonitor) {
        SplitProgressMonitor spm = new SplitProgressMonitor(progressMonitor, 2);
        List updates = a_rep.getAllUpdates(includeUnavailable, offeringId, offeringVersion, spm.next());
        SplitProgressMonitor spm2 = new SplitProgressMonitor(spm.next(), updates.size());
        for (IOffering update : updates) {
            if (return_value.contains(update)) continue;
            return_value.add(update);
            if (!recursive) continue;
            UpdateOfferingUtils.getAllUpdates(includeUnavailable, a_rep, return_value, update.getIdentity(), update.getVersion(), recursive, spm2.next());
        }
    }

    public static IOffering findOfferingOrUpdate(IRepository rep, IIdentity id, Version version, IProgressMonitor progressMonitor) {
        return UpdateOfferingUtils.findOfferingOrUpdate(false, rep, id, version, progressMonitor);
    }

    public static IOffering findOfferingOrUpdate(boolean includeUnavailable, IRepository rep, IIdentity id, Version version, IProgressMonitor progressMonitor) {
        IOffering return_value = rep.findOffering(includeUnavailable, id, version, progressMonitor);
        if (return_value == null) {
            return_value = rep.findUpdate(includeUnavailable, id, version, progressMonitor);
        }
        return return_value;
    }

    public static IOfferingOrFix findOfferingOrUpdateOrFix(IRepository rep, IIdentity id, Version version, IProgressMonitor progressMonitor) {
        return UpdateOfferingUtils.findOfferingOrUpdateOrFix(false, rep, id, version, progressMonitor);
    }

    public static IOfferingOrFix findOfferingOrUpdateOrFix(boolean includeUnavailable, IRepository rep, IIdentity id, Version version, IProgressMonitor progressMonitor) {
        IOfferingOrFix return_value = UpdateOfferingUtils.findOfferingOrUpdate(includeUnavailable, rep, id, version, progressMonitor);
        if (return_value == null) {
            return_value = rep.findFix(includeUnavailable, id, version, progressMonitor);
        }
        return return_value;
    }

    public static boolean isUpdate(IContent offering) {
        if (offering instanceof IOfferingReference) {
            return ((IOfferingReference)offering).isUpdate();
        }
        return false;
    }

    public static boolean isSync(IOffering offering) {
        return UpdateOfferingUtils.isUpdate(offering) && UpdateOfferingUtils.getBaseOfferingVersion(offering).equals((Object)offering.getVersion());
    }

    public static void unsetUpdate(IOffering offering) {
        if (offering instanceof IOfferingReference) {
            IOfferingReference offeringRef = (IOfferingReference)offering;
            offeringRef.unsetUpdate();
        }
    }

    public static void setUpdate(IOffering offering, IOffering baseOffering) {
        if (offering instanceof IOfferingReference) {
            String baseOfferingDisplayVersion;
            IOfferingReference offeringRef = (IOfferingReference)offering;
            Version baseOfferingVersion = baseOffering.getVersion();
            Information information = baseOffering.getInformation();
            String string = baseOfferingDisplayVersion = information != null ? information.getVersion() : null;
            if (baseOfferingDisplayVersion == null) {
                baseOfferingDisplayVersion = baseOfferingVersion.toString();
            }
            offeringRef.setUpdate(offering.getIdentity(), baseOfferingVersion, baseOfferingDisplayVersion);
        }
    }

    public static IIdentity getBaseOfferingId(IOfferingOrFix offeringOrFix) {
        return !UpdateOfferingUtils.isUpdate(offeringOrFix) ? null : ((IOfferingReference)offeringOrFix).getBaseOfferingId();
    }

    public static Version getBaseOfferingVersion(IOfferingOrFix offeringOrFix) {
        return !UpdateOfferingUtils.isUpdate(offeringOrFix) ? null : ((IOfferingReference)offeringOrFix).getBaseOfferingVersion();
    }

    public static String getBaseOfferingDisplayVersion(IOfferingOrFix offeringOrFix) {
        return !UpdateOfferingUtils.isUpdate(offeringOrFix) ? null : ((IOfferingReference)offeringOrFix).getBaseOfferingDisplayVersion();
    }

    public static IOffering getBaseOffering(IOffering update, IRepository repo, IProgressMonitor monitor) {
        if (!UpdateOfferingUtils.isUpdate(update)) {
            return null;
        }
        IIdentity id = UpdateOfferingUtils.getBaseOfferingId(update);
        Version version = UpdateOfferingUtils.getBaseOfferingVersion(update);
        return UpdateOfferingUtils.findOfferingOrUpdate(repo, id, version, monitor);
    }
}

