/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.utils.IStatusCodes;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class StatusCodes {
    private StatusCodes() {
    }

    public static boolean isContentNotFound(IStatus status) {
        return status.getCode() == 1 && IStatusCodes.PLUGIN_ID.equals(status.getPlugin()) && !status.matches(8);
    }

    private static boolean isAuthenticationCanceled(IStatus status, int severityMask) {
        return status.getCode() == 200 && IStatusCodes.PLUGIN_ID.equals(status.getPlugin()) && status.matches(severityMask);
    }

    public static boolean isAuthenticationCanceled(IStatus status) {
        return StatusCodes.isAuthenticationCanceled(status, 12);
    }

    public static boolean isContentFound(IStatus status) {
        return status.isOK() && !StatusCodes.isContentNotFound(status);
    }

    public static IStatus recodeNotFoundToSeverity(IStatus status, final int newSeverity) {
        IStatus recodedStatus = MultiStatusUtil.recodeStatus(status, new MultiStatusUtil.IStatusRecoder(){

            @Override
            public boolean needsRecoding(IStatus s) {
                return !s.isMultiStatus() && StatusCodes.isContentNotFound(s) && MultiStatusUtil.severityNotSame(s, newSeverity);
            }

            @Override
            public IStatus recode(IStatus s) {
                return new Status(newSeverity, s.getPlugin(), s.getCode(), s.getMessage(), s.getException());
            }

            @Override
            public IStatus recode(IStatus multiStatus, IStatus[] children) {
                throw new AssertionError((Object)"should never be called");
            }
        });
        return recodedStatus;
    }

    public static boolean isEqualByCodeSeverityPlugin(IStatus statusA, IStatus statusB) {
        return MultiStatusUtil.isEqualStatus(MultiStatusUtil.StatusEqualByCodeSeverityPlugin, statusA, statusB);
    }

    public static boolean isDiskPromptCanceledStatus(IStatus status) {
        return MultiStatusUtil.hasStatus(status, 8, IStatusCodes.PLUGIN_ID, 203);
    }

    public static boolean isMissingDiskPrompterStatus(IStatus status) {
        return MultiStatusUtil.hasStatus(status, 8, IStatusCodes.PLUGIN_ID, 202);
    }

    public static IStatus getDiskNotAvailableUsePromptOptionError(IStatus status, int newSeverity) {
        String msg = Messages.StatusCodes_diskNotAvailableUsePromptOption;
        IStatus retStatus = MultiStatusUtil.newFlattenedStatus(status.getPlugin(), status, msg);
        if (!(retStatus = MultiStatusUtil.newFilteredStatus(msg, retStatus, new MultiStatusUtil.IStatusFilter(){

            @Override
            public boolean considerChildren() {
                return true;
            }

            @Override
            public boolean include(IStatus aStatus) {
                return StatusCodes.isMissingDiskPrompterStatus(aStatus);
            }
        })).matches(newSeverity)) {
            retStatus = MultiStatusUtil.recodeLevel(retStatus, 4);
        }
        return retStatus;
    }

    private static boolean isKeyringTipOff(IStatus status) {
        IStatus e = IStatusCodes.STATUS_ERROR_MISSING_CREDENTIALS_KEYRING_TIPOFF;
        return status.getCode() == e.getCode() && e.getPlugin().equals(status.getPlugin());
    }

    public static IStatus replaceKeyringTipOffWhenPromptParameterAvailable(IStatus status) {
        IStatus recodedStatus = MultiStatusUtil.recodeStatus(status, new MultiStatusUtil.IStatusRecoder(){

            @Override
            public boolean needsRecoding(IStatus s) {
                return !s.isMultiStatus() && StatusCodes.isKeyringTipOff(s);
            }

            @Override
            public IStatus recode(IStatus s) {
                return IStatusCodes.STATUS_ERROR_MISSING_CREDENTIALS_PROMPT_OR_KEYRING_TIPOFF;
            }

            @Override
            public IStatus recode(IStatus multiStatus, IStatus[] children) {
                throw new AssertionError((Object)"should never be called");
            }
        });
        return recodedStatus;
    }
}

