/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.repository.AbstractBaseRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryCacheHandler;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositoryTypePriority;
import com.ibm.cic.common.logging.ExceptionUtil;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;

public class RepositoryDescriptor {
    private final IConfigurationElement m_element;
    private boolean readOnly;
    private boolean searchable;
    private RepositoryTypePriority priority = null;
    static final String VERSION = "version";
    static final String REPOSITORY_CLASS = "class";
    static final String HANDLER_CLASS = "class_handler";
    private static final String PARAMETERS = "RepositoryParameters";
    private static final String PROPERTY_KEY = "key";
    private static final String PROPERTY_LABEL = "label";
    private static final String PROPERTY_DESCR = "description";
    private static final String PROPERTY_TYPE = "type";
    private static final String PROPERTY_DEFAULT = "default";
    private static final String PROPERTY_REQUIRED = "required";
    private static final String PROPERTY_PASSWORD = "password";
    private static final String MEMORY_CACHE = "MemoryCache";
    private static final String PRIORITY = "Priority";
    private static final String NAME = "name";
    private static final String WEIGHT = "weight";
    private static final int DEFAULT_WEIGHT = 50;

    public RepositoryDescriptor(IConfigurationElement element) {
        this.m_element = element;
    }

    public IConfigurationElement getElement() {
        return this.m_element;
    }

    public String getType() {
        String return_value = this.getElement().getDeclaringExtension().getSimpleIdentifier();
        return return_value;
    }

    public String getVersion() {
        String return_value = this.getElement().getAttribute(VERSION);
        return return_value;
    }

    public int getWeight() {
        String weight = this.getElement().getAttribute(WEIGHT);
        try {
            return Integer.parseInt(weight);
        }
        catch (Throwable t) {
            ExceptionUtil.log.warning(t);
            return 50;
        }
    }

    public IRepository createInitializedExistingOrNewRepositoryObject(IRepositoryInfo repInfo, boolean tryToCreate) throws CoreException, IOException {
        AbstractBaseRepository return_value = this.createRepositoryObject(repInfo, null);
        if (return_value != null) {
            IStatus status = null;
            status = return_value.addExistingRepository();
            if (!status.isOK() && tryToCreate) {
                status = return_value.createRepository();
            }
            if (!status.isOK()) {
                return_value = null;
            }
            return_value = (AbstractBaseRepository)this.setMemoryCache(return_value);
        }
        return return_value;
    }

    public IRepository createInitializedNewRepositoryObject(IRepositoryInfo repInfo) throws CoreException, IOException {
        AbstractBaseRepository return_value = this.createRepositoryObject(repInfo, null);
        if (return_value != null) {
            IStatus status = null;
            status = return_value.createRepository();
            if (!status.isOK()) {
                return_value = null;
            }
            return_value = (AbstractBaseRepository)this.setMemoryCache(return_value);
        }
        return return_value;
    }

    public IRepository createInitializedExistingRepositoryObject(IRepositoryInfo repInfo) throws CoreException, IOException {
        AbstractBaseRepository return_value = this.createRepositoryObject(repInfo, null);
        if (return_value != null) {
            IStatus status = null;
            status = return_value.addExistingRepository();
            return_value = !status.isOK() ? null : (AbstractBaseRepository)this.setMemoryCache(return_value);
        }
        return return_value;
    }

    public AbstractBaseRepository createRepositoryObject(IRepositoryInfo repInfo, IProgressMonitor progressMonitor) throws CoreException {
        AbstractBaseRepository return_value = (AbstractBaseRepository)this.getElement().createExecutableExtension(REPOSITORY_CLASS);
        if (return_value != null) {
            repInfo.setLastOperationStatus(return_value.initializeRepository(repInfo, null));
            if (!repInfo.getLastOperationStatus().isOK()) {
                return_value = null;
            }
        }
        return return_value;
    }

    public RepositoryTypePriority getPriority() {
        if (this.priority == null) {
            String pr = this.getElement().getChildren(PRIORITY)[0].getAttribute(NAME);
            this.priority = RepositoryTypePriority.parse(pr);
        }
        return this.priority;
    }

    public IRepository setMemoryCache(IRepository repository) {
        IRepository return_value = repository;
        if (repository != null) {
            try {
                String c;
                String h;
                IConfigurationElement[] memCache = this.getElement().getChildren(MEMORY_CACHE);
                if (memCache.length > 0 && (h = memCache[0].getAttribute(HANDLER_CLASS)) != null & (c = memCache[0].getAttribute(REPOSITORY_CLASS)) != null) {
                    IRepositoryCacheHandler cacheHandler = (IRepositoryCacheHandler)memCache[0].createExecutableExtension(HANDLER_CLASS);
                    IRepository memoryCache = (IRepository)memCache[0].createExecutableExtension(REPOSITORY_CLASS);
                    if (memoryCache instanceof AbstractBaseRepository) {
                        memoryCache = ((AbstractBaseRepository)memoryCache).setUniqueRepositoryInfo(repository);
                    }
                    if (cacheHandler.setUpRepositories(repository, memoryCache)) {
                        return_value = cacheHandler;
                    }
                }
            }
            catch (InvalidRegistryObjectException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return return_value;
    }

    public RepositoryParameter[] getRepositoryParameters() {
        IConfigurationElement[] params;
        ArrayList<RepositoryParameter> return_value = new ArrayList<RepositoryParameter>();
        IConfigurationElement[] iConfigurationElementArray = params = this.getElement().getChildren(PARAMETERS);
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement param = iConfigurationElementArray[n2];
            String key = param.getAttribute(PROPERTY_KEY);
            String label = param.getAttribute(PROPERTY_LABEL);
            String descr = param.getAttribute(PROPERTY_DESCR);
            String type = param.getAttribute(PROPERTY_TYPE);
            String defaultVal = param.getAttribute(PROPERTY_DEFAULT);
            String requiredVal = param.getAttribute(PROPERTY_REQUIRED);
            String passwordVal = param.getAttribute(PROPERTY_PASSWORD);
            ICicPreferenceConstants.PreferenceTag tag = new ICicPreferenceConstants.PreferenceTag(key, label, descr, type == null ? 1 : Integer.valueOf(type));
            return_value.add(new RepositoryParameter(tag, defaultVal == null ? "" : defaultVal, requiredVal == null ? false : Boolean.valueOf(requiredVal), passwordVal == null ? false : Boolean.valueOf(passwordVal)));
            ++n2;
        }
        return return_value.toArray(new RepositoryParameter[return_value.size()]);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public boolean equals(Object o) {
        RepositoryDescriptor other;
        return o instanceof RepositoryDescriptor && (other = (RepositoryDescriptor)o).getType().equals(this.getType()) && other.getVersion().equals(this.getVersion());
    }

    public int hashCode() {
        return this.getType().hashCode() ^ this.getVersion().hashCode();
    }

    public String toString() {
        return "Type:'" + this.getType() + "'  Version:'" + this.getVersion() + "'";
    }

    public static class RepositoryParameter {
        public final ICicPreferenceConstants.PreferenceTag tag;
        public final String defaultValue;
        public final boolean isRequired;
        public final boolean isPassword;

        public RepositoryParameter(ICicPreferenceConstants.PreferenceTag tag, String defaultValue, boolean required, boolean password) {
            this.tag = tag;
            this.defaultValue = defaultValue;
            this.isRequired = required;
            this.isPassword = password;
        }
    }
}

