/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.repository.IInstallKitContext;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositoryContext;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Version;

public class InstallKitContextChecker
extends RepositoryContext.AbstractRepositoryContext
implements IInstallKitContext {
    private IInstallKitContext.IProvideAgentVersions installedAgent;
    private IInstallKitContext.IProvideAgentVersions runningAgent;

    public InstallKitContextChecker() {
        super("InstallKit");
    }

    @Override
    public void setInstalledAgentVersions(IInstallKitContext.IProvideAgentVersions provider) {
        this.installedAgent = provider;
    }

    @Override
    public void setRunningInstallerVersions(IInstallKitContext.IProvideAgentVersions provider) {
        this.runningAgent = provider;
    }

    @Override
    @Deprecated
    public Object saveState() {
        return new Object[]{this.installedAgent, this.runningAgent};
    }

    @Override
    @Deprecated
    public void restoreState(Object savedState) {
        if (savedState instanceof Object[]) {
            Object[] arr = (Object[])savedState;
            this.installedAgent = (IInstallKitContext.IProvideAgentVersions)arr[0];
            this.runningAgent = (IInstallKitContext.IProvideAgentVersions)arr[1];
        }
    }

    private String getRequireContextSyntax() {
        return NLS.bind(Messages.InstallKitContextChecker_requireContextSyntax, "RequireContext", this.getRepositoryContextId(), "im.version", "im.internal.version", "admin", "user");
    }

    private String getLocalizedVersionInternalVersion(Version version, Version internalVersion) {
        return NLS.bind(Messages.InstallKitContextChecker_versionInternalVersion, (Object)version, (Object)internalVersion);
    }

    @Override
    public IStatus checkRequiredContext(IRepositoryInfo repoInfo, Map repoProperties) {
        ICicStatus status;
        if (!this.hasThisRequireContext(repoProperties)) {
            if (this.hasThisContext(repoInfo)) {
                ICicStatus status2 = Statuses.ERROR.get(6020, Messages.InstallKitContextChecker_missingRepositoryPropertyRequireContext, "RequireContext", this.getRequireContextSyntax());
                return this.result(repoInfo, status2);
            }
            return Status.OK_STATUS;
        }
        this.parseNamedArguments();
        Map args = this.getNamedArguments();
        Version installerVersion = this.getVersionArgument(args, "im.version");
        Version installerInternalVersion = this.getVersionArgument(args, "im.internal.version");
        String admin = this.getArgument(args, "admin");
        String user = this.getArgument(args, "user");
        if (this.hasThisContext(repoInfo)) {
            String strRunningVersion = null;
            strRunningVersion = this.runningAgent == null ? this.getLocalizedVersionInternalVersion(null, null) : this.getLocalizedVersionInternalVersion(this.runningAgent.getDisplayVersion(), this.runningAgent.getInternalVersion());
            String strInstallerVersion = this.getLocalizedVersionInternalVersion(installerVersion, installerInternalVersion);
            if (!strInstallerVersion.equals(strRunningVersion)) {
                ICicStatus status3 = Statuses.ERROR.get(6020, Messages.InstallKitContextChecker_mismatchRunningInstallerAndInstallKit, repoInfo.getLocation(), strRunningVersion, strInstallerVersion, "RequireContext");
                return this.result(repoInfo, status3);
            }
            return this.result(repoInfo, Status.OK_STATUS);
        }
        if (this.installedAgent == null) {
            status = Statuses.ERROR.get(6020, Messages.InstallKitContextChecker_locationIsInstallKitVersion, repoInfo.getLocation(), installerVersion);
        } else {
            assert (this.installedAgent.getDisplayVersion() != null);
            assert (this.installedAgent.getInternalVersion() != null);
            boolean displayVersionEqual = this.installedAgent.getDisplayVersion().equals((Object)installerVersion);
            String strInstallKitVersion = displayVersionEqual ? this.getLocalizedVersionInternalVersion(installerVersion, installerInternalVersion) : installerVersion.toString();
            int cmp = this.installedAgent.getInternalVersion().compareTo(installerInternalVersion);
            status = cmp < 0 ? Statuses.ERROR.get(6020, Messages.InstallKitContextChecker_locationIsInstallKitVersion2, repoInfo.getLocation(), strInstallKitVersion, this.getInstallCommand(admin, user)) : Statuses.ERROR.get(6020, Messages.InstallKitContextChecker_locationIsInstallKitVersion3, repoInfo.getLocation(), strInstallKitVersion, displayVersionEqual ? this.getLocalizedVersionInternalVersion(this.installedAgent.getDisplayVersion(), this.installedAgent.getInternalVersion()) : this.installedAgent.getDisplayVersion().toString());
        }
        return this.result(repoInfo, status);
    }

    private String getArgument(Map args, String argument) {
        return this.getArgument(args, argument, this.getRequireContextSyntax());
    }

    private String getInstallCommand(String admin, String user) {
        return CicCommonSettings.getAccessRightsMode().isAdminMode() ? admin : user;
    }

    private Version getVersionArgument(Map args, String argument) {
        String value = this.getArgument(args, argument);
        Version v = Version.emptyVersion;
        try {
            v = new Version(value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(NLS.bind(Messages.InstallKitContextChecker_requireContextInvalidVersion, "RequireContext", argument, this.getRequireContextSyntax()), e);
        }
        return v;
    }
}

