/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IEnclosingRepositoryContext;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositoryContext;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

class EnclosingContextChecker
extends RepositoryContext.AbstractRepositoryContext
implements IEnclosingRepositoryContext {
    private static final String ARG_PATH = "path";

    public EnclosingContextChecker() {
        super("EnclosingRepository");
    }

    @Override
    public IStatus checkRequiredContext(IRepositoryInfo repoInfo, Map repoProperties) {
        if (!this.hasThisRequireContext(repoProperties)) {
            return Status.OK_STATUS;
        }
        this.parseNamedArguments();
        Map args = this.getNamedArguments();
        String path = (String)args.get(ARG_PATH);
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException(NLS.bind(Messages.RepositoryContext_requireEnclosingRepoMissingPathArg, "RequireContext", this.getRepositoryContextId(), ARG_PATH));
        }
        if (this.hasThisContext(repoInfo)) {
            return this.result(repoInfo, Status.OK_STATUS);
        }
        CicFileLocation relativePath = new CicFileLocation(path);
        ICicLocation useLocation = repoInfo.getLocation().appendRelative(relativePath);
        return this.result(repoInfo, Statuses.ERROR.get(6020, Messages.RepositoryContext_requireEnclosingRepoMessage, repoInfo.getLocationStr(), useLocation));
    }

    @Override
    public String getContextValue(IPath path) {
        return NLS.bind("{0}:path={1}", (Object)"EnclosingRepository", (Object)path);
    }
}

