/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.internal.downloads.FileContentInfo;
import com.ibm.cic.common.core.internal.repository.RepositoryInfo;
import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.model.Writer;
import com.ibm.cic.common.core.repository.AbstractBaseRepository;
import com.ibm.cic.common.core.repository.AbstractContentElementRepository;
import com.ibm.cic.common.core.repository.AbstractFileBasedRepository;
import com.ibm.cic.common.core.repository.ArchDownloader;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.DirectoryArtifactRepository;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.IZipFileHandler;
import com.ibm.cic.common.core.repository.LayoutPolicyCEJ2P1;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.repository.ZipFileHandler;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventContentListAdd;
import com.ibm.cic.common.core.repository.nls.ContentArcResourceManager;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.TempUtil;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadSession;
import com.ibm.cic.common.downloads.IFileContentInfo;
import com.ibm.cic.common.downloads.IMutableContentInfo;
import com.ibm.cic.common.downloads.ResumableDownloadProgress;
import com.ibm.cic.common.downloads.SimpleContentInfo;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ContentZip2Repository
extends AbstractContentElementRepository {
    private static final Logger log = Logger.getLogger(ContentZip2Repository.class);
    public static final String CONTENT_ZIP_REPOSITORY_TYPE = "ContentZip2";
    public static final String CONTENT_ZIP_REPOSITORY_VERSION = "0.0.0.1";
    public static final String ZIP_REPOSITORY_SE_FILE_EXT = "_SE.zip";
    public static final String INTERNAL_DIR_OFFSET = "InternalDirOffset";
    protected static final String REPOSITORY_ARC_HANDLER = "ArcHandler";
    private IZipFileHandler m_arcHandler;
    private IZipFileHandler m_arcParentHandler;
    private IZipFileHandler m_arc2Handler;
    private boolean m_isNestedArchiveRepository = false;
    private String m_internalElementFileName;
    private IRepository m_subrepository = null;

    public ContentZip2Repository() {
        this(CONTENT_ZIP_REPOSITORY_TYPE, CONTENT_ZIP_REPOSITORY_VERSION);
    }

    protected ContentZip2Repository(String type, String version) {
        super(type, version);
        this.setArtifactRepository(new DirectoryArtifactRepository(){

            @Override
            public IRepository getRepository() {
                return ContentZip2Repository.this;
            }

            @Override
            public void createArtifactRepository(IRepositoryInfo repInfo) {
            }

            @Override
            public void deleteArtifactRepository() {
            }
        });
        this.setLayoutPolicy(new LayoutPolicyCEJ2P1(this));
    }

    public String getDotFileExt() {
        return CicConstants.getZipFileDotExt();
    }

    static AbstractBaseRepository createRepositoryObject(IRepositoryInfo repInfo) {
        ContentZip2Repository return_value = new ContentZip2Repository();
        if (!((AbstractBaseRepository)return_value).initializeRepository(repInfo, null).isOK()) {
            return_value = null;
        }
        return return_value;
    }

    AbstractBaseRepository createArcRepositoryObject(IRepositoryInfo repInfo) {
        return ContentZip2Repository.createRepositoryObject(repInfo);
    }

    protected LayoutPolicyCEJ2P1 getCEJ2LP() {
        return (LayoutPolicyCEJ2P1)this.getLP();
    }

    @Override
    public void dispose() {
        if (this.m_arcHandler != null) {
            this.m_arcHandler.dispose();
        }
        if (this.m_arc2Handler != null) {
            this.m_arc2Handler.dispose();
        }
    }

    public IZipFileHandler getArcHandler() {
        return this.m_arcHandler;
    }

    public IZipFileHandler getArcParentHandler() {
        return this.m_arcParentHandler;
    }

    public IZipFileHandler getArc2Handler() {
        if (this.m_arc2Handler == null) {
            try {
                this.m_arc2Handler = new ZipFileHandler(this.getFileContentInfo(new CicFileLocation(this.getSEFileName(this.getLocationStr()))), this.getDownloader());
            }
            catch (Exception e) {
                log.debug(e);
            }
        }
        return this.m_arc2Handler;
    }

    @Override
    public IStatus initializeRepository(IRepositoryInfo repInfo, IProgressMonitor pm) {
        IStatus return_value = Status.OK_STATUS;
        if (super.initializeRepository(repInfo, pm).isOK() && repInfo.getName() != null && repInfo.getLocationStr().endsWith(this.getDotFileExt())) {
            this.setDownloader(new ArchDownloader(this, this.getDownloader()));
            this.m_arcHandler = (IZipFileHandler)repInfo.getProperty(REPOSITORY_ARC_HANDLER);
            if (this.m_arcHandler == null) {
                return_value = this.setArcHandler(repInfo, pm);
                if (return_value.isOK()) {
                    this.getCEJ2LP().setInternalDirectoryOffset(repInfo.getNonNullStringProperty(INTERNAL_DIR_OFFSET));
                    this.m_internalElementFileName = this.getCEJ2LP().getInternalDirectoryOffset().append(repInfo.getName()).toString();
                }
            } else if (CicConstants.hasArchiveInPath(repInfo.getLocation().removeLastSegment()) && CicConstants.isArchiveName(repInfo.getName())) {
                this.m_arcParentHandler = this.m_arcHandler;
                return_value = this.setArcHandler(repInfo, pm);
                if (return_value.isOK()) {
                    this.getCEJ2LP().setInternalDirectoryOffset("");
                    this.m_internalElementFileName = this.getCEJ2LP().getInternalDirectoryOffset().append(String.valueOf(repInfo.getName().substring(0, repInfo.getName().lastIndexOf(46))) + ".offering").toString();
                }
            } else {
                this.m_arc2Handler = this.m_arcHandler;
                this.m_isNestedArchiveRepository = true;
                this.getCEJ2LP().setInternalDirectoryOffset(repInfo.getNonNullStringProperty(INTERNAL_DIR_OFFSET));
                this.m_internalElementFileName = this.getCEJ2LP().getInternalDirectoryOffset().append(repInfo.getName()).toString();
            }
        } else {
            return_value = RepositoryStatus.createErrorMultiStatus(6014, Messages.ERROR_CANT_CREATE_REPOSITORY_OF_TYPE, this.getType(), this.getLocationStr(), return_value);
        }
        return return_value;
    }

    IStatus setArcHandler(IRepositoryInfo repInfo, IProgressMonitor pm) {
        Object return_value = Status.OK_STATUS;
        try {
            this.m_arcHandler = new ZipFileHandler(this.getFileContentInfo(repInfo.getLocation()), this.getDownloader());
        }
        catch (Exception e) {
            IStatus st;
            if (e instanceof CoreException && (st = ((CoreException)((Object)e)).getStatus()) != null) {
                return st;
            }
            return_value = new RepositoryStatus(RepositoryStatus.ST_ERROR_CANT_CREATE_REPOSITORY_AT_REMOTE_LOC, this, this.getLocationStr());
        }
        return return_value;
    }

    private IFileContentInfo getFileContentInfo(ICicLocation full_path) {
        IFileContentInfo return_value = null;
        return_value = full_path.toString().endsWith(this.getSEFileEnding()) ? (IFileContentInfo)this.getRepositoryInfo().getProperty("SECONDARY_CONTENT_INFO") : (IFileContentInfo)this.getRepositoryInfo().getProperty("MAIN_CONTENT_INFO");
        CicFileLocation path = null;
        CicFileLocation name = null;
        String[] segments = full_path.getSegments();
        int i = 0;
        while (i < segments.length - 1) {
            if (CicConstants.isArchiveName(segments[i])) {
                int index;
                String fullString = full_path.toString();
                path = new CicFileLocation(fullString.substring(0, index = fullString.indexOf(segments[i]) + segments[i].length() + 1));
                if (path.toFile().isFile() || FileURLUtil.isURLString(full_path.toString(), true)) {
                    name = new CicFileLocation(fullString.substring(index));
                    break;
                }
                path = null;
            }
            ++i;
        }
        if (path != null && name != null) {
            return_value = new FileContentInfo(path, name);
        }
        if (return_value == null || return_value.getFileName().getSize() == 0) {
            return_value = new FileContentInfo(full_path);
        }
        return return_value;
    }

    String getSEFileName(String name) {
        return String.valueOf(name.substring(0, name.lastIndexOf(this.getDotFileExt()))) + this.getSEFileEnding();
    }

    @Override
    public IStatus canAddExistingRepository(IProgressMonitor progressMonitor) {
        if (this.getArcHandler().exists() && this.getArcHandler().containsFile(this.m_internalElementFileName)) {
            return super.canAddExistingRepository(progressMonitor);
        }
        return Statuses.ERROR.get(6001, Messages.Repo_CantAddExistingRepository, new Object[0]);
    }

    @Override
    public IStatus isRepInfoMatchingRepositoryObject(IRepositoryInfo repInfo) {
        IStatus return_value = super.isRepInfoMatchingRepositoryObject(repInfo);
        if (return_value.isOK() && (repInfo.getName() == null || !repInfo.getName().equals(this.getName()))) {
            return Statuses.ERROR.get(6001, Messages.Repo_CantAddExistingRepository, new Object[0]);
        }
        return return_value;
    }

    @Override
    public IStatus canCreateRepository() {
        Object return_value = null;
        File file = this.getLocation().toFile();
        File parent = file.getParentFile();
        if (parent != null && parent.exists()) {
            return_value = super.canCreateRepository();
            if (return_value.isOK()) {
                return_value = this.getRepositoryInfo().getProperty("RepositoryElement") instanceof IContent ? Status.OK_STATUS : new RepositoryStatus(RepositoryStatus.ST_ERROR_CANT_CREATE_REPOSITORY_NO_ENOUGH_INFO, this.getLocationStr(), "RepositoryElement");
            }
        } else {
            return_value = new RepositoryStatus(RepositoryStatus.ST_ERROR_CANT_CREATE_REPOSITORY_AT_REMOTE_LOC, this, this.getLocationStr());
        }
        return return_value;
    }

    @Override
    public IStatus doSaveElement(IContent element) throws IOException {
        if (this.m_arcHandler.openToAddOrDeleteFiles()) {
            ZipOutputStream zout = this.m_arcHandler.startAddingFile(this.m_internalElementFileName);
            RepositoryUtils.writeToStream(element, zout);
            this.m_arcHandler.completeAddingFile();
            this.m_arcHandler.close();
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus doAddElement(IContent element) throws IOException {
        try {
            this.m_arcHandler.openToAddOrDeleteFiles();
            ZipOutputStream zout = this.m_arcHandler.startAddingFile(this.m_internalElementFileName);
            Writer.write(element, zout);
            this.m_arcHandler.completeAddingFile();
        }
        finally {
            this.m_arcHandler.close();
        }
        return Status.OK_STATUS;
    }

    @Override
    protected String[] getFileNames(ICicLocation relativeDirLocation, AbstractFileBasedRepository.Filter filter) {
        ArrayList<String> return_value = new ArrayList<String>();
        Set allFileNames = this.getArc2Handler().getFileNames();
        Iterator I = allFileNames.iterator();
        while (I.hasNext()) {
            String fileName;
            CicFileLocation loc = new CicFileLocation((String)I.next());
            if (!relativeDirLocation.toString().equals(loc.getPathSegments()) || !filter.acceptableFileName(fileName = loc.getName())) continue;
            return_value.add(fileName);
        }
        return return_value.toArray(new String[return_value.size()]);
    }

    @Override
    public IStatus addContent(List contentList) throws IOException {
        IStatus return_value;
        if (!contentList.isEmpty() && (return_value = this.doAddContent(contentList, ((IContent)contentList.get(0)).getRepository())).isOK()) {
            this.publishEvent(new RepositoryEventContentListAdd(this, contentList.size()));
        }
        return Status.OK_STATUS;
    }

    public IStatus doAddContent(List contentList, IRepository rep) throws IOException {
        try {
            this.getArc2Handler().openToAddOrDeleteFiles();
            for (IContent element : contentList) {
                this.doAddContent(element, rep);
            }
        }
        finally {
            this.getArc2Handler().close();
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IContentRepository createSubRepository(IContent content, String simpleFileName, ICicLocation relativeLocation) {
        if (CicConstants.fileMatchesDEFAULT_EXTENSIONS(simpleFileName)) {
            if (this.m_subrepository == null || content != null) {
                RepositoryInfo subRepositoryInfo = new RepositoryInfo(simpleFileName, this.getType(), this.getVersion(), this.getLocation(), null);
                try {
                    subRepositoryInfo.setProperty(REPOSITORY_ARC_HANDLER, this.getArc2Handler());
                    subRepositoryInfo.setProperty("RepositoryElement", content);
                    subRepositoryInfo.setProperty(INTERNAL_DIR_OFFSET, relativeLocation.toString());
                    AbstractBaseRepository rep = this.createArcRepositoryObject(subRepositoryInfo);
                    IStatus status = rep.addExistingRepository();
                    if (!status.isOK() && content != null) {
                        status = rep.createRepository();
                    }
                    if (status.isOK()) {
                        this.m_subrepository = rep;
                        this.m_subrepository.setRepositoryReference(this.getRepositoryReference());
                    }
                }
                catch (Throwable e) {
                    ExceptionUtil.debugLogToReview(e);
                    this.m_subrepository = null;
                }
            } else {
                this.m_subrepository.setName(simpleFileName);
            }
        } else {
            this.m_subrepository = null;
        }
        return (IContentRepository)this.m_subrepository;
    }

    @Override
    protected IContentRepository findSubRepository(IContent content, String simpleFileName, ICicLocation relativeLocation) {
        if (CicConstants.fileMatchesDEFAULT_EXTENSIONS(simpleFileName)) {
            if (this.m_subrepository == null || content != null) {
                RepositoryInfo subRepositoryInfo = new RepositoryInfo(simpleFileName, this.getType(), this.getVersion(), this.getLocation(), null);
                try {
                    subRepositoryInfo.setProperty(REPOSITORY_ARC_HANDLER, this.getArc2Handler());
                    subRepositoryInfo.setProperty("RepositoryElement", null);
                    subRepositoryInfo.setProperty(INTERNAL_DIR_OFFSET, relativeLocation.toString());
                    AbstractBaseRepository rep = this.createArcRepositoryObject(subRepositoryInfo);
                    IStatus status = rep.addExistingRepository();
                    if (status.isOK()) {
                        this.m_subrepository = rep;
                        this.m_subrepository.setRepositoryReference(this.getRepositoryReference());
                    }
                }
                catch (Throwable e) {
                    ExceptionUtil.debugLogToReview(e);
                    this.m_subrepository = null;
                }
            } else {
                this.m_subrepository.setName(simpleFileName);
            }
        } else {
            this.m_subrepository = null;
        }
        return (IContentRepository)this.m_subrepository;
    }

    @Override
    protected IContent doAddContent(IContent content, IRepository contentRep) {
        String fileName;
        IContentRepository subRepository;
        if ((content instanceof IShareableEntity || content instanceof ISuFragment) && (subRepository = this.createSubRepository(content, fileName = Writer.getFileName(content), this.getLP().getRelativeTopSeDirPath())) != null) {
            return this.customizeNewIContentObject(subRepository, subRepository.getElement(), this.getLP().getRelativeTopSeDirPath().append(fileName));
        }
        return null;
    }

    @Override
    public InputStream getInputStream(String relativePath) throws IOException {
        if (this.getArcHandler().containsFile(relativePath)) {
            return this.getArcHandler().getInputStream(relativePath);
        }
        if (this.getArc2Handler().containsFile(relativePath)) {
            return this.getArc2Handler().getInputStream(relativePath);
        }
        return null;
    }

    @Override
    public IStatus doSaveContent(IContent content) throws IOException {
        this.addContent(content);
        return Status.OK_STATUS;
    }

    @Override
    public IStatus doDeleteContent(IContent content) {
        IContentRepository rep;
        if (this.getStatus(false, null).isOK() && (rep = this.getContentRepository(content)) != null) {
            rep.delete(true);
        }
        return this.getStatus(false, null);
    }

    @Override
    public void doDelete() {
        if (!this.isNestedArchiveRepository()) {
            if (!this.getArcHandler().delete()) {
                this.setStatus((IStatus)new RepositoryStatus(RepositoryStatus.ST_ERRORTEMPLT_CANT_ACCESS_REPOSITORY, this));
            }
        } else {
            HashSet<String> deleteSet = new HashSet<String>();
            deleteSet.add(this.m_internalElementFileName);
            this.getArcHandler().deleteFiles(deleteSet);
        }
    }

    @Override
    public IStatus clear() {
        if (this.getStatus(false, null).isOK()) {
            if (!this.isNestedArchiveRepository()) {
                if (!this.getArc2Handler().delete()) {
                    this.setStatus((IStatus)new RepositoryStatus(RepositoryStatus.ST_ERRORTEMPLT_CANT_ACCESS_REPOSITORY, this));
                }
            } else if (this.getArc2Handler().exists()) {
                Set files = this.getArc2Handler().getFileNames();
                String offset = this.getCEJ2LP().getRelativeTopSeDirPath().toString();
                HashSet<String> deleteSet = new HashSet<String>();
                for (String name : files) {
                    if (!name.startsWith(offset)) continue;
                    deleteSet.add(name);
                }
                this.m_arc2Handler.deleteFiles(deleteSet);
            }
        }
        return super.clear();
    }

    @Override
    protected IStatus doAddNLSFile(String fileName, InputStream source) throws IOException {
        ICicLocation contentFolderPath = this.getLP().getRelativeTopNLSDirPath();
        if (this.m_arcHandler.openToAddOrDeleteFiles()) {
            ZipOutputStream zout = this.m_arcHandler.startAddingFile(contentFolderPath.append(fileName).toString());
            try {
                int num;
                byte[] buf = new byte[1024];
                while ((num = source.read(buf, 0, 1024)) != -1) {
                    zout.write(buf, 0, num);
                }
            }
            finally {
                this.m_arcHandler.completeAddingFile();
                this.m_arcHandler.close();
            }
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus doDeleteNLSFile(String fileName) {
        IStatus return_value = null;
        if (this.isWritable()) {
            String fileToDelete = this.getLP().getRelativeTopNLSDirPath().append(fileName).toString();
            if (this.getArcHandler().deleteFile(fileToDelete)) {
                return_value = Status.OK_STATUS;
            }
        } else {
            return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantDeleteNLFileReadOnly, fileName, this, 6081, log);
        }
        if (return_value == null) {
            return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantDeleteNLFile, fileName, this, 6080, log);
        }
        return return_value;
    }

    @Override
    public IStatus copyFrom(IContentRepository cer, IProgressMonitor monitor) {
        IStatus return_value = this.copyNLSFrom(cer);
        if (return_value.isOK()) {
            return_value = this.copyShareableEntitiesAndP2RepositoryFrom(cer, monitor);
        }
        return return_value;
    }

    protected IStatus copyShareableEntitiesAndP2RepositoryFrom(IContentRepository cer, IProgressMonitor monitor) {
        ContentZip2Repository zr;
        IStatus return_value = null;
        if (this.m_arc2Handler == null && cer.getType().equals(this.getType()) && cer.getVersion().equals(this.getVersion()) && (zr = (ContentZip2Repository)cer).getArcHandler() != zr.getArc2Handler()) {
            try {
                if (zr.getArc2Handler().exists()) {
                    File src = zr.getArc2Handler().getFile();
                    FileUtil.copyFile(src, this.getArc2Handler().getFile(), monitor);
                    return_value = Status.OK_STATUS;
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        if (return_value != Status.OK_STATUS) {
            List ses = cer.getAllShareableEntities(monitor);
            try {
                this.doAddContent(ses, (IRepository)cer);
                List suFragments = cer.getAllSuFragments(monitor);
                this.doAddContent(suFragments, (IRepository)cer);
                if (cer.containsP2Repository(monitor)) {
                    File tmp = TempUtil.createTempFile("FCM_", "content.xml");
                    return_value = cer.exportP2Repository(tmp, monitor);
                    if (return_value.isOK()) {
                        return_value = this.importP2Repository(tmp, monitor);
                    }
                    tmp.delete();
                } else {
                    return_value = Status.OK_STATUS;
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
        }
        if (return_value == null) {
            return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantCopyShareableEntitiesFrom, cer.getLocationStr(), 6019, log);
        }
        return return_value;
    }

    public IStatus copyNLSFrom(IContentRepository cer) {
        try {
            String[] fileList;
            this.getArcHandler().openToAddOrDeleteFiles();
            String[] stringArray = fileList = cer.getNLSFileList();
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                block8: {
                    String element = stringArray[n2];
                    InputStream source = null;
                    try {
                        try {
                            source = cer.openNLSFileStream(element);
                            this.addNLSFile(element, source);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            FileUtil.close(source);
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        FileUtil.close(source);
                        throw throwable;
                    }
                    FileUtil.close(source);
                }
                ++n2;
            }
            this.getArcHandler().close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    @Override
    public IContent getElement() {
        IContent return_value = null;
        return_value = this.getArcHandler().getIContentElement(this.m_internalElementFileName);
        this.initializeExtModel(return_value, new CicFileLocation(this.getName()));
        return return_value;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.m_internalElementFileName = this.getCEJ2LP().getInternalDirectoryOffset().append(this.getName()).toString();
        this.getLP().reset();
    }

    @Override
    public String[] getNLSFileList() {
        ArrayList<String> return_value = new ArrayList<String>();
        ICicLocation subPath = this.getLP().getRelativeTopNLSDirPath();
        Iterator I = this.getArcHandler().getFileNames().iterator();
        while (I.hasNext()) {
            CicFileLocation loc = new CicFileLocation((String)I.next());
            String file = loc.getNextSegment(subPath);
            if (file == null || !file.endsWith(".properties")) continue;
            return_value.add(file);
        }
        return return_value.toArray(new String[return_value.size()]);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public IStatus performNLSupdate(IContent element) {
        ICicLocation loc = this.getLP().getRelativeTopNLSDirPath().append("messages");
        ContentArcResourceManager resourceManager = new ContentArcResourceManager(this.m_arcHandler, loc);
        return resourceManager.performNLSupdate(element);
    }

    public boolean isNestedArchiveRepository() {
        return this.m_isNestedArchiveRepository;
    }

    @Override
    public IStatus getStatus(boolean reEvaluate, IProgressMonitor progressMonitor) {
        Object return_value = Status.OK_STATUS;
        if (reEvaluate && !this.m_arcHandler.exists()) {
            return_value = new RepositoryStatus(RepositoryStatus.ST_ERRORTEMPLT_CANT_ACCESS_REPOSITORY, this);
        }
        this.setStatus((IStatus)return_value);
        return return_value;
    }

    @Override
    public IContentInfo getElementContentInfo() {
        if (this.m_arcHandler != null) {
            IDownloadSession session = IDownloadSession.FACTORY.createDownloadSession();
            try {
                SimpleContentInfo newContentInfo = new SimpleContentInfo();
                if (!this.isNestedArchiveRepository() && this.m_arcHandler.exists()) {
                    this.computeDigests(session, newContentInfo, this.m_arcHandler.getFile(), DIGESTS);
                    return newContentInfo;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public HashMap getSecondaryContentInfoMap() {
        if (!this.isNestedArchiveRepository() && this.getArc2Handler().exists()) {
            IDownloadSession session = IDownloadSession.FACTORY.createDownloadSession();
            try {
                SimpleContentInfo newContentInfo = new SimpleContentInfo();
                File theFile = this.m_arc2Handler.getFile();
                if (theFile.exists()) {
                    this.computeDigests(session, newContentInfo, this.m_arc2Handler.getFile(), DIGESTS);
                    HashMap<String, SimpleContentInfo> return_value = new HashMap<String, SimpleContentInfo>();
                    return_value.put(this.getSEFileName(this.getLocation().getName()), newContentInfo);
                    return return_value;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return EMPTY_MAP;
    }

    protected String getSEFileEnding() {
        return ZIP_REPOSITORY_SE_FILE_EXT;
    }

    private void computeDigests(IDownloadSession session, IMutableContentInfo newContentInfo, File file, Collection computeDigests) throws IOException {
        if (computeDigests.size() == 0) {
            return;
        }
        FileInputStream in = new FileInputStream(file);
        long size = session.getContentInfoComputer().computeDigests(newContentInfo, computeDigests, in, file.length(), new ResumableDownloadProgress.IVerificationProgress(){

            @Override
            public void beginVerification() {
            }

            @Override
            public void endVerification() {
            }

            @Override
            public void updateVerificationProgress(int percent) {
            }

            @Override
            public boolean isCanceled() {
                return false;
            }
        });
        newContentInfo.setSize(size);
    }

    @Override
    public boolean containsP2Repository(IProgressMonitor monitor) {
        return this.getArc2Handler().containsFile(this.getLP().getRelativeP2FilePath().toString());
    }

    @Override
    protected IStatus doDeleteP2Repository(IProgressMonitor monitor) {
        IStatus return_value = null;
        if (this.isWritable()) {
            try {
                if (this.getArc2Handler().openToAddOrDeleteFiles() && this.getArc2Handler().deleteFile(this.getLP().getRelativeP2FilePath().toString())) {
                    this.getArc2Handler().close();
                    return_value = Status.OK_STATUS;
                }
            }
            catch (IOException e) {
                ExceptionUtil.debugLogIOException(e);
            }
        } else {
            return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantDeleteP2RepositoryReadOnly, this, 6074, log);
        }
        if (return_value == null) {
            return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantDeleteP2Repository, this, 6073, log);
        }
        return return_value;
    }

    @Override
    protected IStatus doImportP2Repository(File sourceP2RepositoryFile, IProgressMonitor monitor) {
        IStatus return_value = null;
        if (sourceP2RepositoryFile != null && this.isOpen() && this.canStoreMetadata()) {
            if (this.isWritable()) {
                if (sourceP2RepositoryFile.exists()) {
                    try {
                        if (this.getArc2Handler().openToAddOrDeleteFiles()) {
                            ZipOutputStream zout = this.getArc2Handler().startAddingFile(this.getLP().getRelativeP2FilePath().toString());
                            FileUtil.copyFileToStream(sourceP2RepositoryFile, zout, false, monitor);
                            this.getArc2Handler().completeAddingFile();
                            this.getArc2Handler().close();
                            return_value = Status.OK_STATUS;
                        }
                    }
                    catch (IOException e) {
                        return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantImportP2Repository, this, 6072, log, e);
                    }
                } else {
                    return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantImportP2RepositoryIsMissing, this, 6070, log);
                }
            } else {
                return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantImportP2RepositoryReadOnly, this, 6071, log);
            }
        }
        if (return_value == null) {
            return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantImportP2Repository, this, 6072, log);
        }
        return return_value;
    }

    @Override
    public IStatus exportP2Repository(File destinationFile, IProgressMonitor monitor) {
        return this.exportZippedP2Repository(this.getArc2Handler(), destinationFile);
    }
}

