/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.downloads.TransferUtils;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.internal.repository.TableOfContents;
import com.ibm.cic.common.core.internal.utils.CicParserUtils;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.model.Writer;
import com.ibm.cic.common.core.repository.AbstractBaseRepository;
import com.ibm.cic.common.core.repository.AbstractContentElementRepository;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.LayoutPolicyCEP1;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.core.repository.nls.ContentResourceManager;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.TempUtil;
import com.ibm.cic.common.downloads.ContentInfo;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadSession;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public class ContentElementRepository
extends AbstractContentElementRepository {
    public static final String REPOSITORY_TYPE = "ContentElementRepository";
    public static final String REPOSITORY_VERSION = "0.0.0.1";
    private ICicLocation contentFile;
    private URL contentFileURL;
    private int contentType = -1;
    private final IDownloadSession m_session = IDownloadSession.NO_SESSION;
    private final IContentInfo m_contentInfoBeforeUpdate = ContentInfo.EMPTY_CONTENT_INFO;
    private final TableOfContents.IOnTocSaved m_onSaved = null;
    private static final Logger log = Logger.getLogger(ContentElementRepository.class);

    public ContentElementRepository() {
        super(REPOSITORY_TYPE, REPOSITORY_VERSION);
        this.setLayoutPolicy(new LayoutPolicyCEP1(this));
    }

    static AbstractBaseRepository createRepositoryObject(IRepositoryInfo repInfo) {
        ContentElementRepository return_value = new ContentElementRepository();
        if (!return_value.initializeRepository(repInfo, null).isOK()) {
            return_value = null;
        }
        return return_value;
    }

    @Override
    public IStatus canAddExistingRepository(IProgressMonitor progressMonitor) {
        if (this.setContentFile(this.getRepositoryInfo()) && this.determineType(this.contentFile.toString()) != -1 && TransferUtils.validURL(this.contentFileURL, progressMonitor)) {
            return super.canAddExistingRepository(progressMonitor);
        }
        return Statuses.ERROR.get(6001, Messages.Repo_CantAddExistingRepository, new Object[0]);
    }

    @Override
    public IContent getElement() {
        IContent return_value = null;
        try {
            boolean includeBuildData = this.getRepositoryInfo().getIncludeBuildData();
            return_value = CicParserUtils.getObjectFromFile(this.contentFileURL, includeBuildData);
        }
        catch (IOException e) {
            log.debug(e);
        }
        this.initializeExtModel(return_value, new CicFileLocation(this.getName()));
        return return_value;
    }

    private boolean setContentFile(IRepositoryInfo repInfo) {
        if (this.contentFile == null) {
            if (repInfo.getName() != null) {
                this.contentFile = repInfo.getLocation().append(repInfo.getName());
                this.contentFileURL = this.contentFile.toURL();
            }
            return this.contentFile != null;
        }
        return true;
    }

    @Override
    protected void updateRepositoryInfo(IRepositoryInfo repInfo) throws CoreException, IOException {
        super.updateRepositoryInfo(repInfo);
        if (FileURLUtil.isURLString(this.getLocation().toString(), true)) {
            this.setWritable(false);
        }
    }

    @Override
    public IStatus canCreateRepository() {
        Object return_value = super.canCreateRepository();
        if (return_value.isOK()) {
            if (this.setContentFile(this.getRepositoryInfo()) && this.getRepositoryInfo().getProperty("RepositoryElement") instanceof IContent) {
                File file = this.contentFile.toFile();
                if (file.getParentFile().isDirectory() && !file.exists() && this.determineType(this.contentFile.toString()) != -1) {
                    return_value = Status.OK_STATUS;
                }
            } else {
                return_value = new RepositoryStatus(RepositoryStatus.ST_ERROR_CANT_CREATE_REPOSITORY_NO_ENOUGH_INFO, this.getLocationStr(), "RepositoryElement");
            }
        }
        return return_value;
    }

    @Override
    public IStatus doSaveElement(IContent content) throws IOException {
        File file = this.contentFile.toFile();
        Writer.write(content, file);
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus doAddElement(IContent element) throws IOException {
        return this.doSaveElement(element);
    }

    @Override
    protected IContent doAddContent(IContent content, IRepository contentRep) throws IOException {
        String fileName;
        ICicLocation contentFolderPath;
        File contentFolder;
        if ((content instanceof IShareableEntity || content instanceof ISuFragment) && !new File(contentFolder = (contentFolderPath = this.getLP().getFQTopSeDirPath()).toFile(), fileName = Writer.getFileName(content)).exists()) {
            IContentRepository subRepository;
            if (!contentFolder.exists()) {
                contentFolder.mkdirs();
            }
            if ((subRepository = this.createSubRepository(content, fileName, this.getLP().getRelativeTopSeDirPath())) != null) {
                IContentRepository cer;
                if (contentRep != null && (cer = contentRep.getContentRepository(content)) != null) {
                    subRepository.copyFrom(cer, null);
                }
                ArrayList<TableOfContents.TocEntry> list = new ArrayList<TableOfContents.TocEntry>(1);
                IContentInfo contentInfo = null;
                list.add(new TableOfContents.TocEntry(fileName, null, contentInfo));
                TableOfContents.addTocEntries(this.m_session, contentFolderPath, this.m_contentInfoBeforeUpdate, list, this.m_onSaved, (IProgressMonitor)new NullProgressMonitor());
                return this.customizeNewIContentObject(subRepository, subRepository.getElement(), this.getLP().getRelativeTopSeDirPath().append(fileName));
            }
        }
        return null;
    }

    @Override
    public IStatus doSaveContent(IContent content) throws IOException {
        ICicLocation contLocation;
        IContentRepository subRepository;
        IStatus return_value = this.getStatus(false, null);
        if (return_value.isOK() && (subRepository = this.createSubRepository(content, (contLocation = this.getLocation().append(content.getLocation())).getName(), content.getLocation().removeLastSegment())) != null) {
            return subRepository.saveElement(content);
        }
        return RepositoryStatus.ST_ERROR_CONTENT_ELEMENT_CANT_BE_SAVED;
    }

    @Override
    public IStatus doDeleteContent(IContent content) throws IOException {
        if (this.getStatus(false, null).isOK()) {
            IContentRepository rep = this.getContentRepository(content);
            if (rep != null) {
                rep.delete(true);
            }
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(content.getLocation().getName());
            TableOfContents.removeTocEntries(this.m_session, this.getLP().getCalculatedFQDirPath(content), this.m_contentInfoBeforeUpdate, list, this.m_onSaved, (IProgressMonitor)new NullProgressMonitor());
        }
        return this.getStatus(false, null);
    }

    @Override
    public void doDelete() {
        File path = new File(this.getLocationStr(), this.getName());
        if (path.exists()) {
            path.delete();
        }
    }

    @Override
    public IStatus clear() {
        if (this.getStatus(false, null).isOK()) {
            String contentRep = ((LayoutPolicyCEP1)this.getLP()).getFQBaseDirectory();
            this.clearElements(contentRep);
        }
        return super.clear();
    }

    private void clearElements(String a_fileName) {
        File[] subFiles;
        File path = new File(a_fileName);
        if (!path.exists()) {
            return;
        }
        File[] fileArray = subFiles = path.isDirectory() ? path.listFiles() : new File[]{};
        int n = subFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File subFile = fileArray[n2];
            if (!this.getSiteProperties().isSitePropertyFile(subFile.getName())) {
                if (subFile.isDirectory()) {
                    this.clearElements(subFile.getPath());
                } else {
                    subFile.delete();
                }
            }
            ++n2;
        }
        path.delete();
    }

    private int determineType(String fileName) {
        if (this.contentType == -1) {
            if (fileName.endsWith(".assembly")) {
                this.contentType = 2;
            } else if (fileName.endsWith(".su")) {
                this.contentType = 3;
            } else if (fileName.endsWith(".suFragment")) {
                this.contentType = 4;
            } else if (fileName.endsWith(".fix")) {
                this.contentType = 6;
            } else if (fileName.endsWith(".offering")) {
                this.contentType = 1;
            }
        }
        return this.contentType;
    }

    private IStatus copyNLSFrom(IContentRepository cer) {
        String[] fileList;
        String[] stringArray = fileList = cer.getNLSFileList();
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            try {
                InputStream nlStream = cer.openNLSFileStream(element);
                this.addNLSFile(element, nlStream);
                nlStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    private IStatus copyP2ContentFrom(IContentRepository cer, IProgressMonitor monitor) {
        IStatus return_value;
        if (cer.containsP2Repository(monitor)) {
            try {
                File tmp = TempUtil.createTempFile("FCM_", "content.xml");
                return_value = cer.exportP2Repository(tmp, monitor);
                if (return_value.isOK()) {
                    return_value = this.importP2Repository(tmp, monitor);
                }
                tmp.delete();
            }
            catch (IOException e) {
                return_value = Statuses.ERROR.get(e, e.toString(), new Object[0]);
            }
            catch (CoreException e) {
                return_value = Statuses.ERROR.get(e, e.toString(), new Object[0]);
            }
        } else {
            return_value = Status.OK_STATUS;
        }
        return return_value;
    }

    private IStatus copyShareableEntitiesFrom(IContentRepository cer, IProgressMonitor monitor) {
        List ses = cer.getAllShareableEntities(null);
        for (IShareableEntity element : ses) {
            try {
                this.doAddContent(element, cer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus copyFrom(IContentRepository cer, IProgressMonitor monitor) {
        if (cer.isEmpty()) {
            return Status.OK_STATUS;
        }
        IStatus return_value = this.copyNLSFrom(cer);
        if (return_value.isOK()) {
            return_value = this.copyShareableEntitiesFrom(cer, monitor);
        }
        if (return_value.isOK()) {
            return_value = this.copyP2ContentFrom(cer, monitor);
        }
        if (return_value.isOK()) {
            List suFragments = cer.getAllSuFragments(monitor);
            for (ISuFragment element : suFragments) {
                try {
                    this.doAddContent(element, cer);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return return_value;
    }

    @Override
    protected IStatus doAddNLSFile(String fileName, InputStream source) throws IOException {
        ICicLocation contentFolderPath;
        if (this.isWritable() && this.getStatus(true, null).isOK() && (contentFolderPath = this.getLP().getFQTopNLSPath()) != null) {
            File contentFolder = contentFolderPath.toFile();
            if (!contentFolder.exists()) {
                contentFolder.mkdirs();
            }
            ArrayList<TableOfContents.TocEntry> list = new ArrayList<TableOfContents.TocEntry>(1);
            IContentInfo contentInfo = null;
            list.add(new TableOfContents.TocEntry(fileName, null, contentInfo));
            File destination = new File(contentFolder, fileName);
            FileOutputStream ofs = null;
            try {
                int num;
                ofs = new FileOutputStream(destination);
                byte[] buf = new byte[1024];
                while ((num = source.read(buf, 0, 1024)) != -1) {
                    ofs.write(buf, 0, num);
                }
                TableOfContents.addTocEntries(this.m_session, contentFolderPath, this.m_contentInfoBeforeUpdate, list, this.m_onSaved, (IProgressMonitor)new NullProgressMonitor());
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                try {
                    if (ofs != null) {
                        ofs.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return RepositoryStatus.ST_ERROR_REPOSITORY_IS_NOT_WRITABLE;
    }

    @Override
    public IStatus performNLSupdate(IContent element) {
        if (TransferUtils.validURL(this.getLP().getFQTopNLSPath().toURL(), null)) {
            ICicLocation loc = this.getLP().getFQTopNLSPath().append("messages");
            ContentResourceManager resourceManager = new ContentResourceManager(loc.toString());
            return resourceManager.performNLSupdate(element);
        }
        return Status.OK_STATUS;
    }

    @Override
    public boolean isEmpty() {
        return !TransferUtils.validURL(this.getLocation().append(this.getLP().getRelativeDirectoryPrefix()).toURL(), null);
    }

    @Override
    public IStatus getStatus(boolean reEvaluate, IProgressMonitor progressMonitor) {
        Object return_value = Status.OK_STATUS;
        if (reEvaluate && !TransferUtils.validURL(this.contentFileURL, progressMonitor)) {
            return_value = new RepositoryStatus(RepositoryStatus.ST_ERRORTEMPLT_CANT_ACCESS_REPOSITORY, this);
        }
        this.setStatus((IStatus)return_value);
        return return_value;
    }

    @Override
    public HashMap getSecondaryContentInfoMap() {
        return EMPTY_MAP;
    }

    @Override
    protected IStatus doImportP2Repository(File sourceP2RepositoryFile, IProgressMonitor monitor) {
        IStatus return_value = null;
        if (sourceP2RepositoryFile != null && this.isOpen() && this.canStoreMetadata()) {
            if (this.isWritable()) {
                File p2RepositoryFile = this.getLP().getFQTopP2Path().toFile();
                FileUtil.ensureDestinationDirectory(p2RepositoryFile);
                try {
                    FileUtil.copyFile(sourceP2RepositoryFile, p2RepositoryFile, monitor);
                    return_value = Status.OK_STATUS;
                }
                catch (FileNotFoundException e) {
                    return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantImportP2RepositoryIsMissing, this, 6070, log, e);
                }
                catch (IOException e) {
                    return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantImportP2Repository, this, 6072, log, e);
                }
            } else {
                return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantImportP2RepositoryReadOnly, this, 6071, log);
            }
        }
        if (return_value == null) {
            return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantImportP2Repository, this, 6072, log);
        }
        return return_value;
    }
}

