/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.IArtifactGet;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.model.internal.Offering;
import com.ibm.cic.common.core.repository.AbstractFileBasedRepository;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.CompositeLayoutPolicy;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositoryFileBasedSiteProperties;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestRepositoryData;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Version;

public class CompositeRepository
extends AbstractFileBasedRepository {
    private static final Logger log = Logger.getLogger(CompositeRepository.class);
    private static final String FORBIDDEN_GROUP = "ForbiddenRepositoryGroup";
    public static final String REPOSITORY_TYPE = "CompositeRepository";
    public static final String REPOSITORY_VERSION = "0.0.0.1";
    public static final String REPOSITORY_REPORTED_STATUSES = "RepositoryReportedStatuses";
    private static Set staticHintOfferingOrFixes = null;
    private static int staticHintId = 1;
    private RepositoryGroup m_group = null;
    private List<IRepository> m_forbiddenList;
    private List<IRepository> m_parentForbiddenList;
    private RepositoryGroup m_artifactGetRepository = null;
    private int m_staticHintId = 0;

    public CompositeRepository() {
        this(REPOSITORY_TYPE, REPOSITORY_VERSION);
    }

    public CompositeRepository(String type, String version) {
        super(type, version);
        this.setLayoutPolicy(new CompositeLayoutPolicy(this));
        this.setSiteProperties(new RepositoryFileBasedSiteProperties(this.getLP()));
    }

    @Override
    public IStatus initializeRepository(IRepositoryInfo repInfo, IProgressMonitor progressMonitor) {
        IStatus return_value = super.initializeRepository(repInfo, progressMonitor);
        if (return_value.isOK()) {
            IStatus stat;
            return_value = this.getStatus(false, progressMonitor);
            if (!return_value.isOK() && !this.getSiteProperties().isInitialized()) {
                File location = repInfo.getLocation().toFile();
                return_value = !location.isDirectory() ? RepositoryStatus.createErrorMultiStatus(6014, Messages.ERROR_CANT_CREATE_REPOSITORY_OF_TYPE, this.getType(), this.getLocationStr(), return_value) : Status.OK_STATUS;
            }
            if (return_value.isOK() && (return_value = this.setPropertyGroup(repInfo)).isOK() && ((stat = this.getRepositoryInfo().getRepositoryReportedStatus()) == null || stat.getSeverity() != 4)) {
                this.getGroup();
            }
        }
        return return_value;
    }

    private IStatus setPropertyGroup(IRepositoryInfo repInfo) {
        Object parentForbiddenList = repInfo.getProperty(FORBIDDEN_GROUP);
        if (parentForbiddenList instanceof List) {
            this.m_parentForbiddenList = (List)parentForbiddenList;
        }
        if (this.m_parentForbiddenList == null) {
            this.m_parentForbiddenList = new ArrayList<IRepository>(1);
        }
        this.m_forbiddenList = new ArrayList<IRepository>(1);
        if (this.isForbiddenRepository(repInfo)) {
            return Statuses.ERROR.get(6001, Messages.Repo_CantAddExistingRepository, new Object[0]);
        }
        this.addForbiddenRepository(this.getRepositoryReference());
        return Status.OK_STATUS;
    }

    @Override
    public IStatus canCreateRepository() {
        IStatus return_value = super.canCreateRepository();
        if (return_value.isOK()) {
            return_value = this.getSiteProperties().canCreate();
        }
        return return_value;
    }

    @Override
    public IContent addContent(IContent content) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStatus clear() {
        this.clearGroup();
        this.m_parentForbiddenList.removeAll(this.m_forbiddenList);
        this.setPropertyGroup(this.getRepositoryInfo());
        if (this.m_artifactGetRepository != null) {
            this.m_artifactGetRepository.removeAllRepositories();
            this.m_artifactGetRepository = null;
            ++this.m_staticHintId;
        }
        this.getSiteProperties().getThisRepositoryDigestData().clearDigestInfo();
        return Status.OK_STATUS;
    }

    private synchronized void clearGroup() {
        if (this.m_group != null) {
            this.m_group.removeAllRepositories();
            this.m_group = null;
        }
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == CompositeRepository.class) {
            return this;
        }
        if (adapter == ReferencedRepositoriesSetter.class) {
            return new ReferencedRepositoriesSetter(this);
        }
        Object o = this.getIArtifactGetAdapter(adapter);
        if (o != null) {
            return o;
        }
        o = this.getGroup().getAdapter(adapter);
        if (o != null) {
            return o;
        }
        return super.getAdapter(adapter);
    }

    private IOffering findBaseOffering(IOffering offering) {
        if (UpdateOfferingUtils.isUpdate(offering)) {
            IIdentity baseId = UpdateOfferingUtils.getBaseOfferingId(offering);
            Version baseVersion = UpdateOfferingUtils.getBaseOfferingVersion(offering);
            return new Offering(baseId, baseVersion);
        }
        return null;
    }

    private Object getIArtifactGetAdapter(Class adapter) {
        if (adapter != IArtifactGet.class) {
            return null;
        }
        if (this.m_artifactGetRepository != null) {
            if (this.m_staticHintId == staticHintId) {
                return this.m_artifactGetRepository.getAdapter(adapter);
            }
            this.m_artifactGetRepository.removeAllRepositories();
            this.m_artifactGetRepository = null;
        }
        LinkedHashSet realRepositories = new LinkedHashSet(100);
        this.addRealRepositoriesToGroup(realRepositories, this.getGroup());
        ArrayList<IRepository> moveToFront = new ArrayList<IRepository>();
        HashMap<String, String> offeringMap = new HashMap<String, String>(4);
        if (staticHintOfferingOrFixes != null) {
            block0: for (IOfferingOrFix offeringOrFix : staticHintOfferingOrFixes) {
                while (offeringOrFix != null) {
                    IIdentity id = offeringOrFix.getIdentity();
                    Version version = offeringOrFix.getVersion();
                    IOffering baseOffering = null;
                    String baseOfferingRepository = null;
                    String offeringMapKey = String.valueOf(id.toString()) + version.toString();
                    if (offeringOrFix instanceof IOffering) {
                        if (offeringMap.containsKey(offeringMapKey)) continue block0;
                        offeringMap.put(offeringMapKey, offeringMapKey);
                    }
                    Iterator repos = realRepositories.iterator();
                    while (repos.hasNext()) {
                        IRepository repository = (IRepository)repos.next();
                        offeringOrFix = UpdateOfferingUtils.findOfferingOrUpdateOrFix(repository, id, version, (IProgressMonitor)new NullProgressMonitor());
                        if (offeringOrFix == null) continue;
                        repos.remove();
                        moveToFront.add(repository);
                        if (!(offeringOrFix instanceof IOffering)) continue;
                        IOffering offering = (IOffering)offeringOrFix;
                        if (baseOffering == null) {
                            baseOffering = this.findBaseOffering(offering);
                            baseOfferingRepository = repository.getLocationStr();
                            continue;
                        }
                        IOffering baseOffering2 = this.findBaseOffering(offering);
                        if (baseOffering2 == null || baseOffering.equals(baseOffering2)) continue;
                        log.warning(Messages.Repo_CompositeOfferingHasTwoDifferentBases, this.getLocationStr(), id, version, baseOfferingRepository, baseOffering.getVersion(), repository.getLocationStr(), baseOffering2.getVersion());
                    }
                    offeringOrFix = baseOffering;
                }
            }
        }
        this.m_artifactGetRepository = new RepositoryGroup(this.getArtifactGetRepositoryName());
        this.m_staticHintId = staticHintId;
        for (IRepository repo : moveToFront) {
            this.m_artifactGetRepository.addExistingRepository(repo, false);
        }
        for (IRepository repo : realRepositories) {
            this.m_artifactGetRepository.addExistingRepository(repo, false);
        }
        return this.m_artifactGetRepository.getAdapter(adapter);
    }

    public static void addOfferingOrFixesHint(IOfferingOrFix offeringOrFix) {
        if (offeringOrFix == null) {
            return;
        }
        if (staticHintOfferingOrFixes == null) {
            staticHintOfferingOrFixes = new HashSet();
        }
        if (staticHintOfferingOrFixes.contains(offeringOrFix)) {
            return;
        }
        staticHintOfferingOrFixes.add(offeringOrFix);
        ++staticHintId;
    }

    public static void clearOfferingOrFixesHints() {
        staticHintOfferingOrFixes = null;
    }

    private String getArtifactGetRepositoryName() {
        return String.valueOf(this.getName()) + "_Artifacts";
    }

    public synchronized IRepositoryGroup getGroup() {
        if (this.m_group == null) {
            this.m_group = new RepositoryGroup(this.getName());
            List<RepositoryDigestRepositoryData> subRepositories = this.getSiteProperties().getThisRepositoryDigestData().getRepositoryDigestList();
            int i = 0;
            while (i < subRepositories.size()) {
                RepositoryDigestRepositoryData repData = subRepositories.get(i);
                if (repData.getLocation().length() > 0) {
                    ICicLocation fullPath = this.resolvePath(repData.getLocation());
                    IRepositoryInfo repInfo = this.m_group.createRepositoryInfo(fullPath.getName(), null, null, fullPath, null);
                    if (this.getRepositoryInfo().isReadOnlyRepositoryRequested()) {
                        repInfo.requestReadOnlyRepository();
                    }
                    try {
                        IRepository rep = null;
                        if (repInfo != null) {
                            repInfo.setRepositoryDigestData(repData);
                            repInfo.setProperty(FORBIDDEN_GROUP, this.m_parentForbiddenList);
                            if (!this.isForbiddenRepository(repInfo)) {
                                rep = this.m_group.addExistingRepository(repInfo, false);
                                if (rep == null) {
                                    log.warning(Messages.Repo_CompositeCannotAddReferencedRepository, this.getLocationStr(), repInfo.getLocationStr());
                                } else if (!this.isForbiddenRepository(repInfo)) {
                                    this.addForbiddenRepository(rep);
                                }
                                this.processRepositoryStatus(repInfo);
                            }
                        }
                        if (rep == null && repInfo.getLastOperationStatus().getSeverity() == 8) {
                            this.m_group = null;
                            return new RepositoryGroup("dummy");
                        }
                    }
                    catch (CoreException coreException) {
                        log.warning(Messages.Repo_CompositeCannotAddReferencedRepository, this.getLocationStr(), repInfo.getLocationStr());
                    }
                    catch (IOException iOException) {
                        log.warning(Messages.Repo_CompositeCannotAddReferencedRepository, this.getLocationStr(), repInfo.getLocationStr());
                    }
                }
                ++i;
            }
        }
        return this.m_group;
    }

    private void processRepositoryStatus(IRepositoryInfo a_info) {
        IStatus nested_status = a_info.getRepositoryReportedStatus();
        CicMultiStatus nestedSubStatuses = (CicMultiStatus)a_info.getProperty(REPOSITORY_REPORTED_STATUSES);
        if (nested_status != null || nestedSubStatuses != null) {
            IStatus[] childStatuses;
            IStatus statusToAdd;
            CicMultiStatus subStatuses = (CicMultiStatus)this.getRepositoryInfo().getProperty(REPOSITORY_REPORTED_STATUSES);
            if (subStatuses == null) {
                subStatuses = Statuses.ST.createMultiStatus();
                this.getRepositoryInfo().setProperty(REPOSITORY_REPORTED_STATUSES, subStatuses);
            }
            if (nested_status != null) {
                statusToAdd = null;
                childStatuses = subStatuses.getChildren();
                statusToAdd = nested_status;
                int i = 0;
                while (i < childStatuses.length && statusToAdd != null) {
                    if (childStatuses[i].getCode() == nested_status.getCode() && childStatuses[i].getMessage().equals(nested_status.getMessage())) {
                        statusToAdd = null;
                    }
                    ++i;
                }
                if (statusToAdd != null) {
                    subStatuses.addAllStatuses(statusToAdd);
                }
            }
            if (nestedSubStatuses != null) {
                IStatus[] newChildStatuses;
                statusToAdd = null;
                childStatuses = subStatuses.getChildren();
                IStatus[] iStatusArray = newChildStatuses = nestedSubStatuses.getChildren();
                int n = newChildStatuses.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus newChildStatus;
                    statusToAdd = newChildStatus = iStatusArray[n2];
                    int i = 0;
                    while (i < childStatuses.length && statusToAdd != null) {
                        if (childStatuses[i].getCode() == statusToAdd.getCode() && childStatuses[i].getMessage().equals(newChildStatus.getMessage())) {
                            statusToAdd = null;
                        }
                        ++i;
                    }
                    if (statusToAdd != null) {
                        subStatuses.addAllStatuses(statusToAdd);
                    }
                    ++n2;
                }
            }
        }
    }

    private void addRealRepositoriesToGroup(Set destination, IRepositoryGroup source) {
        for (IRepository element : source) {
            IRepository repo = element;
            CompositeRepository compositeRepository = (CompositeRepository)repo.getAdapter(CompositeRepository.class);
            if (compositeRepository != null) {
                this.addRealRepositoriesToGroup(destination, compositeRepository.getGroup());
                continue;
            }
            destination.add(repo);
        }
    }

    @Override
    public List getAllAssemblies(IProgressMonitor progressMonitor) {
        return this.getGroup().getAllAssemblies(progressMonitor);
    }

    @Override
    public List getAllContentElements(IProgressMonitor pm) {
        List return_value = this.setContainingRepository(this.getGroup().getAllContentElements(pm));
        return return_value;
    }

    @Override
    public List getAllFixes(boolean includeUnavailable, IProgressMonitor progressMonitor) {
        return this.setContainingRepository(this.getGroup().getAllFixes(includeUnavailable, progressMonitor));
    }

    @Override
    public List getAllIus(IProgressMonitor progressMonitor) {
        return this.getGroup().getAllIus(progressMonitor);
    }

    @Override
    public List getAllOfferings(boolean includeUnavailable, IProgressMonitor progressMonitor) {
        List return_value = this.setContainingRepository(this.getGroup().getAllOfferings(includeUnavailable, progressMonitor));
        return return_value;
    }

    @Override
    public List getAllUpdates(boolean includeUnavailable, IIdentity offeringId, Version offeringVersion, IProgressMonitor progressMonitor) {
        List return_value = this.setContainingRepository(this.getGroup().getAllUpdates(includeUnavailable, offeringId, offeringVersion, progressMonitor));
        return return_value;
    }

    @Override
    public IContentRepository getContentRepository(IContent content) {
        IContentRepository return_value = null;
        Iterator<IRepository> I = this.getGroup().iterator();
        while (I.hasNext() && return_value == null) {
            IContent element;
            IRepository rep = I.next();
            if (content instanceof IOffering) {
                if (UpdateOfferingUtils.isUpdate(content)) {
                    element = rep.findUpdate(content.getIdentity(), content.getVersion(), null);
                    if (element != null) {
                        return_value = rep.getContentRepository(element);
                    }
                    this.setContainingRepository(rep.getAllUpdates(null, null, null));
                } else {
                    element = rep.findOffering(content.getIdentity(), content.getVersion(), null);
                    if (element != null) {
                        return_value = rep.getContentRepository(element);
                    }
                    this.setContainingRepository(rep.getAllOfferings(null));
                }
            } else if (content instanceof IFix) {
                element = rep.findFix(content.getIdentity(), content.getVersion(), null);
                if (element != null) {
                    return_value = rep.getContentRepository(element);
                }
                this.setContainingRepository(rep.getAllFixes(null));
            } else if (content instanceof IShareableEntity) {
                element = rep.findShareableEntity(content.getIdentity(), content.getVersion(), null);
                if (element != null) {
                    return_value = rep.getContentRepository(element);
                }
                this.setContainingRepository(rep.getAllShareableEntities(null));
            } else if (content instanceof ISuFragment) {
                element = rep.findSuFragment(content.getIdentity(), content.getVersion(), null);
                if (element != null) {
                    return_value = rep.getContentRepository(element);
                }
                this.setContainingRepository(rep.getAllSuFragments(null));
            } else if (content instanceof IInstallableUnit) {
                element = rep.findInstallableUnit(content.getIdentity(), content.getVersion(), null);
                if (element != null) {
                    return_value = rep.getContentRepository(element);
                }
                this.setContainingRepository(rep.getAllIus(null));
            }
            if (return_value == null) continue;
            return_value.setRepositoryReference(this.getRepositoryReference());
        }
        return return_value;
    }

    @Override
    public List getAllShareableEntities(IProgressMonitor progressMonitor) {
        return this.getGroup().getAllShareableEntities(progressMonitor);
    }

    @Override
    public List getAllSus(IProgressMonitor progressMonitor) {
        return this.getGroup().getAllSus(progressMonitor);
    }

    @Override
    public List getAllSuFragments(IProgressMonitor progressMonitor) {
        return this.getGroup().getAllSuFragments(progressMonitor);
    }

    @Override
    public IReadArtifactRepo.IArtifactTocCapabilities getArtifactTocCapabilities() {
        return this.getGroup().getArtifactTocCapabilities();
    }

    @Override
    public boolean isOpen() {
        return this.getRepositoryInfo().isOpen() || this.getGroup().isOpen();
    }

    @Override
    public IContent moveContent(IContent content) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasArtifactToc(IArtifactSession session, IProgressMonitor monitor) throws CoreException {
        return this.getGroup().hasArtifactToc(session, monitor);
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readArtifactToc(IArtifactSession session, IProgressMonitor monitor) throws CoreException {
        return this.getGroup().readArtifactToc(session, monitor);
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readCachedArtifactToc(IArtifactSession session, IPath tocCache, IProgressMonitor monitor) throws CoreException {
        return this.getGroup().readCachedArtifactToc(session, tocCache, monitor);
    }

    @Override
    public void refresh() {
        this.clear();
    }

    @Override
    public void dispose() {
        this.clear();
        super.dispose();
    }

    @Override
    public IStatus saveContent(IContent content) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setName(String name) {
        this.getGroup().setName(name);
    }

    @Override
    public void setOpen(boolean isOpen) {
        this.getRepositoryInfo().setOpen(isOpen);
        this.getGroup().setOpen(isOpen);
    }

    @Override
    public IStatus unsetUpdateOffering(IOffering updateOffering) {
        throw new UnsupportedOperationException();
    }

    public IRepository getProviderRepository(IOffering offering) {
        if (offering != null) {
            for (IRepository element : this.getGroup()) {
                IRepository rep = element;
                if (UpdateOfferingUtils.findOfferingOrUpdate(rep, offering.getIdentity(), offering.getVersion(), null) == null) continue;
                return rep;
            }
        }
        return null;
    }

    private boolean isRelativePath(String path) {
        return path.charAt(0) == '.';
    }

    @Override
    protected IStatus doCreateRepository() {
        IStatus return_value = super.doCreateRepository();
        if (return_value.isOK()) {
            return_value = this.getSiteProperties().save();
        }
        return return_value;
    }

    @Override
    public void doDelete() {
        File path = new File(this.getLocationStr());
        if (path.exists()) {
            File[] subFiles;
            File[] fileArray = subFiles = path.isDirectory() ? path.listFiles() : new File[]{};
            int n = subFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File subFile = fileArray[n2];
                String name = subFile.getName();
                if (this.getSiteProperties().isSitePropertyFile(name) || name.equals("")) {
                    FileUtil.delete(subFile);
                }
                ++n2;
            }
            FileUtil.deleteEmptyDirsLogIOE(path);
        }
    }

    private ICicLocation resolvePath(String path) {
        CicFileLocation location = new CicFileLocation(path);
        if (this.isRelativePath(path)) {
            return this.getLocation().appendRelative(location);
        }
        return location;
    }

    @Override
    public RepositoryDigestRepositoryData generateRepositoryDigestData(CicMultiStatus status, IProgressMonitor pm) {
        RepositoryDigestRepositoryData return_value = this.getRepositoryDigestData();
        return_value.clearDigestInfo();
        return_value.addRepositoryDigestDictionaryList(this);
        SplitProgressMonitor spm = new SplitProgressMonitor(pm, this.getGroup().size());
        Iterator<IRepository> iterator = this.getGroup().iterator();
        while (iterator.hasNext()) {
            IRepository element;
            IRepository rep = element = iterator.next();
            RepositoryDigestRepositoryData subRdd = rep.generateRepositoryDigestData(status, spm.next());
            if (!status.isOK()) continue;
            return_value.addRepositoryDigestData(subRdd);
        }
        if (status.isOK()) {
            return_value.setUseContentData(true);
            return return_value;
        }
        return_value.setUseContentData(false);
        return null;
    }

    @Override
    protected void updateRepositoryInfo(IRepositoryInfo repInfo) throws CoreException, IOException {
        super.updateRepositoryInfo(repInfo);
        if (FileURLUtil.isURLString(this.getLocation().toString(), true)) {
            this.setWritable(false);
        }
    }

    @Override
    protected IStatus doImportP2Repository(File p2RepositoryFile, IProgressMonitor progressMonitor) {
        return RepositoryStatus.createErrorStatus(Messages.Repo_CantImportP2Repository, this, 6072, log, new UnsupportedOperationException());
    }

    @Override
    protected IStatus doDeleteP2Repository(IProgressMonitor progressMonitor) {
        return RepositoryStatus.createErrorStatus(Messages.Repo_CantDeleteP2Repository, this, 6073, log, new UnsupportedOperationException());
    }

    @Override
    public IStatus exportP2Repository(File destinationFile, IProgressMonitor progressMonitor) {
        return RepositoryStatus.createErrorStatus(Messages.Repo_CantExportP2Repository, this, 6075, log, new UnsupportedOperationException());
    }

    @Override
    public boolean containsP2Repository(IProgressMonitor monitor) {
        boolean return_value = false;
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, this.getGroup().size());
        Iterator<IRepository> I = this.getGroup().iterator();
        while (I.hasNext() && !return_value) {
            IRepository rrepo = I.next();
            if (!rrepo.containsP2Repository(pm.next())) continue;
            return_value = true;
        }
        pm.done();
        return return_value;
    }

    private boolean isForbiddenRepository(IRepositoryInfo repInfo) {
        for (IRepository rr : this.m_parentForbiddenList) {
            if (!rr.getLocation().equals(repInfo.getLocation()) || !rr.isRepInfoMatchingRepositoryObject(repInfo).isOK()) continue;
            return true;
        }
        return false;
    }

    private void addForbiddenRepository(IRepository rep) {
        this.m_parentForbiddenList.add(rep);
        this.m_forbiddenList.add(rep);
    }

    protected void finalize() throws Throwable {
        if (this.m_group != null) {
            this.m_group.removeAllRepositories();
        }
        if (this.m_artifactGetRepository != null) {
            this.m_artifactGetRepository.removeAllRepositories();
        }
        super.finalize();
    }

    private List setContainingRepository(List iContentList) {
        for (IContent content : iContentList) {
            content.setRepository(this.getRepositoryReference());
        }
        return iContentList;
    }

    public static class ReferencedRepositoriesSetter {
        private final CompositeRepository m_rep;

        ReferencedRepositoriesSetter(CompositeRepository a_rep) {
            this.m_rep = a_rep;
        }

        public void addRepositoryLocation(String a_location) {
            this.m_rep.getSiteProperties().getThisRepositoryDigestData().getRepositoryDigestData(null, a_location);
            this.m_rep.clear();
        }

        public void removeRepositoryLocation(String a_location) {
            this.m_rep.getSiteProperties().getThisRepositoryDigestData().removeRepositoryDigestData(a_location);
            this.m_rep.clear();
        }

        public void save() {
            this.m_rep.getSiteProperties().save();
        }

        public String[] getAllRepositoryLocations() {
            return this.m_rep.getSiteProperties().getThisRepositoryDigestData().getNestedRepositoryLocations();
        }

        public String[] getAllRepositoryResolvedLocations() {
            String[] return_value = this.getAllRepositoryLocations();
            int i = 0;
            while (i < return_value.length) {
                return_value[i] = this.m_rep.resolvePath(return_value[i]).toString();
                ++i;
            }
            return return_value;
        }
    }
}

