/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.preferences;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.preferences.CicAbstractPreferenceHandler;
import com.ibm.cic.common.core.preferences.CicURLPreferences;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CicLocationPreferenceHandler
extends CicAbstractPreferenceHandler {
    boolean m_isValid = false;
    boolean m_isReady = false;
    protected String m_currentPrefStoreLocation = "";
    private IStatus status = Status.OK_STATUS;

    public CicLocationPreferenceHandler() {
    }

    public CicLocationPreferenceHandler(URL thePreferenceStoreLocation) {
        this.m_isValid = this.setPreferenceStore(thePreferenceStoreLocation);
    }

    private boolean setPreferenceStore(URL thePreferenceStoreLocation) {
        boolean bl = this.m_isReady = thePreferenceStoreLocation != null;
        if (this.m_isReady) {
            CicURLPreferences PS = new CicURLPreferences(thePreferenceStoreLocation);
            try {
                PS.load();
            }
            catch (IOException e) {
                this.m_isReady = false;
                this.status = new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 4, e.getMessage(), null);
            }
            if (this.m_isReady) {
                this.status = Status.OK_STATUS;
                this.setPreferences(PS);
            }
        }
        return this.m_isReady;
    }

    @Override
    public boolean isValid() {
        return this.m_isValid;
    }

    @Override
    public boolean isReady() {
        return this.m_isReady;
    }

    @Override
    public boolean refresh() {
        boolean return_value = false;
        String location = this.getPrefMan().getString(ICicPreferenceConstants.PREF_LOCATION.key());
        boolean bl = this.m_isValid = location.length() != 0;
        if (this.m_isValid && !this.m_currentPrefStoreLocation.equals(location)) {
            return_value = true;
            this.m_currentPrefStoreLocation = location;
            this.setPreferenceStore(this.toURL(location));
        }
        return return_value;
    }

    protected URL toURL(String s) {
        URL return_value = null;
        try {
            if (s.length() > 0) {
                try {
                    return_value = new URL(s);
                }
                catch (Throwable throwable) {
                    File file = new File(s);
                    return_value = file.toURI().toURL();
                }
            }
        }
        catch (Throwable e) {
            this.status = new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 4, e.getMessage(), null);
            e.printStackTrace();
        }
        return return_value;
    }

    @Override
    public void save() {
    }

    @Override
    public IStatus getStatus() {
        return this.status;
    }
}

