/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.validation;

import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.model.internal.validation.Messages;
import org.eclipse.osgi.util.NLS;

public class ArtifactCheck {
    private static final int STATE_TOKEN_EXPECTED = 1;
    private static final int STATE_TOKEN_OR_DOT_EXPECTED = 2;
    public static final String INVALID_ID_REASON_MUST_NOT_BE_EMPTY = "INVALID_EMPTY";
    public static final String INVALID_ID_REASON_BAD_DOT = "INVALID_BAD_DOT";
    public static final String INVALID_ID_REASON_BAD_TOKEN_CHARS = "INVALID_BAD_TOKEN";
    public static final String VALID_ID_TIP = Messages.ArtifactCheck_ValidUsage;

    public static String getInvalidIdMessage(IArtifact artifact, String reason) {
        if (reason.equals(INVALID_ID_REASON_MUST_NOT_BE_EMPTY)) {
            return NLS.bind((String)Messages.ArtifactCheck_EmptyId, (Object)artifact.toUserString());
        }
        if (reason.equals(INVALID_ID_REASON_BAD_DOT)) {
            return NLS.bind((String)Messages.ArtifactCheck_BadDot, (Object)artifact.toUserString());
        }
        assert (reason.equals(INVALID_ID_REASON_BAD_TOKEN_CHARS));
        return NLS.bind((String)Messages.ArtifactCheck_InvalidTokenCharacter, (Object)artifact.toUserString());
    }

    public static String getInvalidIdReason(IArtifactKey key) {
        return ArtifactCheck.getInvalidIdReason(key.getId().getId());
    }

    public static String getInvalidIdReason(IArtifact artifact) {
        return ArtifactCheck.getInvalidIdReason(artifact.getKey());
    }

    public static String getInvalidIdReason(String id) {
        assert (id != null);
        int len = id.length();
        if (len <= 0) {
            return INVALID_ID_REASON_MUST_NOT_BE_EMPTY;
        }
        int state = 1;
        char c = ' ';
        int i = 0;
        while (i < len) {
            c = id.charAt(i);
            switch (state) {
                case 1: {
                    if (!ArtifactCheck.isTokenChar(c)) {
                        if (c == '.') {
                            return INVALID_ID_REASON_BAD_DOT;
                        }
                        return INVALID_ID_REASON_BAD_TOKEN_CHARS;
                    }
                    state = 2;
                    break;
                }
                case 2: {
                    if (ArtifactCheck.isTokenChar(c)) break;
                    if (c == '.') {
                        state = 1;
                        break;
                    }
                    return INVALID_ID_REASON_BAD_TOKEN_CHARS;
                }
            }
            ++i;
        }
        if (state == 1 && c == '.') {
            return INVALID_ID_REASON_BAD_DOT;
        }
        return null;
    }

    private static boolean isTokenChar(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_' || c == '-';
    }
}

