/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.utils;

import com.ibm.cic.common.downloads.SizeInfo;

public class MaxInstallSizeInfo
extends SizeInfo {
    private long maxSize;

    public MaxInstallSizeInfo() {
        this(Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE);
    }

    public MaxInstallSizeInfo(SizeInfo rhs) {
        this(rhs.getDownloadSize(), rhs.getInstallSize(), rhs.getInstallSize());
    }

    public MaxInstallSizeInfo(MaxInstallSizeInfo maxSizeInfo) {
        this(maxSizeInfo.getDownloadSize(), maxSizeInfo.getInstallSize(), maxSizeInfo.getMaxSize());
    }

    public MaxInstallSizeInfo(long downloadSize, long installSize, long maxSize) {
        super(downloadSize, installSize);
        this.maxSize = maxSize;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + ", maxSize=" + MaxInstallSizeInfo.toString(this.maxSize);
    }

    public void setSizes(long downloadSize, long installSize, long maxSize) {
        super.setSizes(downloadSize, installSize);
        this.maxSize = maxSize;
    }

    public void setSizes(MaxInstallSizeInfo that) {
        super.setSizes(that);
        this.maxSize = that.getMaxSize();
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public void add(MaxInstallSizeInfo that) {
        super.add(that);
        this.addMaxSize(that.getMaxSize());
    }

    @Override
    public void add(SizeInfo that) {
        super.add(that);
        this.addMaxSize(that.getInstallSize());
    }

    public void addMaxSize(long maximumSize) {
        this.maxSize = MaxInstallSizeInfo.add(this.maxSize, maximumSize);
    }
}

