/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.utils;

import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IInstallableUnitContainer;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.model.proxy.IOfferingOrFixReference;
import com.ibm.cic.common.core.model.proxy.IOfferingReference;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.licensing.common.core.ILicenseCheckProvider;
import com.ibm.cic.licensing.common.core.LicenseCheckerFactory;
import com.ibm.cic.licensing.common.core.Messages;
import com.ibm.cic.licensing.common.util.LicenseStatus;
import com.ibm.cic.licensing.common.util.PolicyManager;
import com.ibm.cic.licensing.common.util.ProductInformation;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class LicenseUtils {
    private static final Logger log = Logger.getLogger(LicenseUtils.class);
    public static final String LICENSE_TYPE_FLOATING = Messages.LicenseType_Floating;
    public static final String LICENSE_TYPE_PERM = Messages.LicenseType_Perm;
    public static final String LICENSE_TYPE_TERM = Messages.LicenseType_Term;
    public static final String LICENSE_TYPE_TRIAL = Messages.LicenseType_Trial;
    public static final String LICENSE_TYPE_NODELOCKED = Messages.LicenseType_Nodelocked;
    public static final int LICENSED_OFFERINGS_FLAG = 1;
    public static final int LICENSED_FEATURES_FLAG = 2;
    public static final int LICENSED_ALL_FLAG = 3;
    public static final Version LICENSE_LUM_VERSION_DEFAULT = new Version("7.0.200");
    private static final Util.Formatter FORMATTER = new Util.Formatter(", ");

    public static boolean isPEKOffering(IOffering offering) {
        String type = offering.getProperties().getProperty("offering.type");
        return "pek".equals(type);
    }

    public static Version getOfferingLumVersion(IOffering of) {
        String lumVersion;
        Version return_value = LICENSE_LUM_VERSION_DEFAULT;
        if (of != null && (lumVersion = of.getProperty("license.lum.version")) != null && lumVersion.length() > 0) {
            return_value = new Version(lumVersion);
        }
        return return_value;
    }

    public static boolean isPEKOffering(IOfferingOrFix offeringOrFix) {
        if (offeringOrFix instanceof IFix) {
            return false;
        }
        return LicenseUtils.isPEKOffering((IOffering)offeringOrFix);
    }

    public static String getIdOfOfferingThatPekAppliesTo(IOffering offering) {
        String type = offering.getProperties().getProperty("offering.type");
        if (!"pek".equals(type)) {
            return null;
        }
        IInstallableUnit[] iplaUnits = LicenseUtils.getIplaUnits(offering);
        if (iplaUnits.length != 1) {
            return null;
        }
        return iplaUnits[0].getProperties().getProperty("enablement.offering.id");
    }

    public static String getLicenseNameThatPekAppliesTo(IOffering pek, IOffering prod) {
        IInstallableUnit[] iplaUnits;
        String peklumid = LicenseUtils.getPekLumId(pek);
        if (peklumid == null) {
            return null;
        }
        IInstallableUnit[] iInstallableUnitArray = iplaUnits = LicenseUtils.getAllIplaUnits(prod);
        int n = iplaUnits.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit unit = iInstallableUnitArray[n2];
            String lumid = unit.getProperties().getProperty("enablement.lum.id");
            if (peklumid.equals(lumid)) {
                return LicenseUtils.getLicenseName(unit);
            }
            ++n2;
        }
        return null;
    }

    @Deprecated
    public static VersionRange getToleranceOfOfferingThatPekAppliesTo(IOffering offering) {
        String type = offering.getProperties().getProperty("offering.type");
        if (!"pek".equals(type)) {
            return VersionRange.emptyRange;
        }
        IInstallableUnit[] iplaUnits = LicenseUtils.getIplaUnits(offering);
        if (iplaUnits.length != 1) {
            return null;
        }
        return new VersionRange(iplaUnits[0].getProperties().getProperty("enablement.offering.tolerance"));
    }

    public static String[] getOfferingLumIds(IOffering offering) {
        String lumIds = offering.getProperties().getProperty("OfferingReference.enablement.lum.id");
        if (lumIds != null) {
            return LicenseUtils.asArray(lumIds);
        }
        IInstallableUnit[] ofIus = LicenseUtils.getAllIplaUnits(offering);
        ArrayList<String> list = new ArrayList<String>(ofIus.length);
        IInstallableUnit[] iInstallableUnitArray = ofIus;
        int n = ofIus.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit ofIu = iInstallableUnitArray[n2];
            String lumId = ofIu.getProperties().getProperty("enablement.lum.id");
            if (lumId != null) {
                list.add(lumId);
            }
            ++n2;
        }
        return list.toArray(new String[list.size()]);
    }

    public static String getOfferingLumIdsAsString(IOffering offering) {
        Object[] lumIds = LicenseUtils.getOfferingLumIds(offering);
        return Util.toString(lumIds, FORMATTER);
    }

    public static String[] getOfferingLumVersions(IOffering offering) {
        String lumVersions = offering.getProperties().getProperty("OfferingReference.enablement.lum.version");
        if (lumVersions != null) {
            return LicenseUtils.asArray(lumVersions);
        }
        IInstallableUnit[] ofIus = LicenseUtils.getAllIplaUnits(offering);
        ArrayList<String> list = new ArrayList<String>(ofIus.length);
        IInstallableUnit[] iInstallableUnitArray = ofIus;
        int n = ofIus.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit ofIu = iInstallableUnitArray[n2];
            String lumVersion = ofIu.getProperties().getProperty("enablement.lum.version");
            if (lumVersion != null) {
                list.add(lumVersion);
            }
            ++n2;
        }
        return list.toArray(new String[list.size()]);
    }

    public static String getOfferingLumVersionsAsString(IOffering offering) {
        Object[] lumVersions = LicenseUtils.getOfferingLumVersions(offering);
        return Util.toString(lumVersions, FORMATTER);
    }

    public static boolean isPekApplicableToOffering(IOffering pek, IOffering prod) {
        String[] prodlumvers;
        String peklumid = LicenseUtils.getPekLumId(pek);
        String peklumver = LicenseUtils.getPekLumVersion(pek);
        if (peklumid == null || peklumver == null) {
            return false;
        }
        String[] prodlumids = LicenseUtils.getOfferingLumIds(prod);
        if (prodlumids.length != (prodlumvers = LicenseUtils.getOfferingLumVersions(prod)).length) {
            log.warning("number of LUM ids not equal to number of LUM versions for offering \"{0}_{1}\"", prod.getIdentity().getId(), prod.getVersion());
            return false;
        }
        int i = 0;
        while (i < prodlumids.length) {
            String prodlumid = prodlumids[i];
            String prodlumver = prodlumvers[i];
            if (LicenseUtils.isMatchingLum(peklumid, peklumver, prodlumid, prodlumver)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPekApplicableToFeature(IOffering pek, IOffering prod, IFeatureBase featureOrGroup) {
        IInstallableUnit[] units;
        String peklumid = LicenseUtils.getPekLumId(pek);
        String peklumver = LicenseUtils.getPekLumVersion(pek);
        if (peklumid == null || peklumver == null) {
            return false;
        }
        IInstallableUnit[] iInstallableUnitArray = units = LicenseUtils.getFeatureIplaUnits(prod);
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            String prodlumver;
            IInstallableUnit unit = iInstallableUnitArray[n2];
            String prodlumid = unit.getProperties().getProperty("enablement.lum.id");
            if (LicenseUtils.isMatchingLum(peklumid, peklumver, prodlumid, prodlumver = unit.getProperties().getProperty("enablement.lum.version")) && LicenseUtils.isMatchingFeatureOrGroup(unit, featureOrGroup)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IInstallableUnit[] getIplaUnits(IOffering offering, int flags) {
        List children = offering.getChildren();
        LinkedHashMap<String, IInstallableUnit> result = new LinkedHashMap<String, IInstallableUnit>();
        for (Object child : children) {
            String id;
            IInstallableUnit seenIpla;
            IInstallableUnit unit;
            String enablementKind;
            if (!(child instanceof IInstallableUnit) || (enablementKind = (unit = (IInstallableUnit)child).getProperties().getProperty("enablement.kind")) == null) continue;
            String featureId = unit.getProperties().getProperty("enablement.feature.id");
            if ((flags & 1) == 0 && featureId == null || (flags & 2) == 0 && featureId != null || unit.compareVersion(seenIpla = (IInstallableUnit)result.get(id = unit.getIdentity().getId())) <= 0) continue;
            result.put(id, unit);
        }
        return result.values().toArray(new IInstallableUnit[result.size()]);
    }

    public static IInstallableUnit[] getIplaUnits(IOffering offering) {
        return LicenseUtils.getIplaUnits(offering, 1);
    }

    public static IInstallableUnit[] getFeatureIplaUnits(IOffering offering) {
        return LicenseUtils.getIplaUnits(offering, 2);
    }

    public static IInstallableUnit[] getAllIplaUnits(IOffering offering) {
        return LicenseUtils.getIplaUnits(offering, 3);
    }

    public static String getLocalizedTermLicenseDuration(IInstallableUnit unit) {
        String expiration = unit.getProperties().getProperty("enablement.term.duration");
        if (expiration == null) {
            return null;
        }
        return NLS.bind(com.ibm.cic.common.core.model.internal.Messages.LicenseUtils_enablementTermAndDuration, (Object)expiration);
    }

    public static String getLocalizedLicenseKind(IInstallableUnit unit) {
        String enablementKind = unit.getProperties().getProperty("enablement.kind");
        return LicenseUtils.getLocalizedLicenseKind(enablementKind);
    }

    public static String getLocalizedLicenseKind(String enablementKind) {
        if (enablementKind == null) {
            return null;
        }
        if (enablementKind.equals("perm")) {
            return com.ibm.cic.common.core.model.internal.Messages.LicenseUtils_enablementPerm;
        }
        if (enablementKind.equals("term")) {
            return com.ibm.cic.common.core.model.internal.Messages.LicenseUtils_enablementTerm;
        }
        if (enablementKind.equals("trial")) {
            return com.ibm.cic.common.core.model.internal.Messages.LicenseUtils_enablementTrial;
        }
        return String.valueOf('?') + enablementKind + '?';
    }

    public static String getRuntimeLicenseKind(IInstallableUnit unit) {
        String result;
        Version version;
        String id;
        if (PolicyManager.isFlexEnabled() && PolicyManager.getOffering((String)(id = LicenseUtils.getLicenseId(unit)), (Version)(version = unit.getParent().getVersion())) != null) {
            return LICENSE_TYPE_FLOATING;
        }
        LicenseStatus ls = LicenseUtils.getRuntimeLicenseStatus(unit);
        if (ls != null && (result = ls.getLocalizedLicenseType()) != null) {
            return result;
        }
        return LicenseUtils.getLocalizedLicenseKind(unit);
    }

    public static LicenseStatus getRuntimeLicenseStatus(IInstallableUnit unit) {
        String lt35;
        String lumid = unit.getProperties().getProperty("enablement.lum.id");
        String lumversion = unit.getProperties().getProperty("enablement.lum.version");
        String flexid = unit.getProperties().getProperty("enablement.flex.id");
        String flexversion = unit.getProperties().getProperty("enablement.flex.version");
        if (lumid == null && flexid == null) {
            return null;
        }
        String licenseid = LicenseUtils.getLicenseId(unit);
        String licensename = LicenseUtils.getLicenseName(unit);
        Version offeringversion = unit.getParent().getVersion();
        ProductInformation pi = new ProductInformation();
        pi.setProductId(licenseid == null ? "" : licenseid);
        pi.setProductVersion(offeringversion);
        pi.setProductName(licensename);
        pi.setLumProductId(lumid);
        pi.setLumVersionId(lumversion);
        pi.setFlexFeatureId(flexid == null ? "" : flexid);
        pi.setFlexVersionId(flexversion == null ? "" : flexversion);
        String lictype = "LUM";
        if (PolicyManager.isFlexEnabled() && PolicyManager.getOffering((String)licenseid, (Version)offeringversion) != null) {
            lictype = "FLEX";
            LicenseStatus lstatus = new LicenseStatus(pi);
            lstatus.setLocalizedLicenseType(LICENSE_TYPE_FLOATING);
            return lstatus;
        }
        LicenseStatus licstatus = null;
        if (lumid != null && lumversion != null) {
            ILicenseCheckProvider licenseChecker = LicenseCheckerFactory.getLicenseChecker((String)lictype);
            licstatus = licenseChecker.checkStatus(pi, PolicyManager.getLicenseLocation());
            licstatus.setOfferingName(licensename);
        }
        if (lumid != null && lumversion != null && lumid.equals("35") && ((lt35 = licstatus.getLocalizedLicenseType()).equals(LICENSE_TYPE_NODELOCKED) || lt35.equals(LICENSE_TYPE_TRIAL)) && LicenseUtils.isPre75RbdLumVersion(lumversion)) {
            pi.setLumProductId("37");
            ILicenseCheckProvider licenseChecker = LicenseCheckerFactory.getLicenseChecker((String)lictype);
            LicenseStatus ls37 = licenseChecker.checkStatus(pi, PolicyManager.getLicenseLocation());
            ls37.setOfferingName(licensename);
            String lt37 = ls37.getLocalizedLicenseType();
            if (lt37.equals(LICENSE_TYPE_PERM) || lt37.equals(LICENSE_TYPE_TERM)) {
                return ls37;
            }
        }
        return licstatus;
    }

    public static boolean isPre75RbdLumVersion(String lumversion) {
        if (lumversion == null) {
            return false;
        }
        Version version = new Version(LicenseUtils.massageVersion(lumversion));
        return version.compareTo(new Version(7, 5, 0)) < 0;
    }

    private static String massageVersion(String lumversion) {
        int length = lumversion.length();
        boolean seenDot = false;
        int i = 0;
        while (i < length) {
            char c = lumversion.charAt(i);
            if (!Character.isDigit(c)) {
                if (c == '.' && !seenDot) {
                    seenDot = true;
                } else {
                    return lumversion.substring(0, i);
                }
            }
            ++i;
        }
        return lumversion;
    }

    public static String getLicenseKinds(IOffering offering, boolean localized) {
        Object[] kinds = localized ? LicenseUtils.getLocalizedLicenseKindsArray(offering) : LicenseUtils.getUnlocalizedLicenseKindsArray(offering);
        return Util.toString(kinds, FORMATTER);
    }

    public static String getLicenseKinds(IOffering[] offerings, boolean localized) {
        Object[] kinds = LicenseUtils.getLicenseKindsArray(offerings, localized);
        return Util.toString(kinds, FORMATTER);
    }

    public static String[] getLicenseKindsArray(IOffering[] offerings, boolean localized) {
        LinkedHashSet return_value = new LinkedHashSet();
        IOffering[] iOfferingArray = offerings;
        int n = offerings.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering offering = iOfferingArray[n2];
            if (localized) {
                LicenseUtils.getLocalizedLicenseKindsArray(return_value, offering);
            } else {
                LicenseUtils.getUnlocalizedLicenseKindsArray(return_value, offering);
            }
            ++n2;
        }
        String[] kinds = return_value.toArray(new String[return_value.size()]);
        return kinds;
    }

    public static String[] getLocalizedLicenseKindsArray(IOffering offering) {
        LinkedHashSet return_value = new LinkedHashSet();
        LicenseUtils.getLocalizedLicenseKindsArray(return_value, offering);
        return return_value.toArray(new String[return_value.size()]);
    }

    private static void getLocalizedLicenseKindsArray(LinkedHashSet return_value, IOffering offering) {
        block5: {
            IInstallableUnit[] iplaUnits;
            block3: {
                IInstallableUnit[] iplaUnits2;
                block4: {
                    if (!(offering instanceof IOfferingOrFixReference)) break block3;
                    IOfferingOrFixReference or = (IOfferingOrFixReference)((Object)offering);
                    if (or.hasModelAttached()) break block4;
                    String licKinds = or.getProperties().getProperty("OfferingReference.LicensesKinds");
                    if (licKinds == null) break block5;
                    List list = LicenseUtils.asList(licKinds);
                    for (String kind : list) {
                        return_value.add(LicenseUtils.getLocalizedLicenseKind(kind));
                    }
                    break block5;
                }
                IInstallableUnit[] iInstallableUnitArray = iplaUnits2 = LicenseUtils.getAllIplaUnits(offering);
                int n = iplaUnits2.length;
                int n2 = 0;
                while (n2 < n) {
                    IInstallableUnit unit = iInstallableUnitArray[n2];
                    String enablementKind = LicenseUtils.getLocalizedLicenseKind(unit);
                    return_value.add(enablementKind);
                    ++n2;
                }
                break block5;
            }
            IInstallableUnit[] iInstallableUnitArray = iplaUnits = LicenseUtils.getAllIplaUnits(offering);
            int n = iplaUnits.length;
            int n3 = 0;
            while (n3 < n) {
                IInstallableUnit unit = iInstallableUnitArray[n3];
                String enablementKind = LicenseUtils.getLocalizedLicenseKind(unit);
                return_value.add(enablementKind);
                ++n3;
            }
        }
    }

    public static String[] getUnlocalizedLicenseKindsArray(IOffering offering) {
        LinkedHashSet return_value = new LinkedHashSet();
        LicenseUtils.getUnlocalizedLicenseKindsArray(return_value, offering);
        return return_value.toArray(new String[return_value.size()]);
    }

    private static void getUnlocalizedLicenseKindsArray(LinkedHashSet return_value, IOffering offering) {
        block6: {
            IInstallableUnit[] iplaUnits;
            block4: {
                IInstallableUnit[] iplaUnits2;
                block5: {
                    if (!(offering instanceof IOfferingReference)) break block4;
                    IOfferingReference or = (IOfferingReference)offering;
                    if (or.hasModelAttached()) break block5;
                    String licKinds = or.getProperties().getProperty("OfferingReference.LicensesKinds");
                    if (licKinds == null) break block6;
                    return_value.addAll(LicenseUtils.asList(licKinds));
                    break block6;
                }
                IInstallableUnit[] iInstallableUnitArray = iplaUnits2 = LicenseUtils.getAllIplaUnits(offering);
                int n = iplaUnits2.length;
                int n2 = 0;
                while (n2 < n) {
                    IInstallableUnit unit = iInstallableUnitArray[n2];
                    String enablementKind = unit.getProperties().getProperty("enablement.kind");
                    if (enablementKind != null) {
                        return_value.add(enablementKind);
                    }
                    ++n2;
                }
                break block6;
            }
            IInstallableUnit[] iInstallableUnitArray = iplaUnits = LicenseUtils.getAllIplaUnits(offering);
            int n = iplaUnits.length;
            int n3 = 0;
            while (n3 < n) {
                IInstallableUnit unit = iInstallableUnitArray[n3];
                String enablementKind = unit.getProperties().getProperty("enablement.kind");
                if (enablementKind != null) {
                    return_value.add(enablementKind);
                }
                ++n3;
            }
        }
    }

    public static String getRuntimeLicenseKinds(IOffering offering, int flags) {
        Object[] kinds = LicenseUtils.getRuntimeLicenseKindsArray(offering, flags);
        return Util.toString(kinds, FORMATTER);
    }

    public static String getRuntimeLicenseKinds(IOffering offering) {
        return LicenseUtils.getRuntimeLicenseKinds(offering, 3);
    }

    public static String getRuntimeLicenseExpiration(IOffering offering) {
        Object[] expirations = LicenseUtils.getRuntimeLicenseExpirationArray(offering);
        return Util.toString(expirations, FORMATTER);
    }

    public static String[] getRuntimeLicenseExpirationArray(IOffering offering) {
        LicenseStatus[] statusArray = LicenseUtils.getRuntimeLicenseStatusArray(offering);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        LicenseStatus[] licenseStatusArray = statusArray;
        int n = statusArray.length;
        int n2 = 0;
        while (n2 < n) {
            LicenseStatus licenseStatus = licenseStatusArray[n2];
            String expdateStr = licenseStatus.getExpireDateString();
            if (!licenseStatus.isLumTrial() || expdateStr != null) {
                if (expdateStr != null) {
                    result.add(expdateStr);
                }
            } else {
                result.add(licenseStatus.getLocalizedStatusString());
            }
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] getRuntimeLicenseKindsArray(IOffering offering, int flags) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (LicenseUtils.hasExternalLicenseManager(offering)) {
            result.add(Messages.LicenseExternallyManaged);
        } else {
            IInstallableUnit[] iplaUnits;
            IInstallableUnit[] iInstallableUnitArray = iplaUnits = LicenseUtils.getIplaUnits(offering, flags);
            int n = iplaUnits.length;
            int n2 = 0;
            while (n2 < n) {
                String featureId;
                IInstallableUnit unit = iInstallableUnitArray[n2];
                String enablementKind = LicenseUtils.getRuntimeLicenseKind(unit);
                if (!LICENSE_TYPE_NODELOCKED.equals(enablementKind) || (featureId = unit.getProperties().getProperty("enablement.feature.id")) == null) {
                    result.add(enablementKind);
                }
                ++n2;
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static LicenseStatus[] getRuntimeLicenseStatusArray(IOffering offering) {
        return LicenseUtils.getRuntimeLicenseStatusArray(offering, 3);
    }

    public static LicenseStatus[] getRuntimeLicenseStatusArray(IOffering offering, int flags) {
        LinkedHashSet<LicenseStatus> result = new LinkedHashSet<LicenseStatus>();
        if (!LicenseUtils.hasExternalLicenseManager(offering)) {
            IInstallableUnit[] iplaUnits;
            IInstallableUnit[] iInstallableUnitArray = iplaUnits = LicenseUtils.getIplaUnits(offering, flags);
            int n = iplaUnits.length;
            int n2 = 0;
            while (n2 < n) {
                IInstallableUnit unit = iInstallableUnitArray[n2];
                LicenseStatus lstatus = LicenseUtils.getRuntimeLicenseStatus(unit);
                if (lstatus != null) {
                    result.add(lstatus);
                }
                ++n2;
            }
        }
        return result.toArray(new LicenseStatus[result.size()]);
    }

    public static boolean isOfferingLumApplicable(IOffering offering) {
        IInstallableUnit iplaUnit = LicenseUtils.getOfferingIplaUnit(offering);
        if (iplaUnit == null) {
            return false;
        }
        return iplaUnit.getProperties().getProperty("enablement.lum.id") != null;
    }

    public static boolean isOfferingLumPermanent(IOffering offering) {
        LicenseStatus[] statusArray;
        LicenseStatus[] licenseStatusArray = statusArray = LicenseUtils.getRuntimeLicenseStatusArray(offering);
        int n = statusArray.length;
        int n2 = 0;
        while (n2 < n) {
            LicenseStatus licstat = licenseStatusArray[n2];
            if (LicenseUtils.isLumTemporary(licstat)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isLumTemporary(LicenseStatus licstat) {
        int daysleft = licstat.getDaysToExpire();
        return daysleft <= 60 || licstat.isLumTrial() || LicenseStatus.isTermLicense((int)daysleft);
    }

    public static boolean isFeatureLumPermanent(IOffering offering, IFeatureBase featureOrGroup) {
        IInstallableUnit unit = LicenseUtils.getFeatureIplaUnit(offering, featureOrGroup);
        if (unit == null) {
            return false;
        }
        LicenseStatus status = LicenseUtils.getRuntimeLicenseStatus(unit);
        if (status == null) {
            return false;
        }
        return !LicenseUtils.isLumTemporary(status);
    }

    public static boolean isOfferingFlexlmApplicable(IOffering offering) {
        IInstallableUnit iplaUnit = LicenseUtils.getOfferingIplaUnit(offering);
        if (iplaUnit == null) {
            return false;
        }
        return iplaUnit.getProperties().getProperty("enablement.flex.id") != null;
    }

    public static boolean isOfferingFloatingEnabled(IOffering offering) {
        Version version;
        String id;
        return PolicyManager.isFlexEnabled() && PolicyManager.getOffering((String)(id = offering.getIdentity().getId()), (Version)(version = offering.getVersion())) != null;
    }

    public static boolean isFeatureFlexlmApplicable(IOffering offering, IFeatureBase featureOrGroup) {
        IInstallableUnit iplaUnit = LicenseUtils.getFeatureIplaUnit(offering, featureOrGroup);
        if (iplaUnit == null) {
            return false;
        }
        return iplaUnit.getProperties().getProperty("enablement.flex.id") != null;
    }

    public static IInstallableUnit getOfferingIplaUnit(IOffering offering) {
        IInstallableUnit[] iplaUnits;
        String type = offering.getProperties().getProperty("offering.type");
        if ("pek".equals(type)) {
            return LicenseUtils.getIplaUnits(offering)[0];
        }
        IInstallableUnit[] iInstallableUnitArray = iplaUnits = LicenseUtils.getIplaUnits(offering);
        int n = iplaUnits.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit iplaUnit = iInstallableUnitArray[n2];
            if (iplaUnit.getProperties().getProperty("enablement.offering.id").equals(offering.getIdentity().getId())) {
                return iplaUnit;
            }
            ++n2;
        }
        return null;
    }

    public static IInstallableUnit getFeatureIplaUnit(IOffering offering, IFeatureBase featureOrGroup) {
        IInstallableUnit[] iplaUnits;
        String type = offering.getProperties().getProperty("offering.type");
        if ("pek".equals(type)) {
            return null;
        }
        IInstallableUnit[] iInstallableUnitArray = iplaUnits = LicenseUtils.getFeatureIplaUnits(offering);
        int n = iplaUnits.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit iplaUnit = iInstallableUnitArray[n2];
            if (LicenseUtils.isMatchingFeatureOrGroup(iplaUnit, featureOrGroup) && iplaUnit.getProperties().getProperty("enablement.offering.id").equals(offering.getIdentity().getId())) {
                return iplaUnit;
            }
            ++n2;
        }
        return null;
    }

    public static IFeatureBase[] getLicensedFeatures(IOffering offering) {
        String type = offering.getProperties().getProperty("offering.type");
        if ("pek".equals(type)) {
            return new IFeatureBase[0];
        }
        IInstallableUnit[] units = LicenseUtils.getFeatureIplaUnits(offering);
        if (units.length == 0) {
            return new IFeatureBase[0];
        }
        final LinkedHashSet<String> featureIds = new LinkedHashSet<String>(units.length);
        IInstallableUnit[] iInstallableUnitArray = units;
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit unit = iInstallableUnitArray[n2];
            String featureId = unit.getProperties().getProperty("enablement.feature.id");
            featureIds.add(featureId);
            ++n2;
        }
        List<IFeature> features = offering.getFilteredFeatures(new IOffering.FeatureFilter(){

            @Override
            public boolean canAccept(IFeature feature) {
                return featureIds.contains(feature.getIdentity().getId());
            }
        });
        IFeatureBase[] result = features.toArray(new IFeatureBase[features.size()]);
        int i = 0;
        while (i < result.length) {
            IFeature feature = (IFeature)result[i];
            if (feature.isRequired() && !feature.isVisible()) {
                result[i] = feature.getParent();
            }
            ++i;
        }
        return result;
    }

    public static boolean hasExternalLicenseManager(IOffering offering) {
        String prop = offering.getProperties().getProperty("license.manager.external");
        return prop != null && prop.equalsIgnoreCase("true");
    }

    public static String getExternalLicenseManagerDescription(IOffering offering) {
        String prop = offering.getProperties().getProperty("license.manager.external.description");
        if (prop != null) {
            return prop;
        }
        return "Internal Error: External License Manager not defined";
    }

    public static String getExternalLicenseManagerCommandLabel(IOffering offering) {
        String prop = offering.getProperties().getProperty("license.manager.external.command.label");
        if (prop != null) {
            return prop;
        }
        return "Internal Error: External License Manager Command Label not defined";
    }

    public static String getExternalLicenseManagerCommand(IOffering offering) {
        String prop = offering.getProperties().getProperty("license.manager.external.command");
        if (prop != null) {
            return prop;
        }
        return "Internal Error: External License Manager Command not defined";
    }

    private static boolean isMatchingFeatureOrGroup(IInstallableUnit iplaUnit, IFeatureBase featureOrGroup) {
        String featureId;
        LinkedProperties iplaUnitProperties = iplaUnit.getProperties();
        if (featureOrGroup instanceof IFeature) {
            IFeature feature = (IFeature)featureOrGroup;
            featureId = feature.getIdentity().getId();
        } else {
            IFeatureGroup group = (IFeatureGroup)featureOrGroup;
            featureId = LicenseUtils.getLicensedFeatureGroupId(group);
            if (featureId == null) {
                return false;
            }
        }
        String enablementFeatureId = iplaUnitProperties.getProperty("enablement.feature.id");
        if (enablementFeatureId == null) {
            return false;
        }
        return enablementFeatureId.equals(featureId);
    }

    private static String getLicensedFeatureGroupId(IFeatureGroup group) {
        List features = group.getFeatures();
        for (IFeature feature : features) {
            if (!feature.isRequired() || feature.isVisible()) continue;
            return feature.getIdentity().getId();
        }
        return null;
    }

    public static String getLicenseId(IInstallableUnit unit) {
        String offeringid = unit.getProperties().getProperty("enablement.offering.id");
        String featureid = unit.getProperties().getProperty("enablement.feature.id");
        String licenseid = featureid != null ? featureid : offeringid;
        return licenseid;
    }

    public static String getLicenseName(IInstallableUnit unit) {
        String featureid = unit.getProperties().getProperty("enablement.feature.id");
        IInstallableUnitContainer parent = unit.getParent();
        if (featureid == null || !(parent instanceof IOffering)) {
            return parent.getName();
        }
        IOffering offering = (IOffering)parent;
        IFeatureBase featureOrGroup = LicenseUtils.getLicenseFeatureOrGroup(offering, featureid);
        if (featureOrGroup == null) {
            return parent.getName();
        }
        Information info = featureOrGroup.getInformation();
        if (info != null) {
            return info.getName();
        }
        if (featureOrGroup instanceof IFeature) {
            IFeature feature = (IFeature)featureOrGroup;
            return feature.getIdentity().getId();
        }
        return parent.getName();
    }

    private static IFeatureBase getLicenseFeatureOrGroup(IOffering offering, String featureid) {
        return LicenseUtils.getLicenseFeatureOrGroup(offering.getFeatureGroup(), featureid);
    }

    private static IFeatureBase getLicenseFeatureOrGroup(IFeatureGroup group, String featureid) {
        List features = group.getFeatures();
        for (IFeature feature : features) {
            if (!feature.getIdentity().getId().equals(featureid)) continue;
            if (feature.isRequired() && !feature.isVisible()) {
                return group;
            }
            return feature;
        }
        List subgroups = group.getGroups();
        for (IFeatureGroup subgroup : subgroups) {
            IFeatureBase featureOrGroup = LicenseUtils.getLicenseFeatureOrGroup(subgroup, featureid);
            if (featureOrGroup == null) continue;
            return featureOrGroup;
        }
        return null;
    }

    private static String getPekLumId(IOffering pek) {
        String[] peklumids = LicenseUtils.getOfferingLumIds(pek);
        if (peklumids.length != 1) {
            log.warning("number of LUM ids not equal to 1 for PEK offering \"{0}_{1}\"", pek.getIdentity().getId(), pek.getVersion());
            return null;
        }
        String peklumid = peklumids[0];
        return peklumid;
    }

    private static String getPekLumVersion(IOffering pek) {
        String[] peklumvers = LicenseUtils.getOfferingLumVersions(pek);
        if (peklumvers.length != 1) {
            log.warning("number of LUM versions not equal to 1 for PEK offering \"{0}_{1}\"", pek.getIdentity().getId(), pek.getVersion());
            return null;
        }
        String peklumver = peklumvers[0];
        return peklumver;
    }

    private static boolean isMatchingLum(String peklumid, String peklumver, String prodlumid, String prodlumver) {
        return peklumid.equals(prodlumid) && peklumver.equals(prodlumver);
    }

    private static List asList(String s) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(s, ",");
        while (tok.hasMoreElements()) {
            String element = tok.nextToken().trim();
            list.add(element);
        }
        return list;
    }

    private static String[] asArray(String s) {
        List list = LicenseUtils.asList(s);
        return list.toArray(new String[list.size()]);
    }
}

