/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.proxy;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.model.CicFactory;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IFixApplicableOffering;
import com.ibm.cic.common.core.model.IFixCategory;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.internal.FixApplicableOffering;
import com.ibm.cic.common.core.model.internal.IFixInternal;
import com.ibm.cic.common.core.model.proxy.IFixReference;
import com.ibm.cic.common.core.model.proxy.OfferingOrFixReference;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestFixData;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestOfferingOrFixData;
import com.ibm.cic.common.core.utils.RuntimeStatusException;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class FixReference
extends OfferingOrFixReference
implements IFixReference,
IFixInternal {
    private IFix modelFix;
    private final RepositoryDigestFixData fixData;

    public FixReference(RepositoryDigestFixData fixData) {
        this.fixData = fixData;
        this.modelFix = null;
    }

    public FixReference(IFix modelFix) {
        this.modelFix = modelFix;
        this.fixData = RepositoryDigestFixData.NULL;
    }

    private IFix getModelFix() {
        if (this.modelFix == null) {
            if (this.getUnavailableReason() == null) {
                IContentRepository conRep = RepositoryUtils.getContentRepository(this);
                if (conRep != null) {
                    this.modelFix = (IFix)conRep.getElement();
                    if (this.modelFix != null) {
                        this.modelFix.setLocation(this.fixData.getLocation());
                        conRep.performNLSupdate(this.modelFix);
                    }
                }
                if (this.modelFix == null) {
                    throw new RuntimeStatusException(Statuses.ERROR.get(Messages.Repo_FixContentElementCantBeFound, OfferingUtil.getOfferingOrFixLabelA(this, true), this.getRepository()));
                }
            } else {
                IRepository rep = this.getRepository();
                this.modelFix = CicFactory.getInstance().createFix(this.getIdentity(), this.getVersion());
                this.modelFix.setInformation(this.fixData.getInformation());
                this.modelFix.setRepository(rep);
                List<IFixApplicableOffering> applicableOfferings = this.fixData.getApplicableOfferings();
                for (IFixApplicableOffering applicableOffering : applicableOfferings) {
                    this.modelFix.addApplicableOffering(applicableOffering);
                }
            }
        }
        return this.modelFix;
    }

    @Override
    protected IOfferingOrFix getContentElementOrNull() {
        return this.modelFix;
    }

    @Override
    public RepositoryDigestOfferingOrFixData getContentData() {
        return this.fixData;
    }

    @Override
    void initContentData() {
    }

    @Override
    protected IOfferingOrFix getModel() {
        return this.getModelFix();
    }

    public boolean equals(Object obj) {
        return obj instanceof IFixReference && this.equalsImpl(obj);
    }

    public int hashCode() {
        return this.hashCodeImpl();
    }

    @Override
    @Deprecated
    public IOffering getOffering() {
        return this.modelFix == null ? null : this.modelFix.getOffering();
    }

    @Override
    @Deprecated
    public IIdentity getOfferingId() {
        if (this.getContentElementOrNull() != null) {
            return this.getModelFix().getOfferingId();
        }
        return this.fixData.getOfferingId();
    }

    @Override
    @Deprecated
    public Version getOfferingVersion() {
        if (this.getContentElementOrNull() != null) {
            return this.getModelFix().getOfferingVersion();
        }
        return this.fixData.getOfferingVersion();
    }

    @Override
    @Deprecated
    public void setOffering(IOffering offering) {
        this.getModelFix().setOffering(offering);
    }

    @Override
    @Deprecated
    public void setOfferingId(IIdentity id) {
        this.getModelFix().setOfferingId(id);
    }

    @Override
    @Deprecated
    public void setOfferingVersion(Version version) {
        this.getModelFix().setOfferingVersion(version);
    }

    @Override
    public boolean isEnhancedFix() {
        if (this.getContentElementOrNull() != null) {
            return this.getModelFix().isEnhancedFix();
        }
        return this.fixData.isEnhancedFix();
    }

    @Override
    public List getApplicableOfferings() {
        if (this.getContentElementOrNull() != null) {
            return this.getModelFix().getApplicableOfferings();
        }
        if (!this.isEnhancedFix()) {
            FixApplicableOffering applicableOffering = new FixApplicableOffering(this.fixData.getOfferingId(), new VersionRange(this.fixData.getOfferingVersion(), true, this.fixData.getOfferingVersion(), true));
            return Collections.singletonList(applicableOffering);
        }
        List applicableOfferings = this.fixData.getApplicableOfferings();
        if (applicableOfferings.isEmpty()) {
            applicableOfferings = this.getModelFix().getApplicableOfferings();
        }
        return applicableOfferings;
    }

    @Override
    public void addApplicableOffering(IFixApplicableOffering applicableOffering) {
        this.getModelFix().addApplicableOffering(applicableOffering);
    }

    @Override
    public void addCategory(IFixCategory category) {
        this.getModelFix().addCategory(category);
    }

    @Override
    public List getCategories() {
        return this.getModelFix().getCategories();
    }

    @Override
    public IIdentity getInternalOfferingId() {
        return this.getOfferingId();
    }

    @Override
    public Version getInternalOfferingVersion() {
        return this.getOfferingVersion();
    }

    @Override
    public void setInternalOfferingId(IIdentity offeringId) {
        this.setOfferingId(offeringId);
    }

    @Override
    public void setInternalOfferingVersion(Version version) {
        this.setOfferingVersion(version);
    }

    @Override
    public void setResolved(boolean resolved) {
        this.getModelFix().setResolved(resolved);
    }
}

