/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal;

import com.ibm.cic.common.core.model.ISelectionExpression;
import com.ibm.cic.common.core.model.internal.Messages;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

abstract class SelectionOperator
implements ISelectionExpression.ISelectionOperator {
    SelectionOperator() {
    }

    abstract void addOperand(ISelectionExpression var1);

    abstract IStatus execute(ISelectionExpression.EvaluationContext var1);

    abstract boolean validate();

    static BinaryOperator AND() {
        return new AndOp();
    }

    static BinaryOperator OR() {
        return new OrOp();
    }

    static BinaryOperator XOR() {
        return new XorOp();
    }

    static UnaryOperator NOT() {
        return new NotOp();
    }

    static IStatus fixNull(IStatus status) {
        return status != null ? status : Status.CANCEL_STATUS;
    }

    private static class AndOp
    extends BinaryOperator {
        private AndOp() {
        }

        @Override
        IStatus execute(ISelectionExpression.EvaluationContext context) {
            IStatus okResult = Status.OK_STATUS;
            CicMultiStatus rootStatus = Statuses.ST.createMultiStatus();
            ISelectionExpression[] iSelectionExpressionArray = this.operands;
            int n = this.operands.length;
            int n2 = 0;
            while (n2 < n) {
                ISelectionExpression operand = iSelectionExpressionArray[n2];
                IStatus status = AndOp.fixNull(operand.evaluate(context));
                if (!status.isOK()) {
                    if (status.getSeverity() == 1) {
                        okResult = status;
                    } else {
                        if (this.shortCircuit) {
                            return status;
                        }
                        rootStatus.add(status);
                    }
                }
                ++n2;
            }
            if (!rootStatus.isOK()) {
                return StatusUtil.fixMultiStatusNoMsgProblem(rootStatus);
            }
            return okResult;
        }

        @Override
        public String getOpImage() {
            return "and";
        }
    }

    static abstract class BinaryOperator
    extends SelectionOperator
    implements ISelectionExpression.IBinarySelectionOperator {
        protected ISelectionExpression[] operands;
        protected boolean shortCircuit = true;

        BinaryOperator() {
        }

        @Override
        public boolean isShortCircuit() {
            return this.shortCircuit;
        }

        @Override
        public ISelectionExpression[] getOperands() {
            return this.operands;
        }

        @Override
        void addOperand(ISelectionExpression operand) {
            Assert.isNotNull((Object)operand, (String)NLS.bind(Messages.SelectionOperator_GivenOperandIsNull, (Object)this.getOpImage()));
            this.operands = this.operands == null ? new ISelectionExpression[]{operand} : Util.splice(this.operands, operand);
        }

        @Override
        boolean validate() {
            return this.operands != null && this.operands.length >= 2;
        }

        public void setShortCircuit(boolean shortCircuit) {
            this.shortCircuit = shortCircuit;
        }

        public String toString() {
            if (this.operands == null) {
                return "null";
            }
            StringBuffer sb = new StringBuffer("(");
            int i = 0;
            while (i < this.operands.length) {
                if (i > 0) {
                    sb.append(' ').append(this.getOpImage().toUpperCase()).append(' ');
                }
                sb.append(this.operands[i]);
                ++i;
            }
            sb.append(")");
            return sb.toString();
        }
    }

    private static class NotOp
    extends UnaryOperator {
        private NotOp() {
        }

        @Override
        IStatus execute(ISelectionExpression.EvaluationContext context) {
            IStatus status = NotOp.fixNull(this.theOperand.evaluate(context));
            if (status.isOK()) {
                return Status.CANCEL_STATUS;
            }
            if (status.getSeverity() == 1) {
                return status;
            }
            return Status.OK_STATUS;
        }

        @Override
        public String getOpImage() {
            return "not";
        }
    }

    private static class OrOp
    extends BinaryOperator {
        private OrOp() {
        }

        @Override
        IStatus execute(ISelectionExpression.EvaluationContext context) {
            CicMultiStatus rootStatus = Statuses.ST.createMultiStatus();
            IStatus okResult = null;
            ISelectionExpression[] iSelectionExpressionArray = this.operands;
            int n = this.operands.length;
            int n2 = 0;
            while (n2 < n) {
                ISelectionExpression operand = iSelectionExpressionArray[n2];
                IStatus status = OrOp.fixNull(operand.evaluate(context));
                if (status.isOK() || status.getSeverity() == 1) {
                    if (this.shortCircuit) {
                        return status;
                    }
                    if (okResult == null || okResult.isOK() && status.getSeverity() == 1) {
                        okResult = status;
                    }
                } else {
                    rootStatus.add(status);
                }
                ++n2;
            }
            if (okResult != null) {
                return okResult;
            }
            return StatusUtil.fixMultiStatusNoMsgProblem(rootStatus);
        }

        @Override
        public String getOpImage() {
            return "or";
        }
    }

    static abstract class UnaryOperator
    extends SelectionOperator
    implements ISelectionExpression.IUnarySelectionOperator {
        protected ISelectionExpression theOperand;

        UnaryOperator() {
        }

        @Override
        void addOperand(ISelectionExpression operand) {
            Assert.isNotNull((Object)operand, (String)NLS.bind(Messages.SelectionOperator_GivenOperandIsNull, (Object)this.getOpImage()));
            if (this.theOperand != null) {
                throw new IllegalArgumentException(NLS.bind(Messages.SelectionOperator_CannotHaveMoreThanOneOperand, (Object)this.getOpImage()));
            }
            this.theOperand = operand;
        }

        @Override
        public ISelectionExpression getOperand() {
            return this.theOperand;
        }

        @Override
        boolean validate() {
            return this.theOperand != null;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("(");
            sb.append(this.getOpImage().toUpperCase()).append(' ').append(this.theOperand).append(')');
            return sb.toString();
        }
    }

    private static class XorOp
    extends BinaryOperator {
        private XorOp() {
        }

        @Override
        IStatus execute(ISelectionExpression.EvaluationContext context) {
            int selections = 0;
            IStatus infoStatus = null;
            int i = 0;
            while (!(i >= this.operands.length || selections >= 2 && this.shortCircuit)) {
                IStatus status = XorOp.fixNull(this.operands[i].evaluate(context));
                if (status.isOK()) {
                    ++selections;
                } else if (status.getSeverity() == 1) {
                    infoStatus = status;
                }
                ++i;
            }
            if (infoStatus != null && selections <= 1) {
                return infoStatus;
            }
            return selections == 1 ? Status.OK_STATUS : Status.CANCEL_STATUS;
        }

        @Override
        public String getOpImage() {
            return "xor";
        }
    }
}

