/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.expander;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IContentSelector;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IIncludedShareableEntity;
import com.ibm.cic.common.core.model.IIncludedSuFragment;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IInstallationContext;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.ISelectableNode;
import com.ibm.cic.common.core.model.ISelectionExpression;
import com.ibm.cic.common.core.model.ISelectionExpressionManipulator;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.model.IncludedShareableEntitySelector;
import com.ibm.cic.common.core.model.expander.ContextState;
import com.ibm.cic.common.core.model.expander.ContextStateCache;
import com.ibm.cic.common.core.model.expander.ExpanderUtils;
import com.ibm.cic.common.core.model.expander.IContextState;
import com.ibm.cic.common.core.model.expander.SimpleContextState;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.model.utils.SelectorContext;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.NoTaskNameProgressMonitor;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.core.utils.VersionUtil;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.service.resolver.VersionRange;

public class SelectorExpander {
    static final Logger log = Logger.getLogger();
    private final Map<IOffering, Collection<IFeature>> offerings = new LinkedHashMap<IOffering, Collection<IFeature>>();
    private final Set<IFix> fixes = new LinkedHashSet<IFix>();
    private final Map<IShareableEntity, Set<IContentSelector>> ses = new LinkedHashMap<IShareableEntity, Set<IContentSelector>>(32);
    private ContextState contextState;
    private IStatus status = null;
    private boolean allowMultipleVersions = false;

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        this.toString(sb);
        return sb.toString();
    }

    private String toDebugString() {
        return String.valueOf(this.toString()) + '\n' + (this.contextState == null ? "Not yet expanded" : ExpanderUtils.toDebugString(this.contextState));
    }

    public Map<IOffering, Collection<IFeature>> getOfferings() {
        return this.offerings;
    }

    public Set<IFix> getFixes() {
        return this.fixes;
    }

    public void addOffering(IOffering offering, Collection<IFeature> features) {
        this.checkUniqueId(this.offerings.keySet(), offering);
        this.offerings.put(offering, features);
    }

    public void addFix(IFix fix) {
        this.checkUniqueId(this.fixes, fix);
        this.fixes.add(fix);
    }

    protected void addShareableEntity(IShareableEntity se, Set<IContentSelector> selectors) {
        this.ses.put(se, selectors);
    }

    public IContextState getRootContext() {
        if (this.contextState == null) {
            throw new IllegalStateException("expand() has not yet been called");
        }
        return this.contextState;
    }

    protected SelectorContext createSelectorContext() {
        return new SelectorContext();
    }

    public IStatus expand(IProgressMonitor monitor) {
        log.start(log.debug(this.toString()));
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, 2);
        try {
            ContextState rootContext = this.initExpand(pm.next());
            this.process(rootContext, pm.next());
            rootContext.addFragmentIUs();
            log.stop();
            this.contextState = rootContext;
            this.status = this.collectStatus();
            this.dumpState();
            rootContext.freeMemory();
        }
        catch (CoreException e) {
            this.status = e.getStatus();
        }
        return this.status;
    }

    public IStatus getStatus() {
        return this.status;
    }

    protected void setStatus(IStatus status) {
        this.status = status;
    }

    protected IStatus collectStatus() {
        this.checkRSEs();
        CicMultiStatus ms = Statuses.ERROR.getMultiStatus(200, null, Messages.SelectorExpander_Error_Expanding_Installation_Packages, new Object[0]);
        this.contextState.collectStatus(ms);
        if (UserOptions.CIC_EXPANDER_ALLOW_ERRORS.isSet()) {
            ms.mapErrorToWarning();
        }
        return MultiStatusUtil.convertToOKifNoChildren(ms);
    }

    protected void checkRSEs() {
        ExpanderUtils.visitContexts(this.contextState, new ExpanderUtils.IContextVisitor(){

            @Override
            public void visit(IContextState state) {
                state.checkRSEs(null);
            }
        });
    }

    public boolean hasToleranceError() {
        return this.contextState != null && this.contextState.hasToleranceError();
    }

    public void setAllowMultipleVersions(boolean allowMultipleVersions) {
        this.allowMultipleVersions = allowMultipleVersions;
    }

    private ContextState initExpand(IProgressMonitor monitor) throws CoreException {
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor).split(this.ses.size(), 20 * this.offerings.size(), 2 * this.fixes.size());
        ContextState rootContext = new ContextState();
        pm.checkCanceled().splitNext(this.ses.size());
        for (IShareableEntity se : this.ses.keySet()) {
            rootContext.add(ContextStateCache.INSTANCE.get(se, pm.next()));
        }
        pm.checkCanceled().splitNext(this.offerings.size());
        for (IOffering offering : this.offerings.keySet()) {
            Collection<IFeature> features = this.offerings.get(offering);
            pm.splitNext(new int[]{1, 10});
            StatusUtil.throwIfError(RepositoryUtils.resolve(offering, (IProgressMonitor)new NoTaskNameProgressMonitor(pm.next())));
            features = SelectorExpander.resolveFeatures(offering, features);
            this.offerings.put(offering, features);
            this.addShareableEntity(offering.getAssembly(), OfferingUtil.toSelectorsFromFeatures(features));
            rootContext.add(ContextStateCache.INSTANCE.get(offering, pm.next()));
        }
        pm.checkCanceled().splitNext(2 * this.fixes.size());
        for (IFix fix : this.fixes) {
            StatusUtil.throwIfError(RepositoryUtils.resolve(fix, (IProgressMonitor)new NoTaskNameProgressMonitor(pm.next())));
            this.addShareableEntity(fix.getAssembly(), Collections.emptySet());
            this.addForFix(rootContext, ContextStateCache.INSTANCE.get(fix, pm.next()));
        }
        for (IShareableEntity se : this.ses.keySet()) {
            rootContext.addInclude(se.getIdentity());
            Set<IContentSelector> selectors = this.ses.get(se);
            for (IContentSelector selector : selectors) {
                rootContext.saveSelection(se.getIdentity(), VersionUtil.getDefaultTolerance(se.getVersion()), selector.getIdentity());
            }
        }
        pm.checkCanceled().checkDone();
        return rootContext;
    }

    private void addForFix(ContextState rootContext, final SimpleContextState fixContext) {
        ExpanderUtils.visitContexts(rootContext, new ExpanderUtils.IContextVisitor(){

            @Override
            public void visit(IContextState state) {
                ((ContextState)state).add(fixContext);
            }
        });
    }

    private void process(ContextState state, IProgressMonitor monitor) {
        log.debug("Expanding in {0}", state.getFullId());
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor).split(SelectorExpander.getWeight(state), Util.sum(SelectorExpander.getChildWeights(state)));
        this.contextState = state;
        this.process(pm.next());
        state.validate();
        pm.splitNext(SelectorExpander.getChildWeights(state));
        for (ContextState child : state.getSubContexts()) {
            this.process(child, pm.next());
            state.resolve(child);
        }
    }

    private void process(IProgressMonitor monitor) {
        monitor.beginTask(null, this.contextState.getCandidateCount());
        this.contextState.setSelectorContext(this.createSelectorContext());
        while (!this.contextState.allDone()) {
            IIdentity id = this.contextState.nextReady();
            if (id == null || monitor.isCanceled()) break;
            monitor.subTask(NLS.bind(Messages.SelectorExpander_Processing, (Object)id));
            this.process(id);
            monitor.worked(1);
        }
        monitor.done();
    }

    private void process(IIdentity id) {
        for (IShareableEntity se : this.contextState.getCandidates(id)) {
            this.contextState.applySavedSelections(se);
            if (log.isDebugLoggable()) {
                log.debug("  expand {0} {1} {2}", se.getIdentity(), se.getVersion(), Util.toSelectorIdString(this.contextState.getSelected(se)));
            }
            if (se instanceof IAssembly) {
                this.expand((IAssembly)se);
                continue;
            }
            if (se instanceof IShareableUnit) {
                this.expand((IShareableUnit)se);
                continue;
            }
            assert (false) : se;
        }
        this.contextState.removeSavedSelections(id);
    }

    private void expand(IAssembly asm) {
        this.contextState.selectDependentSelectors(asm);
        List children = asm.getChildren();
        for (ISelectableNode child : children) {
            if (child instanceof IIncludedSuFragment) {
                IIncludedSuFragment isuf = (IIncludedSuFragment)child;
                ISuFragment fragment = isuf.getSuFragment();
                if (fragment == null) continue;
                boolean pushed = this.pushInstallationContext(asm, isuf);
                this.contextState.addFragment(fragment);
                this.popInstallationContext(pushed);
                continue;
            }
            if (child instanceof IIncludedShareableEntity) {
                IIncludedShareableEntity ise = (IIncludedShareableEntity)child;
                this.contextState.addIncludeTolerance(ise, asm);
                Set includedSelectors = ise.getIncludedShareableEntitySelectors();
                for (IncludedShareableEntitySelector ises : includedSelectors) {
                    IIdentity id = ise.getIdentity();
                    VersionRange tolerance = ise.getTolerance();
                    if (!this.contextState.isSelected((IShareableEntity)asm, ises.getExpression())) continue;
                    boolean pushed = this.pushInstallationContext(asm, ises);
                    if (pushed) {
                        this.contextState.addIncludeTolerance(ise, asm);
                    }
                    this.contextState.checkSelector(asm, id, tolerance, ises.getSelectorId(), this.offerings.keySet());
                    this.contextState.saveSelection(ise.getIdentity(), tolerance, ises.getSelectorId());
                    this.contextState.addInclude(id);
                    this.popInstallationContext(pushed);
                }
                continue;
            }
            throw new AssertionError(child);
        }
    }

    private void expand(IShareableUnit su) {
        if (su.definesAnInstallationContext()) {
            this.contextState.addInstallationContext((IInstallationContext)su);
            return;
        }
        if (this.contextState.getSelected(su).isEmpty()) {
            return;
        }
        this.contextState.selectDependentSelectors(su);
        List ius = su.getChildren();
        for (IInstallableUnit iu : ius) {
            ISelectionExpression expr = iu.getExpression();
            if (expr != null && !this.contextState.isSelected((IShareableEntity)su, expr)) continue;
            boolean pushed = this.pushInstallationContext(su, iu);
            this.contextState.add(iu);
            this.popInstallationContext(pushed);
        }
    }

    private boolean pushInstallationContext(IShareableEntity se, ISelectionExpressionManipulator exprParent) {
        SimpleContextState subContext = this.contextState.getIC(se, exprParent);
        if (subContext == null) {
            return false;
        }
        this.contextState = (ContextState)subContext;
        return true;
    }

    private void popInstallationContext(boolean pushed) {
        if (pushed) {
            this.contextState = (ContextState)this.contextState.getParent();
        }
    }

    private void checkUniqueId(Set<? extends IOfferingOrFix> current, IOfferingOrFix offeringOrFix) {
        if (this.contextState != null) {
            throw new IllegalStateException("Can't add offerings and fixes after expanding");
        }
        if (!this.allowMultipleVersions) {
            for (IOfferingOrFix iOfferingOrFix : current) {
                if (!iOfferingOrFix.getIdentity().equals(offeringOrFix.getIdentity())) continue;
                throw new IllegalArgumentException(NLS.bind("Already have unit {0} version {1}; can't add {2}", iOfferingOrFix.getIdentity(), iOfferingOrFix.getVersion(), offeringOrFix.getVersion()));
            }
        }
    }

    private static Collection<IFeature> resolveFeatures(IOffering offering, Collection<IFeature> features) throws CoreException {
        ArrayList<IFeature> newFeatures = new ArrayList<IFeature>(features.size());
        Map map = OfferingUtil.getFeatureMap(offering);
        for (IFeature feature : features) {
            String featureId = feature.getIdentity().getId();
            IFeature newFeature = (IFeature)map.get(featureId);
            if (newFeature == null) {
                throw new CoreException((IStatus)Statuses.ERROR.get(Messages.SelectorExpander_Feature_Not_Found_In_Package, featureId, offering.getIdentity(), offering.getVersion()));
            }
            if (newFeature.getSelector() == null) {
                throw new CoreException((IStatus)Statuses.ERROR.get(Messages.SelectorExpander_Undefined_Selector_In_Feature, offering.getIdentity(), offering.getVersion(), featureId));
            }
            newFeatures.add(newFeature);
        }
        return newFeatures;
    }

    private void dumpState() {
        this.contextState.logSEs();
        if (log.isDebugLoggable()) {
            log.debug(this.toDebugString());
        }
    }

    private void toString(StringBuilder sb) {
        if (this.offerings.isEmpty() && this.fixes.isEmpty() && this.ses.isEmpty()) {
            sb.append("Expanding: (empty)");
            return;
        }
        sb.append("Expanding:");
        for (IOffering offering : this.offerings.keySet()) {
            SelectorExpander.append(sb, "\n  offering ", offering);
            sb.append(' ').append(Util.toFeatureIdString(this.offerings.get(offering)));
        }
        for (IFix fix : this.fixes) {
            SelectorExpander.append(sb, "\n  fix ", fix);
        }
        for (IShareableEntity se : this.ses.keySet()) {
            SelectorExpander.append(sb, "\n  SE ", se);
            sb.append(' ').append(Util.toSelectorIdString(this.ses.get(se)));
        }
    }

    private static StringBuilder append(StringBuilder sb, String prefix, IContent unit) {
        return SelectorExpander.append(sb.append(prefix), unit);
    }

    private static StringBuilder append(StringBuilder sb, IContent unit) {
        return sb.append(unit.getIdentity()).append(' ').append(unit.getVersion());
    }

    private static int getWeight(ContextState state) {
        return state.getCandidateCount() + 1;
    }

    private static int[] getChildWeights(SimpleContextState state) {
        int[] result = new int[state.getSubContexts().size()];
        int j = 0;
        for (SimpleContextState simpleContextState : state.getSubContexts()) {
            result[j++] = simpleContextState.getCandidateCount();
        }
        return result;
    }
}

