/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.volrepo;

import com.ibm.cic.common.core.artifactrepo.IArtifactLocator;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.base.IMultiArtifactOperationArguments;
import com.ibm.cic.common.core.artifactrepo.base.MultiArtifactOperationOptions;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactTableOfContents;
import com.ibm.cic.common.core.artifactrepo.impl.IArtifactGet;
import com.ibm.cic.common.core.artifactrepo.impl.IVolumeAccessByDisk;
import com.ibm.cic.common.core.artifactrepo.impl.RepoAs;
import com.ibm.cic.common.core.downloads.TransferUtils;
import com.ibm.cic.common.core.internal.downloads.FileContentInfo;
import com.ibm.cic.common.core.internal.repository.DigestTableOfContents;
import com.ibm.cic.common.core.internal.repository.RepositoryList;
import com.ibm.cic.common.core.internal.repository.TableOfContents;
import com.ibm.cic.common.core.internal.volrepo.DiskMounter;
import com.ibm.cic.common.core.internal.volrepo.DiskMounterFactory;
import com.ibm.cic.common.core.internal.volrepo.IDiskMounter;
import com.ibm.cic.common.core.internal.volrepo.VolumeAtocUtil;
import com.ibm.cic.common.core.internal.volrepo.VolumeSetReader;
import com.ibm.cic.common.core.internal.volrepo.WrappedLocator;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.IRepositoryPool;
import com.ibm.cic.common.core.repository.PrivateRepositoryPools;
import com.ibm.cic.common.core.repository.RepositoryContext;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.TempUtil;
import com.ibm.cic.common.core.volrepo.DiskTagFile;
import com.ibm.cic.common.core.volrepo.IVolumeRepositoryStatusCodes;
import com.ibm.cic.common.core.volrepo.VolumeBase;
import com.ibm.cic.common.core.volrepo.VolumeRepository;
import com.ibm.cic.common.core.volrepo.VolumesArtifactTableOfContents;
import com.ibm.cic.common.downloads.ContentInfo;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadSession;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class VolumeSetReaderHelperClassic
extends VolumeBase
implements IVolumeRepositoryStatusCodes,
VolumeSetReader.IVolumeSetReaderHelper {
    private DiskMounter diskMounter;
    private IStatus initDiskMountStatus;
    private final DiskMounterFactory diskMounterFactory;
    private final TempUtil.UniqueTempDir cdsetCacheFolder;
    private IRepositoryPool privatePool;
    private RepositoryGroup innerGroup;
    private IRepository mdRepo;
    private String diskLabel;
    private DiskArtifactRepo currentDiskArtifactRepo;
    private VolumeAtocUtil datocUtil;
    private final List cachedPaths = new ArrayList();

    private VolumeSetReaderHelperClassic(DiskMounterFactory diskMounterFactory, DiskMounter diskMounter, TempUtil.UniqueTempDir cdsetCacheFolder) {
        assert (diskMounterFactory.getRequestedDiskSetId() != null);
        assert (diskMounter != null);
        assert (diskMounterFactory.getRequestedDiskSetId().equals(diskMounter.getMountedDisk().getDiskSetId()));
        this.diskMounterFactory = diskMounterFactory;
        this.diskMounter = diskMounter;
        this.cdsetCacheFolder = cdsetCacheFolder;
        this.initDiskMountStatus = Status.OK_STATUS;
    }

    public static VolumeSetReaderHelperClassic open(boolean askForDisk1, ICicLocation root, String requestedDiskSetId, boolean allowOpenFromAnyESDDiskLocation, TempUtil.UniqueTempDir cdsetCacheFolder, IProgressMonitor monitor) throws CoreException {
        DiskMounterFactory diskMounterFactory = new DiskMounterFactory(askForDisk1, root, requestedDiskSetId);
        DiskMounter diskMounter = null;
        if (allowOpenFromAnyESDDiskLocation) {
            diskMounter = diskMounterFactory.mount(Boolean.FALSE, DiskMounterFactory.ANY_DISK);
            IStatus status = diskMounter.ensureInsertedDiskNoPrompting(0, monitor);
            if (status.matches(4)) {
                throw new CoreException(status);
            }
            root = diskMounter.getMountedDisk().getRoot();
        } else {
            diskMounter = diskMounterFactory.mount(null, null);
        }
        VolumeSetReader.checkLayoutVersionCompatible(diskMounter.getMountedDisk());
        String mountedDiskSetId = diskMounter.getMountedDisk().getDiskSetId();
        assert (mountedDiskSetId != null);
        DiskMounterFactory mountedDiskMounterFactory = new DiskMounterFactory(askForDisk1, root, mountedDiskSetId);
        return new VolumeSetReaderHelperClassic(mountedDiskMounterFactory, diskMounter, cdsetCacheFolder);
    }

    private String getDiskSetId() {
        return this.diskMounterFactory.getRequestedDiskSetId();
    }

    public void setDiskLabel(String diskLabel) {
        this.diskLabel = diskLabel;
    }

    public String getDiskLabel() {
        return this.diskLabel;
    }

    public ICicLocation getDisk1Location() {
        return this.diskMounterFactory.getCanonicalRootDir();
    }

    @Override
    public void dispose() {
        if (this.innerGroup != null) {
            this.innerGroup.removeAllRepositories();
        }
        if (this.privatePool != null) {
            PrivateRepositoryPools.INSTANCE.releasePrivatePool(this.privatePool);
        }
        for (File dir : this.cachedPaths) {
            FileUtil.rm_r(dir, true);
        }
        this.cdsetCacheFolder.cleanEmptyDirsLogIOE();
        this.mdRepo = null;
        this.currentDiskArtifactRepo = null;
        this.datocUtil = null;
        this.cachedPaths.clear();
    }

    @Override
    public void refresh(boolean askForDisk1) {
        if (this.innerGroup != null) {
            this.innerGroup.refresh();
        }
        if (this.mdRepo != null) {
            this.mdRepo.refresh();
        }
        this.datocUtil = null;
        this.remount(askForDisk1);
    }

    private void remount(boolean askForDisk, Integer diskIndex) {
        try {
            this.diskMounter = this.diskMounterFactory.mount(askForDisk, diskIndex);
            this.initDiskMountStatus = Status.OK_STATUS;
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            if (status.matches(8)) {
                this.diskMounter.refresh();
            }
            VolumeRepository.log.status(e.getStatus());
            this.diskMounter = null;
            this.initDiskMountStatus = e.getStatus();
        }
    }

    private void remount(boolean askForDisk) {
        this.remount(askForDisk, null);
    }

    @Override
    public IStatus getStatus(boolean reEvaluate, boolean askForDisk, IProgressMonitor monitor) {
        if (reEvaluate) {
            this.remount(askForDisk);
        }
        return this.initDiskMountStatus;
    }

    private File cacheDir(File srcRoot, String tmpArea, IProgressMonitor monitor) throws IOException {
        File cacheDir = this.getCacheDir(tmpArea);
        this.cachedPaths.add(cacheDir);
        FileUtil.rm_r(cacheDir, false);
        FileUtil.copyDir(srcRoot, cacheDir, monitor);
        return cacheDir;
    }

    private File getCacheDir(String tmpArea) {
        Path cacheDir = new Path(this.cdsetCacheFolder.getUniqueTempDir().getAbsolutePath());
        cacheDir = cacheDir.append(this.getDiskSetId());
        cacheDir = cacheDir.append(tmpArea);
        File cacheDirFile = cacheDir.toFile();
        FileUtil.ensureDestinationDirectory(cacheDirFile);
        return cacheDirFile;
    }

    private RepositoryGroup getInnerGroup() {
        if (this.innerGroup == null) {
            String name = "Inner for " + this.diskMounterFactory.getCanonicalRootDir();
            this.privatePool = PrivateRepositoryPools.INSTANCE.createPrivateRepositoryPool(name);
            this.innerGroup = new RepositoryGroup(name, new RepositoryList(), this.privatePool);
        }
        return this.innerGroup;
    }

    private void initMetaRepo(IProgressMonitor monitor) throws IOException, CoreException {
        if (!this.initDiskMountStatus.isOK()) {
            throw new CoreException(this.initDiskMountStatus);
        }
        monitor.beginTask("", 2);
        try {
            IStatus status = this.diskMounter.ensureInsertedDisk(this.diskLabel, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (!status.isOK()) {
                throw new CoreException(status);
            }
            ICicLocation diskRoot = this.diskMounter.getMountedDisk().getRoot();
            ICicLocation metaRoot = diskRoot.append("md");
            File metaRootFile = FileURLUtil.locationToFile(metaRoot.toString());
            File cacheDirFile = this.cacheDir(metaRootFile, "md", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.mdRepo = this.createMetaRepo("md", new CicFileLocation(cacheDirFile.toString()));
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IRepository getMetaRepo(IProgressMonitor monitor) throws IOException, CoreException {
        if (this.mdRepo == null) {
            this.initMetaRepo(monitor);
        }
        return this.mdRepo;
    }

    private void initVolumeArtifactToc(IArtifactSession session, IProgressMonitor monitor) throws CoreException, IOException {
        if (!this.initDiskMountStatus.isOK()) {
            throw new CoreException(this.initDiskMountStatus);
        }
        VolumesArtifactTableOfContents.SetParameters vtocParams = VolumesArtifactTableOfContents.getVtocParameters(true);
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, vtocParams.supportDigests() ? 5 : 4);
        try {
            TableOfContents.TocEntry tocEntry;
            ICicLocation digestsFileLocation;
            TableOfContents.Toc toc;
            IStatus status = this.diskMounter.ensureInsertedDisk(this.diskLabel, 0, spm.next());
            if (!status.isOK()) {
                throw new CoreException(status);
            }
            ICicLocation diskRoot = this.diskMounter.getMountedDisk().getRoot();
            ICicLocation tocRoot = diskRoot.append("toc/");
            ICicLocation tocSource = tocRoot.append("datoc.xml");
            FileContentInfo contentInfo = null;
            if (vtocParams.supportDigests() && (toc = DigestTableOfContents.getDigestToc(digestsFileLocation = tocRoot.append(""), spm.next())) != null && (tocEntry = toc.getEntry("datoc.xml")) != null) {
                contentInfo = tocEntry.getContentInfo();
            }
            File tocCacheRoot = this.getCacheDir("toc/");
            FileUtil.rm_r(tocCacheRoot, false);
            File tocDestination = new File(tocCacheRoot, "datoc.xml");
            this.cachedPaths.add(tocCacheRoot);
            status = TransferUtils.download(session, tocSource, tocDestination, contentInfo, spm.next());
            if (status.matches(12)) {
                throw new CoreException(status);
            }
            ArtifactTableOfContents.TocHolder atocHolder = VolumesArtifactTableOfContents.getToc(vtocParams, (IDownloadSession)session, new Path(tocCacheRoot.toString()).removeLastSegments(1), (IContentInfo)ContentInfo.EMPTY_CONTENT_INFO, spm.next());
            String diskSetId = this.getDiskTagProperties().getProperty("diskSetId");
            this.datocUtil = VolumeAtocUtil.create(session, diskSetId, this.diskLabel, atocHolder, spm.next());
        }
        finally {
            spm.done();
        }
    }

    @Override
    public IStatus ensureInsertedDisk(int diskIndex, IProgressMonitor monitor) {
        if (!this.initDiskMountStatus.isOK()) {
            return this.initDiskMountStatus;
        }
        return this.diskMounter.ensureInsertedDisk(this.diskLabel, diskIndex, monitor);
    }

    @Override
    public boolean canFindAvailableDisks() {
        if (!this.initDiskMountStatus.isOK()) {
            return false;
        }
        return this.diskMounter.canFindAvailableDisks();
    }

    @Override
    public boolean isDiskAvailable(IVolumeAccessByDisk.IDisk disk, IProgressMonitor monitor) throws CoreException {
        if (!this.initDiskMountStatus.isOK()) {
            throw new CoreException(this.initDiskMountStatus);
        }
        int diskIndex = disk.getDiskIndex();
        String diskSetId = disk.getDiskSet().getId();
        if (!diskSetId.equals(this.getDiskSetId())) {
            return false;
        }
        IStatus status = this.diskMounter.ensureInsertedDiskNoPrompting(diskIndex, monitor);
        if (status.matches(8)) {
            throw new CoreException(status);
        }
        return status.isOK();
    }

    @Override
    public DiskTagFile.DiskTagProperties getDiskTagProperties() {
        return this.diskMounter.getMountedDisk().getDiskTagProperties();
    }

    @Override
    public VolumeAtocUtil getVolumeArtifactToc(IArtifactSession session, IProgressMonitor monitor) throws CoreException, IOException {
        if (this.datocUtil == null) {
            this.initVolumeArtifactToc(session, monitor);
        }
        return this.datocUtil;
    }

    @Override
    public IRepository getCurrentDiskArtifactRepo(IArtifactSession session) throws CoreException {
        if (!this.initDiskMountStatus.isOK()) {
            throw new CoreException(this.initDiskMountStatus);
        }
        if (this.currentDiskArtifactRepo == null) {
            this.initCurrentDiskArtifactRepo();
        } else {
            IDiskMounter.IMountedDisk mountedDisk;
            IDiskMounter.IMountedDisk artifactDisk = this.currentDiskArtifactRepo.getDisk();
            if (!artifactDisk.equals(mountedDisk = this.diskMounter.getMountedDisk())) {
                this.innerGroup.removeRepository(this.currentDiskArtifactRepo.getAdRepo());
                this.currentDiskArtifactRepo = null;
                this.initCurrentDiskArtifactRepo();
            }
        }
        return this.currentDiskArtifactRepo.getAdRepo();
    }

    private IRepository createMetaRepo(String name, ICicLocation location) throws CoreException {
        IRepositoryInfo repInfo = RepositoryGroup.getDefault().createRepositoryInfo(name, "Remote", "0.0.0.1", location, null);
        RepositoryContext.setRequiredContext(repInfo, "EnclosingVolumeRepository");
        return RepositoryUtils.addSpecificInnerRepository(this.getInnerGroup(), repInfo, true, null);
    }

    private IRepository createArtifactRepo(String name, ICicLocation location) throws CoreException {
        String version = this.diskMounter.getMountedDisk().getDiskLayoutVersion();
        IRepositoryInfo repInfo = null;
        RepositoryGroup group = this.getInnerGroup();
        repInfo = "0".equals(version) ? group.createRepositoryInfo(name, "Remote", "0.0.0.1", location, null) : group.createRepositoryInfo(name, "ShortName", "0.0.0.1", location, null);
        RepositoryContext.setRequiredContext(repInfo, "EnclosingVolumeRepository");
        return RepositoryUtils.addSpecificInnerRepository(group, repInfo, true, null);
    }

    private void initCurrentDiskArtifactRepo() throws CoreException {
        if (!this.initDiskMountStatus.isOK()) {
            throw new CoreException(this.initDiskMountStatus);
        }
        ICicLocation diskRoot = this.diskMounter.getMountedDisk().getRoot();
        ICicLocation artifactRoot = diskRoot.append("ad");
        IRepository arepo = this.createArtifactRepo("ad", artifactRoot);
        this.currentDiskArtifactRepo = new DiskArtifactRepo(this.diskMounter.getMountedDisk(), arepo);
    }

    public VolumesArtifactTableOfContents.DiskInfo getDiskInfo(IArtifactSession session, IArtifact iartifact, IProgressMonitor monitor) throws IOException, CoreException {
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, 2);
        VolumeAtocUtil datoc = this.getVolumeArtifactToc(session, spm.next());
        VolumesArtifactTableOfContents.DiskInfo diskInfo = datoc.getDiskInfo(session, iartifact, spm.next());
        return diskInfo;
    }

    private IGetDiskInfoHelper getDiskInfoHelper(final IRepository outerRepo) {
        IGetDiskInfoHelper getHelper = new IGetDiskInfoHelper(){

            @Override
            public VolumesArtifactTableOfContents.DiskInfo getDiskInfo(IArtifactSession s, IArtifact a, IProgressMonitor m) throws CoreException, IOException {
                return VolumeSetReaderHelperClassic.this.getDiskInfo(s, a, m);
            }

            @Override
            public VolumeSetReader.IVolumeSetReaderHelper getVsrHelper() {
                return VolumeSetReaderHelperClassic.this;
            }

            @Override
            public IRepository getOuterRepository() {
                return outerRepo;
            }
        };
        return getHelper;
    }

    @Override
    public IArtifactGet getArtifactGet(IRepository outerRepo) {
        return VolumeSetReaderHelperClassic.getArtifactGet(this.getDiskInfoHelper(outerRepo));
    }

    public static IArtifactGet getArtifactGet(IGetDiskInfoHelper diskInfoHelper) {
        return new ClassicArtifactGet(diskInfoHelper);
    }

    @Override
    public void useArtifactLocatorsOnDisk(VolumeSetReader vsr, IArtifactSession session, IVolumeAccessByDisk.IDiskOperation diskOperation, IMultiArtifactOperationArguments artifactsOnDisk, MultiArtifactOperationOptions options, VolumeAtocUtil.OrderedDisks usedDisks, IVolumeAccessByDisk.IDisk disk, int subRepoIndex, IProgressMonitor monitor) {
        VolumeSetReaderHelperClassic.useArtifactLocatorsOnDisk(vsr, this, session, diskOperation, artifactsOnDisk, options, usedDisks, disk, subRepoIndex, monitor);
    }

    /*
     * Loose catch block
     */
    public static void useArtifactLocatorsOnDisk(VolumeSetReader vsr, VolumeSetReader.IVolumeSetReaderHelper helper, IArtifactSession session, IVolumeAccessByDisk.IDiskOperation diskOperation, IMultiArtifactOperationArguments artifactsOnDisk, MultiArtifactOperationOptions options, VolumeAtocUtil.OrderedDisks usedDisks, IVolumeAccessByDisk.IDisk disk, int subRepoIndex, IProgressMonitor monitor) {
        block16: {
            try {
                monitor.beginTask("", 100);
                if (artifactsOnDisk.getRecordCount() == 0) {
                    return;
                }
                if (diskOperation.requiresDiskInserted()) {
                    IRepository repo;
                    IStatus statusInsertDisk = helper.ensureInsertedDisk(disk.getDiskIndex(), (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                    if (!statusInsertDisk.isOK()) {
                        artifactsOnDisk.setFailedOperationStatus(statusInsertDisk);
                        return;
                    }
                    try {
                        repo = helper.getCurrentDiskArtifactRepo(session);
                    }
                    catch (IOException e) {
                        IStatus status = AbstractReadArtifactRepo.createGetArtifactFilesFailedOperationError(vsr.getRepository().getLocationStr(), null, (Exception)e);
                        artifactsOnDisk.setFailedOperationStatus(status);
                        monitor.done();
                        return;
                    }
                    catch (CoreException e) {
                        IStatus status = AbstractReadArtifactRepo.createGetArtifactFilesFailedOperationError(vsr.getRepository().getLocationStr(), e.getStatus(), null);
                        artifactsOnDisk.setFailedOperationStatus(status);
                        monitor.done();
                        return;
                    }
                    IVolumeAccessByDisk.IDiskSetDisks allUsedDisks = disk.getDiskSet().useDisks(usedDisks);
                    IStatus status = diskOperation.useDisk(session, repo, disk, allUsedDisks, artifactsOnDisk, options, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 4));
                    if (status.matches(12)) {
                        artifactsOnDisk.setFailedOperationStatus(status);
                        return;
                    }
                    break block16;
                }
                IVolumeAccessByDisk.IDiskSetDisks allUsedDisks = disk.getDiskSet().useDisks(usedDisks);
                IStatus status = diskOperation.useDisk(session, null, disk, allUsedDisks, artifactsOnDisk, options, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 4));
                if (status.matches(12)) {
                    artifactsOnDisk.setFailedOperationStatus(status);
                    return;
                }
                break block16;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    static class ClassicArtifactGet
    implements IArtifactGet {
        private final IGetDiskInfoHelper diskInfoHelper;

        public ClassicArtifactGet(IGetDiskInfoHelper diskInfoHelper) {
            this.diskInfoHelper = diskInfoHelper;
        }

        @Override
        public IStatus existsArtifact(IArtifactSession session, IArtifact artifact, IProgressMonitor monitor) {
            VolumesArtifactTableOfContents.DiskInfo diskInfo;
            try {
                diskInfo = this.diskInfoHelper.getDiskInfo(session, artifact, monitor);
            }
            catch (CoreException e) {
                IStatus status = AbstractReadArtifactRepo.createGetArtifactLocatorError(artifact, e.getStatus(), null);
                return status;
            }
            catch (IOException e) {
                IStatus status = AbstractReadArtifactRepo.createGetArtifactLocatorError(artifact, null, (Exception)e);
                return status;
            }
            if (diskInfo == null) {
                IStatus status = AbstractReadArtifactRepo.createArtifactNotFoundStatus(0, this.diskInfoHelper.getOuterRepository(), artifact);
                return status;
            }
            return Status.OK_STATUS;
        }

        @Override
        public IStatus getArtifactLocator(IArtifactSession session, IArtifact artifact, IProgressMonitor monitor, IArtifactLocator[] result) {
            IRepository repo;
            VolumesArtifactTableOfContents.DiskInfo diskInfo;
            try {
                diskInfo = this.diskInfoHelper.getDiskInfo(session, artifact, monitor);
            }
            catch (CoreException e) {
                IStatus status = AbstractReadArtifactRepo.createGetArtifactLocatorError(artifact, e.getStatus(), null);
                return status;
            }
            catch (IOException e) {
                IStatus status = AbstractReadArtifactRepo.createGetArtifactLocatorError(artifact, null, (Exception)e);
                return status;
            }
            if (diskInfo == null) {
                IStatus status = AbstractReadArtifactRepo.createArtifactNotFoundStatus(0, this.diskInfoHelper.getOuterRepository(), artifact);
                return status;
            }
            int diskIndex = diskInfo.getDiskNum() - 1;
            IStatus statusInsertDisk = this.diskInfoHelper.getVsrHelper().ensureInsertedDisk(diskIndex, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
            if (statusInsertDisk.matches(8)) {
                return statusInsertDisk;
            }
            if (!statusInsertDisk.isOK()) {
                IStatus status = AbstractReadArtifactRepo.createGetArtifactLocatorError(artifact, statusInsertDisk, null);
                return status;
            }
            try {
                repo = this.diskInfoHelper.getVsrHelper().getCurrentDiskArtifactRepo(session);
            }
            catch (IOException e) {
                IStatus status = AbstractReadArtifactRepo.createGetArtifactLocatorError(artifact, null, (Exception)e);
                return status;
            }
            catch (CoreException e) {
                IStatus status = AbstractReadArtifactRepo.createGetArtifactLocatorError(artifact, e.getStatus(), null);
                return status;
            }
            IArtifactLocator[] myResult = new IArtifactLocator[1];
            IStatus status = RepoAs.IArtifactGet(repo).getArtifactLocator(session, artifact, monitor, myResult);
            if (result != null) {
                if (myResult[0] != null) {
                    VolumeRepository volumeRepo = (VolumeRepository)this.diskInfoHelper.getOuterRepository();
                    result[0] = new WrappedLocator(volumeRepo.getRepositoryReference(), myResult[0]);
                } else {
                    result[0] = null;
                }
            }
            return status;
        }

        @Override
        public IStatus getArtifactFile(IArtifactSession session, IArtifact artifact, IPath destination, IProgressMonitor monitor) {
            IRepository repo;
            VolumesArtifactTableOfContents.DiskInfo diskInfo;
            ICicStatus statusDestination = FileUtil.checkDestination(destination.toFile());
            if (!statusDestination.isOK()) {
                return statusDestination;
            }
            try {
                diskInfo = this.diskInfoHelper.getDiskInfo(session, artifact, monitor);
            }
            catch (CoreException e) {
                IStatus status = AbstractReadArtifactRepo.createGetArtifactLocatorError(artifact, e.getStatus(), null);
                return status;
            }
            catch (IOException e) {
                IStatus status = AbstractReadArtifactRepo.createGetArtifactLocatorError(artifact, null, (Exception)e);
                return status;
            }
            int diskIndex = diskInfo.getDiskNum() - 1;
            IStatus statusInsertDisk = this.diskInfoHelper.getVsrHelper().ensureInsertedDisk(diskIndex, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
            if (statusInsertDisk.matches(8)) {
                return statusInsertDisk;
            }
            if (!statusInsertDisk.isOK()) {
                IStatus status = AbstractReadArtifactRepo.createGetArtifactLocatorError(artifact, statusInsertDisk, null);
                return status;
            }
            try {
                repo = this.diskInfoHelper.getVsrHelper().getCurrentDiskArtifactRepo(session);
            }
            catch (IOException e) {
                IStatus status = AbstractReadArtifactRepo.createGetArtifactLocatorError(artifact, null, (Exception)e);
                return status;
            }
            catch (CoreException e) {
                IStatus status = AbstractReadArtifactRepo.createGetArtifactLocatorError(artifact, e.getStatus(), null);
                return status;
            }
            return RepoAs.IArtifactGet(repo).getArtifactFile(session, artifact, destination, monitor);
        }

        @Override
        public IRepository getRepository() {
            return this.diskInfoHelper.getOuterRepository();
        }
    }

    private static class DiskArtifactRepo {
        private final IDiskMounter.IMountedDisk disk;
        private final IRepository adRepo;

        public DiskArtifactRepo(IDiskMounter.IMountedDisk disk, IRepository adRepo) {
            this.disk = disk;
            this.adRepo = adRepo;
        }

        public IRepository getAdRepo() {
            return this.adRepo;
        }

        public IDiskMounter.IMountedDisk getDisk() {
            return this.disk;
        }
    }

    public static interface IGetDiskInfoHelper {
        public VolumeSetReader.IVolumeSetReaderHelper getVsrHelper();

        public VolumesArtifactTableOfContents.DiskInfo getDiskInfo(IArtifactSession var1, IArtifact var2, IProgressMonitor var3) throws CoreException, IOException;

        public IRepository getOuterRepository();
    }
}

