/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.volrepo;

import com.ibm.cic.common.core.artifactrepo.IArtifactLocator;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.base.IMultiArtifactOperationArguments;
import com.ibm.cic.common.core.artifactrepo.base.MultiArtifactOperationOptions;
import com.ibm.cic.common.core.artifactrepo.impl.IArtifactGet;
import com.ibm.cic.common.core.artifactrepo.impl.IVolumeAccessByDisk;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.utils.CicCommonCoreDebugOptions;
import com.ibm.cic.common.core.internal.volrepo.IDiskMounter;
import com.ibm.cic.common.core.internal.volrepo.Messages;
import com.ibm.cic.common.core.internal.volrepo.VolumeAtocUtil;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.core.volrepo.DiskTagFile;
import com.ibm.cic.common.core.volrepo.IVolumeRepositoryStatusCodes;
import com.ibm.cic.common.core.volrepo.VolumeBase;
import com.ibm.cic.common.core.volrepo.VolumeRepository;
import com.ibm.cic.common.core.volrepo.VolumesArtifactTableOfContents;
import com.ibm.cic.common.logging.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class VolumeSetReader
extends VolumeBase
implements IArtifactGet,
IVolumeRepositoryStatusCodes {
    private static String pluginId = ComIbmCicCommonCorePlugin.getPluginId();
    private IRepository outerRepo;
    private IVolumeSetReaderHelper helper;
    private IArtifactGet artifactGet;
    private static final Logger logAssumeDisksAvailable = Logger.getLoggerUsingDebug(CicCommonCoreDebugOptions.VOLUME_REPOSITORY_ASSUME_DISKS_AVAILABLE);

    public VolumeSetReader(IVolumeSetReaderHelper helper) {
        this.helper = helper;
    }

    public void setOuterRepo(IRepository outerRepo) {
        this.outerRepo = outerRepo;
    }

    public static void checkLayoutVersionCompatible(IDiskMounter.IMountedDisk mountedDisk) throws CoreException {
        String layoutVersion = mountedDisk.getDiskLayoutVersion();
        ArrayList<String> supportedVersions = new ArrayList<String>(2);
        supportedVersions.add("1");
        if (UserOptions.getRepoVolumeSupportInitialVersion()) {
            supportedVersions.add("0");
        }
        if (!supportedVersions.contains(layoutVersion)) {
            String msg = Messages.VolumeSetReader_unsupported_version;
            Status status = new Status(4, pluginId, 6, msg, null);
            throw new CoreException((IStatus)status);
        }
    }

    public void dispose() {
        this.helper.dispose();
        this.helper = null;
    }

    public void refresh() {
        boolean askForDisk1 = VolumeRepository.getAskForDisk1(this.getRepository().getRepositoryInfo());
        this.helper.refresh(askForDisk1);
    }

    public IStatus getStatus(boolean reEvaluate, IProgressMonitor monitor) {
        boolean askForDisk1 = VolumeRepository.getAskForDisk1(this.getRepository().getRepositoryInfo());
        return this.helper.getStatus(reEvaluate, askForDisk1, monitor);
    }

    public IRepository getMetaRepo(IProgressMonitor monitor) throws IOException, CoreException {
        return this.helper.getMetaRepo(monitor);
    }

    public boolean assumeAllDisksAvailable() {
        return logAssumeDisksAvailable.isDebugLoggable();
    }

    public DiskTagFile.DiskTagProperties getDiskTagProperties() {
        return this.helper.getDiskTagProperties();
    }

    public VolumeAtocUtil getVolumeArtifactToc(IArtifactSession session, IProgressMonitor monitor) throws CoreException, IOException {
        return this.helper.getVolumeArtifactToc(session, monitor);
    }

    public VolumeAtocUtil.OrderedDisks getUsedDisks(IArtifactSession session, Collection artifacts, IProgressMonitor monitor) throws IOException, CoreException {
        VolumeAtocUtil datoc = this.getVolumeArtifactToc(session, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
        return datoc.getUsedDisks(session, artifacts, null, monitor);
    }

    public VolumesArtifactTableOfContents.DiskInfo getDiskInfo(IArtifactSession session, IArtifact iartifact, IProgressMonitor monitor) throws IOException, CoreException {
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, 2);
        VolumeAtocUtil datoc = this.getVolumeArtifactToc(session, spm.next());
        VolumesArtifactTableOfContents.DiskInfo diskInfo = datoc.getDiskInfo(session, iartifact, spm.next());
        return diskInfo;
    }

    private IArtifactGet getArtifactGet() {
        if (this.artifactGet == null) {
            this.artifactGet = this.helper.getArtifactGet(this.outerRepo);
        }
        return this.artifactGet;
    }

    @Override
    public IStatus existsArtifact(IArtifactSession session, IArtifact artifact, IProgressMonitor monitor) {
        return this.getArtifactGet().existsArtifact(session, artifact, monitor);
    }

    @Override
    public IStatus getArtifactFile(IArtifactSession session, IArtifact artifact, IPath destination, IProgressMonitor monitor) {
        return this.getArtifactGet().getArtifactFile(session, artifact, destination, monitor);
    }

    @Override
    public IStatus getArtifactLocator(IArtifactSession session, IArtifact artifact, IProgressMonitor monitor, IArtifactLocator[] result) {
        return this.getArtifactGet().getArtifactLocator(session, artifact, monitor, result);
    }

    @Override
    public IRepository getRepository() {
        return this.outerRepo;
    }

    public void useArtifactLocatorsOnDisk(IArtifactSession session, IVolumeAccessByDisk.IDiskOperation diskOperation, IMultiArtifactOperationArguments artifactsOnDisk, MultiArtifactOperationOptions options, VolumeAtocUtil.OrderedDisks usedDisks, IVolumeAccessByDisk.IDisk disk, int subRepoIndex, IProgressMonitor monitor) {
        this.helper.useArtifactLocatorsOnDisk(this, session, diskOperation, artifactsOnDisk, options, usedDisks, disk, subRepoIndex, monitor);
    }

    public boolean canFindAvailableDisks() {
        return this.helper.canFindAvailableDisks();
    }

    public boolean isDiskAvailable(IVolumeAccessByDisk.IDisk disk, IProgressMonitor monitor) throws CoreException {
        return this.helper.isDiskAvailable(disk, monitor);
    }

    static interface IVolumeSetReaderHelper {
        public IRepository getMetaRepo(IProgressMonitor var1) throws CoreException, IOException;

        public IStatus ensureInsertedDisk(int var1, IProgressMonitor var2);

        public DiskTagFile.DiskTagProperties getDiskTagProperties();

        public IRepository getCurrentDiskArtifactRepo(IArtifactSession var1) throws IOException, CoreException;

        public VolumeAtocUtil getVolumeArtifactToc(IArtifactSession var1, IProgressMonitor var2) throws CoreException, IOException;

        public void dispose();

        public IStatus getStatus(boolean var1, boolean var2, IProgressMonitor var3);

        public void refresh(boolean var1);

        public IArtifactGet getArtifactGet(IRepository var1);

        public void useArtifactLocatorsOnDisk(VolumeSetReader var1, IArtifactSession var2, IVolumeAccessByDisk.IDiskOperation var3, IMultiArtifactOperationArguments var4, MultiArtifactOperationOptions var5, VolumeAtocUtil.OrderedDisks var6, IVolumeAccessByDisk.IDisk var7, int var8, IProgressMonitor var9);

        public boolean canFindAvailableDisks();

        public boolean isDiskAvailable(IVolumeAccessByDisk.IDisk var1, IProgressMonitor var2) throws CoreException;
    }
}

