/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.repository;

import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.model.SimpleIdentity;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.Version;

public class UpdateWalker {
    private final Set visitedContent = new HashSet();

    public void updateOffering(IOffering offering1, IOffering offering2) throws Exception {
    }

    public void updateAssembly(IAssembly assembly1, IAssembly assembly2) throws Exception {
    }

    public void updateShareableUnit(IShareableUnit su1, IShareableUnit su2) throws Exception {
    }

    public void updateInstallableUnit(IInstallableUnit iu1, IInstallableUnit iu2) throws Exception {
    }

    public void updateUnit(IContent unit1, IContent unit2) {
        IIdentity id1 = unit1.getIdentity();
        IIdentity id2 = unit2.getIdentity();
        if (id1 == null && id2 != null) {
            unit1.setIdentity(new SimpleIdentity(id2.getId()));
        } else if (id1 != null && id2 == null) {
            unit1.setIdentity(null);
        } else if (id1 != null && id2 != null && !id1.equals(id2)) {
            unit1.setIdentity(new SimpleIdentity(id2.getId()));
        }
        Version version1 = unit1.getVersion();
        Version version2 = unit2.getVersion();
        if (version1 == null && version2 != null) {
            unit1.setVersion(new Version(version2.toString()));
        } else if (version1 != null && version2 == null) {
            unit1.setVersion(null);
        } else if (version1 != null && version2 != null && !version1.equals((Object)version2)) {
            unit1.setVersion(new Version(version2.toString()));
        }
        Information info1 = unit1.getInformation();
        Information info2 = unit2.getInformation();
        if (info1 == null && info2 != null) {
            unit1.setInformation(new Information(info2.getName(), info2.getDescription()));
        } else if (info1 != null && info2 == null) {
            unit1.setInformation(null);
        } else if (info1 != null && info2 != null && !info1.equals(info2)) {
            this.updateInformation(info1, info2);
        }
    }

    protected void updateInformation(Information info1, Information info2) {
        String name1 = info1.getName();
        String name2 = info2.getName();
        if (name1 == null && name2 != null) {
            info1.setName(name2);
        } else if (name1 != null && name2 == null) {
            info1.setName(null);
        } else if (name1 != null && name2 != null && !name1.equals(name2)) {
            info1.setName(name2);
        }
        String desc1 = info1.getDescription();
        String desc2 = info2.getDescription();
        if (desc1 == null && desc2 != null) {
            info1.setDescription(desc2);
        } else if (desc1 != null && desc2 == null) {
            info1.setDescription(null);
        } else if (desc1 != null && desc2 != null && !desc1.equals(desc2)) {
            info1.setDescription(desc2);
        }
    }

    public final void updateIncludes(IContent root1, IContent root2) throws InvocationTargetException {
        block7: {
            if (this.visitedContent.contains(root1) || this.visitedContent.contains(root2)) {
                return;
            }
            this.visitedContent.add(root1);
            this.visitedContent.add(root2);
            try {
                this.updateUnit(root1, root2);
                if (root1 instanceof IOffering && root2 instanceof IOffering) {
                    IOffering offering1 = (IOffering)root1;
                    IOffering offering2 = (IOffering)root2;
                    this.updateOffering(offering1, offering2);
                    break block7;
                }
                if (root1 instanceof IInstallableUnit && root2 instanceof IInstallableUnit) {
                    this.updateInstallableUnit((IInstallableUnit)root1, (IInstallableUnit)root2);
                    break block7;
                }
                if (root1 instanceof IAssembly && root2 instanceof IAssembly) {
                    IAssembly asm1 = (IAssembly)root1;
                    IAssembly asm2 = (IAssembly)root2;
                    this.updateAssembly(asm1, asm2);
                    break block7;
                }
                if (root1 instanceof IShareableUnit && root2 instanceof IShareableUnit) {
                    IShareableUnit su1 = (IShareableUnit)root1;
                    IShareableUnit su2 = (IShareableUnit)root2;
                    this.updateShareableUnit(su1, su2);
                    break block7;
                }
                throw new AssertionError((Object)("unexpected unit type: " + root1 + root2));
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
    }
}

