/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.downloads;

import com.ibm.cic.common.downloads.CredentialInfo;
import com.ibm.cic.common.downloads.CredentialPrompter;
import com.ibm.cic.common.downloads.CredentialRequested;
import com.ibm.cic.common.downloads.ICredentialPrompter;
import com.ibm.cic.common.downloads.ICredentialValidator;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CredentialPrompterRememberCancel {
    private ICredentialPrompter previousPrompter;
    private LinkedHashSet canceledRequests = new LinkedHashSet();

    public CredentialPrompterRememberCancel() {
        this.previousPrompter = CredentialPrompter.INSTANCE.getPrompter();
        ICredentialPrompter rememberCancelPrompter = new ICredentialPrompter(){

            @Override
            public IStatus askUserIdAndPassword(ICredentialValidator validator, String connectMessage, CredentialRequested requested, CredentialInfo previous, CredentialInfo[] ret) {
                if (CredentialPrompterRememberCancel.this.canceledRequests.contains(requested)) {
                    return Status.CANCEL_STATUS;
                }
                if (CredentialPrompterRememberCancel.this.previousPrompter == null) {
                    return null;
                }
                IStatus status = CredentialPrompterRememberCancel.this.previousPrompter.askUserIdAndPassword(validator, connectMessage, requested, previous, ret);
                if (status.matches(8)) {
                    CredentialPrompterRememberCancel.this.canceledRequests.add(requested);
                }
                return status;
            }
        };
        CredentialPrompter.INSTANCE.setPrompter(rememberCancelPrompter);
    }

    public boolean hasCancelations() {
        return this.canceledRequests.size() > 0;
    }

    public void forgetCancelations() {
        CredentialPrompter.INSTANCE.setPrompter(this.previousPrompter);
    }
}

