/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.artifactrepo;

import com.ibm.cic.common.core.artifactrepo.ArtifactProgressFormatter;
import com.ibm.cic.common.core.artifactrepo.IArtifactSessionSettings;
import com.ibm.cic.common.core.artifactrepo.ValidationPolicy;
import com.ibm.cic.common.core.utils.TempUtil;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.logging.Logger;

class ArtifactSessionSettings
implements IArtifactSessionSettings {
    private static final Logger log = Logger.getLogger(ArtifactSessionSettings.class);
    private boolean useToc = true;
    private ValidationPolicy vp = ValidationPolicy.VP_SILENT;
    private ArtifactProgressFormatter.IArtifactProgressMonitorFormatter progressFormatter = ArtifactProgressFormatter.IArtifactProgressMonitorFormatter.DEFAULT_PROGRESS_FORMATTER;
    private TempUtil.UniqueTempDir dipDir;

    public ArtifactSessionSettings(boolean useToc, ValidationPolicy vp) {
        this.useToc = useToc;
        this.vp = vp;
        if (this.checkLogIgnoreAtoc()) {
            this.useToc = false;
        }
    }

    private boolean checkLogIgnoreAtoc() {
        if (this.useToc && UserOptions.getIgnoreAtoc()) {
            log.debug("Artifact table of contents ignored based on UserOptions");
            return true;
        }
        return false;
    }

    public ArtifactSessionSettings() {
        this(true, ValidationPolicy.VP_SILENT);
    }

    @Override
    public ValidationPolicy getValidationPolicy() {
        return this.vp;
    }

    @Override
    public void setValidationPolicy(ValidationPolicy vp) {
        if (vp == null) {
            throw new NullPointerException();
        }
        this.vp = vp;
    }

    @Override
    public boolean getUseToc() {
        return this.useToc;
    }

    @Override
    public void setUseToc(boolean b) {
        this.useToc = b;
        if (this.checkLogIgnoreAtoc()) {
            this.useToc = false;
        }
    }

    @Override
    public TempUtil.UniqueTempDir getDownloadInProgressDir() {
        return this.dipDir;
    }

    @Override
    public void setDownloadInProgressDir(TempUtil.UniqueTempDir dir) {
        this.dipDir = dir;
    }

    @Override
    public ArtifactProgressFormatter.IArtifactProgressMonitorFormatter getProgressFormatter() {
        return this.progressFormatter;
    }

    @Override
    public void setProgressFormatter(ArtifactProgressFormatter.IArtifactProgressMonitorFormatter formatter) {
        this.progressFormatter = formatter;
    }
}

