/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.downloads;

import com.ibm.cic.common.core.downloads.TransferUtils;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.StatusCodes;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.IStatusCodes;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.downloads.IDownloadSession;
import com.ibm.cic.common.downloads.IDownloader;
import com.ibm.cic.common.downloads.IFileContentInfo;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DefaultDownloader
implements IDownloader,
IStatusCodes {
    private static final DefaultDownloader INSTANCE = new DefaultDownloader();
    private static final Logger log = Logger.getLogger(DefaultDownloader.class);
    private boolean m_cachingRequested = false;

    private DefaultDownloader() {
    }

    public DefaultDownloader(boolean cachingRequested) {
        this.m_cachingRequested = cachingRequested;
    }

    public static DefaultDownloader getINSTANCE() {
        return INSTANCE;
    }

    @Override
    public IStatus downloadToFile(IFileContentInfo sourceContentInfo, File destination, IProgressMonitor pm) {
        IStatus return_value;
        log.start(log.debug("downloadToFile(|{0}|->|{1}|)", sourceContentInfo.getFileLocation().toString(), destination.getAbsolutePath()));
        SplitProgressMonitor pmon = new SplitProgressMonitor(pm, 1);
        IDownloadSession session = IDownloadSession.NO_SESSION;
        try {
            return_value = TransferUtils.download(session, sourceContentInfo.getFileLocation(), destination, sourceContentInfo, pmon.next());
            if (StatusCodes.isContentNotFound(return_value)) {
                ICicLocation remoteLocation = sourceContentInfo.getFileLocation();
                String msg = NLS.bind(Messages.Downloader_File_Does_Not_Exist, (Object)remoteLocation.toString());
                log.debug(msg);
                return_value = new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 6251, msg, null);
            }
        }
        catch (Exception e) {
            return_value = new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 0, "", (Throwable)e);
        }
        log.stop();
        return return_value;
    }

    @Override
    public boolean locationShouldBeCached(ICicLocation l) {
        if (this.m_cachingRequested) {
            return true;
        }
        return FileURLUtil.isURLString(l.toString(), false);
    }
}

