/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.cmd;

import com.ibm.cic.common.core.cmd.ACmdManager;
import com.ibm.cic.common.core.cmd.CmdCommand;
import com.ibm.cic.common.core.cmd.CmdParamList;
import com.ibm.cic.common.core.cmd.CmdParamProperties;
import com.ibm.cic.common.core.cmd.CmdParamStr;
import com.ibm.cic.common.core.cmd.CmdParameters;
import com.ibm.cic.common.core.cmd.ICicCmdCnst;
import com.ibm.cic.common.core.definitions.CommonDef;
import com.ibm.cic.common.core.definitions.LanguageCode;
import com.ibm.cic.common.core.internal.Messages;
import java.util.Set;
import org.eclipse.osgi.util.NLS;

public class CommonCommandsRegistration
implements ICicCmdCnst {
    public static CmdCommand registerCommand(ACmdManager cm, String commandId) {
        CmdCommand cmd = null;
        if (CommonCommandsRegistration.shouldRegister(cm, "listAvailablePackages", commandId)) {
            cmd = new CmdCommand("listAvailablePackages", Messages.Cmd_listAvailablePackages_Header);
            cmd.setDescription(Messages.Cmd_listAvailablePackages_Descr);
            cmd.setUseExample(Messages.Cmd_listAvailablePackages_Examples);
            cm.registerCommand(cmd);
        } else if (CommonCommandsRegistration.shouldRegister(cm, "listAvailable", commandId)) {
            cmd = new CmdCommand("listAvailable", Messages.Cmd_listAvailable_Header);
            cmd.setDescription(Messages.Cmd_listAvailable_Descr);
            cmd.setUseExample(Messages.Cmd_listAvailable_Examples);
            cm.registerCommand(cmd);
        } else if (CommonCommandsRegistration.shouldRegister(cm, "listAvailableFixes", commandId)) {
            CmdParameters prms = new CmdParameters(new CmdParamStr(Messages.Cmd_param_IdAndVersion, Messages.Cmd_listAvailableFixes_Param_Header));
            cmd = new CmdCommand("listAvailableFixes", Messages.Cmd_listAvailableFixes_Header, prms);
            cmd.setDescription(Messages.Cmd_listAvailableFixes_Descr);
            cmd.setUseExample(Messages.Cmd_listAvailableFixes_Examples);
            cm.registerCommand(cmd);
        }
        return cmd;
    }

    private static boolean shouldRegister(ACmdManager cm, String theCommandId, String requestedCommandId) {
        return theCommandId.equals(requestedCommandId) && cm.getRegisteredCommand(theCommandId) == null;
    }

    public static CmdCommand registerOption(ACmdManager cm, String commandId) {
        CmdCommand cmd = null;
        if (CommonCommandsRegistration.shouldRegister(cm, "-long", commandId)) {
            cmd = new CmdCommand("-long", Messages.Cmd_long_Header);
            cmd.setCommandRank(CmdCommand.CommandRank.REGULAR);
            cm.registerCommand(cmd);
        } else if (CommonCommandsRegistration.shouldRegister(cm, "-features", commandId)) {
            cmd = new CmdCommand("-features", Messages.Cmd_features_Header);
            cmd.setCommandRank(CmdCommand.CommandRank.REGULAR);
            cm.registerCommand(cmd);
        } else if (CommonCommandsRegistration.shouldRegister(cm, "-rollbackVersions", commandId)) {
            cmd = new CmdCommand("-rollbackVersions", Messages.Cmd_rollbackVersions_Header);
            cmd.setCommandRank(CmdCommand.CommandRank.REGULAR);
            cm.registerCommand(cmd);
        } else if (CommonCommandsRegistration.shouldRegister(cm, "-showPlatforms", commandId)) {
            cmd = new CmdCommand("-showPlatforms", Messages.Cmd_showPlatforms_Header);
            cmd.setCommandRank(CmdCommand.CommandRank.REGULAR);
            cmd.setDescription(Messages.Cmd_showPlatforms_Desc);
            cm.registerCommand(cmd);
        } else if (CommonCommandsRegistration.shouldRegister(cm, "-showUpdateFromVersion", commandId)) {
            cmd = new CmdCommand("-showUpdateFromVersion", Messages.Cmd_showUpdateFromVersion_Header);
            cmd.setCommandRank(CmdCommand.CommandRank.REGULAR);
            cmd.setDescription(Messages.Cmd_showUpdateFromVersion_Descr);
            cmd.setTechPreview(true);
            cm.registerCommand(cmd);
        } else if (CommonCommandsRegistration.shouldRegister(cm, "-repositories", commandId)) {
            CmdParameters prms = new CmdParameters(new CmdParamList(Messages.Cmd_repository_Param_Id, Messages.Cmd_repository_Param_Header));
            cmd = new CmdCommand("-repositories", Messages.Cmd_repository_Header, prms);
            cmd.setDescription(Messages.Cmd_repository_Descr);
            cmd.setCommandRank(CmdCommand.CommandRank.REGULAR);
            cm.registerCommand(cmd);
        } else if (CommonCommandsRegistration.shouldRegister(cm, "-useServiceRepository", commandId)) {
            cmd = new CmdCommand("-useServiceRepository", Messages.Cmd_useServiceRepository_Header);
            cmd.addDefaultAlias();
            cmd.setDescription(Messages.Cmd_useServiceRepository_Descr);
            cmd.setUseExample(Messages.Cmd_useServiceRepository_Examples);
            cmd.setCommandRank(CmdCommand.CommandRank.REGULAR);
            cm.registerCommand(cmd);
        } else if (CommonCommandsRegistration.shouldRegister(cm, "-connectPassportAdvantage", commandId)) {
            cmd = new CmdCommand("-connectPassportAdvantage", Messages.Cmd_connectPassportAdvantage_Header);
            cmd.addDefaultAlias();
            cmd.setDescription(Messages.Cmd_connectPassportAdvantage_Descr);
            cmd.setUseExample(Messages.Cmd_connectPassportAdvantage_Examples);
            cmd.setLevel(1);
            cmd.setCommandRank(CmdCommand.CommandRank.REGULAR);
            cm.registerCommand(cmd);
        } else if (CommonCommandsRegistration.shouldRegister(cm, "-preferences", commandId)) {
            CmdParameters prms = new CmdParameters(new CmdParamProperties(Messages.Cmd_preferences_Param_Id, Messages.Cmd_preferences_Param_Header));
            cmd = new CmdCommand("-preferences", Messages.Cmd_preferences_Header, prms);
            cmd.setDescription(Messages.Cmd_preferences_Descr);
            cmd.setUseExample(Messages.Cmd_preferences_Examples);
            cmd.setLevel(1);
            cmd.setCommandRank(CmdCommand.CommandRank.REGULAR);
            cm.registerCommand(cmd);
        } else if (CommonCommandsRegistration.shouldRegister(cm, "-prompt", commandId)) {
            cmd = new CmdCommand("-prompt", Messages.CommonCommandParameters_Cmd_prompt_Header);
            cmd.setDescription(Messages.CommonCommandParameters_Cmd_prompt_Description);
            cmd.setCommandRank(CmdCommand.CommandRank.REGULAR);
            cm.registerCommand(cmd);
        } else if (CommonCommandsRegistration.shouldRegister(cm, "-showProgress", commandId)) {
            cmd = new CmdCommand("-showProgress", Messages.Cmd_showProgress_Header);
            cmd.addDefaultAlias();
            cm.registerCommand(cmd);
        } else if (CommonCommandsRegistration.shouldRegister(cm, "-showVerboseProgress", commandId)) {
            cmd = new CmdCommand("-showVerboseProgress", Messages.Cmd_showVerboseProgress_Header);
            cmd.addDefaultAlias();
            cm.registerCommand(cmd);
        } else if (CommonCommandsRegistration.shouldRegister(cm, "-nl", commandId)) {
            CmdParameters prms = new CmdParameters(new CmdParamStr(Messages.Cmd_nl_Param_Id, Messages.Cmd_nl_Param_Header));
            cmd = new CmdCommand("-nl", Messages.Cmd_nl_Header, prms);
            cmd.setDescription(NLS.bind((String)Messages.Cmd_nl_Descr, (Object)CommonCommandsRegistration.getCicNlLanguages()));
            cmd.setUseExample(Messages.Cmd_nl_Examples);
            cm.registerCommand(cmd);
        } else if (CommonCommandsRegistration.shouldRegister(cm, "-vm", commandId)) {
            CmdParameters prms = new CmdParameters(new CmdParamStr(Messages.Cmd_vm_Param_Id, Messages.Cmd_vm_Param_Header));
            cmd = new CmdCommand("-vm", Messages.Cmd_vm_Header, prms);
            cmd.setLevel(2);
            cm.registerCommand(cmd);
        } else if (CommonCommandsRegistration.shouldRegister(cm, "-nosplash", commandId)) {
            cmd = new CmdCommand("-nosplash", Messages.Cmd_noSplash_Header);
            cmd.setLevel(2);
            cm.registerCommand(cmd);
        }
        return cmd;
    }

    private static String getCicNlLanguages() {
        StringBuilder sb = new StringBuilder();
        Set<LanguageCode> cicNlLanguagesSet = LanguageCode.getCicNlLanguagesSet();
        for (LanguageCode code : cicNlLanguagesSet) {
            if (sb.length() != 0) {
                sb.append(CommonDef.EOL);
            }
            sb.append(" * ");
            sb.append(code.toString());
        }
        return sb.toString();
    }
}

