/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.cmd;

import com.ibm.cic.common.core.cmd.ACmdLine;
import com.ibm.cic.common.core.cmd.ACmdOp;
import com.ibm.cic.common.core.cmd.CmdRepositoryUtils;
import com.ibm.cic.common.core.cmd.CmdUtils;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.preferences.PreferenceUtil;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.StatusCodes;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.downloads.PreferencesHolder;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public abstract class ANetworkCmdOp
extends ACmdOp
implements CmdRepositoryUtils.IOpenServiceRepoHandler {
    private List<String> sourceRepositories = null;
    private List<IStatus> failedRepositories = null;

    public ANetworkCmdOp(ACmdLine cl) {
        super(cl);
        List<String> repos = cl.getRepositories();
        this.setSourceRepositories(repos);
    }

    @Override
    protected IStatus doExecute(IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        this.failedRepositories = new ArrayList<IStatus>();
        RepositoryGroup repoGroup = new RepositoryGroup("AbstractNetworkCommand");
        try {
            result = this.checkPreferences();
            if (!result.isOK()) {
                CmdUtils.reportNotOKResult(result, this.out, this.err);
                IStatus iStatus = result;
                return iStatus;
            }
            this.setPreferences();
            result = this.openRepositories(repoGroup, CmdUtils.consoleMonitorWithUnknownWork(this.cl));
            if (result.matches(12)) {
                IStatus iStatus = result;
                return iStatus;
            }
            IStatus iStatus = result = this.execute(repoGroup, monitor);
            return iStatus;
        }
        finally {
            repoGroup.removeAllRepositories();
        }
    }

    @Override
    protected void reportSuccessFailureToOutput(IStatus result, PrintWriter outWriter) {
        if (this.isQuery()) {
            return;
        }
        if (this.cl.containsCommand("-prompt") && ANetworkCmdOp.isCanceled(result)) {
            outWriter.println(Messages.CmdRepositoryUtils_authenticationCanceled);
        } else {
            super.reportSuccessFailureToOutput(result, outWriter);
        }
    }

    private static boolean isCanceled(IStatus status) {
        return ANetworkCmdOp.isAuthenticationCanceled(status) || StatusCodes.isDiskPromptCanceledStatus(status);
    }

    private static boolean isAuthenticationCanceled(IStatus status) {
        return MultiStatusUtil.hasFilteredStatus(status, new MultiStatusUtil.IStatusFilter(){

            @Override
            public boolean considerChildren() {
                return true;
            }

            @Override
            public boolean include(IStatus astatus) {
                return StatusCodes.isAuthenticationCanceled(astatus);
            }
        });
    }

    protected abstract IStatus execute(IRepositoryGroup var1, IProgressMonitor var2);

    protected IStatus onOpenRepositoryFailed(IStatus status) {
        if (status.matches(8)) {
            return status;
        }
        if (!status.matches(2)) {
            status = MultiStatusUtil.recodeLevel(status, 2);
        }
        this.failedRepositories.add(status);
        return status;
    }

    protected IStatus convertToWarningAndSaveFailedRepositoryStatus(IStatus status) {
        IStatus return_value = status;
        if (!StatusUtil.isCancel(status)) {
            ArrayList<IStatus> selectedChildren = new ArrayList<IStatus>();
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                if (child.getCode() == 200 || child.getCode() == 204) {
                    if (StatusUtil.isWarning(child)) {
                        selectedChildren.add(child);
                    } else {
                        selectedChildren.add(Statuses.WARNING.get(child.getCode(), child.getMessage(), new Object[0]));
                    }
                }
                ++n2;
            }
            if (selectedChildren.isEmpty()) {
                if (!StatusUtil.isWarning(status)) {
                    return_value = Statuses.WARNING.get(status.getCode(), status.getMessage(), new Object[0]);
                }
            } else {
                return_value = Statuses.WARNING.getMultiStatus(status.getCode(), selectedChildren.toArray(new IStatus[selectedChildren.size()]), status.getMessage(), new Object[0]);
            }
            this.failedRepositories.add(return_value);
        }
        return return_value;
    }

    @Override
    public IStatus onOpenServiceRepository(IStatus status) {
        if (status.isOK()) {
            return status;
        }
        return this.onOpenRepositoryFailed(status);
    }

    protected void reportFailedOpenRepositories() {
        IStatus result = Status.OK_STATUS;
        if (this.failedRepositories.size() > 0) {
            result = Statuses.WARNING.getMultiStatus(this.failedRepositories.toArray(new IStatus[this.failedRepositories.size()]), Messages.ANetworkCmdOp_Repositories_Not_Connected, new Object[0]);
            CmdUtils.reportNotOKResult(result, this.out, this.err);
            this.failedRepositories.clear();
        }
    }

    protected boolean hasFailedRepositories() {
        return !this.failedRepositories.isEmpty();
    }

    @Override
    protected IStatus done(IStatus result) {
        this.reportFailedOpenRepositories();
        return super.done(result);
    }

    protected IStatus openRepositories(IRepositoryGroup repoGroup, IProgressMonitor monitor) {
        int n;
        int n2 = n = this.sourceRepositories != null ? this.sourceRepositories.size() : 0;
        if (CmdRepositoryUtils.usePassportAdvantageCmdOrPref(this.cl)) {
            ++n;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ANetworkCmdOp_taskOpeningRepositories, (int)n);
        try {
            block17: {
                if (this.sourceRepositories != null) {
                    for (String sourceRepo : this.sourceRepositories) {
                        if (sourceRepo != null && sourceRepo.length() > 0) {
                            try {
                                this.openSourceRepository(repoGroup, sourceRepo, (IProgressMonitor)sm.newChild(1, 0));
                                continue;
                            }
                            catch (CoreException e) {
                                IStatus result = this.onOpenRepositoryFailed(e.getStatus());
                                if (!result.matches(12)) continue;
                                IStatus iStatus = result;
                                if (monitor != null) {
                                    monitor.done();
                                }
                                return iStatus;
                            }
                        }
                        sm.worked(1);
                    }
                }
                if (CmdRepositoryUtils.usePassportAdvantageCmdOrPref(this.cl)) {
                    try {
                        this.openPPA(repoGroup, (IProgressMonitor)sm.newChild(1, 0));
                    }
                    catch (CoreException e) {
                        IStatus result = this.convertToWarningAndSaveFailedRepositoryStatus(e.getStatus());
                        if (!StatusUtil.isErrorOrCancel(result)) break block17;
                        IStatus iStatus = result;
                        if (monitor != null) {
                            monitor.done();
                        }
                        return iStatus;
                    }
                }
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void setSourceRepositories(List<String> paramStrList) {
        this.sourceRepositories = paramStrList;
    }

    protected IRepository openPPA(IRepositoryGroup group, IProgressMonitor monitor) throws CoreException {
        return CmdRepositoryUtils.openPPA(this.cl, group, monitor);
    }

    protected IRepository openSourceRepository(IRepositoryGroup group, String location, IProgressMonitor monitor) throws CoreException {
        return CmdRepositoryUtils.openSourceRepository(this.cl, group, location, monitor);
    }

    protected void setPreferences() {
        for (Map.Entry<String, String> entry : this.cl.getPreferences().entrySet()) {
            this.setPreference(entry.getKey(), entry.getValue());
        }
    }

    protected abstract void setPreference(String var1, String var2);

    protected IStatus checkPreferences() {
        try {
            Map<String, String> unknownPreferences = this.checkPreferences(this.cl.getPreferences());
            if (!unknownPreferences.isEmpty()) {
                return PreferenceUtil.getUnknownPreferenceError(unknownPreferences.keySet().iterator().next());
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    protected Map<String, String> checkPreferences(Map<String, String> preferences) throws CoreException {
        LinkedHashMap<String, String> unknownPreferences = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : preferences.entrySet()) {
            String value;
            String key = entry.getKey();
            IStatus status = this.checkValidPreferenceValue(key, value = entry.getValue());
            if (PreferenceUtil.isUnknownPreference(status)) {
                unknownPreferences.put(key, value);
                continue;
            }
            if (!status.matches(4)) continue;
            throw new CoreException(status);
        }
        return unknownPreferences;
    }

    protected IStatus checkValidPreferenceValue(String key, String value) {
        PreferencesHolder ph = PreferencesHolder.INSTANCE;
        IStatus result = ph.checkValidPreferenceValue(key, value);
        if (result.matches(4)) {
            if (!PreferenceUtil.isUnknownPreference(result)) {
                return result;
            }
            if (PreferenceUtil.isKey(key, ICicPreferenceConstants.PASSPORT_ADVANTAGE_ENABLED)) {
                result = Status.OK_STATUS;
            } else if (PreferenceUtil.isKey(key, ICicPreferenceConstants.HTTP_NTLM_AUTH_KIND)) {
                result = ANetworkCmdOp.checkAuthKind(key, value);
            } else if (ANetworkCmdOp.isNTLMAuthIntegratedProperty(key)) {
                result = Status.OK_STATUS;
            } else assert (result.getCode() == 10);
        }
        return result;
    }

    private static boolean isNTLMAuthIntegratedProperty(String key) {
        return key.length() > "http.ntlm.auth.enableIntegrated.".length() && PreferenceUtil.isKey(key.substring(0, "http.ntlm.auth.enableIntegrated.".length()), "http.ntlm.auth.enableIntegrated.");
    }

    private static IStatus checkAuthKind(String key, String value) {
        List<String> enumLiterals = Arrays.asList("LM", "NTLM", "NTLMv2");
        return PreferenceUtil.checkEnumLiterals(enumLiterals, key, value);
    }

    public static interface INetworkCmdOp {
        public IStatus execute(PrintWriter var1, IRepositoryGroup var2, IProgressMonitor var3);
    }
}

