/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.cmd;

import com.ibm.cic.common.core.cmd.ACmdManager;
import com.ibm.cic.common.core.cmd.CmdCommand;
import com.ibm.cic.common.core.cmd.CmdIterator;
import com.ibm.cic.common.core.cmd.CmdLinkCheckIfCmdParam1;
import com.ibm.cic.common.core.cmd.CmdParamPackage;
import com.ibm.cic.common.core.cmd.CmdUtils;
import com.ibm.cic.common.core.cmd.ICmdLink;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IStatus;

public abstract class ACmdLine {
    private final ACmdManager cm = this.createCommandManager();

    protected ACmdLine() {
    }

    public String toString() {
        return this.cm.toString();
    }

    public String[] getCommandLine() {
        String[] cmdLineArgs = this.cm.getCommandLine();
        return cmdLineArgs == null ? new String[]{} : cmdLineArgs;
    }

    protected abstract ACmdManager createCommandManager();

    public IStatus processHelpCommand() {
        CmdCommand helpCmd = this.cm.getCommand("help");
        if (helpCmd == null) {
            return null;
        }
        StringBuffer output = new StringBuffer();
        String param = helpCmd.getParamStrVal(0);
        int levelRequest = this.cm.levelRequest(param);
        if (param != null && levelRequest == 0) {
            CmdCommand helpWithCmd = this.cm.getRegisteredCommand(param);
            if (helpWithCmd == null) {
                return Statuses.ERROR.get(8016, Messages.Cmd_Error_Help_Command_Unavailable, param);
            }
            this.printCommandInfo(output, helpWithCmd, true);
        } else {
            if (levelRequest == 0) {
                levelRequest = 1;
            }
            for (CmdCommand cmd : this.cm.getAllSortedRegisteredCommands()) {
                if ((cmd.getLevel() & levelRequest) <= 0 || !cmd.isMain() || !cmd.checkToolConsistency()) continue;
                this.printCommandInfo(output, cmd, false);
            }
        }
        return Statuses.OK.get(output.toString(), new Object[0]);
    }

    private void printCommandInfo(StringBuffer output, CmdCommand cmd, boolean includeDetails) {
        this.printCommandInfo(output, "", cmd, includeDetails);
    }

    private void printCommandInfo(StringBuffer output, String prefix, CmdCommand cmd, boolean includeDetails) {
        SortedSet<ICmdLink> incompatibleCommands;
        ACmdLine.appendLine(output, prefix, cmd.getSummary());
        if (cmd.isTechPreview()) {
            ACmdLine.appendLine(output, prefix, "    " + Messages.Cmd_techPreviewTag);
        }
        ACmdLine.appendLine(output, prefix, "    " + cmd.getHeader());
        if (!includeDetails) {
            return;
        }
        String headerInfo = cmd.getParameters().getHeaderInfo();
        if (headerInfo.length() > 0) {
            ACmdLine.appendLine(output, prefix, "    " + headerInfo);
        }
        SortedSet<CmdCommand> allCommands = this.cm.getAllSortedRegisteredCommands();
        for (CmdCommand option : allCommands) {
            if (option == cmd || !option.isRegular() || !option.requires(cmd) || !option.checkToolConsistency()) continue;
            String prefixForOptions = String.valueOf(prefix) + "    ";
            this.printCommandInfo(output, prefixForOptions, option, false);
        }
        if (cmd.getDescription() != null) {
            output.append("\n");
            ACmdLine.appendLine(output, prefix, cmd.getDescription());
        }
        SortedSet<ICmdLink> requiredCommands = this.filterAndSortCommands(cmd.isMain() ? this.filterCommandOptions(cmd.getRequiredParents()) : cmd.getRequiredParents());
        SortedSet<ICmdLink> optionalCommands = this.filterAndSortCommands(cmd.isMain() ? this.filterCommandOptions(cmd.getOptionalParents()) : cmd.getOptionalParents());
        if (!requiredCommands.isEmpty() || !optionalCommands.isEmpty()) {
            output.append("\n");
            ACmdLine.appendLine(output, prefix, Messages.Cmd_RequiredCommands);
            ACmdLine.appendParents(output, prefix, requiredCommands);
            ACmdLine.appendParents(output, prefix, optionalCommands);
        }
        if (!(incompatibleCommands = this.filterAndSortCommands(cmd.getIncompatibleCommands())).isEmpty()) {
            output.append("\n");
            ACmdLine.appendLine(output, prefix, Messages.Cmd_IncompatibleCommands);
            ACmdLine.appendParents(output, prefix, incompatibleCommands);
        }
        if (cmd.getUseExample() != null) {
            output.append("\n");
            ACmdLine.appendLine(output, prefix, Messages.Cmd_CommandUseExamples);
            ACmdLine.appendLine(output, prefix, cmd.getUseExample());
        }
    }

    private SortedSet<ICmdLink> filterAndSortCommands(List<ICmdLink> cmdList) {
        TreeSet<ICmdLink> sortedCmds = new TreeSet<ICmdLink>(new Comparator<ICmdLink>(){

            @Override
            public int compare(ICmdLink arg0, ICmdLink arg1) {
                return CmdUtils.compareCommands(arg0.getParent(), arg1.getParent());
            }
        });
        for (ICmdLink cmd : cmdList) {
            if (this.isDeprecatedCommand(cmd) || this.isHiddenCommand(cmd) || this.isDoNotReportCommand(cmd)) continue;
            sortedCmds.add(cmd);
        }
        return sortedCmds;
    }

    public SortedSet<CmdCommand> getAllRegisteredCommands() {
        return this.cm.getAllSortedRegisteredCommands();
    }

    private List<ICmdLink> filterCommandOptions(List<ICmdLink> cmdLinks) {
        ArrayList<ICmdLink> cmdParents = new ArrayList<ICmdLink>();
        for (ICmdLink cmdLink : cmdLinks) {
            CmdCommand cmdParent = cmdLink.getParent();
            if (!cmdParent.getCommandRank().equals((Object)CmdCommand.CommandRank.MAIN)) continue;
            cmdParents.add(cmdLink);
        }
        return cmdParents;
    }

    protected boolean isDeprecatedCommand(ICmdLink link) {
        return link.getParent().getLevel() == 64;
    }

    protected boolean isHiddenCommand(ICmdLink link) {
        return link.getParent().getLevel() == 4;
    }

    protected boolean isDoNotReportCommand(ICmdLink link) {
        boolean return_value = false;
        if (link instanceof CmdLinkCheckIfCmdParam1) {
            CmdLinkCheckIfCmdParam1 lnk = (CmdLinkCheckIfCmdParam1)link;
            boolean bl = return_value = !lnk.getParentLink2().isValidLink();
        }
        if (!return_value) {
            return_value = link.getParent().id() == "-toolId";
        }
        return return_value;
    }

    public String getParam1StrVal(String a_cmdId) {
        return this.cm.getParam1StrVal(a_cmdId);
    }

    public Object getParam1ObjVal(String a_cmdId) {
        return this.cm.getParam1ObjVal(a_cmdId);
    }

    public boolean containsCommand(String a_cmdId) {
        return this.cm.containsCommand(a_cmdId);
    }

    public CmdCommand getCommand(String a_cmdId) {
        return this.cm.getCommand(a_cmdId);
    }

    public String[] getCommandLineData() {
        return this.cm.getCommandLine();
    }

    public IStatus canLoadCommandLine(String[] a_cmdArray) {
        ACmdManager acm = this.createCommandManager();
        return acm.loadCommandLineData(a_cmdArray);
    }

    public List<String> getRepositories() {
        List<String> repos = (List<String>)this.getParam1ObjVal("-repositories");
        return repos != null ? repos : Collections.emptyList();
    }

    public Map<String, String> getPreferences() {
        Map<String, String> prefs = (Map<String, String>)this.getParam1ObjVal("-preferences");
        return prefs != null ? prefs : Collections.emptyMap();
    }

    public List<CmdParamPackage.IdVersionFeatures> getPackages(String cmdId) {
        List<CmdParamPackage.IdVersionFeatures> pkgs = (List<CmdParamPackage.IdVersionFeatures>)this.getParam1ObjVal(cmdId);
        return pkgs != null ? pkgs : Collections.emptyList();
    }

    public IStatus loadCommandLineData(String[] a_cmdArray) {
        return this.cm.loadCommandLineData(a_cmdArray);
    }

    @Deprecated
    public void reset() {
        this.cm.reset();
    }

    public boolean setParam1StrVal(String a_commandId, String a_val) {
        return this.cm.setParam1StrVal(a_commandId, a_val);
    }

    public boolean checkArrayForCommand(String[] a_params, String a_cmdId) {
        CmdIterator cmdData = new CmdIterator(a_params);
        while (cmdData.hasMoreArgs()) {
            CmdCommand cmd = this.cm.getRegisteredCommand(cmdData.getCurrentArg());
            if (cmd != null && cmd.id().equalsIgnoreCase(a_cmdId)) {
                return true;
            }
            cmdData.consumeCurrentArg();
        }
        return false;
    }

    private CmdCommand getRegisteredCommand(String a_commandId) {
        return this.cm.getRegisteredCommand(a_commandId);
    }

    public CmdCommand parseCommandFromArray(String[] a_params, String a_cmdId) {
        CmdCommand return_value = null;
        CmdIterator cmdData = new CmdIterator(a_params);
        while (cmdData.hasMoreArgs()) {
            CmdCommand cmd = this.getRegisteredCommand(cmdData.getCurrentArg());
            if (cmd != null) {
                if (cmd.id().equalsIgnoreCase(a_cmdId)) {
                    CmdCommand newCmd = new CmdCommand(cmd);
                    newCmd.reset();
                    if (newCmd.loadCommandLineData(this.cm, cmdData).isOK()) {
                        return_value = newCmd;
                        continue;
                    }
                    cmdData.consumeCurrentArg();
                    continue;
                }
                cmdData.consumeCurrentArg();
                continue;
            }
            cmdData.consumeCurrentArg();
        }
        return return_value;
    }

    public String[] filterOutCommands(String[] arguments, String[] forbiddenCommands) {
        ArrayList<String> return_value = new ArrayList<String>(arguments.length);
        CmdIterator cmdData = new CmdIterator(arguments);
        while (cmdData.hasMoreArgs()) {
            CmdCommand cmd = this.cm.getRegisteredCommand(cmdData.getCurrentArg());
            if (ACmdLine.isCommandIn(cmd, forbiddenCommands)) {
                CmdCommand dummyCommand = new CmdCommand(cmd);
                dummyCommand.reset();
                dummyCommand.loadCommandLineData(this.cm, cmdData);
                continue;
            }
            return_value.add(cmdData.getCurrentArg());
            cmdData.consumeCurrentArg();
        }
        return return_value.toArray(new String[return_value.size()]);
    }

    private static boolean isCommandIn(CmdCommand cmd, String[] commandIds) {
        if (cmd == null) {
            return false;
        }
        String[] stringArray = commandIds;
        int n = commandIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (cmd.id().equalsIgnoreCase(id)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void appendParents(StringBuffer output, String prefix, Collection<ICmdLink> links) {
        for (ICmdLink link : links) {
            ACmdLine.appendLine(output, prefix, link.getParent().getSummary());
        }
    }

    private static void appendLine(StringBuffer output, String prefix, String line) {
        output.append(prefix).append(line).append("\n");
    }
}

