/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.impl;

import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactsOnDisksInfo;
import com.ibm.cic.common.core.artifactrepo.impl.IVolumeAccessByDisk;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class ArtifactsOnDisks {
    private final IVolumeAccessByDisk diskRepo;
    private List<IArtifact> artifacts;
    private Set<IVolumeAccessByDisk.IDiskSet> onlyDiskSets;
    private Set<IVolumeAccessByDisk.IDisk> onlyDisks;
    private final ArtifactsOnDisksInfo aodi;
    private Set<IArtifact> notOnAnyDisk;

    public String toString() {
        return this.aodi.toString();
    }

    public ArtifactsOnDisks(IVolumeAccessByDisk diskRepo) {
        this.diskRepo = diskRepo;
        this.artifacts = null;
        this.aodi = new ArtifactsOnDisksInfo();
    }

    public void addArtifacts(Collection<IArtifact> toAdd) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList<IArtifact>(toAdd.size());
        }
        this.artifacts.addAll(toAdd);
    }

    public void addCheckOnlyFilter(IVolumeAccessByDisk.IDiskSet diskSet) {
        assert (diskSet != null);
        if (this.onlyDiskSets == null) {
            this.onlyDiskSets = new HashSet<IVolumeAccessByDisk.IDiskSet>();
        }
        this.onlyDiskSets.add(diskSet);
    }

    public void determineArtifactsOnDisk(IArtifactSession session, IProgressMonitor monitor) throws CoreException, IOException {
        IVolumeAccessByDisk.IDiskSet[] diskSetsToConsider = null;
        if (this.onlyDiskSets != null) {
            diskSetsToConsider = this.onlyDiskSets.toArray(new IVolumeAccessByDisk.IDiskSet[this.onlyDiskSets.size()]);
        }
        final HashMap diskToCount = new HashMap();
        final int[] notOnAnyDiskCount = new int[1];
        this.diskRepo.visitArtifactsOnDisk(session, diskSetsToConsider, this.artifacts, new IVolumeAccessByDisk.IArtifactOnDiskCallback(){

            @Override
            public void onDisk(IArtifact artifact, IVolumeAccessByDisk.IDisk disk) {
                if (ArtifactsOnDisks.this.onlyDisks != null && !ArtifactsOnDisks.this.onlyDisks.contains(disk)) {
                    return;
                }
                Integer count = (Integer)diskToCount.get(disk);
                if (count == null) {
                    diskToCount.put(disk, 1);
                } else {
                    diskToCount.put(disk, count + 1);
                }
            }

            @Override
            public void notOnAnyDisk(IArtifact artifact) {
                notOnAnyDiskCount[0] = notOnAnyDiskCount[0] + 1;
            }
        }, monitor);
        this.aodi.clear();
        this.notOnAnyDisk = new LinkedHashSet<IArtifact>(notOnAnyDiskCount[0]);
        for (Map.Entry entry : diskToCount.entrySet()) {
            IVolumeAccessByDisk.IDisk disk = (IVolumeAccessByDisk.IDisk)entry.getKey();
            Integer count = (Integer)entry.getValue();
            ArtifactsOnDisksInfo.ArtifactsOnDiskInfo aod = new ArtifactsOnDisksInfo.ArtifactsOnDiskInfo(disk, count);
            this.aodi.putArtifactsOnDisk(disk, aod);
        }
        this.diskRepo.visitArtifactsOnDisk(session, diskSetsToConsider, this.artifacts, new IVolumeAccessByDisk.IArtifactOnDiskCallback(){

            @Override
            public void onDisk(IArtifact artifact, IVolumeAccessByDisk.IDisk disk) {
                if (ArtifactsOnDisks.this.onlyDisks != null && !ArtifactsOnDisks.this.onlyDisks.contains(disk)) {
                    return;
                }
                ArtifactsOnDisksInfo.ArtifactsOnDiskInfo aod = ArtifactsOnDisks.this.aodi.getArtifactsOnDisk(disk);
                aod.addArtifact(artifact);
            }

            @Override
            public void notOnAnyDisk(IArtifact artifact) {
                ArtifactsOnDisks.this.notOnAnyDisk.add(artifact);
            }
        }, monitor);
    }

    public List<IVolumeAccessByDisk.IDisk> getUsedDisks() {
        return this.aodi.getUsedDisks();
    }

    public Set<IVolumeAccessByDisk.IDiskSet> getUsedDiskSets() {
        return this.aodi.getUsedDiskSets();
    }

    public IVolumeAccessByDisk.IDiskSetDisks getDiskSetDisksUsed(IVolumeAccessByDisk.IDiskSet diskSet) {
        return this.aodi.getDiskSetDisksUsed(diskSet);
    }

    public ArtifactsOnDisksInfo.ArtifactsOnDiskInfo getArtifactsOnDisk(IVolumeAccessByDisk.IDisk disk) {
        return this.aodi.getArtifactsOnDisk(disk);
    }

    public boolean isOnDiskSet(IVolumeAccessByDisk.IDiskSet diskSet, IArtifact artifact) {
        return this.aodi.isOnDiskSet(diskSet, artifact);
    }

    public boolean isNotOnAnyDiskSet(IArtifact artifact) {
        return this.notOnAnyDisk.contains(artifact);
    }
}

