/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.impl;

import com.ibm.cic.common.core.artifactrepo.impl.ArtifactPathMapperUtil;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class ArtifactToPathUtil {
    static IPath getUniquePath(IArtifactKey artifactKey) {
        IPath path = ArtifactPathMapperUtil.toNamespaceUniquePath(artifactKey);
        return new Path(artifactKey.getNamespace()).append(path);
    }

    public static IArtifactKey getArtifactKeyFromUniquePath(IPath relPath) {
        return ArtifactPathMapperUtil.toArtifactKey(relPath);
    }

    public static IPath getUpdateSiteCompatiblePath(IArtifact artifact) {
        return ArtifactToPathUtil.getUpdateSiteCompatiblePath(artifact.getKey());
    }

    public static IPath getUpdateSiteCompatiblePath(IArtifactKey key) {
        Object path = key.getNamespace().equals("eclipse") ? ArtifactPathMapperUtil.toNamespaceUniquePath(key) : (key.getNamespace().equals("native") ? ArtifactPathMapperUtil.toNamespaceUniquePath(key) : (key.getNamespace().equals("agentui") ? ArtifactPathMapperUtil.toNamespaceUniquePath(key) : null));
        return path;
    }

    public static IPath getArtifactPath(IArtifact artifact) {
        IPath path = ArtifactToPathUtil.getUpdateSiteCompatiblePath(artifact);
        if (path == null) {
            path = ArtifactToPathUtil.getUniquePath(artifact.getKey());
        }
        return path;
    }

    public static IPath getArtifactPath(IArtifactKey key) {
        IPath path = ArtifactToPathUtil.getUpdateSiteCompatiblePath(key);
        if (path == null) {
            path = ArtifactToPathUtil.getUniquePath(key);
        }
        return path;
    }

    public static String[] revealArtifactRootNames() {
        TreeSet<String> knownDirs = new TreeSet<String>();
        ArtifactToPathUtil.revealArtifactRootNames(knownDirs);
        return knownDirs.toArray(new String[knownDirs.size()]);
    }

    private static void revealArtifactRootNames(Collection<String> list) {
        String[] namespaces;
        String[] stringArray = namespaces = ArtifactPathMapperUtil.getNamespaces();
        int n = namespaces.length;
        int n2 = 0;
        while (n2 < n) {
            String[] dirs;
            String ns = stringArray[n2];
            String[] stringArray2 = dirs = ArtifactPathMapperUtil.enumerateTopLevelDirs(ns);
            int n3 = dirs.length;
            int n4 = 0;
            while (n4 < n3) {
                String dir = stringArray2[n4];
                list.add(dir.toLowerCase());
                ++n4;
            }
            ++n2;
        }
    }

    public static File[] revealUsedArtifactRoots(File fileRoot) {
        HashSet<String> knownDirs = new HashSet<String>();
        ArtifactToPathUtil.revealArtifactRootNames(knownDirs);
        File[] files = fileRoot.listFiles();
        ArrayList<File> knownDirFiles = new ArrayList<File>(knownDirs.size());
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String simpleName;
            String cmpName;
            File f = fileArray[n2];
            if (f.exists() && f.isDirectory() && knownDirs.contains(cmpName = (simpleName = f.getName()).toLowerCase())) {
                knownDirFiles.add(f);
            }
            ++n2;
        }
        return knownDirFiles.toArray(new File[knownDirFiles.size()]);
    }

    private ArtifactToPathUtil() {
    }
}

