/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.impl;

import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactTocModel;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactTocReader;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactTocUtil;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactTocWriter;
import com.ibm.cic.common.core.artifactrepo.impl.AtocVersionInfo;
import com.ibm.cic.common.core.artifactrepo.impl.ContentInfoComputation;
import com.ibm.cic.common.core.artifactrepo.impl.ContentInfoUtil;
import com.ibm.cic.common.core.artifactrepo.impl.ETagUtil;
import com.ibm.cic.common.core.artifactrepo.impl.ElementHolder;
import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.downloads.TransferUtils;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.downloads.FileContentInfo;
import com.ibm.cic.common.core.internal.repository.RepositoryPool;
import com.ibm.cic.common.core.internal.utils.CicCommonCorePluginTrace;
import com.ibm.cic.common.core.model.adapterdata.AbstractArtifact;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.model.adapterdata.impl.ArtifactKey;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.StatusCodes;
import com.ibm.cic.common.core.utils.AdvisoryLockedFile;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.IndentWriter;
import com.ibm.cic.common.core.utils.PathUtil;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UserName;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.downloads.DigestValue;
import com.ibm.cic.common.downloads.FileCacheManager;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadSession;
import com.ibm.cic.common.downloads.IDownloader;
import com.ibm.cic.common.downloads.IFileContentInfo;
import com.ibm.cic.common.downloads.ProgressMonitorInputStream;
import com.ibm.cic.common.downloads.SimpleContentInfo;
import com.ibm.cic.common.logging.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ArtifactTableOfContents {
    private static final CicCommonCorePluginTrace trace = ComIbmCicCommonCorePlugin.getTrace();
    private static final String ATOC_XML = "atoc.xml";
    private static final String ATOC_DIR = "atoc/";
    private static final String CSET_XML = ".xml";
    private static final Parameters DEFAULT_ATOC_PARAMS_ATOC_DIGESTS_ON = new Parameters("atoc.xml", "atoc/", ".xml", false, true, true, false, null, true);
    private static final Parameters DEFAULT_ATOC_PARAMS_ATOC_DIGESTS_OFF = new Parameters("atoc.xml", "atoc/", ".xml", false, true, true, false, null, false);

    private ArtifactTableOfContents() {
    }

    public static Parameters getDefaultAtocParams(boolean atocDigestsEnabled) {
        return atocDigestsEnabled ? DEFAULT_ATOC_PARAMS_ATOC_DIGESTS_ON : DEFAULT_ATOC_PARAMS_ATOC_DIGESTS_OFF;
    }

    private static ContentInfoComputation.IValidatingInputStream getInputStream(IDownloadSession session, Parameters params, AdvisoryLockedFile alfile, IContentInfo contentInfo, IProgressMonitor monitor) throws IOException {
        long fileLen = alfile.length();
        BufferedInputStream in = new BufferedInputStream(new ProgressMonitorInputStream((InputStream)alfile.getInputStream(), fileLen, fileLen, "", monitor));
        if (params.supportDigests()) {
            return TransferUtils.validateInputStreamContentInfo(new File(alfile.getLocation()), in, contentInfo);
        }
        return new ContentInfoComputation.NOOPValidatingInputStream(alfile.getLocation(), fileLen, in);
    }

    public static synchronized TocHolder getToc(IDownloadSession session, Parameters params, IPath contentFolderPath, IContentInfo contentInfo, IProgressMonitor monitor) throws IOException, CoreException, ParserConfigurationException, SAXException {
        trace.entering(contentFolderPath);
        try (TocFile tocFile = null;){
            tocFile = TocFile.create(params, contentFolderPath, true);
            TocHolder tocHolder = new TocHolder(params, TocFile.getTocBase(params, contentFolderPath), (IPath)new Path(tocFile.getLocation()));
            ContentInfoComputation.IValidatingInputStream vis = ArtifactTableOfContents.getInputStream(session, params, tocFile, contentInfo, monitor);
            InputStream input = vis.getInputStream();
            if (input != null) {
                ArtifactTocReader.parseToc(params, tocHolder, input);
                IStatus status = vis.getValidityStatus();
                if (!status.isOK()) {
                    ArtifactTableOfContents.throwArtifactFileInconsistent(tocFile.getLocation(), status);
                }
            }
            trace.exiting();
            TocHolder tocHolder2 = tocHolder;
            return tocHolder2;
        }
    }

    private static void throwArtifactFileInconsistent(String file, IStatus status) throws CoreException {
        String msg = NLS.bind((String)Messages.ArtifactTableOfContents_fileInconsistent, (Object)file);
        throw new CoreException((IStatus)Statuses.ST.createMultiStatus(status.getCode(), status, msg, new Object[0]));
    }

    private static synchronized ContainedSetPath getContainedSet(IDownloadSession session, Parameters params, ElementHolder parentHolder, IPath base, ElementHolder.IHasHREF ref, IContentInfo contentInfo, IProgressMonitor monitor) throws IOException, CoreException {
        trace.entering();
        try (ArtifactTocWriter.ContainedSetFile csetFile = null;){
            csetFile = ArtifactTocWriter.ContainedSetFile.create(base, ref.getHREF(), true);
            ContainedSetPath csetp = new ContainedSetPath(parentHolder, (IPath)new Path(csetFile.getLocation()));
            ContentInfoComputation.IValidatingInputStream vis = ArtifactTableOfContents.getInputStream(session, params, csetFile, contentInfo, monitor);
            InputStream input = vis.getInputStream();
            if (input != null) {
                ArtifactTocReader.parseContainedSet(params, ref, csetp, csetFile.getLocation(), input);
                IStatus status = vis.getValidityStatus();
                if (!status.isOK()) {
                    ArtifactTableOfContents.throwArtifactFileInconsistent(csetFile.getLocation(), status);
                }
            }
            trace.exiting();
            ContainedSetPath containedSetPath = csetp;
            return containedSetPath;
        }
    }

    private static synchronized ContainedSetURL getContainedSet(IDownloadSession session, Parameters params, ElementHolder parentHolder, URL base, ElementHolder.IHasHREF ref, IContentInfo contentInfo, IProgressMonitor monitor) throws IOException, CoreException {
        trace.entering();
        String fullPath = PathUtil.concatPathSegments(base.toString(), ref.getHREF());
        URL contentSetUrl = new URL(fullPath);
        ContainedSetURL cseturl = new ContainedSetURL(parentHolder, contentSetUrl);
        File file = ArtifactTableOfContents.getCachedFile(session, fullPath, contentInfo, monitor);
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        ArtifactTocReader.parseContainedSet(params, ref, cseturl, contentSetUrl.toString(), is);
        trace.exiting();
        return cseturl;
    }

    private static File getCachedFile(IDownloadSession session, String fullPath, IContentInfo contentInfo, IProgressMonitor monitor) throws FileNotFoundException, IOException, CoreException {
        FileCacheManager fcm = ArtifactTableOfContents.getFileCacheManager();
        FileContentInfo fileContentInfo = new FileContentInfo(contentInfo);
        fileContentInfo.setFilePath(new CicFileLocation(PathUtil.removeSimpleName(fullPath)));
        fileContentInfo.setFileName(new CicFileLocation(PathUtil.getSimpleName(fullPath)));
        try {
            return fcm.getFile(fileContentInfo, false, false, new ArtifactDownloader(session), monitor);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (CoreException e) {
            if (StatusCodes.isContentNotFound(e.getStatus())) {
                throw new FileNotFoundException(e.getStatus().getMessage());
            }
            throw e;
        }
        catch (Exception e) {
            IOException ioe = new IOException("Wrapped exception");
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static FileCacheManager getFileCacheManager() {
        return RepositoryPool.getDefault().getFileCacheManager();
    }

    public static synchronized TocHolder getToc(IDownloadSession session, Parameters params, URL contentFolderUrl, IContentInfo contentInfo, IProgressMonitor monitor) throws IOException, CoreException {
        trace.entering(contentFolderUrl);
        try {
            URL tocBaseUrl = new URL(PathUtil.concatPathSegments(contentFolderUrl.toString(), params.getAtocDir()));
            URL tocUrl = new URL(PathUtil.concatPathSegments(contentFolderUrl.toString(), String.valueOf(params.getAtocDir()) + params.getAtocXml()));
            TocHolder tocHolder = new TocHolder(params, tocBaseUrl, tocUrl);
            String fullPath = tocHolder.getLocation();
            File file = ArtifactTableOfContents.getCachedFile(session, fullPath, contentInfo, monitor);
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            ArtifactTocReader.parseToc(params, tocHolder, is);
            trace.exiting();
            return tocHolder;
        }
        catch (FileNotFoundException fileNotFoundException) {
            trace.exiting("null");
            return null;
        }
        catch (CoreException e) {
            trace.catching(e);
            throw e;
        }
        catch (IOException e) {
            trace.catching(e);
            throw e;
        }
    }

    public static synchronized void createToc(Parameters params, IPath contentFolderPath, IOnAtocSaved onSaved) throws IOException {
        trace.entering(contentFolderPath);
        try (TocFile tocFile = null;){
            tocFile = TocFile.create(params, contentFolderPath, false);
            TocHolder tocHolder = new TocHolder(params, TocFile.getTocBase(params, contentFolderPath), (IPath)new Path(tocFile.getLocation()));
            TocUpdate tocUpdate = new TocUpdate(tocHolder, new IArtifact[0], onSaved){

                @Override
                public boolean doUpdate(IProgressMonitor monitor) {
                    return true;
                }
            };
            tocHolder.writeToc(tocFile, tocUpdate, true, (IProgressMonitor)new NullProgressMonitor());
        }
        trace.exiting();
    }

    static synchronized void removeEmptyToc(Parameters params, IPath repoPath) {
        trace.entering(repoPath);
        File file = TocFile.getTocPath(params, repoPath).toFile();
        FileUtil.rm(file);
        File dir = file.getParentFile();
        if (dir.isDirectory()) {
            FileUtil.deleteEmptyDirsLogIOE(dir);
        }
        trace.exiting();
    }

    public static synchronized void addOrUpdateTocArtifacts(final IDownloadSession session, Parameters params, IPath contentFolderPath, IArtifact[] artifacts, IOnAtocSaved onSaved, IProgressMonitor monitor) throws IOException, CoreException {
        trace.entering(contentFolderPath);
        if (ArtifactTableOfContents.trace.traceEntering) {
            int n = artifacts.length > 3 ? 3 : artifacts.length;
            int i = 0;
            while (i < n) {
                IArtifact artifact = artifacts[i];
                trace.println(".. {0}: {1}", Integer.toString(i), artifact.toString());
                ++i;
            }
            int notShown = artifacts.length - n;
            if (notShown > 0) {
                trace.println(".. {0} more omitted", Integer.toString(notShown));
            }
        }
        try (TocFile tocFile = null;){
            tocFile = TocFile.create(params, contentFolderPath, false);
            TocHolder tocHolder = new TocHolder(params, TocFile.getTocBase(params, contentFolderPath), (IPath)new Path(tocFile.getLocation()));
            TocUpdate tocUpdate = new TocUpdate(tocHolder, artifacts, onSaved){

                @Override
                public boolean doUpdate(IProgressMonitor m) throws IOException, CoreException {
                    boolean isDirty = false;
                    SplitProgressMonitor spm = new SplitProgressMonitor(m, this.artifactsToUpdate.length);
                    IArtifact[] iArtifactArray = this.artifactsToUpdate;
                    int n = this.artifactsToUpdate.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IArtifact iartifact = iArtifactArray[n2];
                        if (this.tocHolder.addOrUpdateArtifact(session, iartifact, spm.next())) {
                            isDirty = true;
                        }
                        ++n2;
                    }
                    return isDirty;
                }
            };
            ArtifactTableOfContents.updateToc(params, tocHolder, tocFile, tocUpdate, monitor);
        }
        trace.exiting();
    }

    public static synchronized void writeTocHolder(IDownloadSession session, TocHolder tocHolder, boolean force, IOnAtocSaved onSaved, IProgressMonitor monitor) throws Exception {
        try (AdvisoryLockedFile tocFile = null;){
            tocFile = TocFile.create(tocHolder.getParams(), tocHolder.getBasePath(), false);
            tocHolder.writeToc((TocFile)tocFile, force, onSaved, monitor);
        }
        trace.exiting();
    }

    public static synchronized void removeTocEntries(final IDownloadSession session, Parameters params, IPath contentFolderPath, IArtifact[] artifactsToRemove, IOnAtocSaved onSaved, IProgressMonitor monitor) throws Exception {
        trace.entering(contentFolderPath);
        TocFile tocFile = null;
        try {
            tocFile = TocFile.create(params, contentFolderPath, false);
            TocHolder tocHolder = new TocHolder(params, TocFile.getTocBase(params, contentFolderPath), (IPath)new Path(tocFile.getLocation()));
            TocUpdate tocUpdate = new TocUpdate(tocHolder, artifactsToRemove, onSaved){

                @Override
                public boolean doUpdate(IProgressMonitor m) throws IOException, CoreException {
                    boolean isDirty = false;
                    SplitProgressMonitor spm = new SplitProgressMonitor(m, this.artifactsToUpdate.length);
                    IArtifact[] iArtifactArray = this.artifactsToUpdate;
                    int n = this.artifactsToUpdate.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IArtifact iartifact = iArtifactArray[n2];
                        if (this.tocHolder.remove(session, iartifact, spm.next())) {
                            isDirty = true;
                        }
                        ++n2;
                    }
                    return isDirty;
                }
            };
            ArtifactTableOfContents.updateToc(params, tocHolder, tocFile, tocUpdate, monitor);
        }
        finally {
            if (tocFile != null) {
                tocFile.close();
                File file = new File(tocFile.getLocation());
                File dir = file.getParentFile();
                if (dir.isDirectory()) {
                    Util.deleteEmptyDirs(dir);
                }
            }
        }
        trace.exiting();
    }

    private static void updateToc(Parameters params, TocHolder tocHolder, TocFile tocFile, TocUpdate tocUpdate, IProgressMonitor monitor) throws IOException, CoreException {
        FileInputStream input = tocFile.getInputStream();
        if (input != null) {
            ArtifactTocReader.parseToc(params, tocHolder, new BufferedInputStream(input));
        }
        tocHolder.writeToc(tocFile, tocUpdate, monitor);
    }

    private static class ArtifactDownloader
    implements IDownloader {
        private static final Logger log = Logger.getLogger(ArtifactDownloader.class);
        private final IDownloadSession session;

        public ArtifactDownloader(IDownloadSession session) {
            this.session = session;
        }

        @Override
        public IStatus downloadToFile(IFileContentInfo sourceContentInfo, File destination, IProgressMonitor monitor) {
            log.start(log.debug("downloadToFile(|{0}|->|{1}|)", sourceContentInfo.getFileLocation().toString(), destination.getAbsolutePath()));
            IStatus return_value = TransferUtils.download(this.session, sourceContentInfo.getFileLocation(), destination, sourceContentInfo, monitor);
            log.stop();
            return return_value;
        }

        @Override
        public boolean locationShouldBeCached(ICicLocation l) {
            if (!UserOptions.CIC_REPO_CACHE_ATOC.isSet()) {
                return false;
            }
            return FileURLUtil.isURLString(l.toString(), false);
        }
    }

    public static class ArtifactWithExtraTocInfo
    extends AbstractArtifact {
        private final IArtifact artifact;
        private final ExtraInfo extraInfo;

        public ArtifactWithExtraTocInfo(IArtifact artifact) {
            this.artifact = artifact;
            this.extraInfo = new ExtraInfo();
        }

        @Override
        public IContentInfo getContentInfo() {
            return this.artifact.getContentInfo();
        }

        @Override
        public IArtifactKey getKey() {
            return this.artifact.getKey();
        }

        @Override
        public IPath toNamespaceUniquePath() {
            return this.artifact.toNamespaceUniquePath();
        }

        @Override
        public String toUserString() {
            return this.artifact.toUserString();
        }

        public ExtraInfo getExtraInfo() {
            return this.extraInfo;
        }
    }

    static abstract class ContainedSetHolder
    extends ElementHolder {
        private ArtifactTocModel.ContainedSet cset;

        ContainedSetHolder(ElementHolder parentHolder) {
            super(parentHolder);
        }

        public ArtifactTocModel.ContainedSet getContainedSet() {
            return this.cset;
        }

        public void setContainedSet(ArtifactTocModel.ContainedSet cs) {
            this.cset = cs;
        }

        @Override
        protected ElementHolder doResolveRef(IDownloadSession session, ElementHolder.IHasHREF ref, IProgressMonitor monitor) throws IOException, CoreException {
            return TocHolder.doResolveContainedSetRef(session, null, ref, monitor);
        }

        @Override
        public void dump(IndentWriter iw, boolean resolve) {
            iw.enter();
            try {
                PrintWriter pw = iw.getPrintWriter();
                pw.print("contained cset=");
                if (this.cset == null) {
                    pw.println(this.cset);
                } else {
                    this.cset.dump(iw, resolve);
                }
            }
            finally {
                iw.leave();
            }
        }
    }

    private static class ContainedSetPath
    extends ContainedSetHolder
    implements ElementHolder.PathElementHolder {
        private final IPath path;

        ContainedSetPath(ElementHolder parentHolder, IPath path) {
            super(parentHolder);
            this.path = path;
        }

        @Override
        public IPath getPath() {
            return this.path;
        }

        @Override
        public String getHolderUserString() {
            return this.path.toString();
        }

        @Override
        public String getLocation() {
            return ElementHolder.getLocation(this);
        }
    }

    private static class ContainedSetURL
    extends ContainedSetHolder
    implements ElementHolder.URLElementHolder {
        private final URL url;

        ContainedSetURL(ElementHolder parentHolder, URL url) {
            super(parentHolder);
            this.url = url;
        }

        @Override
        public URL getURL() {
            return this.url;
        }

        @Override
        public String getHolderUserString() {
            return this.url.toString();
        }

        @Override
        public String getLocation() {
            return ElementHolder.getLocation(this);
        }
    }

    public static class ExtraInfo {
        private final SortedMap<String, String> attributeMap;

        ExtraInfo(SortedMap<String, String> attributeMap) {
            this.attributeMap = attributeMap;
        }

        public ExtraInfo() {
            this.attributeMap = new TreeMap<String, String>();
        }

        public SortedMap<String, String> getAttributeMap() {
            return this.attributeMap;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("ExtraInfo ");
            for (Map.Entry<String, String> me : this.attributeMap.entrySet()) {
                sb.append(me.getKey());
                sb.append("='");
                sb.append(me.getValue());
                sb.append("' ");
            }
            return sb.toString();
        }
    }

    public static interface IOnAtocSaved {
        public void onSave(IPath var1, IPath var2, IContentInfo var3, IProgressMonitor var4);
    }

    public static class Parameters {
        private final String atocXml;
        private final String atocDir;
        private final boolean useETag;
        private final boolean useSummary;
        private final boolean writeIdHolder;
        private final boolean writeQualHolder;
        private final String[] attrNames;
        private final boolean supportDigests;
        private static final String[] EMPTY_NAMES = new String[0];

        public Parameters(String atocXml, String atocDir, String csetExt, boolean useETag, boolean useSummary, boolean writeQualHolder, boolean writeIdHolder, String[] attrNames, boolean supportDigests) {
            this.atocXml = atocXml;
            this.atocDir = atocDir;
            this.useETag = useETag;
            this.useSummary = useSummary;
            this.writeIdHolder = writeIdHolder;
            this.writeQualHolder = writeQualHolder;
            this.attrNames = attrNames != null ? attrNames : EMPTY_NAMES;
            this.supportDigests = supportDigests;
        }

        public boolean supportDigests() {
            return this.supportDigests;
        }

        String getAtocXml() {
            return this.atocXml;
        }

        String getAtocDir() {
            return this.atocDir;
        }

        public String getAtocFilePathAsString() {
            return String.valueOf(this.atocDir) + this.atocXml;
        }

        boolean useETag() {
            return this.useETag;
        }

        boolean useSummary() {
            return this.useSummary;
        }

        boolean writeIdHolder() {
            return this.writeIdHolder;
        }

        boolean writeQualHolder() {
            return this.writeQualHolder;
        }

        void artifactCreated(ArtifactTocModel.Artifact artifact, IArtifact iartifact) {
        }

        void printExtraArtifactAttr(PrintWriter writer, boolean singleQuote, ArtifactTocModel.Artifact artifact) {
            Object objExtraInfo = artifact.getExtraInfo();
            if (objExtraInfo instanceof ExtraInfo) {
                ExtraInfo extraInfo = (ExtraInfo)objExtraInfo;
                SortedMap<String, String> map = extraInfo.getAttributeMap();
                String[] stringArray = this.attrNames;
                int n = this.attrNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    String value = (String)map.get(name);
                    if (value != null) {
                        ArtifactTocWriter.printAttr(writer, singleQuote, name, value);
                    }
                    ++n2;
                }
            }
        }

        void printExtraArtifactContent(PrintWriter writer, ArtifactTocModel.Artifact artifact) {
        }

        void readExtraAttributes(Attributes attributes, ArtifactTocModel.Artifact artifact) {
            TreeMap<String, String> treeMap = null;
            String[] stringArray = this.attrNames;
            int n = this.attrNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                String value = attributes.getValue(name);
                if (value != null) {
                    if (treeMap == null) {
                        treeMap = new TreeMap<String, String>();
                    }
                    treeMap.put(name, value);
                }
                ++n2;
            }
            if (treeMap != null) {
                ExtraInfo extraInfo = new ExtraInfo(treeMap);
                artifact.setExtraInfo(extraInfo);
            }
        }
    }

    private static class TocFile
    extends AdvisoryLockedFile {
        public static IPath getTocBase(Parameters params, IPath repoPath) {
            return repoPath.append(params.getAtocDir());
        }

        public static IPath getTocPath(Parameters params, IPath repoPath) {
            return repoPath.append(String.valueOf(params.getAtocDir()) + params.getAtocXml());
        }

        public TocFile(File file, boolean forReadingOnly) throws IOException {
            super(file, forReadingOnly, UserOptions.CIC_REPO_LOCKING.isSet());
        }

        public static TocFile create(Parameters params, IPath repoPath, boolean forReadingOnly) throws IOException {
            File parent;
            File file = TocFile.getTocPath(params, repoPath).toFile();
            if (!(forReadingOnly || (parent = file.getParentFile()).exists() || parent.mkdirs())) {
                throw new IOException("Failed to mkdirs directory:" + parent.toString());
            }
            TocFile tocFile = new TocFile(file, forReadingOnly);
            return (TocFile)TocFile.lockCloseIfFails(tocFile);
        }
    }

    public static class TocHolder
    extends ElementHolder
    implements IReadArtifactRepo.IArtifactToc,
    ElementHolder.PathElementHolder,
    ElementHolder.URLElementHolder {
        private final IPath tocBasePath;
        private final URL tocBaseUrl;
        private final IPath tocPath;
        private final URL tocUrl;
        private final ArtifactTocModel.Toc toc = new ArtifactTocModel.Toc(this);
        private final Parameters params;

        public TocHolder(Parameters params, IPath basePath, IPath tocPath) {
            super(null);
            this.params = params;
            this.tocBasePath = basePath;
            this.tocPath = tocPath;
            this.tocUrl = null;
            this.tocBaseUrl = null;
        }

        public TocHolder(Parameters params, URL baseUrl, URL tocUrl) {
            super(null);
            this.params = params;
            this.tocBaseUrl = baseUrl;
            this.tocUrl = tocUrl;
            this.tocBasePath = null;
            this.tocPath = null;
        }

        public Parameters getParams() {
            return this.params;
        }

        public ArtifactTocModel.Toc getToc() {
            return this.toc;
        }

        private void getContainedSetRefs(List<ArtifactTocModel.ContainedSetReference> list, ArtifactTocModel.AbstractContainedSet acs) {
            ArtifactTocModel.ContainedSet cs = null;
            if (acs instanceof ArtifactTocModel.ContainedSetReference) {
                ArtifactTocModel.ContainedSetReference csr = (ArtifactTocModel.ContainedSetReference)acs;
                list.add(csr);
                return;
            }
            if (!(acs instanceof ArtifactTocModel.ContainedSet)) {
                throw new AssertionError();
            }
            cs = (ArtifactTocModel.ContainedSet)acs;
            for (ArtifactTocModel.AbstractContainedSet acsChild : cs.getContained()) {
                this.getContainedSetRefs(list, acsChild);
            }
        }

        public List getContents(IDownloadSession session, ArtifactTocModel.AbstractContainedSet acs, IProgressMonitor monitor) throws IOException, CoreException {
            ArtifactTocModel.AbstractContainedSet acsResolved = TocHolder.resolveContainedSet(session, acs, monitor);
            if (acsResolved instanceof ArtifactTocModel.ContainedSet) {
                ArtifactTocModel.ContainedSet cs = (ArtifactTocModel.ContainedSet)acsResolved;
                return cs.getContained();
            }
            return Collections.EMPTY_LIST;
        }

        private ArtifactPos getArtifactPos(IDownloadSession session, ArtifactTocModel.AbstractContainedSet acs, IArtifactKey key, IProgressMonitor monitor) throws IOException, CoreException {
            ArtifactTocModel.AbstractContainedSet acsResolved;
            if (ArtifactTocModel.Artifact.matches(acs.getAttrName(), acs.getAttrValue(), key) && (acsResolved = TocHolder.resolveContainedSet(session, acs, monitor)) instanceof ArtifactTocModel.ContainedSet) {
                ArtifactTocModel.ContainedSet cs = (ArtifactTocModel.ContainedSet)acsResolved;
                if (cs.containsOnly(ArtifactTocModel.Artifact.class)) {
                    ArtifactKey key2;
                    ArtifactPos apos = this.findArtifactPos(key, cs);
                    if (apos != null) {
                        return apos;
                    }
                    Version effectiveVersion = cs.getEffectiveVersion();
                    if (!UserOptions.maintainAtocCompatibility() && "eclipse".equals(key.getNamespace()) && "".equals(key.getPath().toString()) && (apos = this.findArtifactPos(key2 = new ArtifactKey((IPath)new Path(".jar"), key.getNamespace(), key.getQualifier(), key.getId(), key.getVersion()), cs)) != null) {
                        return apos;
                    }
                    if (AtocVersionInfo.ATOC_VERSION_1.equals((Object)effectiveVersion) && "eclipse".equals(key.getNamespace()) && ".jar".equals(key.getPath().toString()) && (apos = this.findArtifactPos(key2 = new ArtifactKey((IPath)Path.EMPTY, key.getNamespace(), key.getQualifier(), key.getId(), key.getVersion()), cs)) != null) {
                        return apos;
                    }
                    return new ArtifactPos(cs, null, null);
                }
                for (ArtifactTocModel.AbstractContainedSet acset2 : cs.getContained()) {
                    ArtifactPos match = this.getArtifactPos(session, acset2, key, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                    if (match == null) continue;
                    return match;
                }
                return new ArtifactPos(cs, null, null);
            }
            return null;
        }

        private ArtifactPos findArtifactPos(IArtifactKey key, ArtifactTocModel.ContainedSet cs) {
            Iterator iter = cs.getContained().iterator();
            while (iter.hasNext()) {
                ArtifactTocModel.Artifact artifact = (ArtifactTocModel.Artifact)iter.next();
                if (!artifact.equalsIdVersionPath(key)) continue;
                return new ArtifactPos(cs, iter, artifact);
            }
            return null;
        }

        private ArtifactPos getArtifactPos(IDownloadSession session, IArtifactKey key, IProgressMonitor monitor) throws IOException, CoreException {
            for (ArtifactTocModel.AbstractContainedSet cset : this.toc.getContents()) {
                ArtifactPos artifact = this.getArtifactPos(session, cset, key, monitor);
                if (artifact == null) continue;
                return artifact;
            }
            return null;
        }

        public ArtifactTocModel.Artifact getArtifact(IDownloadSession session, IArtifactKey key, IProgressMonitor monitor) throws IOException, CoreException {
            ArtifactPos found = this.getArtifactPos(session, key, monitor);
            if (found != null) {
                return found.getArtifact();
            }
            return null;
        }

        @Override
        protected ElementHolder doResolveRef(IDownloadSession session, ElementHolder.IHasHREF ref, IProgressMonitor monitor) throws IOException, CoreException {
            return TocHolder.doResolveContainedSetRef(session, this, ref, monitor);
        }

        static ElementHolder doResolveContainedSetRef(IDownloadSession session, TocHolder tocHolder, ElementHolder.IHasHREF ref, IProgressMonitor monitor) throws IOException, CoreException {
            ContainedSetHolder csh;
            ElementHolder parentHolder = ElementHolder.getHolder(ref);
            if (tocHolder == null) {
                tocHolder = (TocHolder)ElementHolder.getRootHolder(ref);
            }
            ArtifactTocModel.ContainedSetReference csr = (ArtifactTocModel.ContainedSetReference)ref;
            if (tocHolder.tocBaseUrl != null) {
                csh = ArtifactTableOfContents.getContainedSet(session, tocHolder.getParams(), parentHolder, tocHolder.tocBaseUrl, csr, csr.getContentInfo(), monitor);
            } else if (tocHolder.tocBasePath != null) {
                csh = ArtifactTableOfContents.getContainedSet(session, tocHolder.getParams(), parentHolder, tocHolder.tocBasePath, csr, csr.getContentInfo(), monitor);
            } else {
                throw new AssertionError();
            }
            Map<String, String> attrs = csr.getAttributes();
            Map<String, String> attrResolved = csh.getContainedSet().getAttributes();
            for (Map.Entry<String, String> me : attrResolved.entrySet()) {
                String name = me.getKey();
                String valResolved = me.getValue();
                String val = attrs.get(name);
                if (val.equals(valResolved)) continue;
                ElementHolder refHolder = ElementHolder.getHolder(ref);
                String holderUserString = refHolder.getHolderUserString();
                csh.setErrorObject(new IOException("Resolved contained set inconsistent '" + holderUserString) + "'");
                break;
            }
            return csh;
        }

        private static ArtifactTocModel.AbstractContainedSet resolveContainedSet(IDownloadSession session, ArtifactTocModel.AbstractContainedSet acs, IProgressMonitor monitor) throws IOException, CoreException {
            ArtifactTocModel.ContainedSet cs = null;
            if (acs instanceof ArtifactTocModel.ContainedSetReference) {
                ArtifactTocModel.ContainedSetReference csr = (ArtifactTocModel.ContainedSetReference)acs;
                ContainedSetHolder csh = TocHolder.resolveContainedSetRef(session, csr, monitor);
                if (csh != null) {
                    cs = csh.getContainedSet();
                }
            } else if (acs instanceof ArtifactTocModel.ContainedSet) {
                cs = (ArtifactTocModel.ContainedSet)acs;
            } else {
                throw new AssertionError();
            }
            return cs;
        }

        private static ContainedSetHolder resolveContainedSetRef(IDownloadSession session, ArtifactTocModel.ContainedSetReference csr, IProgressMonitor monitor) throws IOException, CoreException {
            ElementHolder csrHolder = ElementHolder.getHolder(csr);
            ElementHolder eh = csrHolder.resolveRef(session, csr, monitor);
            if (eh.getErrorObject() == null) {
                ContainedSetHolder csh = (ContainedSetHolder)eh;
                return csh;
            }
            return null;
        }

        boolean remove(IDownloadSession session, IArtifact iartifact, IProgressMonitor monitor) throws IOException, CoreException {
            ArtifactPos artifactPos = this.getArtifactPos(session, iartifact.getKey(), monitor);
            if (artifactPos != null && artifactPos.getArtifact() != null) {
                ArtifactTocModel.Artifact artifact = artifactPos.getArtifact();
                TocHolder.modifyParentSummary(artifact.getContainerObject(), artifact, false);
                ElementHolder holder = ElementHolder.getHolder(artifactPos.getContainer());
                ElementHolder.recordRemoveElements(holder);
                artifactPos.getIter().remove();
                return true;
            }
            return false;
        }

        private String dumpToString() {
            StringWriter sw = new StringWriter();
            IndentWriter iw = new IndentWriter(new PrintWriter(sw));
            this.dump(iw, false);
            return sw.toString();
        }

        public String toString() {
            return this.dumpToString();
        }

        @Override
        public void dump(IndentWriter iw, boolean resolve) {
            iw.enter();
            try {
                PrintWriter pw = iw.getPrintWriter();
                pw.print("hashCode=");
                pw.println(Integer.toHexString(this.hashCode()));
                pw.print("location=");
                pw.print(this.getLocation());
                pw.print("toc>");
                if (this.toc == null) {
                    pw.print(this.toc);
                } else {
                    this.toc.dump(iw, resolve);
                }
            }
            finally {
                iw.leave();
            }
        }

        boolean addOrUpdateArtifact(IDownloadSession session, IArtifact iartifact, IProgressMonitor monitor) throws IOException, CoreException {
            trace.entering(iartifact);
            ArtifactPos artifactPos = this.getArtifactPos(session, iartifact.getKey(), monitor);
            ArtifactTocModel.Artifact artifact = artifactPos != null ? artifactPos.getArtifact() : null;
            boolean isDirty = false;
            int digestChangeCount = 0;
            if (artifact != null) {
                IContentInfo aContentInfo = iartifact.getContentInfo();
                SimpleContentInfo tocContentInfo = new SimpleContentInfo(artifact.getContentInfo());
                List<String> digestAdds = Collections.emptyList();
                List digestChanges = Collections.emptyList();
                for (String aAlgorithm : aContentInfo.getDigestAlgorithms()) {
                    DigestValue aDigest = aContentInfo.getDigestValue(aAlgorithm);
                    DigestValue tocDigest = tocContentInfo.getDigestValue(aAlgorithm);
                    if (tocDigest == null) {
                        if (digestAdds.isEmpty()) {
                            digestAdds = new ArrayList();
                        }
                        digestAdds.add(aAlgorithm);
                        ++digestChangeCount;
                        artifact.setContentDigest(aDigest);
                        continue;
                    }
                    ContentInfoUtil.MessageDigestComparison mdc = new ContentInfoUtil.MessageDigestComparison(aAlgorithm, tocDigest, aDigest);
                    if (mdc.isEqual()) continue;
                    if (digestChanges.isEmpty()) {
                        digestChanges = new ArrayList();
                    }
                    digestChanges.add(aAlgorithm);
                    ++digestChangeCount;
                    artifact.setContentDigest(aDigest);
                }
                List<String> digestRemovals = Collections.emptyList();
                for (String tocAlgorithm : tocContentInfo.getDigestAlgorithms()) {
                    DigestValue aDigest = aContentInfo.getDigestValue(tocAlgorithm);
                    if (aDigest != null) continue;
                    if (digestRemovals.isEmpty()) {
                        digestRemovals = new ArrayList();
                    }
                    digestRemovals.add(tocAlgorithm);
                    ++digestChangeCount;
                    artifact.removeContentDigest(tocAlgorithm);
                }
                boolean explodedChanged = artifact.isExploded() ^ iartifact.isExploded();
                if (explodedChanged) {
                    artifact.setExploded(iartifact.isExploded());
                }
                long aSize = iartifact.getContentInfo().getSizeInfo().getDownloadSize();
                long tocSize = tocContentInfo.getSizeInfo().getDownloadSize();
                long sizeDelta = aSize - tocSize;
                if (digestChangeCount > 0 || sizeDelta != 0L || explodedChanged) {
                    if (digestAdds.size() > 0 || digestRemovals.size() > 0 || sizeDelta != 0L) {
                        TocHolder.modifyParentDigests(artifact.getContainerObject(), artifact, digestAdds, digestRemovals, sizeDelta);
                    }
                    ElementHolder holder = ElementHolder.getHolder(artifact);
                    ElementHolder.recordModifiedElements(holder);
                    isDirty = true;
                }
            } else {
                ArtifactTocModel.Artifact newArtifact = this.createArtifact(artifactPos, iartifact);
                this.params.artifactCreated(newArtifact, iartifact);
                ElementHolder holder = ElementHolder.getHolder(newArtifact);
                ElementHolder.recordAddElements(holder);
                isDirty = true;
            }
            trace.exiting(isDirty);
            return isDirty;
        }

        private static void modifyParentSummary(Object obj, ArtifactTocModel.Artifact artifact, boolean add) {
            ArtifactTocModel.Summary summary;
            int delta = add ? 1 : -1;
            ElementHolder.IElementHasContainer nextParent = null;
            if (obj instanceof ArtifactTocModel.AbstractContainedSet) {
                ArtifactTocModel.AbstractContainedSet cs = (ArtifactTocModel.AbstractContainedSet)obj;
                summary = cs.getMutableSummary();
                nextParent = ElementHolder.getContainer(cs, true, false);
            } else if (obj instanceof ArtifactTocModel.Toc) {
                ArtifactTocModel.Toc toc = (ArtifactTocModel.Toc)obj;
                summary = toc.getSummary();
            } else {
                throw new AssertionError();
            }
            summary.incrCount(delta);
            IContentInfo ci = artifact.getContentInfo();
            long size = ci.getSizeInfo().getDownloadSize();
            if (size != Long.MIN_VALUE) {
                summary.incrTotalSize((long)delta * size);
            }
            for (String da : ci.getDigestAlgorithms()) {
                if (ci.getDigestValue(da) == null) continue;
                summary.incrDigestCount(da, delta);
            }
            if (nextParent != null) {
                TocHolder.modifyParentSummary(nextParent, artifact, add);
            }
        }

        private static void modifyParentDigests(Object obj, ArtifactTocModel.Artifact artifact, List<String> digestAdds, List<String> digestRemovals, long diffSize) {
            IContentInfo ci;
            long size;
            ArtifactTocModel.Summary summary;
            ElementHolder.IElementHasContainer nextParent = null;
            if (obj instanceof ArtifactTocModel.AbstractContainedSet) {
                ArtifactTocModel.AbstractContainedSet cs = (ArtifactTocModel.AbstractContainedSet)obj;
                summary = cs.getMutableSummary();
                nextParent = ElementHolder.getContainer(cs, true, false);
            } else if (obj instanceof ArtifactTocModel.Toc) {
                ArtifactTocModel.Toc toc = (ArtifactTocModel.Toc)obj;
                summary = toc.getSummary();
            } else {
                throw new AssertionError();
            }
            for (String algorithm : digestAdds) {
                summary.incrDigestCount(algorithm, 1);
            }
            for (String algorithm : digestRemovals) {
                summary.incrDigestCount(algorithm, -1);
            }
            if (diffSize != 0L && (size = (ci = artifact.getContentInfo()).getSizeInfo().getDownloadSize()) != Long.MIN_VALUE) {
                summary.incrTotalSize(diffSize);
            }
            if (nextParent != null) {
                TocHolder.modifyParentDigests(nextParent, artifact, digestAdds, digestRemovals, diffSize);
            }
        }

        private static ArtifactTocModel.Artifact createArtifactAtPathContainer(IContentInfo contentInfo, ArtifactTocModel.ContainedSet csPathSet, IArtifact iartifact, IArtifactKey key) {
            ArtifactTocModel.Artifact artifact = new ArtifactTocModel.Artifact();
            artifact.setIdString(key.getId().getId());
            artifact.setPath(key.getPath());
            artifact.setVersion(key.getVersion());
            artifact.setExploded(iartifact.isExploded());
            artifact.setContentInfo(contentInfo);
            if (iartifact instanceof ArtifactWithExtraTocInfo) {
                ArtifactWithExtraTocInfo artifactWithExtraInfo = (ArtifactWithExtraTocInfo)iartifact;
                artifact.setExtraInfo(artifactWithExtraInfo.getExtraInfo());
            }
            artifact.initContainer(csPathSet);
            csPathSet.getContained().add(artifact);
            return artifact;
        }

        private static ArtifactTocModel.Artifact createArtifactAtVersionContainer(IContentInfo contentInfo, ArtifactTocModel.ContainedSet csVerSet, IArtifact iartifact, IArtifactKey key) {
            ArtifactTocModel.ContainedSet csPathSet = new ArtifactTocModel.ContainedSet();
            csPathSet.setAttr("p", "*");
            csPathSet.setSummary(new ArtifactTocModel.Summary());
            csPathSet.initContainer(csVerSet);
            csVerSet.getContained().add(csPathSet);
            return TocHolder.createArtifactAtPathContainer(contentInfo, csPathSet, iartifact, key);
        }

        private static ArtifactTocModel.Artifact createArtifactAtIdContainer(IContentInfo contentInfo, ArtifactTocModel.ContainedSet csIdSet, IArtifact iartifact, IArtifactKey key) {
            String versionPattern = String.valueOf(Integer.toString(key.getVersion().getMajor())) + ".*";
            ArtifactTocModel.ContainedSet csVerSet = new ArtifactTocModel.ContainedSet();
            csVerSet.setAttr("v", versionPattern);
            csVerSet.setSummary(new ArtifactTocModel.Summary());
            csVerSet.initContainer(csIdSet);
            csIdSet.getContained().add(csVerSet);
            return TocHolder.createArtifactAtVersionContainer(contentInfo, csVerSet, iartifact, key);
        }

        private static ArtifactTocModel.Artifact createArtifactAtQualContainer(IContentInfo contentInfo, ArtifactTocModel.ContainedSet csQual, IArtifact iartifact, IArtifactKey key) {
            String id = key.getId().getId();
            String idPattern = ArtifactTocUtil.getIdPattern(id);
            ArtifactTocModel.ContainedSet csIdSet = new ArtifactTocModel.ContainedSet();
            csIdSet.setAttr("id", idPattern);
            csIdSet.setSummary(new ArtifactTocModel.Summary());
            csIdSet.initContainer(csQual);
            csQual.getContained().add(csIdSet);
            return TocHolder.createArtifactAtIdContainer(contentInfo, csIdSet, iartifact, key);
        }

        private static ArtifactTocModel.Artifact createArtifactAtNsContainer(IContentInfo contentInfo, ArtifactTocModel.ContainedSet csNs, IArtifact iartifact, IArtifactKey key) {
            String qual = key.getQualifier();
            ArtifactTocModel.ContainedSet csQual = new ArtifactTocModel.ContainedSet();
            csQual.setAttr("q", qual);
            csQual.setSummary(new ArtifactTocModel.Summary());
            csQual.initContainer(csNs);
            csNs.getContained().add(csQual);
            return TocHolder.createArtifactAtQualContainer(contentInfo, csQual, iartifact, key);
        }

        private static ArtifactTocModel.Artifact createArtifactInternal(ArtifactPos artifactPos, IArtifact iartifact) {
            IContentInfo contentInfo = iartifact.getContentInfo();
            IArtifactKey key = iartifact.getKey();
            if (artifactPos != null) {
                String attrName = artifactPos.getContainer().getAttrName();
                if (attrName.equals("n")) {
                    return TocHolder.createArtifactAtNsContainer(contentInfo, artifactPos.getContainer(), iartifact, key);
                }
                if (attrName.equals("q")) {
                    return TocHolder.createArtifactAtQualContainer(contentInfo, artifactPos.getContainer(), iartifact, key);
                }
                if (attrName.equals("id")) {
                    return TocHolder.createArtifactAtIdContainer(contentInfo, artifactPos.getContainer(), iartifact, key);
                }
                if (attrName.equals("v")) {
                    return TocHolder.createArtifactAtVersionContainer(contentInfo, artifactPos.getContainer(), iartifact, key);
                }
                if (attrName.equals("p")) {
                    return TocHolder.createArtifactAtPathContainer(contentInfo, artifactPos.getContainer(), iartifact, key);
                }
            }
            String ns = key.getNamespace();
            ArtifactTocModel.ContainedSet csNs = new ArtifactTocModel.ContainedSet();
            csNs.setAttr("n", ns);
            csNs.setSummary(new ArtifactTocModel.Summary());
            return TocHolder.createArtifactAtNsContainer(contentInfo, csNs, iartifact, key);
        }

        private ArtifactTocModel.Artifact createArtifact(ArtifactPos artifactPos, IArtifact iartifact) {
            trace.entering();
            ArtifactTocModel.Artifact artifact = TocHolder.createArtifactInternal(artifactPos, iartifact);
            ElementHolder holder = ElementHolder.getHolder(artifact);
            if (holder == null) {
                Object root = ElementHolder.getRootObject(artifact);
                ArtifactTocModel.ContainedSet csNs = (ArtifactTocModel.ContainedSet)root;
                csNs.initContainer(this.toc);
                this.toc.getContents().add(csNs);
            }
            TocHolder.modifyParentSummary(artifact.getContainerObject(), artifact, true);
            trace.exiting();
            return artifact;
        }

        @Override
        public String getHolderUserString() {
            String msg = this.tocPath != null ? NLS.bind((String)Messages.artifact_toc_user_string, (Object)this.tocPath.toString()) : (this.tocUrl != null ? NLS.bind((String)Messages.artifact_toc_user_string, (Object)this.tocUrl.toString()) : NLS.bind((String)Messages.artifact_toc_user_string, (Object)""));
            return msg;
        }

        IPath getBasePath() {
            return this.tocBasePath;
        }

        @Override
        public IPath getPath() {
            return this.tocPath;
        }

        @Override
        public URL getURL() {
            return this.tocUrl;
        }

        @Override
        public String getLocation() {
            return ElementHolder.getLocation(this);
        }

        @Override
        public ElementHolder getParentHolder() {
            return null;
        }

        @Override
        public IReadArtifactRepo.ISummary getSummary() {
            return this.toc.getSummary();
        }

        @Override
        public Version getVersion() {
            return this.toc.getVersion();
        }

        @Override
        public List<ArtifactTocModel.AbstractContainedSet> getContainedCategories() {
            return this.toc.getContents();
        }

        public void getContainedSetRefs(List<ArtifactTocModel.ContainedSetReference> list, IReadArtifactRepo.ICategory category) {
            this.getContainedSetRefs(list, (ArtifactTocModel.AbstractContainedSet)category);
        }

        @Override
        public List getContents(IDownloadSession session, IReadArtifactRepo.ICategory category, IProgressMonitor monitor) throws CoreException {
            try {
                return this.getContents(session, (ArtifactTocModel.AbstractContainedSet)category, monitor);
            }
            catch (IOException e) {
                String msg = NLS.bind((String)Messages.get_category_contents_failed, (Object)category.toUserString());
                ICicStatus status = Statuses.ERROR.get(121, e, msg, new Object[0]);
                trace.getLog().debug(status);
                if (session != null) {
                    session.log(status);
                }
                throw new CoreException((IStatus)status);
            }
        }

        @Override
        public IArtifact getTocArtifact(IDownloadSession session, IArtifactKey key, IProgressMonitor monitor) throws CoreException {
            ArtifactTocModel.Artifact artifact;
            try {
                artifact = this.getArtifact(session, key, monitor);
            }
            catch (IOException e) {
                ICicStatus status = Statuses.ERROR.get(120, e, Messages.read_artifact_toc_failed_with_exception, new Object[0]);
                throw new CoreException((IStatus)status);
            }
            catch (CoreException e) {
                if (e.getStatus().matches(8)) {
                    throw e;
                }
                CicMultiStatus status = Statuses.ERROR.getMultiStatus(120, new IStatus[]{e.getStatus()}, Messages.read_artifact_toc_failed_with_exception, new Object[0]);
                throw new CoreException((IStatus)status);
            }
            return artifact;
        }

        @Override
        public IContentInfo getArtifactInfo(IDownloadSession session, IArtifactKey key, IProgressMonitor monitor) throws CoreException {
            IArtifact a = this.getTocArtifact(session, key, monitor);
            IContentInfo ci = a == null ? null : a.getContentInfo();
            return ci;
        }

        private String getContainedSetHref(ArtifactTocModel.AbstractContainedSet cs) {
            ArrayList<String> valuePath = new ArrayList<String>();
            ArrayList<String> attrPath = new ArrayList<String>();
            ArtifactTocModel.AbstractContainedSet current = cs;
            while (current != null) {
                String value = current.getAttrValue();
                if (value.endsWith("*")) {
                    value = value.substring(0, value.length() - 1);
                }
                valuePath.add(0, value);
                attrPath.add(0, current.getAttrName());
                current = ArtifactTocModel.AbstractContainedSet.as(ElementHolder.getContainer(current, true, true));
            }
            StringBuffer sb = new StringBuffer();
            int i = 0;
            for (String attrName : attrPath) {
                if (i == 2) {
                    sb.append('/');
                }
                sb.append(attrName);
                ++i;
            }
            sb.append('/');
            boolean first = true;
            for (String value : valuePath) {
                if (!first) {
                    sb.append('_');
                }
                sb.append(value);
                first = false;
            }
            sb.append(ArtifactTableOfContents.CSET_XML);
            return sb.toString();
        }

        private void writeIdHolder(ArtifactTocModel.ContainedSet cs) throws IOException {
            try (AdvisoryLockedFile csetFile = null;){
                String href = this.getContainedSetHref(cs);
                csetFile = ArtifactTocWriter.ContainedSetFile.create(this.tocBasePath, href, false);
                ArtifactTocWriter.writeContainedSetFile(this.params, csetFile, cs);
            }
        }

        private ArtifactTocModel.ContainedSetReference createContainedSetReference(ArtifactTocModel.ContainedSet cs) {
            String href = this.getContainedSetHref(cs);
            ArtifactTocModel.ContainedSetReference csr = new ArtifactTocModel.ContainedSetReference();
            if (this.params.useETag()) {
                csr.setETag(cs.getETag());
            }
            csr.setSummary(new ArtifactTocModel.Summary(cs.getMutableSummary()));
            csr.setAttr(cs.getAttrName(), cs.getAttrValue());
            csr.initHREF(href);
            return csr;
        }

        private void writeQualHolder(ArtifactTocModel.ContainedSet cs) throws IOException {
            boolean changedSubFiles = false;
            if (this.params.writeIdHolder()) {
                ArrayList<ArtifactTocModel.ContainedSetReference> written = new ArrayList<ArtifactTocModel.ContainedSetReference>();
                Iterator iter = cs.getContained().iterator();
                while (iter.hasNext()) {
                    ArtifactTocModel.ContainedSetReference csrId;
                    ElementHolder refHolder;
                    ContainedSetHolder holder;
                    ArtifactTocModel.AbstractContainedSet acsId = (ArtifactTocModel.AbstractContainedSet)iter.next();
                    if (acsId instanceof ArtifactTocModel.ContainedSet) {
                        ArtifactTocModel.ContainedSet csId = (ArtifactTocModel.ContainedSet)acsId;
                        if (this.params.useETag()) {
                            String etag = ETagUtil.newETag(csId.getETag());
                            csId.setETag(etag);
                        }
                        this.writeIdHolder(csId);
                        if (this.params.useETag()) {
                            changedSubFiles = true;
                        }
                        ArtifactTocModel.ContainedSetReference csr = this.createContainedSetReference(csId);
                        iter.remove();
                        csId.releaseContainer();
                        written.add(csr);
                        continue;
                    }
                    if (!(acsId instanceof ArtifactTocModel.ContainedSetReference) || (holder = (ContainedSetHolder)(refHolder = ElementHolder.getHolder(csrId = (ArtifactTocModel.ContainedSetReference)acsId)).getOpenHolder(csrId)) == null) continue;
                    ElementHolder.Update update = refHolder.getHolderUpdate(holder);
                    if (update == null) {
                        update = holder.getHolderUpdate(holder);
                    }
                    if (update != null && update.hasChanges()) {
                        if (this.params.useETag()) {
                            String etag = ETagUtil.newETag(csrId.getETag());
                            csrId.setETag(etag);
                            ArtifactTocModel.ContainedSet containedSet = holder.getContainedSet();
                            containedSet.setETag(etag);
                        }
                        this.writeIdHolder(holder.getContainedSet());
                        if (this.params.useETag()) {
                            changedSubFiles = true;
                        }
                    }
                    holder.closeHolder();
                    holder.getContainedSet().releaseContainer();
                }
                List idContained = cs.getContained();
                for (ArtifactTocModel.ContainedSetReference csr : written) {
                    idContained.add(csr);
                    csr.initContainer(cs);
                }
            }
            if (!changedSubFiles) {
                ElementHolder holder = ElementHolder.getHolder(cs);
                ElementHolder.Update update = this.getHolderUpdate(holder);
                if (update == null && holder != this) {
                    update = holder.getHolderUpdate(holder);
                }
                if (update == null || !update.hasChanges()) {
                    return;
                }
            }
            try (AdvisoryLockedFile csetFile = null;){
                String href = this.getContainedSetHref(cs);
                csetFile = ArtifactTocWriter.ContainedSetFile.create(this.tocBasePath, href, false);
                ArtifactTocWriter.writeContainedSetFile(this.params, csetFile, cs);
            }
        }

        private void writeTocWithHolder(ArtifactTocModel.Toc newToc) throws IOException {
            for (ArtifactTocModel.AbstractContainedSet acs : newToc.getContents()) {
                ArtifactTocModel.ContainedSet csNs = (ArtifactTocModel.ContainedSet)acs;
                ArrayList<ArtifactTocModel.ContainedSetReference> written = new ArrayList<ArtifactTocModel.ContainedSetReference>();
                Iterator iterator = csNs.getContained().iterator();
                while (iterator.hasNext()) {
                    ArtifactTocModel.ContainedSetReference csrQual;
                    ElementHolder holder;
                    ArtifactTocModel.AbstractContainedSet acsQual = (ArtifactTocModel.AbstractContainedSet)iterator.next();
                    if (acsQual.getSummary().getCount() == 0) {
                        this.removeQualHolder(acsQual);
                        iterator.remove();
                        acsQual.releaseContainer();
                        continue;
                    }
                    if (acsQual instanceof ArtifactTocModel.ContainedSet) {
                        ArtifactTocModel.ContainedSet csQual = (ArtifactTocModel.ContainedSet)acsQual;
                        if (this.params.useETag()) {
                            String etag = ETagUtil.newETag(csQual.getETag());
                            csQual.setETag(etag);
                        }
                        this.writeQualHolder(csQual);
                        ArtifactTocModel.ContainedSetReference csr = this.createContainedSetReference(csQual);
                        csr.setContentInfo(csQual.getContentInfo());
                        iterator.remove();
                        csQual.releaseContainer();
                        written.add(csr);
                        continue;
                    }
                    if (!(acsQual instanceof ArtifactTocModel.ContainedSetReference) || (holder = this.getOpenHolder(csrQual = (ArtifactTocModel.ContainedSetReference)acsQual)) == null) continue;
                    ElementHolder.Update update = this.getHolderUpdate(holder);
                    if (update == null) {
                        update = holder.getHolderUpdate(holder);
                    }
                    if (update != null && update.hasChanges()) {
                        ContainedSetHolder csh = (ContainedSetHolder)holder;
                        if (this.params.useETag()) {
                            String etag = ETagUtil.newETag(csrQual.getETag());
                            csrQual.setETag(etag);
                            csh.getContainedSet().setETag(etag);
                        }
                        this.writeQualHolder(csh.getContainedSet());
                        csrQual.setContentInfo(csh.getContainedSet().getContentInfo());
                    }
                    holder.closeHolder();
                }
                List nsContained = csNs.getContained();
                for (ArtifactTocModel.ContainedSetReference csr : written) {
                    nsContained.add(csr);
                    csr.initContainer(csNs);
                }
            }
        }

        private void removeQualHolder(ArtifactTocModel.AbstractContainedSet acsQual) {
            File file;
            if (acsQual instanceof ArtifactTocModel.ContainedSetReference) {
                ArtifactTocModel.ContainedSetReference csr = (ArtifactTocModel.ContainedSetReference)acsQual;
                ElementHolder holder = this.getOpenHolder(csr);
                if (holder != null) {
                    holder.closeHolder();
                }
                file = this.tocBasePath.append(csr.getHREF()).toFile();
            } else {
                String href = this.getContainedSetHref(acsQual);
                file = this.tocBasePath.append(href).toFile();
            }
            FileUtil.rm(file);
        }

        private void writeToc(TocFile tocFile, TocUpdate tocUpdate, IProgressMonitor monitor) throws IOException, CoreException {
            SplitProgressMonitor spm = new SplitProgressMonitor(monitor, 2);
            try {
                if (tocUpdate.doUpdate(spm.next())) {
                    this.writeToc(tocFile, tocUpdate, false, spm.next());
                }
            }
            finally {
                spm.done();
            }
        }

        void writeToc(TocFile tocFile, boolean force, IOnAtocSaved onSaved, IProgressMonitor monitor) throws IOException {
            TocUpdate tocUpdate = new TocUpdate(this, new IArtifact[0], onSaved){

                @Override
                public boolean doUpdate(IProgressMonitor m) {
                    return false;
                }
            };
            this.writeToc(tocFile, tocUpdate, force, monitor);
        }

        private void writeToc(TocFile tocFile, TocUpdate tocUpdate, boolean force, IProgressMonitor monitor) throws IOException {
            ElementHolder newTocHolder;
            ElementHolder.Update update;
            ArtifactTocModel.Toc newToc = tocUpdate.getTocHolder().getToc();
            if (this.params.useETag()) {
                String newETag = ETagUtil.newETag(newToc.getETag());
                newToc.setETag(newETag);
            }
            if (this.params.writeQualHolder()) {
                this.writeTocWithHolder(newToc);
            }
            if (!(force || this.params.useETag() || (update = (newTocHolder = ElementHolder.getHolder(newToc)).getHolderUpdate(newTocHolder)) != null && update.hasChanges())) {
                return;
            }
            if (this.params.supportDigests()) {
                this.computeMissingHrefMessageDigests(tocFile, newToc);
                ArtifactTocWriter.writeTocFile_version2(this.params, tocFile, tocUpdate, monitor);
            } else {
                ArtifactTocWriter.writeTocFile_version1(this.params, tocFile, tocUpdate, monitor);
            }
        }

        private static void collectHRefsWithoutDigest(Collection<ArtifactTocModel.ContainedSetReference> csrs, int depth, int maxdepth, ArtifactTocModel.AbstractContainedSet acs) {
            if (depth == maxdepth) {
                return;
            }
            if (acs instanceof ArtifactTocModel.ContainedSetReference) {
                ArtifactTocModel.ContainedSetReference csr = (ArtifactTocModel.ContainedSetReference)acs;
                if (csr.getContentInfo() == null) {
                    csrs.add(csr);
                }
                return;
            }
            if (acs instanceof ArtifactTocModel.ContainedSet) {
                ArtifactTocModel.ContainedSet cs = (ArtifactTocModel.ContainedSet)acs;
                for (Object o : cs.getContained()) {
                    if (!(o instanceof ArtifactTocModel.AbstractContainedSet)) continue;
                    ArtifactTocModel.AbstractContainedSet acsChild = (ArtifactTocModel.AbstractContainedSet)o;
                    TocHolder.collectHRefsWithoutDigest(csrs, depth + 1, maxdepth, acsChild);
                }
            }
        }

        private void computeMissingHrefMessageDigests(TocFile tocFile, ArtifactTocModel.Toc newToc) throws IOException {
            ArrayList<ArtifactTocModel.ContainedSetReference> csrs = new ArrayList<ArtifactTocModel.ContainedSetReference>(5);
            Iterator<ArtifactTocModel.AbstractContainedSet> iterator = newToc.getContents().iterator();
            while (iterator.hasNext()) {
                ArtifactTocModel.AbstractContainedSet element;
                ArtifactTocModel.AbstractContainedSet acs = element = iterator.next();
                TocHolder.collectHRefsWithoutDigest(csrs, 0, 3, acs);
            }
            if (!csrs.isEmpty()) {
                IDownloadSession session = IDownloadSession.FACTORY.createDownloadSession();
                String algorithm = ContentInfoComputation.getPreferredAlgorithms()[0];
                for (ArtifactTocModel.ContainedSetReference csr : csrs) {
                    SimpleContentInfo mci = new SimpleContentInfo();
                    try (final ArtifactTocWriter.ContainedSetFile csFile = ArtifactTocWriter.ContainedSetFile.create(this.tocBasePath, csr.getHREF(), true);){
                        FileInputStream in = csFile.getInputStream();
                        IStatus status = ContentInfoComputation.computeDigests(session, new UserName(){

                            @Override
                            public String toString() {
                                return csFile.getLocation();
                            }
                        }, in, csFile.length(), algorithm, (IProgressMonitor)new NullProgressMonitor(), mci);
                        if (!status.isOK()) {
                            trace.getLog().status(status);
                            break;
                        }
                    }
                    csr.setContentInfo(mci);
                }
            }
        }

        private static class ArtifactPos {
            private final ArtifactTocModel.ContainedSet cset;
            private final Iterator iter;
            private final ArtifactTocModel.Artifact artifact;

            public ArtifactPos(ArtifactTocModel.ContainedSet container, Iterator iter, ArtifactTocModel.Artifact artifact) {
                this.cset = container;
                this.iter = iter;
                this.artifact = artifact;
            }

            public ArtifactTocModel.ContainedSet getContainer() {
                return this.cset;
            }

            public ArtifactTocModel.Artifact getArtifact() {
                return this.artifact;
            }

            public Iterator getIter() {
                return this.iter;
            }
        }
    }

    static abstract class TocUpdate {
        final TocHolder tocHolder;
        final IArtifact[] artifactsToUpdate;
        private final IOnAtocSaved onSaved;

        public TocUpdate(TocHolder tocHolder, IArtifact[] artifactsToUpdate, IOnAtocSaved onSaved) {
            this.tocHolder = tocHolder;
            this.artifactsToUpdate = artifactsToUpdate;
            this.onSaved = onSaved;
        }

        public abstract boolean doUpdate(IProgressMonitor var1) throws IOException, CoreException;

        public TocHolder getTocHolder() {
            return this.tocHolder;
        }

        public void onSaved(SimpleContentInfo digests, IProgressMonitor m) {
            if (this.onSaved != null) {
                this.onSaved.onSave(this.tocHolder.getBasePath(), this.tocHolder.getPath(), digests, m);
            }
        }
    }

    static interface XMLConstants {
        public static final String ELEM_ATOC = "atoc";
        public static final String ATT_ETAG = "etag";
        public static final String ELEM_CONTAINED_SET = "cset";
        public static final String ATT_HREF = "href";
        public static final String ELEM_SUMMARY_SET = "summary";
        public static final String ATT_COUNT = "count";
        public static final String ATT_TOTAL_SIZE = "totalSize";
        public static final String ELEM_DIGEST_SUMMARY = "digs";
        public static final String ELEM_ARTIFACT = "af";
        public static final String ATT_NAMESPACE = "n";
        public static final String ATT_QUALIFIER = "q";
        public static final String ATT_ID = "id";
        public static final String ATT_VERSION = "v";
        public static final String ATT_PATH = "p";
        public static final String ATT_EXPLODED = "ex";
        public static final String ATT_SIZE = "sz";
        public static final String ELEM_DIGEST = "dig";
        public static final String ATT_DIGEST_ALGORITHM = "da";
        public static final String ATT_DIGEST_VALUE = "dv";
        public static final String[] CONTAINED_SET_CAPTURED_ATTRIBUTES = new String[]{"n", "q", "id", "v", "p"};
    }
}

