/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.base;

import com.ibm.cic.common.core.artifactrepo.IArtifactLocator;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IContentLocator;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.base.AbstractAddCopyArtifacts;
import com.ibm.cic.common.core.artifactrepo.base.AbstractModifyArtifactsAndUpdateToc;
import com.ibm.cic.common.core.artifactrepo.base.ArtifactOperationUtil;
import com.ibm.cic.common.core.artifactrepo.base.CancelOnlyMonitor;
import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperation;
import com.ibm.cic.common.core.artifactrepo.base.IMultiArtifactOperationArguments;
import com.ibm.cic.common.core.artifactrepo.base.MultiArtifactOperationOptions;
import com.ibm.cic.common.core.artifactrepo.base.SingleArtifactOperationOptions;
import com.ibm.cic.common.core.artifactrepo.impl.AddOption;
import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.artifactrepo.impl.RepoAs;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.repository.DirectoryRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRevealFileLocations;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.TempUtil;
import com.ibm.cic.common.core.utils.UserNames;
import com.ibm.cic.common.downloads.DownloadInProgressManager;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;

public class AddArtifacts
extends AbstractAddCopyArtifacts {
    public static final AddArtifacts INSTANCE = new AddArtifacts();

    public static IArtifactOperation.IArtifactOperationInput createGetRequest(IArtifact artifact, IContentLocator locator) {
        return new AddInput(artifact, locator);
    }

    public static IArtifactOperation.IArtifactOperationInput createGetRequest(IArtifactLocator locator) {
        return new AddInput(locator.getArtifact(), locator);
    }

    public static AddInput getAddInput(IArtifactOperation.IArtifactOperationRecord record) {
        IArtifactOperation.IArtifactOperationInput input = record.getInput();
        if (input instanceof AddInput) {
            return (AddInput)input;
        }
        return null;
    }

    public static IArtifact getAddInputArtifact(IArtifactOperation.IArtifactOperationRecord record) {
        AddInput addInput = AddArtifacts.getAddInput(record);
        if (addInput != null) {
            return addInput.getArtifact();
        }
        return null;
    }

    public static long getAddInputArtifactDownloadSize(IArtifactOperation.IArtifactOperationRecord record) {
        AddInput input = AddArtifacts.getAddInput(record);
        if (input == null) {
            return Long.MIN_VALUE;
        }
        if (input.getLocator() != null) {
            return input.getLocator().getContentInfo().getSizeInfo().getDownloadSize();
        }
        if (input.getArtifact() != null) {
            return input.getArtifact().getContentInfo().getSizeInfo().getDownloadSize();
        }
        return Long.MIN_VALUE;
    }

    @Override
    protected IArtifact getArtifact(IArtifactOperation.IArtifactOperationRecord record) {
        return AddArtifacts.getAddInputArtifact(record);
    }

    private static File getRepoTempDir(IReadArtifactRepo repo) {
        IRevealFileLocations reveal = (IRevealFileLocations)repo.getAdapter(IRevealFileLocations.class);
        if (reveal == null) {
            return null;
        }
        return reveal.getTempDir();
    }

    public static File getUniqueTempDir(IReadArtifactRepo repo) {
        TempUtil.UniqueTempDir utd = AddArtifacts.getUniqueTempDirInternal(repo);
        return utd.getUniqueTempDir();
    }

    public static File getUniqueTempDir(File repoLocation) {
        TempUtil.UniqueTempDir utd = AddArtifacts.getUniqueTempDirInternal(repoLocation);
        return utd.getUniqueTempDir();
    }

    private static TempUtil.UniqueTempDir getUniqueTempDirInternal(IReadArtifactRepo repo) {
        File repoTempDir = AddArtifacts.getRepoTempDir(repo);
        return AddArtifacts.getUniqueTempDirInRepoTempDir(repoTempDir);
    }

    private static TempUtil.UniqueTempDir getUniqueTempDirInternal(File repoLocation) {
        File repoTempDir = DirectoryRepository.getTempDir(repoLocation);
        return AddArtifacts.getUniqueTempDirInRepoTempDir(repoTempDir);
    }

    private static TempUtil.UniqueTempDir getUniqueTempDirInRepoTempDir(File repoTempDir) {
        TempUtil.UniqueTempDir utd = DownloadInProgressManager.getUniqueDownloadInProgressRoot(repoTempDir, 5);
        return utd;
    }

    @Override
    protected Object onBeforeExecute(IArtifactSession session, IReadArtifactRepo repo, MultiArtifactOperationOptions options) throws CoreException {
        super.onBeforeExecute(session, repo, options);
        TempUtil.UniqueTempDir oldDipDir = session.getDownloadInProgressDir();
        TempUtil.UniqueTempDir utd = AddArtifacts.getUniqueTempDirInternal(repo);
        utd.create();
        session.setDownloadInProgressDir(utd);
        return oldDipDir;
    }

    @Override
    protected void onAfterExecute(IArtifactSession session, IReadArtifactRepo repo, MultiArtifactOperationOptions options, Object onBeforeObject) {
        super.onAfterExecute(session, repo, options, onBeforeObject);
        TempUtil.UniqueTempDir utd = session.getDownloadInProgressDir();
        if (utd != null) {
            utd.cleanEmptyDirsLogIOE();
        }
        session.setDownloadInProgressDir((TempUtil.UniqueTempDir)onBeforeObject);
    }

    @Override
    protected boolean doAddOrCopy(IReadArtifactRepo repo, IArtifactSession session, SingleArtifactOperationOptions options, IArtifactOperation.IArtifactOperationRecord record, IProgressMonitor monitor, IArtifactLocator[] outTargetLocator) {
        IArtifactOperation.IArtifactOperationInput input = record.getInput();
        if (input instanceof AddInput) {
            IStatus dlStatus;
            AddInput addInput = (AddInput)input;
            try {
                dlStatus = RepoAs.IArtifactWrite(repo).addArtifactNoTocUpdate(session, (AddOption)options, addInput.getArtifact(), addInput.getLocator(), false, monitor, outTargetLocator);
            }
            catch (Throwable t) {
                UserNames repoNames = ((IRepository)repo).getUserNames();
                dlStatus = Statuses.ERROR.get(11, t, Messages.add_artifact_failed_to_repo, addInput.getArtifact().toUserString(), repoNames.getPureSystemName());
            }
            if (!dlStatus.matches(12)) {
                record.setResult(new AbstractAddCopyArtifacts.AddOrCopyResult(outTargetLocator[0], dlStatus));
            }
            record.getHistory().setHistoryStatus(session, dlStatus);
            return true;
        }
        return false;
    }

    @Override
    public boolean isSuccessRecord(IArtifactOperation.IArtifactOperationRecord record) {
        return ArtifactOperationUtil.isSuccessRecord(record) && record.getLastStatus().getCode() != 14;
    }

    @Override
    protected void updateFiles(IArtifactSession session, AbstractModifyArtifactsAndUpdateToc.Context context, IMultiArtifactOperationArguments multiArgs, MultiArtifactOperationOptions options, IReadArtifactRepo repo, IProgressMonitor monitor) {
        boolean keepCopying = true;
        for (IArtifactOperation.IArtifactOperationRecord dlRecord : multiArgs.getRecords()) {
            IStatus status = dlRecord.getLastStatus();
            if (status != IArtifactOperation.STATUS_OK_REQUESTED || !keepCopying || multiArgs.isCanceled()) continue;
            MultiArtifactOperationOptions.ProcessRecordListener fireRecordProcessing = options.getFireEvents();
            fireRecordProcessing.onBeforeRecord(options, dlRecord);
            boolean performed = this.doSingleRecord(context, repo, session, options.getSingleArtifactOptions(), dlRecord, new CancelOnlyMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 0)));
            fireRecordProcessing.onProcessedRecord(options, multiArgs, dlRecord, performed);
            if (!performed) continue;
            IStatus dlStatus = dlRecord.getLastStatus();
            if (dlStatus.getSeverity() == 8) {
                multiArgs.setCanceled();
                continue;
            }
            boolean isError = dlStatus.matches(4);
            if (options.getContinueOnError() || !isError) continue;
            keepCopying = false;
        }
    }

    public static class AddInput
    implements IArtifactOperation.IArtifactOperationInput {
        private final IArtifact artifact;
        private IContentLocator locator;

        public AddInput(IArtifact artifact, IContentLocator locator) {
            this.artifact = artifact;
            this.locator = locator;
        }

        public IArtifact getArtifact() {
            return this.artifact;
        }

        public IContentLocator getLocator() {
            return this.locator;
        }

        public void setLocator(IContentLocator locator) {
            this.locator = locator;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("artifact='");
            sb.append(this.artifact.toString());
            sb.append("'");
            sb.append("locator='");
            sb.append(this.locator);
            sb.append("'");
            return sb.toString();
        }
    }
}

