/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.LUMClient;

import com.ibm.LUMClient.LicenseConstants;
import java.util.Hashtable;
import java.util.Iterator;

public class LumCapacity
implements LicenseConstants {
    int Disks;
    int MemorySize;
    int ConfigProcs;
    int OnlineProcs;
    int ProcsType;
    Hashtable CapacityHash = new Hashtable(256);

    native int lumSetDisks();

    native int lumSetMemorySize();

    native int lumSetOnlineProcs();

    native int lumSetConfigProcs();

    native int lumSetProcsType();

    public LumCapacity() {
        for (int i = 0; i < LicenseConstants.CapacityTypes.length; ++i) {
            this.CapacityHash.put(new Integer(LicenseConstants.CapacityTypes[i]), this.GetValuefromKey(LicenseConstants.CapacityTypes[i]));
        }
    }

    private Integer GetValuefromKey(int n) {
        switch (n) {
            case 100: {
                return new Integer(this.lumGetConfigProcs());
            }
            case 101: {
                return new Integer(this.lumGetOnlineProcs());
            }
            case 103: {
                return new Integer(this.lumGetDisks());
            }
            case 104: {
                return new Integer(this.lumGetMemorySize());
            }
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                return new Integer(this.lumGetProcsType() == n ? this.lumGetOnlineProcs() : 0);
            }
        }
        return new Integer(0);
    }

    public int lumGetDisks() {
        if (this.lumSetDisks() != 1) {
            return this.Disks;
        }
        return 0;
    }

    public int lumGetCapacityUnits(int n) {
        Integer n2 = (Integer)this.CapacityHash.get(new Integer(n));
        if (n2 != null) {
            return n2;
        }
        return -1;
    }

    public Iterator lumGetCapacityPairs() {
        return this.CapacityHash.entrySet().iterator();
    }

    public int lumGetMemorySize() {
        if (this.lumSetMemorySize() != 1) {
            return this.MemorySize;
        }
        return 0;
    }

    public int lumGetConfigProcs() {
        if (this.lumSetConfigProcs() != 1) {
            return this.ConfigProcs;
        }
        return 0;
    }

    public int lumGetOnlineProcs() {
        if (this.lumSetOnlineProcs() != 1) {
            return this.OnlineProcs;
        }
        return 0;
    }

    public int lumGetProcsType() {
        if (this.lumSetProcsType() != 1) {
            return this.ProcsType;
        }
        return 0;
    }

    static {
        System.loadLibrary("i4clntjni");
    }
}

