/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.commonNativeInstallAdapter;

import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.ICommonNativeInstallOperation;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.SymLinkUtil;
import com.ibm.cic.common.commonNativeAdapterData.SymLinkCommonNativeData;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.CommonAdapterData;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SymLinkInstallOperation
extends ICommonNativeInstallOperation {
    private final SymLinkCommonNativeData data;
    private final boolean isInstall;

    public SymLinkInstallOperation(int phase, IInstallableUnit unit, InstallContext context, SymLinkCommonNativeData data, boolean isInstall) {
        super(phase, unit, context);
        this.data = data;
        this.isInstall = isInstall;
    }

    protected CommonAdapterData getData() {
        return this.data;
    }

    @Override
    protected boolean shouldPerform() {
        return this.shouldPerformInstall() || this.shouldPerformUninstall();
    }

    protected IStatus doPerform(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 1);
        String theTarget = this.performVariableSubstitutions(this.data.getTarget());
        if (CicCommonSettings.isPortable()) {
            this.verifySymLinkTargetIsRelative(this, theTarget);
        }
        File theLink = this.performVariableSubstitutionsAndResolvePath(this.data.getLink());
        if (this.shouldPerformInstall()) {
            SymLinkUtil.installSymLink(theTarget, theLink);
        } else if (this.shouldPerformUninstall()) {
            SymLinkUtil.uninstallSymLink(theTarget, theLink);
        }
        monitor.worked(1);
        monitor.done();
        return Status.OK_STATUS;
    }

    private boolean shouldPerformInstall() {
        return this.data.canInstallArtifact(this.getPhase()) && this.isInstall;
    }

    private boolean shouldPerformUninstall() {
        return this.data.canUninstallArtifact(this.getPhase()) && !this.isInstall;
    }
}

