/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.commonNativeInstallAdapter;

import com.ibm.cic.agent.core.api.IInvokeContext;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.CustomOperationThread;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.Messages;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.Util;
import com.ibm.cic.common.commonNativeAdapterData.InvokeCommonNativeData;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.VersionUtil;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

class Invoke {
    private static final String RUN_METHOD_NAME = "run";
    private static final Class[] RUN_METHOD_PARAM_TYPES = new Class[]{IInvokeContext.class, String[].class, PrintWriter.class, IProgressMonitor.class};
    private final InvokeCommonNativeData data;
    private final File[] classpath;

    public Invoke(InvokeCommonNativeData data, File[] classpath) {
        this.data = data;
        this.classpath = classpath;
    }

    public void perform(IInvokeContext context, String[] args, String description, PrintWriter printWriter, IProgressMonitor monitor) throws CoreException {
        URLClassLoader loader = this.getUrlClassLoader(this.getClasspathUrls());
        Class cls = this.loadCustomOperationClass(loader);
        Method runMethod = this.getRunMethod(cls);
        Object instance = Modifier.isStatic(runMethod.getModifiers()) ? null : this.createCustomOperationInstance(cls);
        Object[] paramValues = this.getParamValues(runMethod, context, args, printWriter, monitor);
        InvokeRunnable runnable = new InvokeRunnable(runMethod, instance, paramValues);
        if (!this.isProgressMonitorPassed(paramValues)) {
            CustomOperationThread opThread = new CustomOperationThread(description, this.data.getApproximateTime(), runnable);
            opThread.runCustomOperationThread(monitor);
        } else {
            runnable.run();
        }
        runnable.check();
        try {
            loader.close();
        }
        catch (IOException e) {
            throw Util.coreException(e, Messages.Invoke_Unexpected_Exception_Creating_Instance, cls);
        }
    }

    public String toString() {
        return this.data.toString();
    }

    private boolean isProgressMonitorPassed(Object[] paramValues) {
        if (paramValues.length < 3) {
            return false;
        }
        if (paramValues.length == 3) {
            return paramValues[2] instanceof IProgressMonitor;
        }
        return true;
    }

    private Object[] getParamValues(Method runMethod, IInvokeContext context, String[] args, Writer printWriter, IProgressMonitor monitor) {
        Class<?>[] paramTypes = runMethod.getParameterTypes();
        Object[] possibleParamValues = new Object[]{context, args, printWriter, monitor};
        int length = paramTypes.length;
        Object[] paramValues = new Object[length];
        int srcPos = 1;
        if (paramTypes.length > 0 && paramTypes[0].equals(IInvokeContext.class)) {
            srcPos = 0;
        }
        System.arraycopy(possibleParamValues, srcPos, paramValues, 0, length);
        return paramValues;
    }

    private URLClassLoader getUrlClassLoader(final URL[] urls) {
        if (System.getSecurityManager() == null) {
            return new URLClassLoader(urls, this.getClass().getClassLoader());
        }
        return AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(urls, this.getClass().getClassLoader());
            }
        });
    }

    private Class loadCustomOperationClass(URLClassLoader loader) throws CoreException {
        Class cls = this.loadCustomOperationClassFromBundle();
        if (cls != null) {
            return cls;
        }
        String classname = this.data.getClassname();
        try {
            return loader.loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            throw Util.coreException(e, Messages.Invoke_Unable_To_Find_Custom_Install_Operation, classname);
        }
    }

    private URL[] getClasspathUrls() throws CoreException {
        URL[] result = new URL[this.classpath.length];
        int i = 0;
        while (i < this.classpath.length) {
            File file = this.classpath[i];
            try {
                result[i] = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw Util.coreException(e, Messages.malformed_URL, file.getPath());
            }
            ++i;
        }
        return result;
    }

    private Class loadCustomOperationClassFromBundle() {
        File[] fileArray = this.classpath;
        int n = this.classpath.length;
        int n2 = 0;
        while (n2 < n) {
            File location = fileArray[n2];
            Class cls = this.loadCustomOperationClassFromBundle(location);
            if (cls != null) {
                return cls;
            }
            ++n2;
        }
        return null;
    }

    private Class loadCustomOperationClassFromBundle(File location) {
        Manifest manifest = this.getManifest(location);
        if (manifest == null) {
            return null;
        }
        Attributes attributes = manifest.getMainAttributes();
        String bundleName = this.getBundleName(attributes);
        if (bundleName == null) {
            return null;
        }
        Version bundleVersion = this.getBundleVersion(attributes);
        if (bundleVersion == null) {
            return null;
        }
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            return null;
        }
        File bundleProjectLocation = this.getBundleProjectLocation(bundle);
        if (bundleProjectLocation == null) {
            return null;
        }
        Version loadedBundleVersion = bundle.getVersion();
        if (!this.versionsMatch(loadedBundleVersion, bundleVersion)) {
            Logger.getGlobalLogger().warning(Messages.Invoke_workspaceBundleVersionMismatch, new Object[]{bundleProjectLocation, loadedBundleVersion, bundleVersion});
            return null;
        }
        String classname = this.data.getClassname();
        try {
            return bundle.loadClass(classname);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.getGlobalLogger().warning(Messages.Invoke_classNotFoundInWorkspaceBundle, new Object[]{bundleProjectLocation, classname});
            return null;
        }
    }

    private String getBundleName(Attributes attributes) {
        String bundleName = attributes.getValue("Bundle-SymbolicName");
        return bundleName;
    }

    private Version getBundleVersion(Attributes attributes) {
        Version bundleVersion;
        String bundleVersionValue = attributes.getValue("Bundle-Version");
        if (bundleVersionValue == null) {
            return null;
        }
        try {
            bundleVersion = new Version(bundleVersionValue);
        }
        catch (IllegalArgumentException e) {
            Logger.getGlobalLogger().error((Throwable)e);
            bundleVersion = null;
        }
        return bundleVersion;
    }

    private File getBundleProjectLocation(Bundle bundle) {
        File bundleLocation = new File(PlatformUtils.getInstallLocation((Bundle)bundle));
        if (!bundleLocation.isDirectory()) {
            return null;
        }
        File projectFile = new File(bundleLocation, ".project");
        if (!projectFile.isFile()) {
            return null;
        }
        File classpathFile = new File(bundleLocation, ".classpath");
        if (!classpathFile.isFile()) {
            return null;
        }
        return bundleLocation;
    }

    private boolean versionsMatch(Version loadedBundleVersion, Version bundleVersion) {
        if ("qualifier".equals(loadedBundleVersion.getQualifier())) {
            return VersionUtil.compareToIgnoreQualifier((Version)loadedBundleVersion, (Version)bundleVersion) == 0;
        }
        return loadedBundleVersion.equals((Object)bundleVersion);
    }

    private Manifest getManifest(File location) {
        if (location.isDirectory()) {
            return this.getDirManifest(location);
        }
        if (location.isFile()) {
            return this.getJarManifest(location);
        }
        return null;
    }

    private Manifest getDirManifest(File location) {
        FileInputStream stream;
        File f = new File(location, "META-INF/MANIFEST.MF");
        if (!f.isFile()) {
            return null;
        }
        try {
            stream = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            Logger.getGlobalLogger().error((Throwable)e);
            return null;
        }
        try {
            Manifest manifest = new Manifest(stream);
            return manifest;
        }
        catch (IOException iOException) {
            return null;
        }
        finally {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException e) {
                ExceptionUtil.debugLogToReview((Throwable)e);
            }
        }
    }

    private Manifest getJarManifest(File location) {
        FileInputStream stream;
        try {
            stream = new FileInputStream(location);
        }
        catch (FileNotFoundException e) {
            Logger.getGlobalLogger().error((Throwable)e);
            return null;
        }
        ZipInputStream zipStream = new ZipInputStream(stream);
        try {
            ZipEntry zipEntry;
            do {
                if ((zipEntry = zipStream.getNextEntry()) != null) continue;
                return null;
            } while (!zipEntry.getName().equalsIgnoreCase("META-INF/MANIFEST.MF"));
            Manifest manifest = new Manifest(zipStream);
            return manifest;
        }
        catch (IOException iOException) {
            return null;
        }
        finally {
            try {
                zipStream.close();
            }
            catch (IOException e) {
                Logger.getGlobalLogger().error((Throwable)e);
            }
        }
    }

    private Method getRunMethod(Class[] possibleParamTypes, int startIndex, Class cls) {
        int nParams = possibleParamTypes.length - startIndex;
        while (nParams >= 0) {
            Class[] paramTypes = new Class[nParams];
            System.arraycopy(possibleParamTypes, startIndex, paramTypes, 0, nParams);
            try {
                return cls.getMethod(RUN_METHOD_NAME, paramTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                --nParams;
            }
        }
        return null;
    }

    private Method getRunMethod(Class cls) throws CoreException {
        Method runMethod = this.getRunMethod(RUN_METHOD_PARAM_TYPES, 0, cls);
        if (runMethod == null && (runMethod = this.getRunMethod(RUN_METHOD_PARAM_TYPES, 1, cls)) == null) {
            throw Util.coreException(Messages.Invoke_No_Appropriate_Method_Found_In_Class, RUN_METHOD_NAME, cls);
        }
        return runMethod;
    }

    private Object createCustomOperationInstance(Class cls) throws CoreException {
        try {
            Constructor ctor = cls.getConstructor(new Class[0]);
            return ctor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw Util.coreException(Messages.Invoke_No_Zero_Parameter_Constructor_Found, cls);
        }
        catch (Throwable e) {
            throw Util.coreException(e, Messages.Invoke_Unexpected_Exception_Creating_Instance, cls);
        }
    }

    private static class InvokeRunnable
    implements Runnable {
        private final Method runMethod;
        private final Object instance;
        private final Object[] paramValues;
        private Throwable exception;

        public InvokeRunnable(Method runMethod, Object instance, Object[] paramValues) {
            this.runMethod = runMethod;
            this.instance = instance;
            this.paramValues = paramValues;
        }

        public String toString() {
            return "invoke: " + this.runMethod.getDeclaringClass().getName();
        }

        @Override
        public void run() {
            try {
                this.runMethod.invoke(this.instance, this.paramValues);
            }
            catch (InvocationTargetException e) {
                this.exception = e.getCause();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void check() throws CoreException {
            if (this.exception != null) {
                if (this.exception instanceof CoreException) {
                    throw (CoreException)this.exception;
                }
                throw Util.coreException(this.exception, "", new Object[0]);
            }
        }
    }
}

