/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.commonNativeInstallAdapter;

import com.ibm.cic.agent.core.commonNativeInstallAdapter.DelayedProcessing;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.Messages;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.TempUnzipUtil;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.Util;
import com.ibm.cic.common.commonNativeAdapterData.ZipCommonNativeData;
import com.ibm.cic.common.core.artifactrepo.impl.ContentInfoComputation;
import com.ibm.cic.common.core.downloads.TransferUtils;
import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.TempUtil;
import com.ibm.cic.common.downloads.ContentInfo;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.logging.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class BackupFiles {
    private static final Logger log = Logger.getLogger(BackupFiles.class);
    private static final String PROPERTIES_SUFFIX = ".properties";
    private final File backupDir;
    private final boolean doBackup;

    public BackupFiles(File backupDir) {
        this(backupDir, false);
    }

    public BackupFiles(File backupDir, boolean doBackup) {
        this.doBackup = doBackup;
        this.backupDir = backupDir;
    }

    public IStatus restore(boolean isUndoable, DelayedProcessing delayedProcessing, IProgressMonitor monitor) {
        BackupProperties backupProps;
        File propsFile = BackupFiles.getBackupProperties(this.backupDir);
        if (!propsFile.exists()) {
            return Status.OK_STATUS;
        }
        try {
            backupProps = new BackupProperties(propsFile);
        }
        catch (IOException e) {
            Status status = new Status(4, "com.ibm.cic.agent.core.commonNativeInstallAdapter", 0, e.toString(), null);
            monitor.done();
            return status;
        }
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        this.restoreFilesFromBackup(result, isUndoable, backupProps, delayedProcessing, monitor);
        if (!result.isOK()) {
            result.setMessage(NLS.bind((String)Messages.RecordFiles_Deleting_Files_From, (Object)backupProps.getRootDir()));
        }
        return result;
    }

    public void backupFilesInDir(ZipCommonNativeData data, IArtifact artifact, TempUnzipUtil.ZipEntryFileMap zipEntryMap, Object zipFile, File outputDir, IProgressMonitor monitor) throws CoreException, IOException {
        File propsFile = BackupFiles.getBackupProperties(this.backupDir);
        if (propsFile.exists()) {
            return;
        }
        log.debug("Backing up under {0} for {1}", new Object[]{outputDir, zipFile});
        final File pendingBackupDir = new File(String.valueOf(this.backupDir.toString()) + '_');
        this.eraseLeftOverInfompleteBackup(pendingBackupDir);
        pendingBackupDir.mkdirs();
        propsFile = BackupFiles.getBackupProperties(pendingBackupDir);
        BackupProperties backupProps = new BackupProperties(propsFile, artifact, outputDir);
        ZipOutputStream[] refZos = new ZipOutputStream[1];
        String prevDir = null;
        try {
            Collection namesInZipEntryFormat = zipEntryMap.getNamesInZipFormat();
            for (String name : namesInZipEntryFormat) {
                int i = name.lastIndexOf(47);
                if (i != -1) {
                    String dir = name.substring(0, i);
                    if (this.doBackup && !dir.equals(prevDir)) {
                        monitor.subTask(dir);
                        prevDir = dir;
                    }
                }
                if (name.endsWith("/")) {
                    backupProps.addDir(name);
                    continue;
                }
                this.backupFile(data, backupProps, artifact, outputDir, name, refZos);
            }
        }
        finally {
            if (refZos[0] != null) {
                refZos[0].close();
            }
        }
        backupProps.store();
        if (this.backupDir.exists()) {
            CicMultiStatus ms;
            boolean removeRoot = true;
            ArrayList notDeleted = new ArrayList();
            ArrayList deleted = new ArrayList();
            boolean deletedAll = FileUtil.rm_r((File)this.backupDir, (boolean)removeRoot, notDeleted, deleted);
            if (!deletedAll || notDeleted.size() > 0) {
                ms = Statuses.ERROR.getMultiStatus(Messages.BackupFiles_failedToDeleteDestination, new Object[]{pendingBackupDir, this.backupDir});
                for (File file : notDeleted) {
                    ms.add((IStatus)Statuses.ERROR.get(file.toString(), new Object[0]));
                }
                throw new CoreException((IStatus)ms);
            }
            if (deleted.size() > 0) {
                ms = Util.multiStatus(NLS.bind((String)Messages.BackupFiles_warnAboutLeftoverDestinationFiles, (Object)pendingBackupDir, (Object)this.backupDir));
                for (File file : deleted) {
                    ms.add((IStatus)Statuses.WARNING.get(file.toString(), new Object[0]));
                }
                log.status((IStatus)ms);
            }
        }
        FileUtil.RetryToTimeoutOnIOException retry = new FileUtil.RetryToTimeoutOnIOException(log, 10){

            protected String getOperationDebugMessage() {
                return this.getOperationForMessage();
            }

            protected String getOperationForMessage() {
                return NLS.bind((String)Messages.BackupFiles_renameFileSourceToDest, (Object)pendingBackupDir, (Object)BackupFiles.this.backupDir);
            }

            protected void operation() throws IOException {
                FileUtil.renameTo((File)pendingBackupDir, (File)BackupFiles.this.backupDir, (boolean)true);
            }
        };
        retry.perform();
    }

    private void eraseLeftOverInfompleteBackup(File pendingBackupDir) throws CoreException {
        if (pendingBackupDir.exists() && !FileUtil.rm_r((File)pendingBackupDir, (boolean)true)) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.cic.agent.core.commonNativeInstallAdapter", 0, NLS.bind((String)Messages.RecordFiles_Failed_To_Delete, (Object)pendingBackupDir), null));
        }
    }

    private void backupFile(ZipCommonNativeData data, BackupProperties backupProps, IArtifact artifact, File outputDir, String name, ZipOutputStream[] refZos) throws IOException, CoreException {
        File origFile = new File(outputDir, name);
        if (!origFile.exists()) {
            backupProps.addFileToDelete(name);
        } else if (this.doBackup) {
            refZos[0] = this.backupFile(backupProps, origFile, refZos[0], name);
        } else if (data.getDelayedDeleteFiles().contains(name)) {
            backupProps.addFileToDelete(name);
        } else {
            throw Util.coreException(Messages.ZipInstallOperation_Error_File_Exists, artifact.toUserString(), origFile.getAbsolutePath());
        }
    }

    private ZipOutputStream backupFile(BackupProperties backupProps, File origFile, ZipOutputStream zos, String name) throws IOException {
        int bufSize = 4096;
        if (zos == null) {
            File archiveFile = backupProps.getArchive();
            zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(archiveFile), bufSize));
        }
        ZipEntry zipEntry = new ZipEntry(name);
        zipEntry.setTime(origFile.lastModified());
        zos.putNextEntry(zipEntry);
        Util.copyStream(new FileInputStream(origFile), true, zos, false, bufSize);
        zos.closeEntry();
        return zos;
    }

    public boolean artifactBackupExists() {
        File propsFile = BackupFiles.getBackupProperties(this.backupDir);
        return propsFile.exists();
    }

    private void restoreFilesFromBackup(CicMultiStatus result, boolean isUndoable, BackupProperties backupProps, DelayedProcessing delayedProcessing, IProgressMonitor monitor) {
        monitor.beginTask(NLS.bind((String)Messages.restoring, (Object)backupProps.getArtifactUserString()), 4);
        monitor.subTask("");
        for (String name : backupProps.getFilesToDelete()) {
            File full = new File(backupProps.getRootDir(), name);
            if (delayedProcessing.removeDestinationFile(full, name).getSeverity() != 4) continue;
            result.add((IStatus)new Status(4, "com.ibm.cic.agent.core.commonNativeInstallAdapter", 0, NLS.bind((String)Messages.RecordFiles_Failed_To_Delete, (Object)full), null));
            if (!isUndoable) continue;
            monitor.done();
            return;
        }
        monitor.worked(1);
        File zipFile = backupProps.getArchive();
        if (zipFile.exists()) {
            SubProgressMonitor sub = new SubProgressMonitor(monitor, 1, 4);
            IStatus restoreStat = this.restoreZip(isUndoable, backupProps, delayedProcessing, zipFile, (IProgressMonitor)sub);
            result.add(restoreStat);
            if (isUndoable && restoreStat.getSeverity() == 4) {
                return;
            }
        } else {
            monitor.worked(1);
        }
        for (String name : backupProps.getDirsToDelete()) {
            File full = new File(backupProps.getRootDir(), name);
            try {
                IStatus rmDirStat = delayedProcessing.removeDestinationFile(full.getCanonicalFile(), name);
                if (!log.isDebugLoggable()) continue;
                log.status(rmDirStat);
            }
            catch (IOException e) {
                String msg = NLS.bind((String)Messages.RecordFiles_Failed_To_Delete, (Object)full.getAbsolutePath());
                result.add((IStatus)Statuses.ERROR.get((Throwable)e, msg, new Object[0]));
                if (!isUndoable || result.isOK()) continue;
                return;
            }
        }
        monitor.worked(1);
        backupProps.file.delete();
        if (backupProps.file.exists()) {
            result.add((IStatus)new Status(4, "com.ibm.cic.agent.core.commonNativeInstallAdapter", 0, NLS.bind((String)Messages.RecordFiles_Failed_To_Delete, (Object)backupProps.file), null));
            if (isUndoable) {
                monitor.done();
                return;
            }
        }
        if (!FileUtil.rm_r((File)this.backupDir, (boolean)true)) {
            result.add((IStatus)new Status(4, "com.ibm.cic.agent.core.commonNativeInstallAdapter", 0, NLS.bind((String)Messages.RecordFiles_Failed_To_Delete, (Object)this.backupDir), null));
        }
        this.backupDir.getParentFile().delete();
        monitor.worked(1);
        monitor.done();
    }

    private IStatus restoreZip(boolean isUndoable, BackupProperties backupProps, DelayedProcessing delayedProcessing, File zipFile, IProgressMonitor monitor) {
        CicMultiStatus result;
        block10: {
            BufferedInputStream in;
            try {
                in = new BufferedInputStream(new FileInputStream(zipFile));
            }
            catch (FileNotFoundException e) {
                String msg = NLS.bind((String)com.ibm.cic.common.core.utils.Messages.Util_Error_Unzipping, (Object)zipFile, (Object)e.getMessage());
                return Statuses.ERROR.get((Throwable)e, msg, new Object[0]);
            }
            SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{8, 2});
            TempUtil.UniqueTempDir utdForUnzip = null;
            try {
                utdForUnzip = TempUnzipUtil.getTempDestination(zipFile, backupProps.getRootDir(), null);
            }
            catch (CoreException e) {
                FileUtil.close((Closeable)in);
                return e.getStatus();
            }
            result = Util.multiStatus(NLS.bind((String)Messages.BackupFiles_restoring, (Object)zipFile, (Object)backupProps.getRootDir()));
            ContentInfoComputation.IValidatingInputStream visZip = TransferUtils.validateInputStreamContentInfo((File)zipFile, (InputStream)in, (IContentInfo)ContentInfo.EMPTY_CONTENT_INFO);
            try {
                TempUnzipUtil.ZipEntryFileMap zipFileMap = TempUnzipUtil.unzipAndDetermineEntries(isUndoable, visZip, "", utdForUnzip, spm.next());
                delayedProcessing.moveToDestination(result, isUndoable, zipFile, zipFileMap, backupProps.getRootDir(), "", spm.next());
                try {
                    TempUnzipUtil.removeIntermediatedUnzipDir(utdForUnzip, Status.OK_STATUS, zipFile);
                }
                catch (CoreException e) {
                    result.add(e.getStatus());
                }
            }
            catch (CoreException e) {
                if (!isUndoable) break block10;
                try {
                    TempUnzipUtil.removeIntermediatedUnzipDir(utdForUnzip, e.getStatus(), zipFile);
                    result.add(e.getStatus());
                    return result;
                }
                catch (CoreException e2) {
                    result.add(e2.getStatus());
                    return result;
                }
            }
        }
        return result;
    }

    private static File getBackupProperties(File backupDir) {
        return new File(backupDir, "0.properties");
    }

    private static class BackupProperties
    extends Properties {
        private static final long serialVersionUID = 2268313492348533029L;
        private static final char FILE_KIND = 'f';
        private static final char DIR_KIND = 'd';
        private static final String ROOT_DIR = "rootDir";
        private static final String ARTIFACT_KEY = "artifactKey";
        private static final String ARTIFACT_USER = "artifactUser";
        private static final char C_SEPARATOR = '/';
        private static final String SEPARATOR = Character.toString('/');
        private int n = 0;
        private final File file;
        private final List keys = new LinkedList();
        private final File rootDir;
        private final Set dirsToCreate = new TreeSet();

        public BackupProperties(File file, IArtifact artifact, File rootDir) {
            this.file = file;
            this.rootDir = rootDir;
            this.setProperty(ROOT_DIR, rootDir.getPath().replace('\\', '/'));
            this.setProperty(ARTIFACT_KEY, artifact.getKey().toUniqueString());
            this.setProperty(ARTIFACT_USER, artifact.toUserString());
            this.addDir("./");
        }

        public BackupProperties(File file) throws IOException {
            this.file = file;
            try (FileInputStream stream = new FileInputStream(file);){
                this.load(stream);
            }
            this.rootDir = new File(this.getProperty(ROOT_DIR));
        }

        public String getArtifactKey() {
            return this.getProperty(ARTIFACT_KEY);
        }

        public String getArtifactUserString() {
            String result = this.getProperty(ARTIFACT_USER);
            if (result != null) {
                return result;
            }
            result = this.getArtifactKey();
            result = result.replaceFirst(",native,", ",");
            return result.replace(',', ' ').trim();
        }

        public File getRootDir() {
            return this.rootDir;
        }

        public File getArchive() {
            String path = this.file.getPath();
            if (path.endsWith(BackupFiles.PROPERTIES_SUFFIX)) {
                path = path.substring(0, path.length() - BackupFiles.PROPERTIES_SUFFIX.length());
            }
            return new File(String.valueOf(path) + CicConstants.getZipFileDotExt());
        }

        public Set getFilesToDelete() {
            return this.getMatchingProperties('f');
        }

        public Set getDirsToDelete() {
            return this.getMatchingProperties('d');
        }

        private Set getMatchingProperties(char c) {
            Comparator comparator = new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    String str0 = (String)arg0;
                    String str1 = (String)arg1;
                    Path path0 = new Path(str0);
                    Path path1 = new Path(str1);
                    int cmp = str0.compareTo(str1);
                    if (cmp == 0) {
                        return 0;
                    }
                    if (path0.isPrefixOf((IPath)path1)) {
                        return 1;
                    }
                    if (path1.isPrefixOf((IPath)path0)) {
                        return -1;
                    }
                    return cmp;
                }
            };
            TreeSet<String> result = new TreeSet<String>(comparator);
            Enumeration<?> e = this.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key.equals(ROOT_DIR) || key.charAt(0) != c) continue;
                result.add(this.getProperty(key));
            }
            return result;
        }

        public void addFileToDelete(String name) {
            this.add('f', name);
            this.addDir(name);
        }

        public void store() throws IOException {
            for (String name : this.dirsToCreate) {
                this.add('d', name);
            }
            try (FileUtil.SyncOnCloseFileOutputStream stream = new FileUtil.SyncOnCloseFileOutputStream(this.file);){
                this.store((OutputStream)stream, null);
            }
        }

        @Override
        public Object put(Object key, Object value) {
            if (!(key instanceof String)) {
                throw new AssertionError((Object)("expected String: " + key));
            }
            if (!(value instanceof String)) {
                throw new AssertionError((Object)("expected String: " + value));
            }
            this.keys.add(key);
            return super.put(key, value);
        }

        @Override
        public synchronized Enumeration keys() {
            final Iterator iterator = this.keys.iterator();
            return new Enumeration(){

                @Override
                public boolean hasMoreElements() {
                    return iterator.hasNext();
                }

                public Object nextElement() {
                    return iterator.next();
                }
            };
        }

        private void add(char kind, String name) {
            StringBuffer key = new StringBuffer(4);
            key.append(kind).append(this.n++);
            name = name.replace('\\', '/');
            if (kind == 'd' && !name.endsWith(SEPARATOR)) {
                name = String.valueOf(name) + SEPARATOR;
            }
            this.setProperty(key.toString(), name);
        }

        private void addDir(String name) {
            StringTokenizer tokenizer = new StringTokenizer(name, SEPARATOR);
            boolean isDirectory = name.endsWith(SEPARATOR);
            if (!isDirectory && tokenizer.countTokens() == 1) {
                return;
            }
            int count = tokenizer.countTokens();
            int c = isDirectory ? 0 : 1;
            String dirName = null;
            while (count-- > c) {
                String token = tokenizer.nextToken();
                if (this.dirsToCreate.contains(dirName = dirName == null ? token : String.valueOf(dirName) + SEPARATOR + token) || new File(this.rootDir, dirName).exists()) continue;
                this.dirsToCreate.add(dirName);
            }
        }
    }
}

